/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import org.rhq.enterprise.server.alert.engine.model.AbstractCacheElement;
import org.rhq.enterprise.server.alert.engine.model.AlertConditionOperator;
import org.rhq.enterprise.server.alert.engine.model.UnsupportedAlertConditionOperatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NumericDoubleCacheElement
extends AbstractCacheElement<Double> {
    public NumericDoubleCacheElement(AlertConditionOperator operator, Double value, int conditionTriggerId) {
        super(operator, value, conditionTriggerId);
    }

    @Override
    public boolean matches(Double providedValue, Object ... extraParams) {
        if (this.alertConditionValue == null || ((Double)this.alertConditionValue).isNaN() || ((Double)this.alertConditionValue).isInfinite()) {
            return false;
        }
        if (providedValue == null || providedValue.isNaN() || providedValue.isInfinite()) {
            return false;
        }
        if (this.alertConditionOperator == AlertConditionOperator.GREATER_THAN) {
            return providedValue.compareTo((Double)this.alertConditionValue) > 0;
        }
        if (this.alertConditionOperator == AlertConditionOperator.LESS_THAN) {
            return providedValue.compareTo((Double)this.alertConditionValue) < 0;
        }
        if (this.alertConditionOperator == AlertConditionOperator.EQUALS) {
            return providedValue.compareTo((Double)this.alertConditionValue) == 0;
        }
        if (this.alertConditionOperator == AlertConditionOperator.CHANGES) {
            Boolean results = null;
            if (results == null && ((Double)this.alertConditionValue).compareTo(providedValue) != 0) {
                results = Boolean.TRUE;
            }
            if (results == null) {
                results = Boolean.FALSE;
            }
            this.alertConditionValue = providedValue;
            return results;
        }
        throw new UnsupportedAlertConditionOperatorException(this.getClass().getSimpleName() + " does not yet support " + (Object)((Object)this.alertConditionOperator));
    }

    @Override
    public AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator operator) {
        if (operator == AlertConditionOperator.GREATER_THAN || operator == AlertConditionOperator.EQUALS || operator == AlertConditionOperator.LESS_THAN || operator == AlertConditionOperator.CHANGES) {
            return operator.getDefaultType();
        }
        return AlertConditionOperator.Type.NONE;
    }
}

