/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud.instance;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.cloud.instance.CacheConsistencyManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;

@Stateless
public class CacheConsistencyManagerBean
implements CacheConsistencyManagerLocal {
    private final Log log = LogFactory.getLog(CacheConsistencyManagerBean.class);
    @Resource
    TimerService timerService;
    @EJB
    ServerManagerLocal serverManager;
    @EJB
    AlertConditionCacheManagerLocal cacheManager;
    @EJB
    CacheConsistencyManagerLocal cacheConsistencyManager;
    private final String TIMER_DATA = "CacheConsistencyManagerBean.reloadServerCacheIfNeeded";

    public void scheduleServerCacheReloader() {
        Collection timers = this.timerService.getTimers();
        for (Timer existingTimer : timers) {
            this.log.debug((Object)("Found timer - attempting to cancel: " + existingTimer.toString()));
            try {
                existingTimer.cancel();
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed in attempting to cancel timer: " + existingTimer.toString()));
            }
        }
        this.timerService.createTimer(30000L, (Serializable)((Object)"CacheConsistencyManagerBean.reloadServerCacheIfNeeded"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Timeout
    public void handleHeartbeatTimer(Timer timer) {
        try {
            try {
                this.cacheConsistencyManager.reloadServerCacheIfNeeded();
            }
            catch (Throwable t) {
                this.log.error((Object)("Failed to reload server cache if needed - will try again later. Cause: " + t));
                Object var4_3 = null;
                this.timerService.createTimer(30000L, (Serializable)((Object)"CacheConsistencyManagerBean.reloadServerCacheIfNeeded"));
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.timerService.createTimer(30000L, (Serializable)((Object)"CacheConsistencyManagerBean.reloadServerCacheIfNeeded"));
            throw throwable;
        }
        this.timerService.createTimer(30000L, (Serializable)((Object)"CacheConsistencyManagerBean.reloadServerCacheIfNeeded"));
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void reloadServerCacheIfNeeded() {
        this.reloadGlobalCacheIfNeeded();
        this.reloadAgentCachesAsNeeded();
    }

    private void reloadGlobalCacheIfNeeded() {
        try {
            boolean hadServerStatus = this.serverManager.getAndClearServerStatus();
            if (!hadServerStatus) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Global cache does not need reloading");
                }
                return;
            }
            long startTime = System.currentTimeMillis();
            this.cacheManager.reloadGlobalCache();
            long endTime = System.currentTimeMillis();
            String serverName = this.serverManager.getIdentity();
            this.log.info((Object)(serverName + " took [" + (endTime - startTime) + "]ms to reload global cache"));
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Failed to reload global cache", t);
            }
            this.log.error((Object)("Failed to reload global cache, cause: " + t.getMessage()));
        }
    }

    private void reloadAgentCachesAsNeeded() {
        List<Object> agentIds = new ArrayList();
        try {
            agentIds = this.serverManager.getAndClearAgentsWithStatus();
            if (agentIds.size() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"No agent caches need reloading");
                }
                return;
            }
            long startTime = System.currentTimeMillis();
            for (Integer n : agentIds) {
                this.log.debug((Object)("Agent[id=" + n + "] is stale "));
                this.cacheManager.reloadCachesForAgent(n);
            }
            long endTime = System.currentTimeMillis();
            String serverName = this.serverManager.getIdentity();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(serverName + " took [" + (endTime - startTime) + "]ms to reload cache for the follow agentIds: " + agentIds + " agents"));
            } else {
                this.log.info((Object)(serverName + " took [" + (endTime - startTime) + "]ms to reload cache for " + agentIds.size() + " agents"));
            }
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Failed to reload caches for the following agents: " + agentIds), t);
            }
            this.log.error((Object)("Failed to reload caches for the following agents: " + agentIds + ", cause: " + t.getMessage()));
        }
    }
}

