/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.composite.IntegerOptionItem;
import org.rhq.core.domain.content.ContentRequestStatus;
import org.rhq.core.domain.content.ContentServiceRequest;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.InstalledPackageHistory;
import org.rhq.core.domain.content.PackageInstallationStep;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.composite.AdvisoryDetailsComposite;
import org.rhq.core.domain.content.composite.LoadedPackageBitsComposite;
import org.rhq.core.domain.content.composite.PackageListItemComposite;
import org.rhq.core.domain.content.composite.PackageVersionComposite;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class ContentUIManagerBean
implements ContentUIManagerLocal {
    private final Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @Override
    public LoadedPackageBitsComposite getLoadedPackageBitsComposite(int packageVersionId) {
        Query query = this.entityManager.createNamedQuery("PackageBits.isLoaded");
        query.setParameter("id", (Object)packageVersionId);
        LoadedPackageBitsComposite composite = (LoadedPackageBitsComposite)query.getSingleResult();
        return composite;
    }

    @Override
    public InstalledPackage getInstalledPackage(int id) {
        InstalledPackage installedPackage = (InstalledPackage)this.entityManager.find(InstalledPackage.class, (Object)id);
        return installedPackage;
    }

    @Override
    public PackageType getPackageType(int id) {
        PackageType packageType = (PackageType)this.entityManager.find(PackageType.class, (Object)id);
        return packageType;
    }

    @Override
    public List<PackageType> getPackageTypes(int resourceTypeId) {
        OrderingField orderingField = new OrderingField("pt.displayName", PageOrdering.ASC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageType.findByResourceTypeId", (OrderingField[])new OrderingField[]{orderingField});
        query.setParameter("typeId", (Object)resourceTypeId);
        List packageList = query.getResultList();
        return packageList;
    }

    @Override
    public PageList<PackageType> getPackageTypes(int resourceTypeId, PageControl pageControl) {
        pageControl.setPrimarySort("pt.name", PageOrdering.ASC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageType.findByResourceTypeId");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageType.findByResourceTypeId", (PageControl)pageControl);
        queryCount.setParameter("typeId", (Object)resourceTypeId);
        query.setParameter("typeId", (Object)resourceTypeId);
        long totalCount = (Long)queryCount.getSingleResult();
        List types = query.getResultList();
        return new PageList((Collection)types, (int)totalCount, pageControl);
    }

    @Override
    public PageList<ContentServiceRequest> getContentRequestsWithStatus(Subject user, int resourceId, ContentRequestStatus status, PageControl pageControl) {
        pageControl.initDefaultOrderingField("csr.ctime", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentServiceRequest.findByResourceWithStatus");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentServiceRequest.findByResourceWithStatus", (PageControl)pageControl);
        queryCount.setParameter("resourceId", (Object)resourceId);
        queryCount.setParameter("status", (Object)status);
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("status", (Object)status);
        long totalCount = (Long)queryCount.getSingleResult();
        List requests = query.getResultList();
        return new PageList((Collection)requests, (int)totalCount, pageControl);
    }

    @Override
    public PageList<ContentServiceRequest> getContentRequestsWithNotStatus(Subject user, int resourceId, ContentRequestStatus status, PageControl pageControl) {
        pageControl.initDefaultOrderingField("csr.id", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentServiceRequest.findByResourceWithNotStatus");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentServiceRequest.findByResourceWithNotStatus", (PageControl)pageControl);
        queryCount.setParameter("resourceId", (Object)resourceId);
        queryCount.setParameter("status", (Object)status);
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("status", (Object)status);
        long totalCount = (Long)queryCount.getSingleResult();
        List requests = query.getResultList();
        return new PageList((Collection)requests, (int)totalCount, pageControl);
    }

    @Override
    public PageList<PackageListItemComposite> getInstalledPackages(Subject user, int resourceId, Integer packageTypeFilterId, String packageVersionFilter, String search, PageControl pageControl) {
        pageControl.initDefaultOrderingField("gp.name", PageOrdering.ASC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"InstalledPackage.findPackageListItemComposite");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"InstalledPackage.findPackageListItemComposite", (PageControl)pageControl);
        queryCount.setParameter("resourceId", (Object)resourceId);
        query.setParameter("resourceId", (Object)resourceId);
        queryCount.setParameter("packageTypeFilterId", (Object)packageTypeFilterId);
        query.setParameter("packageTypeFilterId", (Object)packageTypeFilterId);
        queryCount.setParameter("packageVersionFilter", (Object)packageVersionFilter);
        query.setParameter("packageVersionFilter", (Object)packageVersionFilter);
        if (search != null) {
            search = "%" + search.toUpperCase() + "%";
        }
        queryCount.setParameter("search", (Object)search);
        query.setParameter("search", (Object)search);
        long totalCount = (Long)queryCount.getSingleResult();
        List packages = query.getResultList();
        return new PageList((Collection)packages, (int)totalCount, pageControl);
    }

    @Override
    public List<IntegerOptionItem> getInstalledPackageTypes(Subject user, int resourceId) {
        Query query = this.entityManager.createNamedQuery("InstalledPackage.findPackageListTypes");
        query.setParameter("resourceId", (Object)resourceId);
        List packages = query.getResultList();
        return packages;
    }

    @Override
    public PageList<InstalledPackageHistory> getInstalledPackageHistory(Subject subject, int resourceId, int generalPackageId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("iph.timestamp", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"InstalledPackageHistory.findByResourceIdAndPkgId");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"InstalledPackageHistory.findByResourceIdAndPkgId", (PageControl)pageControl);
        query.setParameter("resourceId", (Object)resourceId);
        queryCount.setParameter("resourceId", (Object)resourceId);
        query.setParameter("packageId", (Object)generalPackageId);
        queryCount.setParameter("packageId", (Object)generalPackageId);
        long totalCount = (Long)queryCount.getSingleResult();
        List packages = query.getResultList();
        return new PageList((Collection)packages, (int)totalCount, pageControl);
    }

    @Override
    public PageList<PackageVersionComposite> getPackageVersionCompositesByFilter(Subject user, int resourceId, String filter, PageControl pc) {
        pc.initDefaultOrderingField("pv.generalPackage.name", PageOrdering.ASC);
        PageControl unlimitedpc = PageControl.getUnlimitedInstance();
        Query queryInstalled = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"InstalledPackage.findPackageListItemComposite", (PageControl)unlimitedpc);
        queryInstalled.setParameter("resourceId", (Object)resourceId);
        queryInstalled.setParameter("packageTypeFilterId", null);
        queryInstalled.setParameter("packageVersionFilter", null);
        queryInstalled.setParameter("search", null);
        List packagesInstalled = queryInstalled.getResultList();
        ArrayList<String> installedPackageNames = new ArrayList<String>();
        for (PackageListItemComposite packageInstalled : packagesInstalled) {
            installedPackageNames.add(packageInstalled.getPackageName());
        }
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersion.findCompositeByFilters", (PageControl)unlimitedpc);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersion.findCompositeByFilters");
        query.setParameter("resourceId", (Object)resourceId);
        queryCount.setParameter("resourceId", (Object)resourceId);
        query.setParameter("filter", (Object)filter);
        queryCount.setParameter("filter", (Object)filter);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        ArrayList<PackageVersionComposite> modifiedResults = new ArrayList<PackageVersionComposite>();
        for (PackageVersionComposite result : results) {
            if (installedPackageNames.contains(result.getPackageName())) {
                if (count <= 0L) continue;
                --count;
                continue;
            }
            modifiedResults.add(result);
        }
        Collections.sort(modifiedResults, new Comparator(){

            public int compare(Object o1, Object o2) {
                PackageVersionComposite p1 = (PackageVersionComposite)o1;
                PackageVersionComposite p2 = (PackageVersionComposite)o2;
                return p1.getPackageName().compareToIgnoreCase(p2.getPackageName());
            }
        });
        return new PageList(modifiedResults, (int)count, pc);
    }

    @Override
    public PageList<PackageVersionComposite> getUpdatePackageVersionCompositesByFilter(Subject user, int resourceId, String filter, PageControl pc) {
        pc.initDefaultOrderingField("pv.generalPackage.name", PageOrdering.ASC);
        PageControl unlimitedpc = PageControl.getUnlimitedInstance();
        Query queryInstalled = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"InstalledPackage.findPackageListItemComposite", (PageControl)unlimitedpc);
        queryInstalled.setParameter("resourceId", (Object)resourceId);
        queryInstalled.setParameter("packageTypeFilterId", null);
        queryInstalled.setParameter("packageVersionFilter", null);
        queryInstalled.setParameter("search", null);
        List packagesInstalled = queryInstalled.getResultList();
        HashMap<String, String> installedPackageNameAndVersion = new HashMap<String, String>();
        for (PackageListItemComposite packageInstalled : packagesInstalled) {
            installedPackageNameAndVersion.put(packageInstalled.getPackageName(), packageInstalled.getVersion());
        }
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersion.findCompositeByFilters", (PageControl)unlimitedpc);
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("filter", (Object)filter);
        List results = query.getResultList();
        ArrayList<PackageVersionComposite> modifiedResults = new ArrayList<PackageVersionComposite>();
        String packageName = new String();
        for (PackageVersionComposite result : results) {
            if (installedPackageNameAndVersion.get(result.getPackageName()) == null || ((String)installedPackageNameAndVersion.get(packageName = result.getPackageName())).compareTo(result.getPackageVersion().getVersion()) >= 0) continue;
            modifiedResults.add(result);
        }
        ArrayList<PackageVersionComposite> testResults = new ArrayList<PackageVersionComposite>();
        for (PackageVersionComposite result : modifiedResults) {
            testResults.add(result);
        }
        ArrayList<PackageVersionComposite> latestResults = new ArrayList<PackageVersionComposite>();
        PackageVersionComposite latestPackage = null;
        Iterator i$ = modifiedResults.iterator();
        while (i$.hasNext()) {
            PackageVersionComposite newPackage;
            latestPackage = newPackage = (PackageVersionComposite)i$.next();
            for (PackageVersionComposite pack : testResults) {
                if (!pack.getPackageName().equals(latestPackage.getPackageName()) || latestPackage.getPackageVersion().getVersion().compareTo(pack.getPackageVersion().getVersion()) >= 0) continue;
                latestPackage = pack;
            }
            latestResults.add(latestPackage);
        }
        ArrayList<PackageVersionComposite> finalResults = new ArrayList<PackageVersionComposite>();
        long count = 0L;
        for (PackageVersionComposite pack : latestResults) {
            if (finalResults.contains(pack)) continue;
            finalResults.add(pack);
            ++count;
        }
        Collections.sort(finalResults, new Comparator(){

            public int compare(Object o1, Object o2) {
                PackageVersionComposite p1 = (PackageVersionComposite)o1;
                PackageVersionComposite p2 = (PackageVersionComposite)o2;
                return p1.getPackageName().compareToIgnoreCase(p2.getPackageName());
            }
        });
        return new PageList(finalResults, (int)count, pc);
    }

    @Override
    public PackageVersionComposite loadPackageVersionComposite(Subject user, int packageVersionId) {
        Query q = this.entityManager.createNamedQuery("PackageVersion.findCompositeById");
        q.setParameter("id", (Object)packageVersionId);
        PackageVersionComposite pv = (PackageVersionComposite)q.getSingleResult();
        return pv;
    }

    @Override
    public PackageVersionComposite loadPackageVersionCompositeWithExtraProperties(Subject user, int packageVersionId) {
        Query q = this.entityManager.createNamedQuery("PackageVersion.findCompositeByIdWithProps");
        q.setParameter("id", (Object)packageVersionId);
        PackageVersionComposite pv = (PackageVersionComposite)q.getSingleResult();
        return pv;
    }

    @Override
    public List<PackageVersionComposite> getPackageVersionComposites(Subject user, int[] packageVersionIds) {
        ArrayList<Integer> iPackageVersionIds = new ArrayList<Integer>(packageVersionIds.length);
        for (int i : packageVersionIds) {
            iPackageVersionIds.add(i);
        }
        Query q = this.entityManager.createNamedQuery("PackageVersion.findCompositesByIds");
        q.setParameter("ids", iPackageVersionIds);
        List results = q.getResultList();
        return results;
    }

    @Override
    public AdvisoryDetailsComposite loadAdvisoryDetailsComposite(Subject user, Integer advisoryId) {
        Query q = this.entityManager.createNamedQuery("Advisory.queryFindCompositeByAdvId");
        q.setParameter("id", (Object)advisoryId);
        AdvisoryDetailsComposite results = (AdvisoryDetailsComposite)q.getSingleResult();
        return results;
    }

    @Override
    public PageList<PackageVersionComposite> getPackageVersionComposites(Subject user, int[] packageVersionIds, PageControl pageControl) {
        pageControl.initDefaultOrderingField("pv.id");
        ArrayList<Integer> iPackageVersionIds = new ArrayList<Integer>(packageVersionIds.length);
        for (int i : packageVersionIds) {
            iPackageVersionIds.add(i);
        }
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersion.findCompositesByIds", (PageControl)pageControl);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersion.findCompositesByIds");
        query.setParameter("ids", iPackageVersionIds);
        queryCount.setParameter("ids", iPackageVersionIds);
        long count = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PackageVersion getPackageVersion(int packageVersionId) {
        Query q = this.entityManager.createNamedQuery("PackageVersion.findById");
        q.setParameter("id", (Object)packageVersionId);
        PackageVersion pv = (PackageVersion)q.getSingleResult();
        return pv;
    }

    @Override
    public ContentServiceRequest getContentServiceRequest(int requestId) {
        Query q = this.entityManager.createNamedQuery("ContentServiceRequest.findById");
        q.setParameter("id", (Object)requestId);
        ContentServiceRequest csr = (ContentServiceRequest)q.getSingleResult();
        return csr;
    }

    @Override
    public PageList<InstalledPackageHistory> getInstalledPackageHistory(int contentServiceRequestId, PageControl pc) {
        pc.initDefaultOrderingField("iph.timestamp", PageOrdering.DESC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"InstalledPackageHistory.findByCsrId", (PageControl)pc);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"InstalledPackageHistory.findByCsrId");
        query.setParameter("contentServiceRequestId", (Object)contentServiceRequestId);
        queryCount.setParameter("contentServiceRequestId", (Object)contentServiceRequestId);
        long totalCount = (Long)queryCount.getSingleResult();
        List packages = query.getResultList();
        return new PageList((Collection)packages, (int)totalCount, pc);
    }

    @Override
    public InstalledPackageHistory getInstalledPackageHistory(int historyId) {
        Query query = this.entityManager.createNamedQuery("InstalledPackageHistory.findById");
        query.setParameter("id", (Object)historyId);
        InstalledPackageHistory history = (InstalledPackageHistory)query.getSingleResult();
        return history;
    }

    @Override
    public List<PackageInstallationStep> getPackageInstallationSteps(int installedPackageHistoryId) {
        Query query = this.entityManager.createNamedQuery("PackageInstallationStep.findByInstalledPackageHistoryId");
        query.setParameter("installedPackageHistoryId", (Object)installedPackageHistoryId);
        List steps = query.getResultList();
        return steps;
    }

    @Override
    public PackageInstallationStep getPackageInstallationStep(int stepId) {
        PackageInstallationStep step = (PackageInstallationStep)this.entityManager.find(PackageInstallationStep.class, (Object)stepId);
        return step;
    }

    @Override
    public PageList<InstalledPackageHistory> getInstalledPackageHistoryForResource(int resourceId, PageControl pc) {
        pc.initDefaultOrderingField("iph.timestamp", PageOrdering.DESC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"InstalledPackageHistory.findByResourceId", (PageControl)pc);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"InstalledPackageHistory.findByResourceId");
        query.setParameter("resourceId", (Object)resourceId);
        queryCount.setParameter("resourceId", (Object)resourceId);
        long totalCount = (Long)queryCount.getSingleResult();
        List packages = query.getResultList();
        return new PageList((Collection)packages, (int)totalCount, pc);
    }
}

