/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Properties;
import javax.ejb.Stateless;
import javax.management.MBeanServer;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.rhq.core.clientapi.server.core.AgentNotSupportedException;
import org.rhq.core.clientapi.server.core.AgentRegistrationException;
import org.rhq.core.clientapi.server.core.AgentRegistrationRequest;
import org.rhq.core.clientapi.server.core.AgentRegistrationResults;
import org.rhq.core.clientapi.server.core.CoreServerService;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.enterprise.server.core.CoreServerServiceImpl;
import org.rhq.enterprise.server.test.CoreTestLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class CoreTestBean
implements CoreTestLocal {
    static final String TEST_AGENT_ADDRESS = "127.0.0.2";
    static final int TEST_AGENT_PORT = 2145;
    static final String TEST_AGENT_REMOTE_ENDPOINT = "socket://127.0.0.2:2145/?rhqtype=agent";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    private CoreServerService coreServerService = new CoreServerServiceImpl();

    @Override
    public boolean isTestAgentReported() {
        try {
            this.getTestAgent();
            return true;
        }
        catch (NoResultException nre) {
            return false;
        }
    }

    @Override
    public void enableHibernateStatistics() {
        PersistenceUtility.enableHibernateStatistics((EntityManager)this.entityManager, (MBeanServer)ManagementFactory.getPlatformMBeanServer());
    }

    @Override
    public AgentRegistrationResults registerTestAgent() {
        AgentRegistrationRequest registrationRequest = new AgentRegistrationRequest(TEST_AGENT_ADDRESS, TEST_AGENT_ADDRESS, 2145, TEST_AGENT_REMOTE_ENDPOINT, true, null, null);
        try {
            return this.coreServerService.registerAgent(registrationRequest);
        }
        catch (AgentRegistrationException e) {
            throw new RuntimeException(e);
        }
        catch (AgentNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
    }

    public Properties getLatestConfiguration() {
        return new Properties();
    }

    public List<Plugin> getLatestPlugins() {
        return null;
    }

    public InputStream getPluginArchive(String pluginName) {
        return null;
    }

    public InputStream getFileContents(String file) {
        return new ByteArrayInputStream(("Test contents of " + file).getBytes());
    }

    @Override
    public Agent getTestAgent() {
        return (Agent)this.entityManager.createNamedQuery("Agent.findByAddressAndPort").setParameter("address", (Object)TEST_AGENT_ADDRESS).setParameter("port", (Object)2145).getSingleResult();
    }
}

