/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration;

import java.util.Map;
import javax.ejb.Remote;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PluginConfigurationUpdate;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.group.GroupPluginConfigurationUpdate;
import org.rhq.core.domain.configuration.group.GroupResourceConfigurationUpdate;
import org.rhq.enterprise.server.configuration.ConfigurationUpdateStillInProgressException;
import org.rhq.enterprise.server.jaxb.WebServiceTypeAdapter;
import org.rhq.enterprise.server.jaxb.adapter.ConfigurationAdapter;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT)
@WebService(targetNamespace="http://www.rhq-project.org/2.4/2010/7/Webservices.xsd")
@Remote
public interface ConfigurationManagerRemote {
    @WebMethod
    public GroupPluginConfigurationUpdate getGroupPluginConfigurationUpdate(@WebParam(name="subject") Subject var1, @WebParam(name="configurationUpdateId") int var2);

    @WebMethod
    public GroupResourceConfigurationUpdate getGroupResourceConfigurationUpdate(@WebParam(name="subject") Subject var1, @WebParam(name="configurationUpdateId") int var2);

    @WebMethod
    @XmlJavaTypeAdapter(value=ConfigurationAdapter.class)
    @Nullable
    public Configuration getPluginConfiguration(@WebParam(name="subject") Subject var1, @WebParam(name="resourceId") int var2);

    @WebMethod
    @XmlJavaTypeAdapter(value=ConfigurationAdapter.class)
    public Configuration getResourceConfiguration(@WebParam(name="subject") Subject var1, @WebParam(name="resourceId") int var2);

    @WebMethod
    public PluginConfigurationUpdate getLatestPluginConfigurationUpdate(@WebParam(name="subject") Subject var1, @WebParam(name="resourceId") int var2);

    @WebMethod
    public ResourceConfigurationUpdate getLatestResourceConfigurationUpdate(@WebParam(name="subject") Subject var1, @WebParam(name="resourceId") int var2);

    @WebMethod
    public boolean isResourceConfigurationUpdateInProgress(@WebParam(name="subject") Subject var1, @WebParam(name="resourceId") int var2);

    @WebMethod
    public boolean isGroupResourceConfigurationUpdateInProgress(@WebParam(name="subject") Subject var1, @WebParam(name="resourceGroupId") int var2);

    @WebMethod
    public int scheduleGroupResourceConfigurationUpdate(@WebParam(name="subject") Subject var1, @WebParam(name="compatibleGroupId") int var2, @XmlJavaTypeAdapter(value=WebServiceTypeAdapter.class) @WebParam(name="newResourceConfigurationMap", targetNamespace="http://www.rhq-project.org/2.4/2010/7/Webservices.xsd") Map<Integer, Configuration> var3);

    @WebMethod
    public PluginConfigurationUpdate updatePluginConfiguration(@WebParam(name="subject") Subject var1, @WebParam(name="resourceId") int var2, @WebParam(name="newConfiguration") @XmlJavaTypeAdapter(value=ConfigurationAdapter.class) Configuration var3) throws ResourceNotFoundException;

    @WebMethod
    public ResourceConfigurationUpdate updateResourceConfiguration(@WebParam(name="subject") Subject var1, @WebParam(name="resourceId") int var2, @WebParam(name="newConfiguration") @XmlJavaTypeAdapter(value=ConfigurationAdapter.class) Configuration var3) throws ResourceNotFoundException, ConfigurationUpdateStillInProgressException;

    @WebMethod
    public Configuration getLiveResourceConfiguration(@WebParam(name="subject") Subject var1, @WebParam(name="resourceId") int var2, @WebParam(name="pingAgentFirst") boolean var3) throws Exception;

    @WebMethod
    public ConfigurationDefinition getResourceConfigurationDefinitionForResourceType(@WebParam(name="subject") Subject var1, @WebParam(name="resourceTypeId") int var2);

    @WebMethod
    public ConfigurationDefinition getResourceConfigurationDefinitionWithTemplatesForResourceType(@WebParam(name="subject") Subject var1, @WebParam(name="resourceTypeId") int var2);

    @WebMethod
    public ConfigurationDefinition getPluginConfigurationDefinitionForResourceType(@WebParam(name="subject") Subject var1, @WebParam(name="resourceTypeId") int var2);

    @WebMethod
    public ConfigurationDefinition getPackageTypeConfigurationDefinition(@WebParam(name="subject") Subject var1, @WebParam(name="packageTypeId") int var2);

    public Configuration translateResourceConfiguration(Subject var1, int var2, Configuration var3, boolean var4) throws ResourceNotFoundException;
}

