/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.concurrency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceCircularityException;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatchedServiceController {
    private final Log log = LogFactory.getLog(LatchedServiceController.class);
    private final Collection<? extends LatchedService> latchedServices;
    private final CountDownLatch serviceStartupLatch = new CountDownLatch(1);
    private final CountDownLatch serviceCompletionLatch;
    private final Map<String, CountDownLatch> dependencyLatches;
    private int threadPoolSize;

    public LatchedServiceController(Collection<? extends LatchedService> services) {
        this.serviceCompletionLatch = new CountDownLatch(services.size());
        this.dependencyLatches = new HashMap<String, CountDownLatch>(services.size());
        this.latchedServices = services;
        for (LatchedService latchedService : this.latchedServices) {
            this.dependencyLatches.put(latchedService.getServiceName(), new CountDownLatch(latchedService.dependencies.size()));
            latchedService.controller = this;
        }
        try {
            this.threadPoolSize = Integer.parseInt(System.getProperty("rhq.server.plugin-deployer-threads", "5"));
        }
        catch (NumberFormatException e) {
            this.threadPoolSize = 5;
            this.log.warn((Object)("Invalid number of threads specified, defaulting to [" + this.threadPoolSize + "]: " + e));
        }
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeServices() throws LatchedServiceCircularityException {
        block8: {
            this.checkForCircularDependencies();
            ExecutorService threadPool = Executors.newFixedThreadPool(this.threadPoolSize);
            this.log.debug((Object)("Will execute latched services with a concurrency of [" + this.threadPoolSize + "]"));
            HashMap<String, Object> threads = new HashMap<String, Object>();
            for (LatchedService latchedService : this.latchedServices) {
                this.log.debug((Object)("Submitting [" + latchedService.getServiceName() + "] to thread pool"));
                Map.Entry thread = threadPool.submit(latchedService);
                threads.put(latchedService.getServiceName(), thread);
            }
            this.serviceStartupLatch.countDown();
            try {
                try {}
                catch (InterruptedException ie) {
                    this.log.warn((Object)"Controller was interrupted; can not be sure if all services have begun");
                    Object var7_11 = null;
                    threadPool.shutdownNow();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                threadPool.shutdownNow();
                throw throwable;
            }
            while (!this.serviceCompletionLatch.await(90L, TimeUnit.SECONDS)) {
                boolean stillRunning = false;
                for (Map.Entry thread : threads.entrySet()) {
                    if (((Future)thread.getValue()).isDone()) continue;
                    stillRunning = true;
                    this.log.warn((Object)("Still processing [" + (String)thread.getKey() + "] - is it hung?"));
                }
                if (stillRunning) continue;
                this.log.error((Object)"The controller is waiting for threads that are already dead, breaking deadlock now!");
                break;
            }
            Object var7_10 = null;
            threadPool.shutdownNow();
        }
        this.log.debug((Object)"All services have begun");
    }

    private void checkForCircularDependencies() throws LatchedServiceException {
        HashSet<LatchedService> visited = new HashSet<LatchedService>();
        ArrayList<LatchedService> currentPath = new ArrayList<LatchedService>();
        for (LatchedService latchedService : this.latchedServices) {
            if (visited.contains(latchedService)) continue;
            this.visit(latchedService, visited, currentPath);
        }
    }

    private void visit(LatchedService current, Set<LatchedService> visited, List<LatchedService> currentPath) throws LatchedServiceException {
        visited.add(current);
        if (currentPath.contains(current)) {
            int firstOccurrence = currentPath.indexOf(current);
            StringBuilder circularMessage = new StringBuilder(current.getServiceName());
            for (int i = firstOccurrence + 1; i < currentPath.size(); ++i) {
                circularMessage.append(" -> ");
                circularMessage.append(currentPath.get(i).getServiceName());
            }
            circularMessage.append(" -> ");
            circularMessage.append(current.getServiceName());
            throw new LatchedServiceCircularityException("Circular dependency detected in latched services: " + circularMessage + "; " + "will not attempt to start any of them");
        }
        currentPath.add(current);
        for (LatchedService dependency : current.dependencies) {
            this.visit(dependency, visited, currentPath);
        }
        currentPath.remove(current);
    }

    public static abstract class LatchedService
    implements Runnable {
        private LatchedServiceController controller;
        private final String serviceName;
        private final Set<LatchedService> dependencies;
        private final Set<LatchedService> dependees;
        private volatile boolean running = false;
        private volatile boolean hasFailed = false;

        public LatchedService(String serviceName) {
            this.serviceName = serviceName;
            this.dependencies = new HashSet<LatchedService>();
            this.dependees = new HashSet<LatchedService>();
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void addDependency(LatchedService dependency) {
            if (this.running) {
                throw new IllegalArgumentException(this.serviceName + " can't accept new dependencies; it is already started");
            }
            this.dependencies.add(dependency);
            dependency.dependees.add(this);
        }

        public void notifyComplete(LatchedService finishedService, boolean didFail) {
            if (!this.dependencies.contains(finishedService)) {
                this.controller.log.error((Object)(finishedService + " is not a dependency of " + this));
                return;
            }
            if (didFail) {
                this.hasFailed = true;
            }
            ((CountDownLatch)this.controller.dependencyLatches.get(this.serviceName)).countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            this.running = true;
            String originalThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("Latched Service Processor: " + this.serviceName);
            if (this.controller.log.isDebugEnabled()) {
                this.controller.log.debug((Object)("Latched Service Processing [" + this.serviceName + "]; dependencies=[" + this.dependencies + "]; dependees=[" + this.dependees + "]..."));
            }
            if (this.controller == null) {
                throw new IllegalStateException("LatchedServices must be started via some controller");
            }
            try {
                this.controller.serviceStartupLatch.await();
            }
            catch (InterruptedException ie) {
                this.controller.log.info((Object)(this.serviceName + " will not be started; " + "could not verify all dependent services in ready state"));
                this.hasFailed = true;
                Object var4_5 = null;
                try {
                    for (LatchedService dependee : this.dependees) {
                        dependee.notifyComplete(this, this.hasFailed);
                    }
                    Object var8_17 = null;
                    this.controller.serviceCompletionLatch.countDown();
                }
                catch (Throwable throwable) {
                    Object var8_18 = null;
                    this.controller.serviceCompletionLatch.countDown();
                    this.controller.log.debug((Object)("Processed [" + this.serviceName + "]"));
                    Thread.currentThread().setName(originalThreadName);
                    throw throwable;
                }
                this.controller.log.debug((Object)("Processed [" + this.serviceName + "]"));
                Thread.currentThread().setName(originalThreadName);
                return;
            }
            try {
                ((CountDownLatch)this.controller.dependencyLatches.get(this.serviceName)).await();
            }
            catch (InterruptedException ie) {
                this.controller.log.info((Object)(this.serviceName + " will not be started; " + "did not verify all dependent services successfully started"));
                this.hasFailed = true;
                Object var4_6 = null;
                try {
                    for (LatchedService dependee : this.dependees) {
                        dependee.notifyComplete(this, this.hasFailed);
                    }
                    Object var8_19 = null;
                    this.controller.serviceCompletionLatch.countDown();
                }
                catch (Throwable throwable) {
                    Object var8_20 = null;
                    this.controller.serviceCompletionLatch.countDown();
                    this.controller.log.debug((Object)("Processed [" + this.serviceName + "]"));
                    Thread.currentThread().setName(originalThreadName);
                    throw throwable;
                }
                this.controller.log.debug((Object)("Processed [" + this.serviceName + "]"));
                Thread.currentThread().setName(originalThreadName);
                return;
            }
            if (this.hasFailed) {
                this.controller.log.info((Object)(this.serviceName + " will not be started; " + "some upstream dependency has failed to start"));
            } else {
                try {
                    this.executeService();
                    this.controller.log.debug((Object)(this.serviceName + " successfully started!"));
                }
                catch (LatchedServiceException lsse) {
                    this.controller.log.error((Object)lsse);
                }
            }
            Object var4_7 = null;
            try {
                for (LatchedService dependee : this.dependees) {
                    dependee.notifyComplete(this, this.hasFailed);
                }
                Object var8_21 = null;
                this.controller.serviceCompletionLatch.countDown();
            }
            catch (Throwable throwable) {
                Object var8_22 = null;
                this.controller.serviceCompletionLatch.countDown();
                this.controller.log.debug((Object)("Processed [" + this.serviceName + "]"));
                Thread.currentThread().setName(originalThreadName);
                throw throwable;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                try {
                    for (LatchedService dependee : this.dependees) {
                        dependee.notifyComplete(this, this.hasFailed);
                    }
                    Object var8_23 = null;
                    this.controller.serviceCompletionLatch.countDown();
                }
                catch (Throwable throwable2) {
                    Object var8_24 = null;
                    this.controller.serviceCompletionLatch.countDown();
                    this.controller.log.debug((Object)("Processed [" + this.serviceName + "]"));
                    Thread.currentThread().setName(originalThreadName);
                    throw throwable2;
                }
                this.controller.log.debug((Object)("Processed [" + this.serviceName + "]"));
                Thread.currentThread().setName(originalThreadName);
                throw throwable;
            }
            this.controller.log.debug((Object)("Processed [" + this.serviceName + "]"));
            Thread.currentThread().setName(originalThreadName);
        }

        public abstract void executeService() throws LatchedServiceException;

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getServiceName() + ":");
            boolean first = true;
            for (LatchedService dep : this.dependencies) {
                if (!first) {
                    builder.append("|");
                } else {
                    first = false;
                }
                builder.append(dep.getServiceName());
            }
            return builder.toString();
        }

        public final int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LatchedService other = (LatchedService)obj;
            return !(this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName));
        }
    }
}

