/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorMetadataParser;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPluginScanner {
    private Log log = LogFactory.getLog(ServerPluginScanner.class);
    private List<File> scanned = new ArrayList<File>();
    private Map<File, PluginWithDescriptor> serverPluginsOnFilesystem = new HashMap<File, PluginWithDescriptor>();
    private File serverPluginDir;

    public File getServerPluginDir() {
        return this.serverPluginDir;
    }

    public void setServerPluginDir(File dir) {
        this.serverPluginDir = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerServerPlugins() throws Exception {
        for (File file : this.scanned) {
            this.log.debug((Object)("Deploying server plugin [" + file + "]..."));
            this.registerServerPlugin(file);
        }
        this.scanned.clear();
        ServerPluginsLocal serverPluginsManager = LookupUtil.getServerPlugins();
        List<ServerPlugin> allPlugins = serverPluginsManager.getAllServerPlugins();
        ArrayList<ServerPlugin> installedPlugins = new ArrayList<ServerPlugin>();
        ArrayList<ServerPlugin> undeployedPlugins = new ArrayList<ServerPlugin>();
        for (ServerPlugin plugin : allPlugins) {
            if (plugin.getStatus() == PluginStatusType.INSTALLED) {
                installedPlugins.add(plugin);
                continue;
            }
            undeployedPlugins.add(plugin);
        }
        for (ServerPlugin undeployedPlugin : undeployedPlugins) {
            Object var11_10;
            File undeployedFile = new File(this.getServerPluginDir(), undeployedPlugin.getPath());
            PluginWithDescriptor pluginWithDescriptor = this.serverPluginsOnFilesystem.get(undeployedFile);
            if (pluginWithDescriptor == null) continue;
            try {
                this.log.info((Object)("Plugin file [" + undeployedFile + "] has been undeployed. It will be deleted."));
                List<Integer> id = Arrays.asList(new Integer(undeployedPlugin.getId()));
                serverPluginsManager.undeployServerPlugins(LookupUtil.getSubjectManager().getOverlord(), id);
                var11_10 = null;
                this.serverPluginsOnFilesystem.remove(undeployedFile);
            }
            catch (Throwable throwable) {
                var11_10 = null;
                this.serverPluginsOnFilesystem.remove(undeployedFile);
                throw throwable;
            }
            {
            }
        }
        MasterServerPluginContainer master = LookupUtil.getServerPluginService().getMasterPluginContainer();
        if (master != null) {
            for (ServerPlugin installedPlugin : installedPlugins) {
                PluginKey key = PluginKey.createServerPluginKey((String)installedPlugin.getType(), (String)installedPlugin.getName());
                Object pc = master.getPluginContainerByPlugin(key);
                if (pc == null || !((AbstractTypeServerPluginContainer)pc).isPluginLoaded(key)) continue;
                boolean needToReloadPlugin = false;
                boolean currentlyEnabled = ((AbstractTypeServerPluginContainer)pc).isPluginEnabled(key);
                if (installedPlugin.isEnabled() != currentlyEnabled) {
                    this.log.info((Object)("Detected a state change to plugin [" + key + "]. It will now be " + (installedPlugin.isEnabled() ? "[enabled]" : "[disabled]")));
                    needToReloadPlugin = true;
                } else {
                    long configChangeTimestamp;
                    Long pluginLoadTime = ((AbstractTypeServerPluginContainer)pc).getPluginLoadTime(key);
                    if (pluginLoadTime != null && (configChangeTimestamp = serverPluginsManager.getLastConfigurationChangeTimestamp(installedPlugin.getId())) > pluginLoadTime) {
                        this.log.info((Object)("Detected a config change to plugin [" + key + "]. It will be reloaded and " + (installedPlugin.isEnabled() ? "[enabled]" : "[disabled]")));
                        needToReloadPlugin = true;
                    }
                }
                if (!needToReloadPlugin) continue;
                ((AbstractTypeServerPluginContainer)pc).reloadPlugin(key, installedPlugin.isEnabled());
            }
        }
    }

    void serverPluginScan() throws Exception {
        this.log.debug((Object)"Scanning for server plugins");
        if (this.getServerPluginDir() == null || !this.getServerPluginDir().isDirectory()) {
            return;
        }
        List<File> updatedFiles1 = this.serverPluginScanFilesystem();
        List<File> updatedFiles2 = this.serverPluginScanDatabase();
        ArrayList<File> allUpdatedFiles = new ArrayList<File>();
        allUpdatedFiles.addAll(updatedFiles1);
        allUpdatedFiles.addAll(updatedFiles2);
        for (File updatedFile : allUpdatedFiles) {
            this.log.debug((Object)("Scan detected server plugin [" + updatedFile + "]..."));
            this.scanned.add(updatedFile);
        }
    }

    private void registerServerPlugin(File pluginFile) {
        try {
            PluginKey newPluginKey;
            ServerPluginsLocal serverPluginsManager;
            PluginStatusType status;
            ServerPluginDescriptorType descriptor = this.serverPluginsOnFilesystem.get((Object)pluginFile).descriptor;
            String pluginName = descriptor.getName();
            String displayName = descriptor.getDisplayName();
            ComparableVersion version = ServerPluginDescriptorUtil.getPluginVersion((File)pluginFile, (ServerPluginDescriptorType)descriptor);
            this.log.debug((Object)("Registering server plugin [" + pluginName + "], version " + version));
            ServerPlugin plugin = new ServerPlugin(pluginName, pluginFile.getName());
            plugin.setDisplayName(displayName != null ? displayName : pluginName);
            plugin.setEnabled(!descriptor.isDisabledOnDiscovery());
            plugin.setDescription(descriptor.getDescription());
            plugin.setMtime(pluginFile.lastModified());
            plugin.setVersion(version.toString());
            plugin.setAmpsVersion(descriptor.getApiVersion());
            plugin.setMD5(MessageDigestGenerator.getDigestString((File)pluginFile));
            plugin.setPluginConfiguration(this.getDefaultPluginConfiguration(descriptor));
            plugin.setScheduledJobsConfiguration(this.getDefaultScheduledJobsConfiguration(descriptor));
            plugin.setType(new ServerPluginType(descriptor).stringify());
            if (descriptor.getHelp() != null && !descriptor.getHelp().getContent().isEmpty()) {
                plugin.setHelp(String.valueOf(descriptor.getHelp().getContent().get(0)));
            }
            if (PluginStatusType.DELETED == (status = (serverPluginsManager = LookupUtil.getServerPlugins()).getServerPluginStatus(newPluginKey = new PluginKey(plugin)))) {
                this.log.warn((Object)("Plugin file [" + pluginFile + "] has been detected but that plugin with name [" + pluginName + "] was previously undeployed. Will not re-register that plugin and the file will be deleted."));
                pluginFile.delete();
            } else {
                SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
                ServerPlugin dbPlugin = serverPluginsManager.registerServerPlugin(subjectManager.getOverlord(), plugin, pluginFile);
                this.log.info((Object)("Registered server plugin [" + dbPlugin.getName() + "], version " + dbPlugin.getVersion()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to register server plugin file [" + pluginFile + "]"), (Throwable)e);
        }
    }

    private Configuration getDefaultPluginConfiguration(ServerPluginDescriptorType descriptor) throws Exception {
        Configuration defaults = null;
        ConfigurationDefinition def = ServerPluginDescriptorMetadataParser.getPluginConfigurationDefinition((ServerPluginDescriptorType)descriptor);
        if (def != null) {
            defaults = def.getDefaultTemplate().createConfiguration();
        }
        return defaults;
    }

    private Configuration getDefaultScheduledJobsConfiguration(ServerPluginDescriptorType descriptor) throws Exception {
        Configuration defaults = null;
        ConfigurationDefinition def = ServerPluginDescriptorMetadataParser.getScheduledJobsDefinition((ServerPluginDescriptorType)descriptor);
        if (def != null) {
            defaults = def.getDefaultTemplate().createConfiguration();
        }
        return defaults;
    }

    private List<File> serverPluginScanFilesystem() {
        ArrayList<File> updated = new ArrayList<File>();
        File[] pluginJars = this.getServerPluginDir().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        ArrayList<File> doomedPluginFiles = new ArrayList<File>();
        for (File cachedPluginFile : this.serverPluginsOnFilesystem.keySet()) {
            boolean existsOnFileSystem = false;
            for (File filesystemPluginFile : pluginJars) {
                if (!cachedPluginFile.equals(filesystemPluginFile)) continue;
                existsOnFileSystem = true;
                break;
            }
            if (existsOnFileSystem) continue;
            doomedPluginFiles.add(cachedPluginFile);
        }
        for (File deletedPluginFile : doomedPluginFiles) {
            this.serverPluginsOnFilesystem.remove(deletedPluginFile);
        }
        for (File pluginJar : pluginJars) {
            String md5 = null;
            PluginWithDescriptor pluginWithDescriptor = this.serverPluginsOnFilesystem.get(pluginJar);
            ServerPlugin plugin = null;
            if (pluginWithDescriptor != null) {
                plugin = pluginWithDescriptor.plugin;
            }
            try {
                if (plugin != null) {
                    if (pluginJar.lastModified() == 0L) {
                        md5 = MessageDigestGenerator.getDigestString((File)pluginJar);
                        if (!md5.equals(plugin.getMd5())) {
                            plugin = null;
                        }
                    } else if (pluginJar.lastModified() != plugin.getMtime()) {
                        plugin = null;
                    }
                }
                if (plugin != null) continue;
                this.cacheFilesystemServerPluginJar(pluginJar, md5);
                updated.add(pluginJar);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to scan server plugin [" + pluginJar + "] found on filesystem. Skipping. Cause: " + e));
                this.serverPluginsOnFilesystem.remove(pluginJar);
                updated.remove(pluginJar);
            }
        }
        doomedPluginFiles.clear();
        HashMap<String, ServerPlugin> pluginsByName = new HashMap<String, ServerPlugin>();
        for (Map.Entry<File, PluginWithDescriptor> currentPluginFileEntry : this.serverPluginsOnFilesystem.entrySet()) {
            ServerPlugin currentPlugin = currentPluginFileEntry.getValue().plugin;
            ServerPlugin existingPlugin = (ServerPlugin)pluginsByName.get(currentPlugin.getName() + currentPlugin.getType());
            if (existingPlugin == null) {
                pluginsByName.put(currentPlugin.getName() + currentPlugin.getType(), currentPlugin);
                continue;
            }
            ServerPlugin obsolete = ServerPluginDescriptorUtil.determineObsoletePlugin((ServerPlugin)currentPlugin, (ServerPlugin)existingPlugin);
            if (obsolete == null) {
                obsolete = currentPlugin;
            }
            doomedPluginFiles.add(new File(this.getServerPluginDir(), obsolete.getPath()));
            if (obsolete != existingPlugin) continue;
            pluginsByName.put(currentPlugin.getName() + currentPlugin.getType(), currentPlugin);
        }
        for (File doomedPluginFile : doomedPluginFiles) {
            if (doomedPluginFile.delete()) {
                this.log.info((Object)("Deleted an obsolete server plugin file: " + doomedPluginFile));
                this.serverPluginsOnFilesystem.remove(doomedPluginFile);
                updated.remove(doomedPluginFile);
                continue;
            }
            this.log.warn((Object)("Failed to delete what was deemed an obsolete server plugin file: " + doomedPluginFile));
        }
        return updated;
    }

    private ServerPlugin cacheFilesystemServerPluginJar(File pluginJar, String md5) throws Exception {
        if (md5 == null) {
            md5 = MessageDigestGenerator.getDigestString((File)pluginJar);
        }
        URL pluginUrl = pluginJar.toURI().toURL();
        ServerPluginDescriptorType descriptor = ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)pluginUrl);
        String version = ServerPluginDescriptorUtil.getPluginVersion((File)pluginJar, (ServerPluginDescriptorType)descriptor).toString();
        String name = descriptor.getName();
        ServerPlugin plugin = new ServerPlugin(name, pluginJar.getName());
        plugin.setType(new ServerPluginType(descriptor).stringify());
        plugin.setMd5(md5);
        plugin.setVersion(version);
        plugin.setMtime(pluginJar.lastModified());
        this.serverPluginsOnFilesystem.put(pluginJar, new PluginWithDescriptor(plugin, descriptor));
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> serverPluginScanDatabase() throws Exception {
        ArrayList<ServerPlugin> updatedPlugins = new ArrayList<ServerPlugin>();
        ArrayList<File> updatedFiles = new ArrayList<File>();
        ServerPluginsLocal serverPluginsManager = LookupUtil.getServerPlugins();
        List<ServerPlugin> installedPlugins = serverPluginsManager.getServerPlugins();
        for (ServerPlugin installedPlugin : installedPlugins) {
            String name = installedPlugin.getName();
            String path = installedPlugin.getPath();
            String md5 = installedPlugin.getMd5();
            long mtime = installedPlugin.getMtime();
            String version = installedPlugin.getVersion();
            ServerPluginType pluginType = new ServerPluginType(installedPlugin.getType());
            File expectedFile = new File(this.getServerPluginDir(), path);
            File currentFile = null;
            PluginWithDescriptor pluginWithDescriptor = this.serverPluginsOnFilesystem.get(expectedFile);
            if (pluginWithDescriptor != null) {
                currentFile = expectedFile;
                if (!pluginWithDescriptor.plugin.getName().equals(name) || !pluginType.equals(pluginWithDescriptor.pluginType)) {
                    this.log.warn((Object)("For some reason, the server plugin file [" + expectedFile + "] is plugin [" + pluginWithDescriptor.plugin.getName() + "] of type [" + pluginWithDescriptor.pluginType + "] but the database says it should be [" + name + "] of type [" + pluginType + "]"));
                } else {
                    this.log.debug((Object)("File system and db agree on server plugin location for [" + expectedFile + "]"));
                }
            } else {
                for (Map.Entry<File, PluginWithDescriptor> cacheEntry : this.serverPluginsOnFilesystem.entrySet()) {
                    if (!cacheEntry.getValue().plugin.getName().equals(name) || !cacheEntry.getValue().pluginType.equals(pluginType)) continue;
                    currentFile = cacheEntry.getKey();
                    pluginWithDescriptor = cacheEntry.getValue();
                    this.log.info((Object)("Filesystem has a server plugin [" + name + "] at the file [" + currentFile + "] which is different than where the DB thinks it should be [" + expectedFile + "]"));
                    break;
                }
            }
            if (pluginWithDescriptor != null && currentFile != null && currentFile.exists()) {
                ServerPlugin dbPlugin = new ServerPlugin(name, path);
                dbPlugin.setType(pluginType.stringify());
                dbPlugin.setMd5(md5);
                dbPlugin.setVersion(version);
                dbPlugin.setMtime(mtime);
                ServerPlugin obsoletePlugin = ServerPluginDescriptorUtil.determineObsoletePlugin((ServerPlugin)dbPlugin, (ServerPlugin)pluginWithDescriptor.plugin);
                if (obsoletePlugin == pluginWithDescriptor.plugin) {
                    StringBuilder logMsg = new StringBuilder();
                    logMsg.append("Found server plugin [").append(name);
                    logMsg.append("] in the DB that is newer than the one on the filesystem: ");
                    logMsg.append("DB path=[").append(path);
                    logMsg.append("]; file path=[").append(currentFile.getName());
                    logMsg.append("]; DB MD5=[").append(md5);
                    logMsg.append("]; file MD5=[").append(pluginWithDescriptor.plugin.getMd5());
                    logMsg.append("]; DB version=[").append(version);
                    logMsg.append("]; file version=[").append(pluginWithDescriptor.plugin.getVersion());
                    logMsg.append("]; DB timestamp=[").append(new Date(mtime));
                    logMsg.append("]; file timestamp=[").append(new Date(pluginWithDescriptor.plugin.getMtime()));
                    logMsg.append("]");
                    this.log.info((Object)logMsg.toString());
                    updatedPlugins.add(dbPlugin);
                    if (currentFile.delete()) {
                        this.log.info((Object)("Deleted the obsolete server plugin file to be updated: " + currentFile));
                        this.serverPluginsOnFilesystem.remove(currentFile);
                    } else {
                        this.log.warn((Object)("Failed to delete the obsolete (to-be-updated) server plugin: " + currentFile));
                    }
                    currentFile = null;
                    continue;
                }
                if (obsoletePlugin == null) {
                    currentFile.setLastModified(mtime);
                    pluginWithDescriptor.plugin.setMtime(mtime);
                    pluginWithDescriptor.plugin.setVersion(version);
                    pluginWithDescriptor.plugin.setMd5(md5);
                    continue;
                }
                this.log.info((Object)("It appears that the server plugin [" + dbPlugin + "] in the database may be obsolete. If so, it will be updated later."));
                continue;
            }
            this.log.info((Object)("Found server plugin in the DB that we do not yet have: " + name));
            ServerPlugin plugin = new ServerPlugin(name, path, md5);
            plugin.setType(pluginType.stringify());
            plugin.setMtime(mtime);
            plugin.setVersion(version);
            updatedPlugins.add(plugin);
            this.serverPluginsOnFilesystem.remove(expectedFile);
        }
        if (!updatedPlugins.isEmpty()) {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                DataSource ds = LookupUtil.getDataSource();
                conn = ds.getConnection();
                ps = conn.prepareStatement("SELECT CONTENT FROM RHQ_PLUGIN WHERE DEPLOYMENT = 'SERVER' AND STATUS = 'INSTALLED' AND NAME = ? AND PTYPE = ?");
                for (ServerPlugin plugin : updatedPlugins) {
                    File file = new File(this.getServerPluginDir(), plugin.getPath());
                    ps.setString(1, plugin.getName());
                    ps.setString(2, plugin.getType());
                    rs = ps.executeQuery();
                    rs.next();
                    InputStream content = rs.getBinaryStream(1);
                    StreamUtil.copy((InputStream)content, (OutputStream)new FileOutputStream(file));
                    rs.close();
                    file.setLastModified(plugin.getMtime());
                    updatedFiles.add(file);
                    this.cacheFilesystemServerPluginJar(file, null);
                }
                Object var21_21 = null;
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                JDBCUtil.safeClose((Connection)conn, (Statement)ps, rs);
                throw throwable;
            }
            JDBCUtil.safeClose((Connection)conn, (Statement)ps, rs);
            {
            }
        }
        return updatedFiles;
    }

    private class PluginWithDescriptor {
        public final ServerPlugin plugin;
        public final ServerPluginDescriptorType descriptor;
        public final ServerPluginType pluginType;

        public PluginWithDescriptor(ServerPlugin plugin, ServerPluginDescriptorType descriptor) {
            this.plugin = plugin;
            this.descriptor = descriptor;
            this.pluginType = new ServerPluginType(descriptor);
        }
    }
}

