/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.install.remote;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.install.remote.AgentInstallInfo;
import org.rhq.core.domain.install.remote.AgentInstallStep;
import org.rhq.core.domain.install.remote.RemoteAccessInfo;
import org.rhq.enterprise.server.install.remote.SSHFileSend;
import org.rhq.enterprise.server.util.LookupUtil;

public class SSHInstallUtility {
    static final int DEFAULT_BUFFER_SIZE = 4096;
    static final long TIMEOUT = 10000L;
    static final long POLL_TIMEOUT = 1000L;
    private Log log = LogFactory.getLog(SSHInstallUtility.class);
    private RemoteAccessInfo accessInfo;
    private Session session;
    private String agentDestination = "/tmp/rhqAgent";
    private String agentFile = "rhq-enterprise-agent-3.0.0-SNAPSHOT.jar";
    private String agentPath = "/projects/rhq/dev-container/jbossas/server/default/deploy/rhq.ear/rhq-downloads/rhq-agent/" + this.agentFile;

    public SSHInstallUtility(RemoteAccessInfo accessInfo) {
        this.accessInfo = accessInfo;
        try {
            File agentBinaryFile = LookupUtil.getAgentManager().getAgentUpdateBinaryFile();
            this.agentPath = agentBinaryFile.getCanonicalPath();
            this.agentFile = agentBinaryFile.getName();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed agent binary file lookup", (Throwable)e);
        }
        if (!new File(this.agentPath).exists()) {
            throw new RuntimeException("Unable to find agent binary file for installation at [" + this.agentPath + "]");
        }
        this.connect();
    }

    public void connect() {
        try {
            JSch jsch = new JSch();
            jsch.addIdentity("/Users/ghinkle/.ssh/ghinkleawskey.pem");
            this.session = jsch.getSession(this.accessInfo.getUser(), this.accessInfo.getHost(), 22);
            if (this.accessInfo.getPass() != null) {
                this.session.setPassword(this.accessInfo.getPass());
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.connect(30000);
        }
        catch (JSchException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void disconnect() {
        this.session.disconnect();
    }

    public String[] pathDiscovery(String parentPath) {
        String full = this.executeCommand("ls" + parentPath);
        return full.split("\n");
    }

    private String executeCommand(String command, String description) {
        return this.executeCommand(command, description, new AgentInstallInfo(null, null));
    }

    private String executeCommand(String command, String description, AgentInstallInfo info) {
        this.log.info((Object)("Running: " + description));
        long start = System.currentTimeMillis();
        String result = null;
        try {
            result = this.executeCommand(command);
            info.addStep(new AgentInstallStep(0, command, description, result, System.currentTimeMillis() - start));
        }
        catch (ExecuteException e) {
            info.addStep(new AgentInstallStep(e.errorCode, command, e.message, description, System.currentTimeMillis() - start));
        }
        this.log.info((Object)("Result [" + description + "]: " + result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeCommand(String command) {
        ChannelExec channel = null;
        int exitStatus = 0;
        InputStream is = null;
        InputStream es = null;
        try {
            channel = (ChannelExec)this.session.openChannel("exec");
            channel.setCommand(command);
            is = channel.getInputStream();
            es = channel.getErrStream();
            channel.connect(10000);
            String out = this.read(is, (Channel)channel);
            String err = this.read(es, (Channel)channel);
            if (err.length() > 0) {
                if (channel.getExitStatus() != 0) {
                    throw new ExecuteException(channel.getExitStatus(), err);
                }
                if (out.length() == 0) {
                    String string = err;
                    return string;
                }
            }
            String string = out;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                es.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (channel != null) {
                channel.disconnect();
            }
        }
        return "exit: " + exitStatus;
    }

    public String read(InputStream is, Channel channel) throws IOException {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        long endTime = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < endTime) {
            int count;
            while (is.available() > 0 && (count = is.read(buffer, 0, 4096)) >= 0) {
                bos.write(buffer, 0, count);
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return bos.toString();
    }

    public String read2(BufferedReader reader) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            buf.append(line + "\n");
        }
        return buf.toString();
    }

    public String agentStop() {
        String agentWrapperScript = this.agentDestination + "/rhq-agent/bin/rhq-agent-wrapper.sh ";
        return this.executeCommand(agentWrapperScript + " stop", "Agent Stop");
    }

    public String agentStart() {
        String agentWrapperScript = this.agentDestination + "/rhq-agent/bin/rhq-agent-wrapper.sh ";
        return this.executeCommand(agentWrapperScript + " start", "Agent Start");
    }

    public String agentStatus() {
        String agentWrapperScript = this.agentDestination + "/rhq-agent/bin/rhq-agent-wrapper.sh ";
        String value = this.executeCommand("if  [ -f " + agentWrapperScript + " ]; then echo \"exists\"; fi");
        if (value == null || value.length() == 0) {
            return "Agent Not Installed";
        }
        return this.executeCommand(agentWrapperScript + " status", "Agent Status");
    }

    public AgentInstallInfo installAgent() {
        AgentInstallInfo info = new AgentInstallInfo(this.agentDestination, this.accessInfo.getUser(), "3.0.0-SNAPSHOT");
        this.executeCommand("uname -a", "Machine uname", info);
        this.executeCommand("java -version", "Java Version Check", info);
        this.executeCommand("mkdir -p " + this.agentDestination, "Create Agent Install Directory", info);
        this.log.info((Object)"Copying Agent Distribution");
        long start = System.currentTimeMillis();
        boolean fileSent = SSHFileSend.sendFile(this.session, this.agentPath, this.agentDestination);
        info.addStep(new AgentInstallStep(0, "scp agent-installer", "Remote copy the agent distribution", fileSent ? "Success" : "Failed", System.currentTimeMillis() - start));
        this.log.info((Object)"Agent Distribution Copied");
        this.executeCommand("cd " + this.agentDestination, "Change to install directory", info);
        this.executeCommand("java -jar " + this.agentDestination + "/" + this.agentFile + " --install=" + this.agentDestination, "Install Agent", info);
        String serverAddress = LookupUtil.getCloudManager().getAllCloudServers().get(0).getAddress();
        System.out.println("Install an agent at " + this.accessInfo.getHost() + " point to the server " + serverAddress);
        AgentInstallInfo agentInfo = new AgentInstallInfo(serverAddress, this.accessInfo.getHost());
        String agentScript = this.agentDestination + "/rhq-agent/bin/rhq-agent.sh ";
        String agentWrapperScript = this.agentDestination + "/rhq-agent/bin/rhq-agent-wrapper.sh ";
        String properties = agentInfo.getConfigurationStartString();
        String pidFileProp = "export RHQ_AGENT_IN_BACKGROUND=" + this.agentDestination + "/rhq-agent/bin/rhq-agent.pid";
        String startCommand = pidFileProp + " ; nohup " + agentScript + properties + "&";
        this.executeCommand(startCommand, "Agent Start With Configuration", info);
        return info;
    }

    public static void main(String[] args) throws IOException {
        String pass = null;
        if (args.length > 2) {
            pass = args[2];
        }
        RemoteAccessInfo info = new RemoteAccessInfo(args[0], args[1], pass);
        SSHInstallUtility ssh = new SSHInstallUtility(info);
        System.out.println("Agent status: " + ssh.agentStatus());
        System.out.println("Set server address: " + ssh.executeCommand("echo '71.162.145.95    ghinkle' >> /etc/hosts"));
        ssh.agentStop();
        ssh.installAgent();
        ssh.agentStatus();
        ssh.agentStop();
        ssh.agentStatus();
        ssh.agentStart();
        ssh.disconnect();
    }

    public static class ExecuteException
    extends RuntimeException {
        int errorCode;
        String message;

        public ExecuteException(int errorCode, String message) {
            this.errorCode = errorCode;
            this.message = message;
        }
    }
}

