/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.disambiguation;

import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationPolicy;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationUpdateStrategy;
import org.rhq.enterprise.server.resource.disambiguation.MutableDisambiguationReport;
import org.rhq.enterprise.server.resource.disambiguation.ResourceResolution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DefaultDisambiguationUpdateStrategies implements DisambiguationUpdateStrategy
{
    EXACT{

        @Override
        public <T> void update(DisambiguationPolicy policy, MutableDisambiguationReport<T> report) {
            1.updateResources(policy, report);
            int nofParents = policy.size() - 1;
            if (nofParents < 0) {
                nofParents = 0;
            }
            if (nofParents == 0) {
                report.parents.clear();
            } else {
                while (report.parents.size() > nofParents) {
                    report.parents.remove(report.parents.size() - 1);
                }
            }
        }
    }
    ,
    KEEP_AT_LEAST_ONE_PARENT{

        @Override
        public <T> void update(DisambiguationPolicy policy, MutableDisambiguationReport<T> report) {
            2.updateResources(policy, report);
            int nofParents = policy.size() - 1;
            if (nofParents < 1) {
                nofParents = 1;
            }
            while (report.parents.size() > nofParents) {
                report.parents.remove(report.parents.size() - 1);
            }
        }

        @Override
        public EnumSet<ResourceResolution> resourceLevelRepartitionableResolutions() {
            return EnumSet.allOf(ResourceResolution.class);
        }
    }
    ,
    KEEP_PARENTS_TO_TOPMOST_SERVERS{

        @Override
        public <T> void update(DisambiguationPolicy policy, MutableDisambiguationReport<T> report) {
            3.updateResources(policy, report);
            if (policy.size() > 1 && report.parents.size() > policy.size() - 1) {
                report.parents.remove(report.parents.size() - 1);
            }
        }

        @Override
        public EnumSet<ResourceResolution> resourceLevelRepartitionableResolutions() {
            return EnumSet.allOf(ResourceResolution.class);
        }
    }
    ,
    KEEP_ALL_PARENTS{

        @Override
        public <T> void update(DisambiguationPolicy policy, MutableDisambiguationReport<T> report) {
            4.updateResources(policy, report);
        }

        @Override
        public EnumSet<ResourceResolution> resourceLevelRepartitionableResolutions() {
            return EnumSet.allOf(ResourceResolution.class);
        }
    };

    private static final Log log;

    public static <T> void updateResources(DisambiguationPolicy policy, MutableDisambiguationReport<T> report) {
        int disambiguationPolicyIndex;
        DefaultDisambiguationUpdateStrategies.updateResource((ResourceResolution)((Object)policy.get(0)), report.resource);
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateResource called with " + report));
        }
        for (disambiguationPolicyIndex = 1; disambiguationPolicyIndex < policy.size() && disambiguationPolicyIndex - 1 < report.parents.size(); ++disambiguationPolicyIndex) {
            ResourceResolution parentResolution = (ResourceResolution)((Object)policy.get(disambiguationPolicyIndex));
            MutableDisambiguationReport.Resource parent = report.parents.get(disambiguationPolicyIndex - 1);
            DefaultDisambiguationUpdateStrategies.updateResource(parentResolution, parent);
        }
        --disambiguationPolicyIndex;
        while (disambiguationPolicyIndex < report.parents.size()) {
            DefaultDisambiguationUpdateStrategies.updateResource(ResourceResolution.TYPE, report.parents.get(disambiguationPolicyIndex));
            ++disambiguationPolicyIndex;
        }
        if (policy.get(0) == ResourceResolution.PLUGIN) {
            MutableDisambiguationReport.Resource reportResource = report.resource;
            MutableDisambiguationReport.ResourceType reportType = reportResource.resourceType;
            String reportPlugin = reportType.plugin;
            for (MutableDisambiguationReport.Resource parent : report.parents) {
                if (parent == null) continue;
                MutableDisambiguationReport.ResourceType reportParentType = parent.resourceType;
                String reportParentPlugin = reportParentType.plugin;
                if (!reportPlugin.equals(reportParentPlugin)) continue;
                reportParentType.plugin = null;
            }
        }
    }

    @Override
    public EnumSet<ResourceResolution> resourceLevelRepartitionableResolutions() {
        return EnumSet.noneOf(ResourceResolution.class);
    }

    @Override
    public EnumSet<ResourceResolution> alwaysRepartitionableResolutions() {
        return EnumSet.noneOf(ResourceResolution.class);
    }

    private static void updateResource(ResourceResolution resolution, MutableDisambiguationReport.Resource resource) {
        switch (resolution) {
            case NAME: 
            case TYPE: {
                resource.resourceType.plugin = null;
            }
        }
    }

    public static DefaultDisambiguationUpdateStrategies getDefault() {
        return KEEP_ALL_PARENTS;
    }

    static {
        log = LogFactory.getLog(DefaultDisambiguationUpdateStrategies.class);
    }
}

