/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.alert.AlertDefinitionCreationException;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionUpdateException;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.InvalidAlertDefinitionException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;

@Stateless
public class GroupAlertDefinitionManagerBean
implements GroupAlertDefinitionManagerLocal {
    private static final Log LOG = LogFactory.getLog(GroupAlertDefinitionManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    @IgnoreDependency
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    public PageList<AlertDefinition> findGroupAlertDefinitions(Subject subject, int resourceGroupId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("ctime", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"AlertDefinition.findByResourceGroup");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AlertDefinition.findByResourceGroup", (PageControl)pageControl);
        queryCount.setParameter("groupId", (Object)resourceGroupId);
        query.setParameter("groupId", (Object)resourceGroupId);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        return new PageList((Collection)list, (int)totalCount, pageControl);
    }

    private List<Integer> getChildrenAlertDefinitionIds(Subject subject, int groupAlertDefinitionId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.findByGroupAlertDefinitionId");
        query.setParameter("groupAlertDefinitionId", (Object)groupAlertDefinitionId);
        List list = query.getResultList();
        return list;
    }

    @Override
    public int removeGroupAlertDefinitions(Subject subject, Integer[] groupAlertDefinitionIds) {
        if (groupAlertDefinitionIds == null || groupAlertDefinitionIds.length == 0) {
            return 0;
        }
        int modified = 0;
        ArrayList<Integer> allChildDefinitionIds = new ArrayList<Integer>();
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer groupAlertDefinitionId : groupAlertDefinitionIds) {
            List<Integer> childDefinitions = this.getChildrenAlertDefinitionIds(subject, groupAlertDefinitionId);
            allChildDefinitionIds.addAll(childDefinitions);
            modified += this.alertDefinitionManager.removeAlertDefinitions(subject, new int[]{groupAlertDefinitionId});
            this.alertDefinitionManager.removeAlertDefinitions(overlord, ArrayUtils.unwrapCollection(childDefinitions));
        }
        if (allChildDefinitionIds.size() > 0) {
            Query breakLinksQuery = this.entityManager.createNamedQuery("AlertDefinition.updateSetParentsNull");
            breakLinksQuery.setParameter("childrenDefinitionIds", allChildDefinitionIds);
            breakLinksQuery.executeUpdate();
        }
        return modified;
    }

    private List<Integer> getCommittedResourceIdsNeedingGroupAlertDefinitionApplication(Subject subject, int groupAlertDefinitionId, int resourceGroupId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.findResourceIdsNeedingGroupApplication");
        query.setParameter("groupAlertDefinitionId", (Object)groupAlertDefinitionId);
        query.setParameter("resourceGroupId", (Object)resourceGroupId);
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        List list = query.getResultList();
        return list;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int createGroupAlertDefinitions(Subject subject, AlertDefinition groupAlertDefinition, Integer resourceGroupId) throws InvalidAlertDefinitionException, AlertDefinitionCreationException {
        ResourceGroup group = this.resourceGroupManager.getResourceGroupById(subject, resourceGroupId, null);
        groupAlertDefinition.setResourceGroup(group);
        int groupAlertDefinitionId = 0;
        try {
            groupAlertDefinitionId = this.alertDefinitionManager.createAlertDefinition(subject, groupAlertDefinition, null);
        }
        catch (Throwable t) {
            throw new AlertDefinitionCreationException("Could not create groupAlertDefinitions for " + group + " with data " + groupAlertDefinition.toSimpleString(), t);
        }
        Subject overlord = this.subjectManager.getOverlord();
        Throwable firstThrowable = null;
        List<Integer> resourceIdsForGroup = this.getCommittedResourceIdsNeedingGroupAlertDefinitionApplication(subject, groupAlertDefinitionId, resourceGroupId);
        ArrayList<Integer> resourceIdsInError = new ArrayList<Integer>();
        for (Integer resourceId : resourceIdsForGroup) {
            try {
                AlertDefinition childAlertDefinition = new AlertDefinition(groupAlertDefinition);
                childAlertDefinition.setGroupAlertDefinition(groupAlertDefinition);
                this.alertDefinitionManager.createAlertDefinition(overlord, childAlertDefinition, resourceId);
            }
            catch (Throwable t) {
                if (firstThrowable == null) {
                    firstThrowable = t;
                }
                resourceIdsInError.add(resourceId);
            }
        }
        if (firstThrowable != null) {
            throw new AlertDefinitionCreationException("Could not create alert definition child for Resources " + resourceIdsInError + " with group " + groupAlertDefinition.toSimpleString(), firstThrowable);
        }
        return groupAlertDefinitionId;
    }

    @Override
    public int disableGroupAlertDefinitions(Subject subject, Integer[] groupAlertDefinitionIds) {
        if (groupAlertDefinitionIds == null || groupAlertDefinitionIds.length == 0) {
            return 0;
        }
        int modified = 0;
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer groupAlertDefinitionId : groupAlertDefinitionIds) {
            List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(subject, groupAlertDefinitionId);
            modified += this.alertDefinitionManager.disableAlertDefinitions(subject, new int[]{groupAlertDefinitionId});
            this.alertDefinitionManager.disableAlertDefinitions(overlord, ArrayUtils.unwrapCollection(alertDefinitions));
        }
        return modified;
    }

    @Override
    public int enableGroupAlertDefinitions(Subject subject, Integer[] groupAlertDefinitionIds) {
        if (groupAlertDefinitionIds == null || groupAlertDefinitionIds.length == 0) {
            return 0;
        }
        int modified = 0;
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer groupAlertDefinitionId : groupAlertDefinitionIds) {
            List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(subject, groupAlertDefinitionId);
            modified += this.alertDefinitionManager.enableAlertDefinitions(subject, new int[]{groupAlertDefinitionId});
            this.alertDefinitionManager.enableAlertDefinitions(overlord, ArrayUtils.unwrapCollection(alertDefinitions));
        }
        return modified;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public AlertDefinition updateGroupAlertDefinitions(Subject subject, AlertDefinition groupAlertDefinition, boolean purgeInternals) throws InvalidAlertDefinitionException, AlertDefinitionUpdateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updateGroupAlertDefinition: " + groupAlertDefinition));
        }
        AlertDefinition updated = null;
        try {
            updated = this.alertDefinitionManager.updateAlertDefinition(subject, groupAlertDefinition.getId(), groupAlertDefinition, purgeInternals);
        }
        catch (Throwable t) {
            throw new AlertDefinitionUpdateException("Failed to update a GroupAlertDefinition: " + groupAlertDefinition.toSimpleString(), t);
        }
        Subject overlord = this.subjectManager.getOverlord();
        Throwable firstThrowable = null;
        List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(overlord, groupAlertDefinition.getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Need to update the following children alert definition ids: " + alertDefinitions));
        }
        ArrayList<Integer> alertDefinitionIdsInError = new ArrayList<Integer>();
        for (Integer alertDefinitionId : alertDefinitions) {
            try {
                this.alertDefinitionManager.updateAlertDefinition(overlord, alertDefinitionId, groupAlertDefinition, purgeInternals);
            }
            catch (Throwable t) {
                if (firstThrowable == null) {
                    firstThrowable = t;
                }
                alertDefinitionIdsInError.add(alertDefinitionId);
            }
        }
        List<Integer> resourceIds = this.getCommittedResourceIdsNeedingGroupAlertDefinitionApplication(overlord, groupAlertDefinition.getId(), this.getResourceGroupIdForAlertDefinitionId(groupAlertDefinition.getId()));
        ArrayList<Integer> resourceIdsInError = new ArrayList<Integer>();
        for (Integer resourceId : resourceIds) {
            try {
                AlertDefinition childAlertDefinition = new AlertDefinition(groupAlertDefinition);
                childAlertDefinition.setGroupAlertDefinition(groupAlertDefinition);
                this.alertDefinitionManager.createAlertDefinition(overlord, childAlertDefinition, resourceId);
            }
            catch (Throwable t) {
                if (firstThrowable == null) {
                    firstThrowable = t;
                }
                resourceIdsInError.add(resourceId);
            }
        }
        if (firstThrowable != null) {
            StringBuilder error = new StringBuilder();
            if (alertDefinitionIdsInError.size() != 0) {
                error.append("Failed to update child AlertDefinitions " + alertDefinitionIdsInError + " ; ");
            }
            if (resourceIdsInError.size() != 0) {
                error.append("Failed to re-create child AlertDefinition for Resources " + resourceIdsInError + "; ");
            }
            throw new AlertDefinitionUpdateException(error.toString(), firstThrowable);
        }
        return updated;
    }

    @Override
    public void addGroupAlertDefinitions(Subject subject, int resourceGroupId, int[] resourcesIdsToAdd) throws AlertDefinitionCreationException {
        if (resourcesIdsToAdd == null || resourcesIdsToAdd.length == 0) {
            return;
        }
        Subject overlord = this.subjectManager.getOverlord();
        Throwable firstThrowable = null;
        PageList<AlertDefinition> groupAlertDefinitions = this.findGroupAlertDefinitions(subject, resourceGroupId, PageControl.getUnlimitedInstance());
        ArrayList<Integer> resourceIdsInError = new ArrayList<Integer>();
        for (AlertDefinition groupAlertDefinition : groupAlertDefinitions) {
            int[] arr$ = resourcesIdsToAdd;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer resourceId = arr$[i$];
                try {
                    AlertDefinition childAlertDefinition = new AlertDefinition(groupAlertDefinition);
                    childAlertDefinition.setGroupAlertDefinition(groupAlertDefinition);
                    this.alertDefinitionManager.createAlertDefinition(overlord, childAlertDefinition, resourceId);
                    continue;
                }
                catch (Throwable t) {
                    if (firstThrowable == null) {
                        firstThrowable = t;
                    }
                    resourceIdsInError.add(resourceId);
                }
            }
        }
        if (firstThrowable != null) {
            throw new AlertDefinitionCreationException("Could not create group alert definition children for Resources " + resourceIdsInError + " under ResourceGroup[id=" + resourceGroupId + "]", firstThrowable);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void purgeAllGroupAlertDefinitions(Subject subject, int resourceGroupId) {
        Integer[] groupAlertDefinitionIdsForResourceGroup = this.findGroupAlertDefinitionIds(resourceGroupId);
        this.removeGroupAlertDefinitions(subject, groupAlertDefinitionIdsForResourceGroup);
    }

    private Integer[] findGroupAlertDefinitionIds(int resourceGroupId) {
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.addFilterResourceGroupIds(new Integer[]{resourceGroupId});
        criteria.setPageControl(PageControl.getUnlimitedInstance());
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        generator.alterProjection("alertdefinition.id");
        Query query = generator.getQuery(this.entityManager);
        List groupAlertDefinitionIds = query.getResultList();
        Integer[] results = groupAlertDefinitionIds.toArray(new Integer[groupAlertDefinitionIds.size()]);
        return results;
    }

    @Override
    public void removeGroupAlertDefinitions(Subject subject, int resourceGroupId, int[] resourceIdsToRemove) {
        if (resourceIdsToRemove == null || resourceIdsToRemove.length == 0) {
            return;
        }
        Integer[] groupAlertDefinitionIdsForResourceGroup = this.findGroupAlertDefinitionIds(resourceGroupId);
        ArrayList<Integer> allChildrenDefinitionIds = new ArrayList<Integer>();
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer nextGroupAlertDefinitionId : groupAlertDefinitionIdsForResourceGroup) {
            List<Integer> childDefinitions = this.getChildrenAlertDefinitionIds(subject, nextGroupAlertDefinitionId);
            allChildrenDefinitionIds.addAll(childDefinitions);
            this.alertDefinitionManager.removeAlertDefinitions(overlord, ArrayUtils.unwrapCollection(childDefinitions));
        }
        if (allChildrenDefinitionIds.size() > 0) {
            Query breakLinksQuery = this.entityManager.createNamedQuery("AlertDefinition.updateSetParentsNull");
            breakLinksQuery.setParameter("childrenDefinitionIds", allChildrenDefinitionIds);
            breakLinksQuery.executeUpdate();
        }
    }

    private int getResourceGroupIdForAlertDefinitionId(int groupAlertDefinitionId) {
        Query query = this.entityManager.createQuery("SELECT groupAlertDefinition.resourceGroup.id   FROM AlertDefinition groupAlertDefinition  WHERE groupAlertDefinition.id = :groupAlertDefinitionId");
        query.setParameter("groupAlertDefinitionId", (Object)groupAlertDefinitionId);
        int groupId = ((Number)query.getSingleResult()).intValue();
        return groupId;
    }
}

