/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.alert.engine.model.AlertConditionOperator;
import org.rhq.enterprise.server.alert.engine.model.InvalidCacheElementException;
import org.rhq.enterprise.server.alert.engine.model.UnsupportedAlertConditionOperatorException;

public abstract class AbstractCacheElement<T> {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected AlertConditionOperator alertConditionOperator;
    protected Object alertConditionOperatorOption;
    protected T alertConditionValue;
    protected int alertConditionTriggerId;
    protected boolean active;
    protected AbstractCacheElement<?> nextCacheElement;

    public AbstractCacheElement(AlertConditionOperator operator, T value, int conditionTriggerId) {
        this(operator, null, value, conditionTriggerId);
    }

    public AbstractCacheElement(AlertConditionOperator operator, Object operatorOption, T value, int conditionId) {
        if (this.getOperatorSupportsType(operator) == AlertConditionOperator.Type.NONE) {
            throw new UnsupportedAlertConditionOperatorException("operator '" + operator.toString() + "'" + " is unsupported in class " + this.getClass().getSimpleName() + " for AlertConditionId=" + conditionId);
        }
        if (value == null) {
            if (operator == AlertConditionOperator.CHANGES || operator == AlertConditionOperator.CHANGES_TO || operator == AlertConditionOperator.CHANGES_FROM) {
                this.log.debug((Object)("Possible invalid Cache Element: condition with id=" + conditionId + " " + "and operator='" + operator.toString() + "' " + "passed a null value argument"));
            } else {
                throw new InvalidCacheElementException("Invalid Cache Element: condition with id=" + conditionId + " " + "and operator='" + operator.toString() + "' " + "requires a non-null value");
            }
        }
        if (operatorOption == null && (operator == AlertConditionOperator.CHANGES_TO || operator == AlertConditionOperator.CHANGES_FROM)) {
            throw new InvalidCacheElementException("operator '" + operator.toString() + "'" + " requires an operator option; it can not be null");
        }
        this.alertConditionOperatorOption = operatorOption;
        this.alertConditionOperator = operator;
        this.alertConditionValue = value;
        this.alertConditionTriggerId = conditionId;
    }

    public void setNextCacheElement(AbstractCacheElement<?> nextCacheElement) {
        this.nextCacheElement = nextCacheElement;
    }

    public AlertConditionOperator getAlertConditionOperator() {
        return this.alertConditionOperator;
    }

    public Object getAlertConditionOperatorOption() {
        return this.alertConditionOperatorOption;
    }

    public T getAlertConditionValue() {
        return this.alertConditionValue;
    }

    public void setAlertConditionValue(T updatedValue) {
        this.alertConditionValue = updatedValue;
    }

    public int getAlertConditionTriggerId() {
        return this.alertConditionTriggerId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public final boolean process(T providedValue, Object ... extraParams) {
        String beforeString = null;
        String afterString = null;
        if (this.log.isDebugEnabled()) {
            beforeString = this.toString();
        }
        boolean match = this.matches(providedValue, extraParams);
        if (this.log.isDebugEnabled()) {
            afterString = this.toString();
            this.log.debug((Object)("comparing " + (providedValue == null ? "<null>" : providedValue) + " " + "against " + beforeString + " " + (match ? "match" : "")));
            if (!afterString.equals(beforeString)) {
                this.log.debug((Object)("element updated: " + afterString));
            }
        }
        return match;
    }

    public abstract boolean matches(T var1, Object ... var2);

    public abstract AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator var1);

    public boolean isType(AlertConditionOperator.Type type) {
        return this.getOperatorSupportsType(this.alertConditionOperator) == type;
    }

    public String convertValueToString(T providedValue) {
        return providedValue.toString();
    }

    public String toString() {
        String conditionValue = null;
        try {
            conditionValue = this.alertConditionValue.toString();
        }
        catch (Throwable t) {
            conditionValue = t.getClass().getSimpleName() + "(" + this.alertConditionValue.getClass().getSimpleName() + ")";
        }
        return this.getClass().getSimpleName() + "[ " + "alertConditionTriggerId=" + this.alertConditionTriggerId + ", " + "alertConditionOperator=" + (Object)((Object)this.alertConditionOperator) + (this.alertConditionOperatorOption != null ? "(" + this.alertConditionOperatorOption + ")" : "") + ", " + "alertConditionValue=" + conditionValue + " ]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alertConditionOperator == null ? 0 : this.alertConditionOperator.hashCode());
        result = 31 * result + (this.alertConditionOperatorOption == null ? 0 : this.alertConditionOperatorOption.hashCode());
        result = 31 * result + this.alertConditionTriggerId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCacheElement other = (AbstractCacheElement)obj;
        if (this.alertConditionOperator == null ? other.alertConditionOperator != null : !this.alertConditionOperator.equals((Object)other.alertConditionOperator)) {
            return false;
        }
        if (this.alertConditionOperatorOption == null ? other.alertConditionOperatorOption != null : !this.alertConditionOperatorOption.equals(other.alertConditionOperatorOption)) {
            return false;
        }
        return this.alertConditionTriggerId == other.alertConditionTriggerId;
    }
}

