/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.auth.AuthSession;
import org.rhq.enterprise.server.auth.SessionException;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SessionTimeoutException;
import org.rhq.enterprise.server.util.LookupUtil;

public class SessionManager {
    private static Random _random = new Random();
    private static Map<Integer, AuthSession> _cache = new HashMap<Integer, AuthSession>();
    private static SessionManager _manager = new SessionManager();
    private static final long DEFAULT_TIMEOUT = 5400000L;
    private static final long OVERLORD_TIMEOUT = 120000L;
    private static final int OVERLORD_SUBJECT_ID = 1;
    private static Subject overlordSubject = null;

    private SessionManager() {
    }

    public static SessionManager getInstance() {
        return _manager;
    }

    public int put(Subject subject) {
        return this.put(subject, 5400000L);
    }

    public synchronized int put(Subject subject, long timeout) {
        Integer key;
        while (_cache.containsKey(key = new Integer(_random.nextInt()))) {
        }
        subject.setSessionId(key);
        _cache.put(key, new AuthSession(subject, timeout));
        return key;
    }

    public synchronized int getSessionIdFromUsername(String username) throws SessionNotFoundException, SessionTimeoutException {
        for (Map.Entry<Integer, AuthSession> map_entry : _cache.entrySet()) {
            int session_id = map_entry.getKey();
            AuthSession session = map_entry.getValue();
            if (!session.getSubject(false).getName().equals(username)) continue;
            if (session.isExpired()) {
                throw new SessionTimeoutException();
            }
            session.getSubject(true);
            return session_id;
        }
        throw new SessionNotFoundException();
    }

    public synchronized Subject getSubject(int sessionId) throws SessionNotFoundException, SessionTimeoutException {
        Integer id = new Integer(sessionId);
        AuthSession session = _cache.get(id);
        if (session == null) {
            throw new SessionNotFoundException();
        }
        if (session.isExpired()) {
            this.invalidate(sessionId);
            throw new SessionTimeoutException();
        }
        return session.getSubject(true);
    }

    public synchronized void invalidate(int sessionId) {
        _cache.remove(new Integer(sessionId));
        ArrayList<Integer> expired_session_ids = new ArrayList<Integer>();
        for (Map.Entry<Integer, AuthSession> map_entry : _cache.entrySet()) {
            AuthSession session = map_entry.getValue();
            if (!session.isExpired()) continue;
            expired_session_ids.add(map_entry.getKey());
        }
        for (Integer expired_session_id : expired_session_ids) {
            _cache.remove(expired_session_id);
        }
    }

    public long getlastAccess(int sessionId) {
        AuthSession session = _cache.get(sessionId);
        if (session == null) {
            return -1L;
        }
        return session.getLastAccess();
    }

    public Subject getOverlord() {
        if (overlordSubject == null) {
            overlordSubject = LookupUtil.getSubjectManager().getSubjectById(1);
            if (overlordSubject == null) {
                String err = "Cannot find the system's superuser - the database might be corrupted";
                throw new IllegalStateException(err);
            }
            this.put(overlordSubject, 120000L);
        }
        int session_id = overlordSubject.getSessionId();
        try {
            this.getSubject(session_id);
        }
        catch (SessionException e) {
            session_id = this.put(overlordSubject, 120000L);
        }
        Subject copy = new Subject();
        copy.setSessionId(Integer.valueOf(session_id));
        copy.setId(overlordSubject.getId());
        copy.setFsystem(overlordSubject.getFsystem());
        copy.setFactive(overlordSubject.getFactive());
        copy.setName(overlordSubject.getName());
        copy.setFirstName(overlordSubject.getFirstName());
        copy.setLastName(overlordSubject.getLastName());
        copy.setRoles(overlordSubject.getRoles());
        return copy;
    }
}

