/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.resource.Agent;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.cloud.CloudManagerLocal;
import org.rhq.enterprise.server.cloud.StatusManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;

@Stateless
public class StatusManagerBean
implements StatusManagerLocal {
    private final Log log = LogFactory.getLog(StatusManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    AgentManagerLocal agentManager;
    @EJB
    @IgnoreDependency
    ServerManagerLocal serverManager;
    @EJB
    @IgnoreDependency
    CloudManagerLocal cloudManager;
    @EJB
    @IgnoreDependency
    AlertDefinitionManagerLocal alertDefinitionManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<Integer> getAndClearAgentsWithStatusForServer(String serverName) {
        Query selectQuery = this.entityManager.createNamedQuery("Agent.findAllWithStatusByServer");
        selectQuery.setParameter("serverName", (Object)serverName);
        List agentIds = selectQuery.getResultList();
        if (agentIds.size() > 0) {
            Query updateQuery = this.entityManager.createNamedQuery("Agent.updateClearStatusByIds");
            updateQuery.setParameter("agentIds", (Object)agentIds);
            updateQuery.executeUpdate();
        }
        return agentIds;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateByResource(Subject subject, int resourceId) {
        this.log.debug((Object)"About to mark status by resource");
        this.markGlobalCache();
        Query updateAgentQuery = this.entityManager.createNamedQuery("Agent.updateStatusByResource");
        updateAgentQuery.setParameter("resourceId", (Object)resourceId);
        int agentsUpdated = updateAgentQuery.executeUpdate();
        if (this.log.isDebugEnabled()) {
            Agent agent = this.agentManager.getAgentByResourceId(subject, resourceId);
            this.log.debug((Object)("Marking status, agent[id=" + agent.getId() + ", status=" + agent.getStatus() + "] for resource[id=" + resourceId + "]"));
            this.log.debug((Object)("Agents updated: " + agentsUpdated));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateByAlertDefinition(Subject subject, int alertDefinitionId) {
        this.log.debug((Object)"About to mark status by alert definition");
        if (!this.alertDefinitionManager.isResourceAlertDefinition(alertDefinitionId)) {
            return;
        }
        this.markGlobalCache();
        Query updateAgentQuery = this.entityManager.createNamedQuery("Agent.updateStatusByAlertDefinition");
        updateAgentQuery.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        int agentsUpdated = updateAgentQuery.executeUpdate();
        if (this.log.isDebugEnabled()) {
            AlertDefinition definition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefinitionId);
            Agent agent = this.agentManager.getAgentByResourceId(subject, definition.getResource().getId());
            this.log.debug((Object)("Marking status, agent[id=" + agent.getId() + ", status=" + agent.getStatus() + "] for alertDefinition[id=" + alertDefinitionId + "]"));
            this.log.debug((Object)("Agents updated: " + agentsUpdated));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void markGlobalCache() {
        Query updateServerQuery = this.entityManager.createNamedQuery("Server.updateStatusByName");
        updateServerQuery.setParameter("identity", (Object)this.serverManager.getIdentity());
        int serversUpdated = updateServerQuery.executeUpdate();
        if (this.log.isDebugEnabled()) {
            Server server = this.serverManager.getServer();
            this.log.debug((Object)("Marking status, server[id=" + server.getId() + ", status=" + server.getStatus() + "]"));
            this.log.debug((Object)("Servers updated: " + serversUpdated));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateByMeasurementBaseline(int baselineId) {
        this.log.debug((Object)"About to mark status by measurement baseline");
        Query updateAgentQuery = this.entityManager.createNamedQuery("Agent.updateStatusByMeasurementBasleine");
        updateAgentQuery.setParameter("baselineId", (Object)baselineId);
        updateAgentQuery.executeUpdate();
        if (this.log.isDebugEnabled()) {
            MeasurementBaseline baseline = (MeasurementBaseline)this.entityManager.find(MeasurementBaseline.class, (Object)baselineId);
            Agent agent = baseline.getSchedule().getResource().getAgent();
            this.log.debug((Object)("Marking status, agent[id=" + agent.getId() + ", status=" + agent.getStatus() + "] for measurementBaseline[id=" + baselineId + "]"));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateByAgent(int agentId) {
        this.log.debug((Object)"About to mark status by agent");
        Query updateAgentQuery = this.entityManager.createNamedQuery("Agent.updateStatusByAgent");
        updateAgentQuery.setParameter("agentId", (Object)agentId);
        updateAgentQuery.executeUpdate();
        if (this.log.isDebugEnabled()) {
            Agent agent = (Agent)this.entityManager.find(Agent.class, (Object)agentId);
            this.log.debug((Object)("Marking status, agent[id=" + agent.getId() + ", status=" + agent.getStatus() + "]"));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateByAutoBaselineCalculationJob() {
        this.log.debug((Object)"About to mark status by autoBaselineCalculationJob");
        Query updateAgentQuery = this.entityManager.createNamedQuery("Agent.updateStatusForAll");
        updateAgentQuery.executeUpdate();
        if (this.log.isDebugEnabled()) {
            List<Agent> agents = this.agentManager.getAllAgents();
            for (Agent agent : agents) {
                this.log.debug((Object)("Marking status, agent[id=" + agent.getId() + ", status=" + agent.getStatus() + "] for AutoBaselineCalculationJob"));
            }
        }
    }
}

