/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.license;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.rhq.core.util.xmlparser.XmlAttr;
import org.rhq.core.util.xmlparser.XmlAttrException;
import org.rhq.core.util.xmlparser.XmlTagInfo;
import org.rhq.enterprise.server.license.LRES;
import org.rhq.enterprise.server.license.LicenseTag;
import org.rhq.enterprise.server.license.LicenseTermTag;

final class ExpirationTag
extends LicenseTermTag {
    static final DateFormat DFORMAT = new SimpleDateFormat(LRES.get("\"+#L6dqa}U"));
    static final NumberFormat NFORMAT = new DecimalFormat(LRES.get("A:="));
    static final int PST_OFFSET = -28800000;
    static final int DST_OFFSET = 0;
    private boolean trial = false;
    private String _origValue = null;
    private long _expMillis = 0L;
    private static final XmlAttr[] ATTRS = new XmlAttr[]{new XmlAttr(LRES.get("'NbA"), 0), new XmlAttr(LRES.get("\"EF"), 0)};

    protected ExpirationTag(LicenseTag lt) {
        super(lt);
    }

    public String getName() {
        return LRES.get("qTnWTkOF<ld^KQ;T1P");
    }

    public XmlTagInfo[] getSubTags() {
        return new XmlTagInfo[0];
    }

    public XmlAttr[] getAttributes() {
        return ATTRS;
    }

    protected String getOriginalExpirationString() {
        return this._origValue;
    }

    public void handleAttribute(int attrNumber, String value) throws XmlAttrException {
        if (attrNumber != 0 && attrNumber != 1) {
            throw new IllegalArgumentException();
        }
        if (attrNumber == 0) {
            if (value.equals(LRES.get("l"))) {
                this._expMillis = 9223372036854775307L;
                this._origValue = value;
            } else {
                Calendar cal = Calendar.getInstance();
                try {
                    Date expDate = DFORMAT.parse(value);
                    cal.setTime(expDate);
                }
                catch (ParseException e) {
                    try {
                        int days = NFORMAT.parse(value).intValue();
                        cal.add(5, days);
                        this.trial = true;
                    }
                    catch (ParseException ee) {
                        throw new XmlAttrException(LRES.get("]@aFvKfS@lwIJ|[#Wwvta-?/y,ta["));
                    }
                }
                cal.set(10, 23);
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(15, -28800000);
                cal.set(16, 0);
                this._expMillis = cal.getTimeInMillis();
                this._origValue = value;
            }
        } else {
            this.setKey(value);
        }
    }

    @Override
    protected String getValidationComparisonValue() {
        return String.valueOf(this._origValue);
    }

    @Override
    protected void termValidated() {
        this.getLicense().setTrial(this.trial);
    }
}

