/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.uibean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.rhq.enterprise.server.measurement.uibean.MeasurementSummary;
import org.rhq.enterprise.server.measurement.uibean.MetricDisplayConstants;
import org.rhq.enterprise.server.measurement.uibean.MetricDisplayValue;

public abstract class BaseMetricDisplay
extends MeasurementSummary
implements Serializable,
Comparable {
    private Long beginTimeFrame;
    private Long endTimeFrame;
    private String label;
    private String units;
    private Integer scheduleId;
    private Integer definitionId;
    private Integer collectionType;
    private Boolean showNumberCollecting;
    private int numberCollecting = -1;
    private String metricSource;
    private int metricSourceId;
    private String description;
    private Map<String, MetricDisplayValue> metrics = new HashMap<String, MetricDisplayValue>();
    protected static final List<String> attrKeyList = Arrays.asList(MetricDisplayConstants.attrKey);

    public double[] getMetricValueDoubles() {
        ArrayList<Double> values = new ArrayList<Double>();
        for (Map.Entry<String, MetricDisplayValue> ent : this.metrics.entrySet()) {
            if (ent.getKey() == null || ent.getValue() == null) continue;
            values.add(ent.getValue().getValue());
        }
        int i = 0;
        double[] rv = new double[values.size()];
        for (Double v : values) {
            rv[i] = v;
            ++i;
        }
        return rv;
    }

    public String[] getMetricKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, MetricDisplayValue> ent : this.metrics.entrySet()) {
            if (ent.getKey() == null || ent.getValue() == null) continue;
            keys.add(ent.getKey());
        }
        int i = 0;
        String[] rv = new String[keys.size()];
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            String key;
            rv[i] = key = (String)i$.next();
            ++i;
        }
        return rv;
    }

    public void setMetric(String key, MetricDisplayValue value) {
        if (!attrKeyList.contains(key)) {
            throw new IllegalArgumentException(key + " is not a known metric value");
        }
        this.metrics.put(key, value);
    }

    public MetricDisplayValue getMetric(String key) {
        if (key == null) {
            throw new IllegalArgumentException("'null' is not a valid metric key");
        }
        return this.metrics.get(key);
    }

    public Map<String, MetricDisplayValue> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, MetricDisplayValue> metrics) {
        this.metrics = metrics;
    }

    public MetricDisplayValue getMinMetric() {
        MetricDisplayValue mdv = this.getMetric("min");
        if (mdv == null) {
            throw new IllegalArgumentException("No valid metric key: min");
        }
        return mdv;
    }

    public MetricDisplayValue getMaxMetric() {
        MetricDisplayValue mdv = this.getMetric("max");
        if (mdv == null) {
            throw new IllegalArgumentException("No valid metric key: max");
        }
        return mdv;
    }

    public MetricDisplayValue getAvgMetric() {
        MetricDisplayValue mdv = this.getMetric("average");
        if (mdv == null) {
            throw new IllegalArgumentException("No valid metric key: average");
        }
        return mdv;
    }

    public MetricDisplayValue getLastMetric() {
        MetricDisplayValue mdv = this.getMetric("last");
        if (mdv == null) {
            throw new IllegalArgumentException("No valid metric key: last");
        }
        return mdv;
    }

    public MetricDisplayValue getSummaryMetric() {
        MetricDisplayValue mdv = this.getMetric("summary");
        if (mdv == null) {
            throw new IllegalArgumentException("No valid metric key: summary");
        }
        return mdv;
    }

    public Long getBeginTimeFrame() {
        return this.beginTimeFrame;
    }

    public void setBeginTimeFrame(Long beginTimeFrame) {
        this.beginTimeFrame = beginTimeFrame;
    }

    public Long getEndTimeFrame() {
        return this.endTimeFrame;
    }

    public void setEndTimeFrame(Long endTimeFrame) {
        this.endTimeFrame = endTimeFrame;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public Integer getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Integer collectionType) {
        this.collectionType = collectionType;
    }

    public Integer getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(Integer scheduleId) {
        this.scheduleId = scheduleId;
    }

    public Integer getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(Integer definitionId) {
        this.definitionId = definitionId;
    }

    public Boolean getShowNumberCollecting() {
        return this.showNumberCollecting;
    }

    public String getMetricSource() {
        return this.metricSource;
    }

    public void setMetricSource(String string) {
        this.metricSource = string;
    }

    public int getMetricSourceId() {
        return this.metricSourceId;
    }

    public void setMetricSourceId(int id) {
        this.metricSourceId = id;
    }

    public void setShowNumberCollecting(Boolean showNumberCollecting) {
        this.showNumberCollecting = showNumberCollecting;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(BaseMetricDisplay.class.getName());
        sb.append("(label=").append(this.label);
        sb.append(",beginTimeFrame=").append(this.beginTimeFrame);
        sb.append(",endTimeFrame=").append(this.endTimeFrame);
        sb.append(",units=").append(this.units);
        sb.append(",collectionType=").append(this.collectionType);
        sb.append(",metricSource=").append(this.metricSource);
        sb.append(",scheduleId=").append(this.scheduleId);
        sb.append(",showNumberCollecting=").append(this.showNumberCollecting);
        sb.append("metrics[");
        for (String anAttrKey : MetricDisplayConstants.attrKey) {
            sb.append("\n").append(anAttrKey).append("=").append(this.metrics.get(anAttrKey));
        }
        sb.append("]\n)");
        return sb.toString();
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof BaseMetricDisplay) {
            BaseMetricDisplay to = (BaseMetricDisplay)arg0;
            return this.getLabel().compareTo(to.getLabel());
        }
        throw new IllegalArgumentException("Cannot compare to non-BaseMetricDisplay object: " + arg0);
    }

    public int getNumberCollecting() {
        return this.numberCollecting;
    }

    public void setNumberCollecting(int numberCollecting) {
        this.numberCollecting = numberCollecting;
    }
}

