/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.util;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataPK;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.measurement.MeasurementAggregate;
import org.rhq.enterprise.server.measurement.MeasurementNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

public class MeasurementDataManagerUtility {
    private static final Log LOG = LogFactory.getLog(MeasurementDataManagerUtility.class);
    public static final int STORED_DAYS = 7;
    public static final int TABLES_PER_DAY = 2;
    public static final int BUFFER_TABLES = 1;
    public static final int LIVE_TABLES = 14;
    public static final int TABLE_COUNT = 15;
    private static final String TABLE_PREFIX = "RHQ_MEAS_DATA_NUM_R";
    static final String TABLE_DATA_1H = "RHQ_MEASUREMENT_DATA_NUM_1H";
    static final String TABLE_DATA_6H = "RHQ_MEASUREMENT_DATA_NUM_6H";
    static final String TABLE_DATA_1D = "RHQ_MEASUREMENT_DATA_NUM_1D";
    private static final int MAX_IN_CLAUSE_PARAMS = 1000;
    private static NumberFormat nf = new DecimalFormat("00");
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    public static final long MILLESECONDS_PER_TABLE = 43200000L;
    public static final long RAW_PURGE = 604800000L;
    public static final int DEFAULT_NUM_DATA_POINTS = 60;
    private DataSource datasource;
    private static long purge1h;
    private static long purge6h;
    private static long purge1d;
    private static long purgeRt;
    private static long purgeAlert;

    public static MeasurementDataManagerUtility getInstance(DataSource dataSource) {
        MeasurementDataManagerUtility util = new MeasurementDataManagerUtility();
        util.datasource = dataSource;
        return util;
    }

    private static void loadPurgeDefaults() {
        LOG.debug((Object)"Loading default purge intervals");
        try {
            Properties conf = LookupUtil.getSystemManager().getSystemConfiguration();
            purge1h = Long.parseLong(conf.getProperty("CAM_DATA_PURGE_1H"));
            purge6h = Long.parseLong(conf.getProperty("CAM_DATA_PURGE_6H"));
            purge1d = Long.parseLong(conf.getProperty("CAM_DATA_PURGE_1D"));
            purgeRt = Long.parseLong(conf.getProperty("RT_DATA_PURGE"));
            purgeAlert = Long.parseLong(conf.getProperty("ALERT_PURGE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<List<MeasurementDataNumericHighLowComposite>> getMeasurementDataAggregatesForContext(long beginTime, long endTime, EntityContext context, int definitionId, int numDataPoints) throws MeasurementNotFoundException {
        List<List<MeasurementDataNumericHighLowComposite>> list;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        ArrayList data = new ArrayList();
        try {
            String conditions = this.getQueryConditionsByDefinitionAndContext(definitionId, context);
            Object[] bindParams = this.getBindParamsByDefinitionAndContext(definitionId, context);
            connection = this.datasource.getConnection();
            ps = this.getFullQuery("getMeasurementDataAggregatesForContext", connection, beginTime, endTime, numDataPoints, conditions, bindParams);
            rs = ps.executeQuery();
            ArrayList<MeasurementDataNumericHighLowComposite> compositeList = new ArrayList<MeasurementDataNumericHighLowComposite>();
            while (rs.next()) {
                MeasurementDataNumericHighLowComposite next = this.fillHighLowCompositeFromResultSet(rs);
                compositeList.add(next);
            }
            data.add(compositeList);
            list = Collections.singletonList(compositeList);
        }
        catch (SQLException e) {
            try {
                throw new MeasurementNotFoundException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(connection, ps, rs);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Connection)connection, (Statement)ps, (ResultSet)rs);
        return list;
    }

    public MeasurementAggregate getAggregateByScheduleId(long beginTime, long endTime, long scheduleId) throws MeasurementNotFoundException {
        ResultSet rs;
        PreparedStatement ps;
        Connection connection;
        block5: {
            MeasurementAggregate measurementAggregate;
            connection = null;
            ps = null;
            rs = null;
            connection = this.datasource.getConnection();
            String condition = "         AND d.schedule_id = ? \n";
            ps = this.getFullQuery("getAggregateByScheduleId", connection, beginTime, endTime, 1, condition, scheduleId);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            MeasurementAggregate measurementAggregate2 = measurementAggregate = this.fillAggregateFromResultSet(rs);
            JDBCUtil.safeClose((Connection)connection, (Statement)ps, (ResultSet)rs);
            return measurementAggregate2;
        }
        try {
            try {
                throw new MeasurementNotFoundException("Data not found");
            }
            catch (SQLException e) {
                throw new MeasurementNotFoundException(e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose((Connection)connection, ps, rs);
            throw throwable;
        }
    }

    public MeasurementAggregate getAggregateByDefinitionAndContext(long beginTime, long endTime, int definitionId, EntityContext context) throws MeasurementNotFoundException {
        ResultSet rs;
        PreparedStatement ps;
        Connection connection;
        block5: {
            MeasurementAggregate measurementAggregate;
            connection = null;
            ps = null;
            rs = null;
            String conditions = this.getQueryConditionsByDefinitionAndContext(definitionId, context);
            Object[] bindParams = this.getBindParamsByDefinitionAndContext(definitionId, context);
            connection = this.datasource.getConnection();
            ps = this.getFullQuery("getAggregateByContext", connection, beginTime, endTime, 1, conditions, bindParams);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            MeasurementAggregate measurementAggregate2 = measurementAggregate = this.fillAggregateFromResultSet(rs);
            JDBCUtil.safeClose((Connection)connection, (Statement)ps, (ResultSet)rs);
            return measurementAggregate2;
        }
        try {
            try {
                throw new MeasurementNotFoundException("Data not found");
            }
            catch (SQLException e) {
                throw new MeasurementNotFoundException(e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(connection, ps, rs);
            throw throwable;
        }
    }

    private String getQueryConditionsByDefinitionAndContext(int definitionId, EntityContext context) {
        String scheduleSubQuery = null;
        if (context.type == EntityContext.Type.Resource) {
            scheduleSubQuery = "SELECT innerSchedule.id \n  FROM rhq_measurement_sched innerSchedule \n WHERE innerSchedule.definition = ? \n   AND innerSchedule.resource_id = ? \n";
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            scheduleSubQuery = "SELECT innerSchedule.id \n  FROM rhq_measurement_sched innerSchedule \n  JOIN rhq_resource_group_res_exp_map groupMap \n       ON innerSchedule.resource_id = groupMap.resource_id \n WHERE innerSchedule.definition = ? \n   AND groupMap.resource_group_id = ? \n";
        } else if (context.type == EntityContext.Type.AutoGroup) {
            scheduleSubQuery = "SELECT innerSchedule.id \n  FROM rhq_measurement_sched innerSchedule \n  JOIN rhq_resource innerRes \n       ON innerSchedule.resource_id = innerRes.id \n WHERE innerSchedule.definition = ? \n   AND innerRes.parent_resource_id = ? \n   AND innerRes.resource_type_id = ? \n";
        }
        if (scheduleSubQuery != null) {
            return "         AND d.schedule_id IN ( " + scheduleSubQuery + " ) \n";
        }
        return "";
    }

    private Object[] getBindParamsByDefinitionAndContext(int definitionId, EntityContext context) {
        Object[] bindParams = null;
        if (context.type == EntityContext.Type.Resource) {
            bindParams = new Object[]{definitionId, context.getResourceId()};
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            bindParams = new Object[]{definitionId, context.getGroupId()};
        } else if (context.type == EntityContext.Type.AutoGroup) {
            bindParams = new Object[]{definitionId, context.getParentResourceId(), context.getResourceTypeId()};
        }
        if (bindParams != null) {
            return bindParams;
        }
        return new Object[0];
    }

    private MeasurementDataNumericHighLowComposite fillHighLowCompositeFromResultSet(ResultSet rs) throws SQLException {
        long timestamp = rs.getLong(1);
        double value = MeasurementDataManagerUtility.getDoubleOrNanFromResultSet(rs, 2);
        double peak = MeasurementDataManagerUtility.getDoubleOrNanFromResultSet(rs, 3);
        double low = MeasurementDataManagerUtility.getDoubleOrNanFromResultSet(rs, 4);
        MeasurementDataNumericHighLowComposite highLowComposite = new MeasurementDataNumericHighLowComposite(timestamp, value, peak, low);
        return highLowComposite;
    }

    private MeasurementAggregate fillAggregateFromResultSet(ResultSet rs) throws SQLException {
        Double avg = MeasurementDataManagerUtility.getDoubleOrNanFromResultSet(rs, 2);
        Double max = MeasurementDataManagerUtility.getDoubleOrNanFromResultSet(rs, 3);
        Double min = MeasurementDataManagerUtility.getDoubleOrNanFromResultSet(rs, 4);
        MeasurementAggregate measurementAggregate = new MeasurementAggregate(min, avg, max);
        return measurementAggregate;
    }

    private static double getDoubleOrNanFromResultSet(ResultSet rs, int index) throws SQLException {
        double value = rs.getDouble(index);
        if (rs.wasNull()) {
            value = Double.NaN;
        }
        return value;
    }

    public MeasurementDataNumeric getLatestValueForSchedule(int scheduleId) {
        long now = System.currentTimeMillis();
        int index = MeasurementDataManagerUtility.getTableIndex(now);
        do {
            ResultSet rs;
            PreparedStatement ps;
            Connection connection;
            block5: {
                MeasurementDataNumeric measurementDataNumeric;
                connection = null;
                ps = null;
                rs = null;
                try {
                    connection = this.datasource.getConnection();
                    String table = TABLE_PREFIX + nf.format(index);
                    String query = "SELECT d.time_stamp, d.value \nFROM " + table + " d \n" + "WHERE d.schedule_id = ? \n" + "AND d.time_stamp = ( SELECT MAX(dd.time_stamp) \n" + "FROM " + table + " dd \n" + "WHERE dd.schedule_id = ? )";
                    ps = connection.prepareStatement(query);
                    ps.setInt(1, scheduleId);
                    ps.setInt(2, scheduleId);
                    rs = ps.executeQuery();
                    if (!rs.next()) break block5;
                    measurementDataNumeric = new MeasurementDataNumeric(new MeasurementDataPK(rs.getLong(1), scheduleId), Double.valueOf(rs.getDouble(2)));
                }
                catch (SQLException e) {
                    try {
                        throw new MeasurementNotFoundException(e);
                    }
                    catch (Throwable throwable) {
                        JDBCUtil.safeClose((Connection)connection, ps, rs);
                        throw throwable;
                    }
                }
                JDBCUtil.safeClose((Connection)connection, (Statement)ps, (ResultSet)rs);
                return measurementDataNumeric;
            }
            JDBCUtil.safeClose((Connection)connection, (Statement)ps, (ResultSet)rs);
            if (--index >= 0) continue;
            index = 14;
        } while (!(TABLE_PREFIX + nf.format(index)).equals(MeasurementDataManagerUtility.getDeadTable(now)));
        return null;
    }

    private PreparedStatement getFullQuery(String methodName, Connection connection, long beginTime, long endTime, int numDataPoints, String conditions, Object ... bindParameters) throws SQLException {
        String[] tables;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getFullQuery for " + methodName));
        }
        numDataPoints = numDataPoints <= 0 ? 60 : numDataPoints;
        long interval = (endTime - beginTime) / (long)numDataPoints;
        String valuesClause = MeasurementDataManagerUtility.isRawTimePeriod(beginTime) ? "avg(value), max(value) as peak, min(value) as low" : "avg(value), max(maxvalue) as peak, min(minvalue) as low";
        StringBuilder unions = new StringBuilder();
        for (String table : tables = MeasurementDataManagerUtility.getTables(beginTime, endTime)) {
            if (unions.length() != 0) {
                unions.append("   UNION ALL \n ");
            }
            unions.append(MeasurementDataManagerUtility.getTableString(table, valuesClause, conditions));
        }
        String sql = "SELECT timestamp, max(av), max(peak), max(low) FROM ( \n   (SELECT timestamp, avg(value) as av, max(value) as peak, min(value) as low FROM (\n" + unions.toString() + "   ) data GROUP BY timestamp) \n" + "   UNION ALL (select ? + (? * i) as timestamp, null as av, null as peak, null as low from RHQ_numbers where i < ?) ) alldata \n" + "GROUP BY timestamp ORDER BY timestamp";
        PreparedStatement ps = connection.prepareStatement(sql);
        StringBuilder fullSql = null;
        if (LOG.isDebugEnabled()) {
            fullSql = new StringBuilder(sql);
        }
        int i = 1;
        for (int tableIndex = 0; tableIndex < tables.length; ++tableIndex) {
            ps.setLong(i++, beginTime);
            ps.setLong(i++, interval);
            ps.setInt(i++, numDataPoints);
            ps.setLong(i++, interval);
            if (LOG.isDebugEnabled()) {
                this.replaceNextPlaceHolders(fullSql, beginTime, interval, numDataPoints, interval);
            }
            for (Object param : bindParameters) {
                if (param.getClass().isArray()) {
                    int length = Array.getLength(param);
                    if (length > 1000) {
                        throw new IllegalArgumentException("Number of resource id's must be less than or equal to 1000.");
                    }
                    for (int x = 0; x < length; ++x) {
                        Object bindValue = Array.get(param, x);
                        ps.setObject(i++, bindValue);
                        if (!LOG.isDebugEnabled()) continue;
                        this.replaceNextPlaceHolders(fullSql, bindValue);
                    }
                    continue;
                }
                ps.setObject(i++, param);
                if (!LOG.isDebugEnabled()) continue;
                this.replaceNextPlaceHolders(fullSql, param);
            }
        }
        ps.setLong(i++, beginTime);
        ps.setLong(i++, interval);
        ps.setInt(i++, numDataPoints);
        if (LOG.isDebugEnabled()) {
            this.replaceNextPlaceHolders(fullSql, beginTime, interval, numDataPoints);
            LOG.debug((Object)fullSql);
        }
        return ps;
    }

    public static String getTableString(String table, String valuesClause, String conditions) {
        return "      (SELECT beginTS as timestamp, value \n      FROM (select ? + (? * i) as beginTS, i from RHQ_numbers where i < ?) n, \n         " + table + " d " + " \n" + "      WHERE time_stamp BETWEEN beginTS AND (beginTS + ?) \n" + "      " + conditions + "      ) \n";
    }

    private void replaceNextPlaceHolders(StringBuilder sqlWithQuestionMarks, Object ... valuesToReplace) {
        for (Object nextValue : valuesToReplace) {
            int index = sqlWithQuestionMarks.indexOf("?");
            sqlWithQuestionMarks.replace(index, index + 1, String.valueOf(nextValue));
        }
    }

    public static String getTable(long time) {
        return TABLE_PREFIX + nf.format(MeasurementDataManagerUtility.getTableIndex(time));
    }

    public static String[] getAllRawTables() {
        String[] tables = new String[15];
        for (int i = 0; i < 15; ++i) {
            tables[i] = TABLE_PREFIX + nf.format(i);
        }
        return tables;
    }

    public static String[] getAllRawTables(int startIndex) {
        String[] tables = new String[15];
        for (int i = 0; i < 15; ++i) {
            tables[i] = TABLE_PREFIX + nf.format((i + startIndex) % 15);
        }
        return tables;
    }

    public static String[] getTables(long beginTime, long endTime) {
        ArrayList<String> tables = new ArrayList<String>();
        long now = System.currentTimeMillis();
        if (now - 604800000L < beginTime) {
            int startIndex = MeasurementDataManagerUtility.getTableIndex(beginTime);
            int endIndex = MeasurementDataManagerUtility.getTableIndex(endTime);
            int tableCount = (endIndex + 15 - startIndex) % 15 + 1;
            if (endTime - beginTime > 604800000L) {
                throw new RuntimeException("Time span greater than raw data storage");
            }
            for (int i = 0; i < tableCount; ++i) {
                tables.add(TABLE_PREFIX + nf.format((startIndex + i) % 15));
            }
            return tables.toArray(new String[tables.size()]);
        }
        if (now - purge1h < beginTime) {
            return new String[]{TABLE_DATA_1H};
        }
        if (now - purge6h < beginTime) {
            return new String[]{TABLE_DATA_6H};
        }
        return new String[]{TABLE_DATA_1D};
    }

    public static String getDeadTable(long time) {
        long tableIndex = MeasurementDataManagerUtility.getTableIndex(time);
        return TABLE_PREFIX + nf.format((tableIndex + 1L) % 15L);
    }

    public static String getCurrentRawTable() {
        return MeasurementDataManagerUtility.getTable(System.currentTimeMillis());
    }

    public static String getNextRotationTime() {
        long day;
        long timeOfDay;
        long remaining;
        long now = System.currentTimeMillis();
        long nextRotation = now + (remaining = 43200000L - (timeOfDay = now - (day = now / 86400000L) * 86400000L));
        if (nextRotation < now) {
            nextRotation += 43200000L;
        }
        return DateFormat.getDateTimeInstance(1, 0).format(new Date(nextRotation));
    }

    private static int getTableIndex(long time) {
        long day = time / 86400000L;
        long timeOfDay = time - day * 86400000L;
        long table = day * 2L + timeOfDay / 43200000L;
        long tableIndex = table % 15L;
        return (int)tableIndex;
    }

    public static int getTableNameIndex(String tableName) {
        int result;
        String indexString = tableName.substring(TABLE_PREFIX.length());
        try {
            result = Integer.valueOf(indexString);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Invalid raw table name: " + tableName + ", returning table index 0."));
            result = 0;
        }
        return result;
    }

    public long getPurge1h() {
        return purge1h;
    }

    public long getPurge6h() {
        return purge6h;
    }

    public long getPurge1d() {
        return purge1d;
    }

    public long getPurgeRt() {
        return purgeRt;
    }

    public long getPurgeAlert() {
        return purgeAlert;
    }

    public static long getRawTimePeriodStart(long end) {
        return end - 604800000L;
    }

    public static boolean isRawTimePeriod(long beginTime) {
        long now = System.currentTimeMillis();
        return now - 604800000L < beginTime;
    }

    public static boolean isRawTable(String tableName) {
        return null != tableName && tableName.startsWith(TABLE_PREFIX);
    }

    static {
        MeasurementDataManagerUtility.loadPurgeDefaults();
    }
}

