/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective.activator;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.perspective.activator.AbstractResourceOrGroupActivator;
import org.rhq.enterprise.server.perspective.activator.ActivatorHelper;
import org.rhq.enterprise.server.perspective.activator.ResourceConditionSet;
import org.rhq.enterprise.server.perspective.activator.context.AbstractResourceOrGroupActivationContext;

public class ResourceTypeActivator
extends AbstractResourceOrGroupActivator {
    static final long serialVersionUID = 1L;
    private List<ResourceConditionSet> resourceConditionSets;

    public ResourceTypeActivator(List<ResourceConditionSet> resourceConditionSets) {
        this.resourceConditionSets = resourceConditionSets;
    }

    @Override
    public boolean isActive(AbstractResourceOrGroupActivationContext context) {
        for (ResourceConditionSet resourceConditionSet : this.resourceConditionSets) {
            if (!context.getResourceType().getPlugin().equals(resourceConditionSet.getPluginName()) || !context.getResourceType().getName().equals(resourceConditionSet.getResourceTypeName()) || !this.hasResourcePermissions(context, resourceConditionSet.getPermissions()) || !this.hasTraits(context, resourceConditionSet.getTraitMatchers())) continue;
            return true;
        }
        return false;
    }

    private boolean hasResourcePermissions(AbstractResourceOrGroupActivationContext context, EnumSet<Permission> resourcePermissions) {
        for (Permission permission : resourcePermissions) {
            if (context.hasResourcePermission(permission)) continue;
            return false;
        }
        return true;
    }

    private boolean hasTraits(AbstractResourceOrGroupActivationContext context, Map<String, Matcher> traitMatchers) {
        if (traitMatchers.isEmpty()) {
            return true;
        }
        Set<Resource> resources = context.getResources();
        return ActivatorHelper.areTraitsSatisfied(context.getSubject(), traitMatchers, resources, true);
    }
}

