/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.translation;

import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.enterprise.server.search.SearchExpressionException;
import org.rhq.enterprise.server.search.common.SearchQueryGenerationUtility;
import org.rhq.enterprise.server.search.translation.AbstractSearchTranslator;
import org.rhq.enterprise.server.search.translation.antlr.RHQLAdvancedTerm;
import org.rhq.enterprise.server.search.translation.antlr.RHQLComparisonOperator;
import org.rhq.enterprise.server.search.translation.jpql.SearchFragment;
import org.rhq.enterprise.server.search.translation.jpql.SearchFragmentType;

public class GroupSearchTranslator
extends AbstractSearchTranslator {
    public GroupSearchTranslator(Subject subject) {
        super(subject);
    }

    @Override
    public SearchFragment getSearchFragment(String alias, RHQLAdvancedTerm term) {
        String path = term.getPath();
        RHQLComparisonOperator op = term.getOperator();
        String param = term.getParam();
        String filter = term.getValue();
        if (path.equals("availability")) {
            if (op == RHQLComparisonOperator.NOT_NULL || op == RHQLComparisonOperator.NULL) {
                return new SearchFragment(SearchFragmentType.WHERE_CLAUSE, "true");
            }
            String numericAvailabilityFragment = null;
            numericAvailabilityFragment = op == RHQLComparisonOperator.EQUALS || op == RHQLComparisonOperator.EQUALS_STRICT ? " = " : " != ";
            numericAvailabilityFragment = filter.equalsIgnoreCase("up") ? numericAvailabilityFragment + "1" : numericAvailabilityFragment + "0";
            return new SearchFragment(SearchFragmentType.PRIMARY_KEY_SUBQUERY, "SELECT rg.id  FROM ResourceGroup rg  WHERE ( SELECT AVG( iavail.availabilityType )            FROM rg.explicitResources ires            JOIN ires.currentAvailability iavail ) " + numericAvailabilityFragment);
        }
        if (path.equals("category")) {
            return new SearchFragment(SearchFragmentType.WHERE_CLAUSE, this.getJPQLForEnum(alias + ".resourceType.category", op, filter, ResourceCategory.class, false));
        }
        if (path.equals("type")) {
            return new SearchFragment(SearchFragmentType.WHERE_CLAUSE, SearchQueryGenerationUtility.getJPQLForString(alias + ".resourceType.name", op, filter));
        }
        if (path.equals("plugin")) {
            return new SearchFragment(SearchFragmentType.WHERE_CLAUSE, SearchQueryGenerationUtility.getJPQLForString(alias + ".resourceType.plugin", op, filter));
        }
        if (path.equals("name")) {
            return new SearchFragment(SearchFragmentType.WHERE_CLAUSE, SearchQueryGenerationUtility.getJPQLForString(alias + ".name", op, filter));
        }
        if (param == null) {
            throw new SearchExpressionException("No search fragment available for " + path);
        }
        throw new SearchExpressionException("No search fragment available for " + path + "[" + param + "]");
    }
}

