/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.bundle;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.bundle.BundleServerService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.bundle.BundleDeploymentStatus;
import org.rhq.core.domain.bundle.BundleFile;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.criteria.BundleFileCriteria;
import org.rhq.core.domain.criteria.PackageVersionCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.exception.WrappedRemotingException;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.util.HibernateDetachUtility;
import org.rhq.enterprise.server.util.LookupUtil;

public class BundleServerServiceImpl
implements BundleServerService {
    private final Log log = LogFactory.getLog(this.getClass());

    public void addDeploymentHistory(int bundleDeploymentId, BundleResourceDeploymentHistory history) {
        try {
            BundleManagerLocal bm = LookupUtil.getBundleManager();
            bm.addBundleResourceDeploymentHistory(LookupUtil.getSubjectManager().getOverlord(), bundleDeploymentId, history);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to add history to deployment id: " + bundleDeploymentId), (Throwable)e);
            throw new WrappedRemotingException((Throwable)e);
        }
    }

    public List<PackageVersion> getAllBundleVersionPackageVersions(int bundleVersionId) {
        try {
            BundleManagerLocal bm = LookupUtil.getBundleManager();
            ContentManagerLocal cm = LookupUtil.getContentManager();
            Subject subject = LookupUtil.getSubjectManager().getOverlord();
            BundleFileCriteria bfc = new BundleFileCriteria();
            PackageVersionCriteria pvc = new PackageVersionCriteria();
            bfc.addFilterBundleVersionId(Integer.valueOf(bundleVersionId));
            bfc.fetchPackageVersion(true);
            PageList<BundleFile> bundleFiles = bm.findBundleFilesByCriteria(subject, bfc);
            ArrayList<PackageVersion> packageVersions = new ArrayList<PackageVersion>(bundleFiles.size());
            PackageVersion packageVersion = null;
            for (BundleFile bundleFile : bundleFiles) {
                pvc.addFilterId(Integer.valueOf(bundleFile.getPackageVersion().getId()));
                packageVersion = (PackageVersion)cm.findPackageVersionsByCriteria(subject, pvc).get(0);
                HibernateDetachUtility.nullOutUninitializedFields((Object)packageVersion, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
                packageVersions.add(packageVersion);
            }
            return packageVersions;
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to obtain bundle files for bundle version id: " + bundleVersionId), (Throwable)e);
            throw new WrappedRemotingException((Throwable)e);
        }
    }

    public long downloadPackageBits(PackageVersion packageVersion, OutputStream outputStream) {
        try {
            ContentSourceManagerLocal csm = LookupUtil.getContentSourceManager();
            long size = csm.outputPackageVersionBits(packageVersion, outputStream);
            return size;
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to obtain package version bits for package version: " + packageVersion), (Throwable)e);
            throw new WrappedRemotingException((Throwable)e);
        }
    }

    public void setBundleDeploymentStatus(int bundleDeploymentId, BundleDeploymentStatus status) {
        try {
            BundleManagerLocal bm = LookupUtil.getBundleManager();
            bm.setBundleResourceDeploymentStatus(LookupUtil.getSubjectManager().getOverlord(), bundleDeploymentId, status);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to set status for deployment id: " + bundleDeploymentId), (Throwable)e);
            throw new WrappedRemotingException((Throwable)e);
        }
    }
}

