/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jboss.util.StringPropertyReplacer;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.content.Advisory;
import org.rhq.core.domain.content.AdvisoryBuglist;
import org.rhq.core.domain.content.AdvisoryCVE;
import org.rhq.core.domain.content.AdvisoryPackage;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceSyncResults;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.ContentSyncResults;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.DistributionFile;
import org.rhq.core.domain.content.DistributionType;
import org.rhq.core.domain.content.DownloadMode;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageBits;
import org.rhq.core.domain.content.PackageBitsBlob;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionContentSource;
import org.rhq.core.domain.content.PackageVersionContentSourcePK;
import org.rhq.core.domain.content.ProductVersionPackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoAdvisory;
import org.rhq.core.domain.content.RepoContentSource;
import org.rhq.core.domain.content.RepoDistribution;
import org.rhq.core.domain.content.RepoPackageVersion;
import org.rhq.core.domain.content.RepoSyncResults;
import org.rhq.core.domain.content.composite.LoadedPackageBitsComposite;
import org.rhq.core.domain.content.composite.PackageVersionFile;
import org.rhq.core.domain.content.composite.PackageVersionMetadataComposite;
import org.rhq.core.domain.criteria.RepoCriteria;
import org.rhq.core.domain.resource.ProductVersion;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.content.AdvisoryException;
import org.rhq.enterprise.server.content.AdvisoryManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerHelper;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceException;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.DistributionException;
import org.rhq.enterprise.server.content.DistributionManagerLocal;
import org.rhq.enterprise.server.content.RepoException;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.AdvisoryBugDetails;
import org.rhq.enterprise.server.plugin.pc.content.AdvisoryCVEDetails;
import org.rhq.enterprise.server.plugin.pc.content.AdvisoryDetails;
import org.rhq.enterprise.server.plugin.pc.content.AdvisoryPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.AdvisorySyncReport;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderManager;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetailsKey;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.content.DistributionDetails;
import org.rhq.enterprise.server.plugin.pc.content.DistributionFileDetails;
import org.rhq.enterprise.server.plugin.pc.content.DistributionSource;
import org.rhq.enterprise.server.plugin.pc.content.DistributionSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.InitializationException;
import org.rhq.enterprise.server.plugin.pc.content.PackageSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.RepoDetails;
import org.rhq.enterprise.server.resource.ProductVersionManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class ContentSourceManagerBean
implements ContentSourceManagerLocal {
    public static final String FILESYSTEM_PROPERTY = "rhq.server.content.filesystem";
    private final Log log = LogFactory.getLog(ContentSourceManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS", mappedName="java:/RHQDS")
    private DataSource dataSource;
    @EJB
    private ContentSourceManagerLocal contentSourceManager;
    @EJB
    private ContentManagerLocal contentManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ProductVersionManagerLocal productVersionManager;
    @EJB
    private RepoManagerLocal repoManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public void purgeOrphanedPackageVersions(Subject subject) {
        Query q = this.entityManager.createNamedQuery("PackageVersion.findOrphanedExtraProps");
        List pvs = q.getResultList();
        for (PackageVersion pv : pvs) {
            this.entityManager.remove((Object)pv.getExtraProperties());
            pv.setExtraProperties(null);
        }
        q = this.entityManager.createNamedQuery("PackageVersion.findOrphanedFiles");
        List pvFiles = q.getResultList();
        this.entityManager.flush();
        this.entityManager.clear();
        this.entityManager.createNamedQuery("PackageVersion.deletePVPVIfNoContentSourcesOrRepos").executeUpdate();
        int count = this.entityManager.createNamedQuery("PackageVersion.deleteIfNoContentSourcesOrRepos").executeUpdate();
        this.entityManager.createNamedQuery("PackageBits.deleteIfNoPackageVersion").executeUpdate();
        this.entityManager.flush();
        this.entityManager.clear();
        for (PackageVersionFile pvFile : pvFiles) {
            try {
                File doomed = this.getPackageBitsLocalFileAndCreateParentDir(pvFile.getPackageVersionId(), pvFile.getFileName());
                if (!doomed.exists()) continue;
                doomed.delete();
            }
            catch (Exception e) {
                this.log.warn((Object)("Cannot purge orphaned package version file [" + pvFile.getFileName() + "] (" + pvFile.getPackageVersionId() + ")"));
            }
        }
        this.log.info((Object)("User [" + subject + "] purged [" + count + "] orphaned package versions"));
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public void deleteContentSource(Subject subject, int contentSourceId) {
        this.log.debug((Object)("User [" + subject + "] is deleting content source [" + contentSourceId + "]"));
        this.entityManager.flush();
        this.entityManager.clear();
        this.entityManager.createNamedQuery("RepoContentSource.deleteByContentSourceId").setParameter("contentSourceId", (Object)contentSourceId).executeUpdate();
        this.entityManager.createNamedQuery("PackageVersionContentSource.deleteByContentSourceId").setParameter("contentSourceId", (Object)contentSourceId).executeUpdate();
        ContentSource cs = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSourceId);
        if (cs != null) {
            List results;
            if (cs.getConfiguration() != null) {
                this.entityManager.remove((Object)cs.getConfiguration());
            }
            if ((results = cs.getSyncResults()) != null) {
                int[] ids = new int[results.size()];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = ((ContentSourceSyncResults)results.get(i)).getId();
                }
                this.deleteContentSourceSyncResults(subject, ids);
            }
            this.entityManager.remove((Object)cs);
            this.log.debug((Object)("User [" + subject + "] deleted content source [" + cs + "]"));
            this.repoManager.deleteCandidatesWithOnlyContentSource(subject, contentSourceId);
            try {
                ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
                pc.unscheduleProviderSyncJob(cs);
                pc.getAdapterManager().shutdownAdapter(cs);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to shutdown adapter for [" + cs + "]"), (Throwable)e);
            }
        } else {
            this.log.debug((Object)("Content Source ID [" + contentSourceId + "] doesn't exist - nothing to delete"));
        }
        this.purgeOrphanedPackageVersions(subject);
    }

    @Override
    public Set<ContentSourceType> getAllContentSourceTypes() {
        Query q = this.entityManager.createNamedQuery("ContentSourceType.findAll");
        List resultList = q.getResultList();
        return new HashSet<ContentSourceType>(resultList);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public PageList<ContentSource> getAllContentSources(Subject subject, PageControl pc) {
        pc.initDefaultOrderingField("cs.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentSource.findAllWithConfig", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentSource.findAll");
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public PageList<ContentSource> getAvailableContentSourcesForRepo(Subject subject, Integer repoId, PageControl pc) {
        pc.initDefaultOrderingField("cs.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentSource.findAvailableByRepoId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentSource.findAvailableByRepoId");
        query.setParameter("repoId", (Object)repoId);
        countQuery.setParameter("repoId", (Object)repoId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public ContentSourceType getContentSourceType(String name) {
        Query q = this.entityManager.createNamedQuery("ContentSourceType.findByNameWithConfigDef");
        q.setParameter("name", (Object)name);
        ContentSourceType type = null;
        try {
            type = (ContentSourceType)q.getSingleResult();
        }
        catch (NoResultException e) {
            type = null;
        }
        return type;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public ContentSource getContentSource(Subject subject, int contentSourceId) {
        Query q = this.entityManager.createNamedQuery("ContentSource.findByIdWithConfig");
        q.setParameter("id", (Object)contentSourceId);
        ContentSource contentSource = null;
        try {
            contentSource = (ContentSource)q.getSingleResult();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return contentSource;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public ContentSource getContentSourceByNameAndType(Subject subject, String name, String typeName) {
        Query q = this.entityManager.createNamedQuery("ContentSource.findByNameAndTypeName");
        q.setParameter("name", (Object)name);
        q.setParameter("typeName", (Object)typeName);
        ContentSource cs = null;
        try {
            cs = (ContentSource)q.getSingleResult();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return cs;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public PageList<Repo> getAssociatedRepos(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("c.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Repo.findByContentSourceId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Repo.findByContentSourceId");
        query.setParameter("id", (Object)contentSourceId);
        countQuery.setParameter("id", (Object)contentSourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public PageList<Repo> getCandidateRepos(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("c.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Repo.findCandidateByContentSourceId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Repo.findCandidateByContentSourceId");
        query.setParameter("id", (Object)contentSourceId);
        countQuery.setParameter("id", (Object)contentSourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public PageList<ContentSourceSyncResults> getContentSourceSyncResults(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("cssr.startTime", PageOrdering.DESC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentSourceSyncResults.getAllByCSId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentSourceSyncResults.getAllByCSId");
        query.setParameter("contentSourceId", (Object)contentSourceId);
        countQuery.setParameter("contentSourceId", (Object)contentSourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public void mergeRepoImportResults(List<RepoDetails> repos) {
        Subject overlord = this.subjectManager.getOverlord();
        for (RepoDetails createMe : repos) {
            String repoName = createMe.getName();
            List<Repo> existingRepo = this.repoManager.getRepoByName(repoName);
            if (existingRepo != null) continue;
            Repo repo = new Repo(repoName);
            repo.setCandidate(false);
            repo.setDescription(createMe.getDescription());
            try {
                this.repoManager.createRepo(overlord, repo);
            }
            catch (RepoException e) {
                this.log.error((Object)("Error creating repo [" + repo + "]"), (Throwable)e);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public void deleteContentSourceSyncResults(Subject subject, int[] ids) {
        if (ids != null) {
            for (int id : ids) {
                ContentSourceSyncResults doomed = (ContentSourceSyncResults)this.entityManager.getReference(ContentSourceSyncResults.class, (Object)id);
                this.entityManager.remove((Object)doomed);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public ContentSource createContentSource(Subject subject, ContentSource contentSource) throws ContentSourceException {
        this.validateContentSource(contentSource);
        this.log.debug((Object)("User [" + subject + "] is creating content source [" + contentSource + "]"));
        try {
            ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
            pc.getAdapterManager().startAdapter(contentSource);
            pc.scheduleProviderSyncJob(contentSource);
            pc.syncProviderNow(contentSource);
        }
        catch (InitializationException ie) {
            this.log.warn((Object)("Failed to start adapter for [" + contentSource + "]"), (Throwable)ie);
            throw new ContentSourceException("Failed to start adapter for [" + contentSource + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)ie));
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to start adapter for [" + contentSource + "]"), (Throwable)e);
        }
        this.entityManager.persist((Object)contentSource);
        contentSource.setSyncResults(null);
        this.log.debug((Object)("User [" + subject + "] created content source [" + contentSource + "]"));
        return contentSource;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public ContentSource simpleCreateContentSource(Subject subject, ContentSource contentSource) throws ContentSourceException {
        this.validateContentSource(contentSource);
        contentSource.setSyncResults(new ArrayList());
        this.entityManager.persist((Object)contentSource);
        return contentSource;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public ContentSource updateContentSource(Subject subject, ContentSource contentSource, boolean syncNow) throws ContentSourceException {
        ContentServerPluginContainer pc;
        this.log.debug((Object)("User [" + subject + "] is updating content source [" + contentSource + "]"));
        ContentSource loaded = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSource.getId());
        if (contentSource.getConfiguration() == null && loaded.getConfiguration() != null) {
            this.entityManager.remove((Object)loaded.getConfiguration());
        }
        if (!loaded.getName().equals(contentSource.getName())) {
            this.log.info((Object)("Content source [" + loaded.getName() + "] is being renamed to [" + contentSource.getName() + "].  Will now unschedule the old sync job"));
            try {
                pc = ContentManagerHelper.getPluginContainer();
                pc.unscheduleProviderSyncJob(loaded);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to unschedule obsolete content source sync job for [" + loaded + "]"), (Throwable)e);
            }
        }
        contentSource = (ContentSource)this.entityManager.merge((Object)contentSource);
        this.log.debug((Object)("User [" + subject + "] updated content source [" + contentSource + "]"));
        try {
            pc = ContentManagerHelper.getPluginContainer();
            pc.unscheduleProviderSyncJob(contentSource);
            pc.getAdapterManager().restartAdapter(contentSource);
            pc.scheduleProviderSyncJob(contentSource);
            if (syncNow) {
                pc.syncProviderNow(contentSource);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to restart adapter for [" + contentSource + "]"), (Throwable)e);
        }
        return contentSource;
    }

    private void validateContentSource(ContentSource cs) throws ContentSourceException {
        String name = cs.getName();
        ContentSourceType type = cs.getContentSourceType();
        if (name == null || name.trim().equals("")) {
            throw new ContentSourceException("ContentSource name attribute is required");
        }
        Query q = this.entityManager.createNamedQuery("ContentSource.findByNameAndTypeName");
        q.setParameter("name", (Object)name);
        q.setParameter("typeName", (Object)type.getName());
        List existingMatchingContentSources = q.getResultList();
        if (existingMatchingContentSources.size() > 0) {
            throw new ContentSourceException("Content source with name [" + name + "] and of type [" + type.getName() + "] already exists, please specify a different name.");
        }
    }

    @Override
    public void testContentSourceConnection(int contentSourceId) throws Exception {
        try {
            ContentServerPluginContainer contentServerPluginContainer = ContentManagerHelper.getPluginContainer();
            contentServerPluginContainer.getAdapterManager().testConnection(contentSourceId);
        }
        catch (Exception e) {
            this.log.info((Object)("Failed to test connection to [" + contentSourceId + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
            this.log.debug((Object)("Content source test connection failure stack follows for [" + contentSourceId + "]"), (Throwable)e);
            throw e;
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public void synchronizeAndLoadContentSource(Subject subject, int contentSourceId) {
        try {
            ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
            ContentSource contentSource = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSourceId);
            if (contentSource != null) {
                pc.syncProviderNow(contentSource);
            } else {
                this.log.warn((Object)("Asked to synchronize a non-existing content source [" + contentSourceId + "]"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not spawn the sync job for content source [" + contentSourceId + "]");
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public PageList<PackageVersionContentSource> getPackageVersionsFromContentSource(Subject subject, int contentSourceId, PageControl pc) {
        pc.initDefaultOrderingField("pvcs.contentSource.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByContentSourceId", (PageControl)pc);
        query.setParameter("id", (Object)contentSourceId);
        List results = query.getResultList();
        long count = this.getPackageVersionCountFromContentSource(subject, contentSourceId);
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public List<PackageVersionContentSource> getPackageVersionsFromContentSourceForRepo(Subject subject, int contentSourceId, int repoId) {
        Query query = this.entityManager.createNamedQuery("PackageVersionContentSource.findByContentSourceIdAndRepoId");
        query.setParameter("content_source_id", (Object)contentSourceId);
        query.setParameter("repo_id", (Object)repoId);
        List results = query.getResultList();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public long getPackageVersionCountFromContentSource(Subject subject, int contentSourceId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByContentSourceIdCount");
        countQuery.setParameter("id", (Object)contentSourceId);
        Long count = (Long)countQuery.getSingleResult();
        return count;
    }

    @Override
    public long getPackageBitsLength(int resourceId, PackageDetailsKey packageDetailsKey) {
        Query q = this.entityManager.createNamedQuery("PackageVersion.getPkgBitsLengthByPkgDetailsAndResId");
        q.setParameter("packageName", (Object)packageDetailsKey.getName());
        q.setParameter("packageTypeName", (Object)packageDetailsKey.getPackageTypeName());
        q.setParameter("version", (Object)packageDetailsKey.getVersion());
        q.setParameter("architectureName", (Object)packageDetailsKey.getArchitectureName());
        q.setParameter("resourceId", (Object)resourceId);
        Long count = (Long)q.getSingleResult();
        return count;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public PageList<PackageVersionContentSource> getPackageVersionsFromContentSources(Subject subject, int[] contentSourceIds, PageControl pc) {
        pc.initDefaultOrderingField("pvcs.contentSource.id");
        ArrayList<Integer> idList = new ArrayList<Integer>(contentSourceIds.length);
        int[] arr$ = contentSourceIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer id = arr$[i$];
            idList.add(id);
        }
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByAllContentSourceIds", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByAllContentSourceIdsCount");
        query.setParameter("ids", idList);
        countQuery.setParameter("ids", idList);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    public PageList<PackageVersionContentSource> getUnloadedPackageVersionsFromContentSourceInRepo(Subject subject, int contentSourceId, int repoId, PageControl pc) {
        pc.initDefaultOrderingField("pvcs.contentSource.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByCSIdAndNotLoaded", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersionContentSource.findByCSIdAndNotLoadedCount");
        query.setParameter("id", (Object)contentSourceId);
        query.setParameter("repo_id", (Object)repoId);
        countQuery.setParameter("id", (Object)contentSourceId);
        countQuery.setParameter("repo_id", (Object)repoId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        PageList dbList = new PageList((Collection)results, (int)count, pc);
        HashSet<PackageVersionContentSource> uniquePVs = new HashSet<PackageVersionContentSource>();
        uniquePVs.addAll((Collection<PackageVersionContentSource>)dbList);
        ContentSource contentSource = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSourceId);
        if (contentSource.getDownloadMode().equals((Object)DownloadMode.FILESYSTEM)) {
            PageList<PackageVersionContentSource> allPackageVersions = this.contentSourceManager.getPackageVersionsFromContentSource(subject, contentSourceId, pc);
            for (PackageVersionContentSource item : allPackageVersions) {
                PackageVersion pv = item.getPackageVersionContentSourcePK().getPackageVersion();
                File verifyFile = this.getPackageBitsLocalFilesystemFile(pv.getId(), pv.getFileName());
                if (verifyFile.exists()) continue;
                this.log.info((Object)("Missing file from ContentProvider, adding to list: " + verifyFile.getAbsolutePath()));
                uniquePVs.add(item);
            }
        }
        return new PageList(uniquePVs, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public void downloadDistributionBits(Subject subject, ContentSource contentSource) {
        try {
            this.log.debug((Object)"downloadDistributionBits invoked");
            DistributionManagerLocal distManager = LookupUtil.getDistributionManagerLocal();
            ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
            int contentSourceId = contentSource.getId();
            ContentProviderManager cpMgr = pc.getAdapterManager();
            ContentProvider provider = cpMgr.getIsolatedContentProvider(contentSource.getId());
            if (!(provider instanceof DistributionSource)) {
                return;
            }
            DistributionSource distSource = (DistributionSource)((Object)provider);
            RepoCriteria reposForContentSource = new RepoCriteria();
            reposForContentSource.addFilterContentSourceIds(new Integer[]{contentSourceId});
            reposForContentSource.addFilterCandidate(Boolean.valueOf(false));
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            PageList<Repo> repos = this.repoManager.findReposByCriteria(overlord, reposForContentSource);
            this.log.debug((Object)("downloadDistributionBits found " + repos.size() + " repos associated with this contentSourceId " + contentSourceId));
            for (Repo repo : repos) {
                this.log.debug((Object)("downloadDistributionBits operating on repo: " + repo.getName() + " id = " + repo.getId()));
                PageControl pageControl = PageControl.getUnlimitedInstance();
                this.log.debug((Object)("Looking up existing distributions for repoId: " + repo.getId()));
                PageList<Distribution> dists = this.repoManager.findAssociatedDistributions(overlord, repo.getId(), pageControl);
                this.log.debug((Object)("Found " + dists.size() + " Distributions for repoId " + repo.getId()));
                for (Distribution dist : dists) {
                    this.log.debug((Object)("Looking up DistributionFiles for dist: " + dist));
                    List<DistributionFile> distFiles = distManager.getDistributionFilesByDistId(dist.getId());
                    this.log.debug((Object)("Found " + distFiles.size() + " DistributionFiles"));
                    for (DistributionFile dFile : distFiles) {
                        String relPath = dist.getBasePath() + "/" + dFile.getRelativeFilename();
                        File outputFile = this.getDistLocalFileAndCreateParentDir(dist.getLabel(), relPath);
                        this.log.debug((Object)("Checking if file exists at: " + outputFile.getAbsolutePath()));
                        if (outputFile.exists()) {
                            this.log.debug((Object)("File " + outputFile.getAbsolutePath() + " exists, checking md5sum"));
                            String expectedMD5 = dFile.getMd5sum() != null ? dFile.getMd5sum() : "<unspecified MD5>";
                            String actualMD5 = MessageDigestGenerator.getDigestString((File)outputFile);
                            if (!expectedMD5.trim().toLowerCase().equals(actualMD5.toLowerCase())) {
                                this.log.error((Object)("Expected [" + expectedMD5 + "] versus actual [" + actualMD5 + "] md5sums for file " + outputFile.getAbsolutePath() + " do not match."));
                                this.log.error((Object)"Need to re-fetch file.  Will download from DistributionSource and overwrite local file.");
                            } else {
                                this.log.info((Object)(outputFile + " exists and md5sum matches [" + actualMD5 + "] no need to re-download"));
                                continue;
                            }
                        }
                        this.log.debug((Object)("Attempting download of " + dFile.getRelativeFilename() + " from contentSourceId " + contentSourceId));
                        String remoteFetchLoc = distSource.getDistFileRemoteLocation(repo.getName(), dist.getLabel(), dFile.getRelativeFilename());
                        InputStream bitsStream = pc.getAdapterManager().loadDistributionFileBits(contentSourceId, remoteFetchLoc);
                        StreamUtil.copy((InputStream)bitsStream, (OutputStream)new FileOutputStream(outputFile), (boolean)true);
                        bitsStream = null;
                        this.log.debug((Object)("DistributionFile has been downloaded to: " + outputFile.getAbsolutePath()));
                    }
                }
            }
        }
        catch (Throwable t) {
            this.log.error((Object)t);
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_REPOSITORIES)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @TransactionTimeout(value=5400)
    public PackageBits downloadPackageBits(Subject subject, PackageVersionContentSource pvcs) {
        PackageVersionContentSourcePK pk = pvcs.getPackageVersionContentSourcePK();
        int contentSourceId = pk.getContentSource().getId();
        int packageVersionId = pk.getPackageVersion().getId();
        String packageVersionLocation = pvcs.getLocation();
        switch (pk.getContentSource().getDownloadMode()) {
            case NEVER: {
                return null;
            }
            case DATABASE: {
                this.log.debug((Object)("Downloading package bits to DB for package located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                break;
            }
            case FILESYSTEM: {
                this.log.debug((Object)("Downloading package bits to filesystem for package located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                break;
            }
            default: {
                throw new IllegalStateException(" Unknown download mode - this is a bug, please report it: " + pvcs);
            }
        }
        InputStream bitsStream = null;
        PackageBits packageBits = null;
        try {
            ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
            bitsStream = pc.getAdapterManager().loadPackageBits(contentSourceId, packageVersionLocation);
            Connection conn = null;
            Statement ps = null;
            Statement ps2 = null;
            try {
                packageBits = this.createPackageBits(pk.getContentSource().getDownloadMode() == DownloadMode.DATABASE);
                PackageVersion pv = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
                pv.setPackageBits(packageBits);
                this.entityManager.flush();
                if (pk.getContentSource().getDownloadMode() == DownloadMode.DATABASE) {
                    conn = this.dataSource.getConnection();
                    ps = conn.prepareStatement("SELECT BITS FROM RHQ_PACKAGE_BITS WHERE ID = ? FOR UPDATE");
                    ps.setInt(1, packageBits.getId());
                    ResultSet rs = ps.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            Blob blb = rs.getBlob(1);
                            StreamUtil.copy((InputStream)bitsStream, (OutputStream)blb.setBinaryStream(1L), (boolean)true);
                            ps2 = conn.prepareStatement("UPDATE RHQ_PACKAGE_BITS SET bits = ? where id = ?");
                            ps2.setBlob(1, blb);
                            ps2.setInt(2, packageBits.getId());
                            if (ps2.execute()) {
                                throw new Exception("Did not download the package bits to the DB for ");
                            }
                            ps2.close();
                        }
                    }
                    ps.close();
                    conn.close();
                } else {
                    File outputFile = this.getPackageBitsLocalFileAndCreateParentDir(pv.getId(), pv.getFileName());
                    this.log.info((Object)("OutPutFile is located at: " + outputFile));
                    boolean download = false;
                    if (outputFile.exists()) {
                        String expectedMD5 = pv.getMD5() != null ? pv.getMD5() : "<unspecified MD5>";
                        String actualMD5 = MessageDigestGenerator.getDigestString((File)outputFile);
                        if (!expectedMD5.trim().toLowerCase().equals(actualMD5.toLowerCase())) {
                            this.log.error((Object)("Already have package bits for [" + pv + "] located at [" + outputFile + "] but the MD5 hashcodes do not match. Expected MD5=[" + expectedMD5 + "], Actual MD5=[" + actualMD5 + "] - redownloading package"));
                            download = true;
                        } else {
                            this.log.info((Object)("Asked to download package bits but we already have it at [" + outputFile + "] with matching MD5 of [" + actualMD5 + "]"));
                            download = false;
                        }
                    } else {
                        download = true;
                    }
                    if (download) {
                        StreamUtil.copy((InputStream)bitsStream, (OutputStream)new FileOutputStream(outputFile), (boolean)true);
                        bitsStream = null;
                    }
                }
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("Failed to close prepared statement for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                    }
                }
                if (ps2 != null) {
                    try {
                        ps2.close();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("Failed to close prepared statement for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("Failed to close connection for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Did not download the package bits for [" + pvcs + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t), t);
        }
        finally {
            if (bitsStream != null) {
                try {
                    bitsStream.close();
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to close stream to package bits located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                }
            }
        }
        return packageBits;
    }

    private PackageBits createPackageBits(boolean initialize) {
        PackageBits bits = null;
        PackageBitsBlob blob = null;
        blob = new PackageBitsBlob();
        if (initialize) {
            blob.setBits("EmptyBlob".getBytes());
        }
        this.entityManager.persist((Object)blob);
        bits = new PackageBits();
        bits.setId(blob.getId());
        bits.setBlob(blob);
        this.entityManager.flush();
        return bits;
    }

    private InputStream preloadPackageBits(PackageVersionContentSource pvcs) throws Exception {
        PackageVersionContentSourcePK pk = pvcs.getPackageVersionContentSourcePK();
        int contentSourceId = pk.getContentSource().getId();
        int packageVersionId = pk.getPackageVersion().getId();
        String packageVersionLocation = pvcs.getLocation();
        ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
        InputStream bitsStream = pc.getAdapterManager().loadPackageBits(contentSourceId, packageVersionLocation);
        PackageVersion pv = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
        switch (pk.getContentSource().getDownloadMode()) {
            case NEVER: {
                return null;
            }
            case DATABASE: {
                this.log.debug((Object)("Downloading package bits to DB for package located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                File tempFile = File.createTempFile("JonContent", "");
                tempFile.deleteOnExit();
                BufferedOutputStream tempStream = new BufferedOutputStream(new FileOutputStream(tempFile));
                StreamUtil.copy((InputStream)bitsStream, (OutputStream)tempStream, (boolean)true);
                BufferedInputStream inp = new BufferedInputStream(new FileInputStream(tempFile));
                return inp;
            }
            case FILESYSTEM: {
                this.log.debug((Object)("Downloading package bits to filesystem for package located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                File outputFile = this.getPackageBitsLocalFileAndCreateParentDir(pv.getId(), pv.getFileName());
                this.log.info((Object)("OutPutFile is located at: " + outputFile));
                boolean download = false;
                if (outputFile.exists()) {
                    String expectedMD5 = pv.getMD5() != null ? pv.getMD5() : "<unspecified MD5>";
                    String actualMD5 = MessageDigestGenerator.getDigestString((File)outputFile);
                    if (!expectedMD5.trim().toLowerCase().equals(actualMD5.toLowerCase())) {
                        this.log.error((Object)("Already have package bits for [" + pv + "] located at [" + outputFile + "] but the MD5 hashcodes do not match. Expected MD5=[" + expectedMD5 + "], Actual MD5=[" + actualMD5 + "] - redownloading package"));
                        download = true;
                    } else {
                        this.log.info((Object)("Asked to download package bits but we already have it at [" + outputFile + "] with matching MD5 of [" + actualMD5 + "]"));
                        download = false;
                    }
                } else {
                    download = true;
                }
                if (!download) break;
                StreamUtil.copy((InputStream)bitsStream, (OutputStream)new FileOutputStream(outputFile), (boolean)true);
                bitsStream = null;
                break;
            }
            default: {
                throw new IllegalStateException(" Unknown download mode - this is a bug, please report it: " + pvcs);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2400)
    private PackageBits preparePackageBits(Subject subject, InputStream bitsStream, PackageVersionContentSource pvcs) {
        PackageVersionContentSourcePK pk = pvcs.getPackageVersionContentSourcePK();
        int contentSourceId = pk.getContentSource().getId();
        int packageVersionId = pk.getPackageVersion().getId();
        String packageVersionLocation = pvcs.getLocation();
        PackageBits packageBits = null;
        try {
            Connection conn = null;
            Statement ps = null;
            Statement ps2 = null;
            try {
                packageBits = this.createPackageBits(pk.getContentSource().getDownloadMode() == DownloadMode.DATABASE);
                PackageVersion pv = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
                pv.setPackageBits(packageBits);
                this.entityManager.flush();
                if (pk.getContentSource().getDownloadMode() == DownloadMode.DATABASE) {
                    packageBits = (PackageBits)this.entityManager.find(PackageBits.class, (Object)packageBits.getId());
                    conn = this.dataSource.getConnection();
                    ps = conn.prepareStatement("SELECT BITS FROM RHQ_PACKAGE_BITS WHERE ID = ? FOR UPDATE");
                    ps.setInt(1, packageBits.getId());
                    ResultSet rs = ps.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            Blob blb = rs.getBlob(1);
                            StreamUtil.copy((InputStream)bitsStream, (OutputStream)blb.setBinaryStream(1L), (boolean)false);
                            bitsStream.close();
                            ps2 = conn.prepareStatement("UPDATE RHQ_PACKAGE_BITS SET bits = ? where id = ?");
                            ps2.setBlob(1, blb);
                            ps2.setInt(2, packageBits.getId());
                            if (ps2.execute()) {
                                throw new Exception("Did not download the package bits to the DB for ");
                            }
                            ps2.close();
                        }
                    }
                    ps.close();
                    conn.close();
                }
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("Failed to close prepared statement for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                    }
                }
                if (ps2 != null) {
                    try {
                        ps2.close();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("Failed to close prepared statement for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("Failed to close connection for package bits [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Did not download the package bits for [" + pvcs + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t), t);
        }
        finally {
            if (bitsStream != null) {
                try {
                    bitsStream.close();
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to close stream to package bits located at [" + packageVersionLocation + "] on content source [" + contentSourceId + "]"));
                }
            }
        }
        return packageBits;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean internalSynchronizeContentSource(int contentSourceId) throws Exception {
        ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
        ContentProviderManager contentProviderManager = pc.getAdapterManager();
        return contentProviderManager.synchronizeContentProvider(contentSourceId);
    }

    @Override
    public ContentSourceSyncResults persistContentSourceSyncResults(ContentSourceSyncResults results) {
        ContentManagerHelper helper = new ContentManagerHelper(this.entityManager);
        Query q = this.entityManager.createNamedQuery("ContentSourceSyncResults.getInProgressByCSId");
        q.setParameter("contentSourceId", (Object)results.getContentSource().getId());
        return (ContentSourceSyncResults)helper.persistSyncResults(q, (ContentSyncResults)results);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentSourceSyncResults mergeContentSourceSyncResults(ContentSourceSyncResults results) {
        return (ContentSourceSyncResults)this.entityManager.merge((Object)results);
    }

    @Override
    public ContentSourceSyncResults getContentSourceSyncResults(int resultsId) {
        return (ContentSourceSyncResults)this.entityManager.find(ContentSourceSyncResults.class, (Object)resultsId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public RepoSyncResults mergeDistributionSyncReport(ContentSource contentSource, DistributionSyncReport report, RepoSyncResults syncResults) {
        try {
            StringBuilder progress = new StringBuilder();
            if (syncResults.getResults() != null) {
                progress.append(syncResults.getResults());
            }
            syncResults = this.contentSourceManager._mergeDistributionSyncReportREMOVE(contentSource, report, syncResults, progress);
            syncResults = this.contentSourceManager._mergeDistributionSyncReportADD(contentSource, report, syncResults, progress);
            if (report.getDistributions().size() > 0 || report.getDeletedDistributions().size() > 0) {
                this.contentSourceManager._mergePackageSyncReportUpdateRepo(contentSource.getId());
            }
            progress.append(new Date()).append(": ").append("MERGE COMPLETE.\n");
            syncResults.setResults(progress.toString());
            syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        }
        catch (Throwable t) {
            String errorMsg = "Could not process sync report from [" + contentSource + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t);
            this.log.error((Object)errorMsg, t);
            throw new RuntimeException(errorMsg, t);
        }
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public RepoSyncResults mergePackageSyncReport(ContentSource contentSource, Repo repo, PackageSyncReport report, Map<ContentProviderPackageDetailsKey, PackageVersionContentSource> previous, RepoSyncResults syncResults) {
        try {
            StringBuilder progress = new StringBuilder();
            if (syncResults.getResults() != null) {
                progress.append(syncResults.getResults());
            }
            syncResults = this.contentSourceManager._mergePackageSyncReportREMOVE(contentSource, repo, report, previous, syncResults, progress);
            ArrayList<ContentProviderPackageDetails> newPackages = new ArrayList<ContentProviderPackageDetails>(report.getNewPackages());
            int chunkSize = 200;
            int fromIndex = 0;
            int toIndex = chunkSize;
            int newPackageCount = newPackages.size();
            int addedCount = 0;
            progress.append(new Date()).append(": ").append("Adding");
            syncResults.setResults(progress.toString());
            syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
            while (fromIndex < newPackageCount) {
                if (toIndex > newPackageCount) {
                    toIndex = newPackageCount;
                }
                List<ContentProviderPackageDetails> pkgs = newPackages.subList(fromIndex, toIndex);
                syncResults = this.contentSourceManager._mergePackageSyncReportADD(contentSource, repo, pkgs, previous, syncResults, progress, fromIndex);
                addedCount += pkgs.size();
                fromIndex += chunkSize;
                toIndex += chunkSize;
            }
            progress.append("...").append(addedCount).append('\n');
            syncResults.setResults(progress.toString());
            syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
            syncResults = this.contentSourceManager._mergePackageSyncReportUPDATE(contentSource, report, previous, syncResults, progress);
            if (report.getNewPackages().size() > 0 || report.getUpdatedPackages().size() > 0 || report.getDeletedPackages().size() > 0) {
                this.contentSourceManager._mergePackageSyncReportUpdateRepo(contentSource.getId());
            }
            progress.append(new Date()).append(": ").append("MERGE COMPLETE.\n");
            syncResults.setResults(progress.toString());
            syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        }
        catch (Throwable t) {
            String errorMsg = "Could not process sync report from [" + contentSource + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t);
            this.log.error((Object)errorMsg, t);
            throw new RuntimeException(errorMsg, t);
        }
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public RepoSyncResults mergeAdvisorySyncReport(ContentSource contentSource, AdvisorySyncReport report, RepoSyncResults syncResults) {
        try {
            StringBuilder progress = new StringBuilder();
            if (syncResults.getResults() != null) {
                progress.append(syncResults.getResults());
            }
            syncResults = this.contentSourceManager._mergeAdvisorySyncReportREMOVE(contentSource, report, syncResults, progress);
            syncResults = this.contentSourceManager._mergeAdvisorySyncReportADD(contentSource, report, syncResults, progress);
            if (report.getAdvisory().size() > 0 || report.getDeletedAdvisorys().size() > 0) {
                this.contentSourceManager._mergePackageSyncReportUpdateRepo(contentSource.getId());
            }
            progress.append(new Date()).append(": ").append("MERGE COMPLETE.\n");
            syncResults.setResults(progress.toString());
            syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        }
        catch (Throwable t) {
            String errorMsg = "Could not process sync report from [" + contentSource + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t);
            this.log.error((Object)errorMsg, t);
            throw new RuntimeException(errorMsg, t);
        }
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public RepoSyncResults _mergeAdvisorySyncReportADD(ContentSource contentSource, AdvisorySyncReport report, RepoSyncResults syncResults, StringBuilder progress) {
        AdvisoryManagerLocal advManager = LookupUtil.getAdvisoryManagerLocal();
        RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        List<AdvisoryDetails> newDetails = report.getAdvisory();
        for (AdvisoryDetails detail : newDetails) {
            try {
                Advisory newAdv = advManager.getAdvisoryByName(detail.getAdvisory());
                if (newAdv == null) {
                    this.log.debug((Object)("Attempting to create new advisory based off of: " + detail));
                    newAdv = advManager.createAdvisory(overlord, detail.getAdvisory(), detail.getAdvisory_type(), detail.getSynopsis());
                    newAdv.setAdvisory_name(detail.getAdvisory_name());
                    newAdv.setAdvisory_rel(detail.getAdvisory_rel());
                    newAdv.setDescription(detail.getDescription());
                    newAdv.setSolution(detail.getSolution());
                    newAdv.setIssue_date(detail.getIssue_date());
                    newAdv.setUpdate_date(detail.getUpdate_date());
                    newAdv.setTopic(detail.getTopic());
                    this.entityManager.flush();
                    this.entityManager.persist((Object)newAdv);
                }
                Repo repo = repoManager.getRepo(overlord, report.getRepoId());
                RepoAdvisory repoAdv = new RepoAdvisory(repo, newAdv);
                this.log.debug((Object)("Created new mapping of RepoAdvisory repoId = " + repo.getId() + ", distId = " + newAdv.getId()));
                this.entityManager.flush();
                this.entityManager.persist((Object)repoAdv);
                List<AdvisoryPackageDetails> pkgs = detail.getPkgs();
                Query q = this.entityManager.createNamedQuery("PackageVersion.findPackageVersionByFilename");
                for (AdvisoryPackageDetails pkg : pkgs) {
                    try {
                        q.setParameter("rpmName", (Object)pkg.getRpmFilename());
                        PackageVersion pExisting = (PackageVersion)q.getSingleResult();
                        AdvisoryPackage apkg = advManager.findAdvisoryPackage(overlord, newAdv.getId(), pExisting.getId());
                        if (apkg != null) continue;
                        apkg = new AdvisoryPackage(newAdv, pExisting);
                        this.entityManager.persist((Object)apkg);
                        this.entityManager.flush();
                    }
                    catch (NoResultException nre) {
                        this.log.info((Object)("Advisory has package thats not yet in the db [" + pkg.getRpmFilename() + "] - Processing rest"));
                    }
                }
                List<AdvisoryCVEDetails> cves = detail.getCVEs();
                this.log.debug((Object)("list of CVEs " + cves));
                if (cves != null && cves.size() > 0) {
                    for (AdvisoryCVEDetails cve : cves) {
                        AdvisoryCVE acve = new AdvisoryCVE(newAdv, advManager.createCVE(overlord, cve.getName()));
                        this.entityManager.persist((Object)acve);
                        this.entityManager.flush();
                    }
                }
                List<AdvisoryBugDetails> abugs = detail.getBugs();
                this.log.debug((Object)("list of Bugs " + abugs));
                if (abugs == null || abugs.size() <= 0) continue;
                for (AdvisoryBugDetails abug : abugs) {
                    AdvisoryBuglist abuglist = advManager.getAdvisoryBuglist(overlord, newAdv.getId(), abug.getBugInfo());
                    if (abuglist != null) continue;
                    abuglist = new AdvisoryBuglist(newAdv, abug.getBugInfo());
                    this.entityManager.persist((Object)abuglist);
                    this.entityManager.flush();
                }
            }
            catch (AdvisoryException e) {
                progress.append("Caught exception when trying to add: " + detail.getAdvisory() + "\n");
                progress.append("Error is: " + e.getMessage());
                syncResults.setResults(progress.toString());
                syncResults = repoManager.mergeRepoSyncResults(syncResults);
                this.log.error((Object)e);
            }
        }
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public RepoSyncResults _mergeAdvisorySyncReportREMOVE(ContentSource contentSource, AdvisorySyncReport report, RepoSyncResults syncResults, StringBuilder progress) {
        progress.append(new Date()).append(": ").append("Removing");
        syncResults.setResults(progress.toString());
        syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        AdvisoryManagerLocal advManager = LookupUtil.getAdvisoryManagerLocal();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        for (AdvisoryDetails advDetails : report.getDeletedAdvisorys()) {
            Advisory nukeAdv = advManager.getAdvisoryByName(advDetails.getAdvisory());
            advManager.deleteAdvisoryCVE(overlord, nukeAdv.getId());
            advManager.deleteAdvisoryPackage(overlord, nukeAdv.getId());
            advManager.deleteAdvisoryBugList(overlord, nukeAdv.getId());
            advManager.deleteAdvisoryByAdvId(overlord, nukeAdv.getId());
            progress.append("Removed advisory & advisory cves for: " + advDetails.getAdvisory());
            syncResults.setResults(progress.toString());
            syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        }
        progress.append("Finished Advisory removal...").append('\n');
        syncResults.setResults(progress.toString());
        syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void _mergePackageSyncReportUpdateRepo(int contentSourceId) {
        long now = System.currentTimeMillis();
        ContentSource contentSource = (ContentSource)this.entityManager.find(ContentSource.class, (Object)contentSourceId);
        Set ccss = contentSource.getRepoContentSources();
        for (RepoContentSource ccs : ccss) {
            ccs.getRepoContentSourcePK().getRepo().setLastModifiedDate(now);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public RepoSyncResults _mergePackageSyncReportREMOVE(ContentSource contentSource, Repo repo, PackageSyncReport report, Map<ContentProviderPackageDetailsKey, PackageVersionContentSource> previous, RepoSyncResults syncResults, StringBuilder progress) {
        progress.append(new Date()).append(": ").append("Removing");
        syncResults.setResults(progress.toString());
        syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        int flushCount = 0;
        int removeCount = 0;
        for (ContentProviderPackageDetails doomedDetails : report.getDeletedPackages()) {
            ContentProviderPackageDetailsKey doomedDetailsKey = doomedDetails.getContentProviderPackageDetailsKey();
            PackageVersionContentSource doomedPvcs = previous.get((Object)doomedDetailsKey);
            if ((doomedPvcs = (PackageVersionContentSource)this.entityManager.find(PackageVersionContentSource.class, (Object)doomedPvcs.getPackageVersionContentSourcePK())) != null) {
                this.entityManager.remove((Object)doomedPvcs);
            }
            Query q = this.entityManager.createNamedQuery("RepoPackageVersion.deleteWhenNoProvider");
            q.setParameter("repoId", (Object)repo.getId());
            q.executeUpdate();
            PackageVersion doomedPv = doomedPvcs.getPackageVersionContentSourcePK().getPackageVersion();
            q = this.entityManager.createNamedQuery("PackageVersion.deleteSingleIfNoContentSourcesOrRepos");
            q.setParameter("packageVersionId", (Object)doomedPv.getId());
            q.executeUpdate();
            if (++flushCount % 200 == 0) {
                this.entityManager.flush();
                this.entityManager.clear();
            }
            if (++removeCount % 200 != 0) continue;
            progress.append("...").append(removeCount);
            syncResults.setResults(progress.toString());
            syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        }
        progress.append("...").append(removeCount).append('\n');
        syncResults.setResults(progress.toString());
        syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public RepoSyncResults _mergePackageSyncReportADD(ContentSource contentSource, Repo repo, Collection<ContentProviderPackageDetails> newPackages, Map<ContentProviderPackageDetailsKey, PackageVersionContentSource> previous, RepoSyncResults syncResults, StringBuilder progress, int addCount) {
        int flushCount = 0;
        HashMap<ResourceType, ResourceType> knownResourceTypes = new HashMap<ResourceType, ResourceType>();
        HashMap<PackageType, PackageType> knownPackageTypes = new HashMap<PackageType, PackageType>();
        HashMap<Architecture, Architecture> knownArchitectures = new HashMap<Architecture, Architecture>();
        HashMap knownProductVersions = new HashMap();
        repo = (Repo)this.entityManager.find(Repo.class, (Object)repo.getId());
        for (ContentProviderPackageDetails newDetails : newPackages) {
            Package pkg;
            PackageType pt;
            Query q;
            ResourceType rt;
            block25: {
                ContentProviderPackageDetailsKey key;
                block24: {
                    key = newDetails.getContentProviderPackageDetailsKey();
                    rt = null;
                    if (key.getResourceTypeName() != null && key.getResourceTypePluginName() != null) {
                        rt = new ResourceType();
                        rt.setName(key.getResourceTypeName());
                        rt.setPlugin(key.getResourceTypePluginName());
                        if (!knownResourceTypes.containsKey(rt)) {
                            q = this.entityManager.createNamedQuery("ResourceType.findByNameAndPlugin");
                            q.setParameter("name", (Object)rt.getName());
                            q.setParameter("plugin", (Object)rt.getPlugin());
                            try {
                                rt = (ResourceType)q.getSingleResult();
                                knownResourceTypes.put(rt, rt);
                                knownProductVersions.put(rt, new HashMap());
                                break block24;
                            }
                            catch (NoResultException nre) {
                                this.log.warn((Object)("Content source adapter found a package for an unknown resource type [" + key.getResourceTypeName() + "|" + key.getResourceTypePluginName() + "] Skipping it."));
                                continue;
                            }
                        }
                        rt = (ResourceType)knownResourceTypes.get(rt);
                    }
                }
                if (!knownPackageTypes.containsKey(pt = new PackageType(key.getPackageTypeName(), rt))) {
                    if (rt != null) {
                        q = this.entityManager.createNamedQuery("PackageType.findByResourceTypeIdAndName");
                        q.setParameter("typeId", (Object)rt.getId());
                    } else {
                        q = this.entityManager.createNamedQuery("PackageType.findByNameAndNullResourceType");
                    }
                    q.setParameter("name", (Object)pt.getName());
                    try {
                        pt = (PackageType)q.getSingleResult();
                        pt.setResourceType(rt);
                        knownPackageTypes.put(pt, pt);
                        break block25;
                    }
                    catch (NoResultException nre) {
                        this.log.warn((Object)("Content source adapter found a package of an unknown package type [" + key.getPackageTypeName() + "|" + rt + "] Skipping it."));
                        continue;
                    }
                }
                pt = (PackageType)knownPackageTypes.get(pt);
            }
            q = this.entityManager.createNamedQuery("Package.findByNamePkgTypeResourceType");
            q.setParameter("name", (Object)newDetails.getName());
            q.setParameter("packageTypeName", (Object)newDetails.getPackageTypeName());
            q.setParameter("resourceTypeId", rt != null ? Integer.valueOf(rt.getId()) : null);
            try {
                pkg = (Package)q.getSingleResult();
            }
            catch (NoResultException nre) {
                pkg = new Package(newDetails.getName(), pt);
                pkg.setClassification(newDetails.getClassification());
                pkg = this.contentManager.persistOrMergePackageSafely(pkg);
            }
            Architecture arch = new Architecture(newDetails.getArchitectureName());
            if (!knownArchitectures.containsKey(arch)) {
                q = this.entityManager.createNamedQuery("Architecture.findByName");
                q.setParameter("name", (Object)arch.getName());
                try {
                    arch = (Architecture)q.getSingleResult();
                    knownArchitectures.put(arch, arch);
                }
                catch (NoResultException nre) {
                    this.log.info((Object)("Content source adapter found a previously unknown architecture [" + arch + "] - it will be added to the list of known architectures"));
                }
            } else {
                arch = (Architecture)knownArchitectures.get(arch);
            }
            PackageVersion pv = new PackageVersion(pkg, newDetails.getVersion(), arch);
            pv.setDisplayName(newDetails.getDisplayName());
            pv.setDisplayVersion(newDetails.getDisplayVersion());
            pv.setExtraProperties(newDetails.getExtraProperties());
            pv.setFileCreatedDate(newDetails.getFileCreatedDate());
            pv.setFileName(newDetails.getFileName());
            pv.setFileSize(newDetails.getFileSize());
            pv.setLicenseName(newDetails.getLicenseName());
            pv.setLicenseVersion(newDetails.getLicenseVersion());
            pv.setLongDescription(newDetails.getLongDescription());
            pv.setMD5(newDetails.getMD5());
            pv.setMetadata(newDetails.getMetadata());
            pv.setSHA256(newDetails.getSHA256());
            pv.setShortDescription(newDetails.getShortDescription());
            q = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKey");
            q.setParameter("packageName", (Object)newDetails.getName());
            q.setParameter("packageTypeName", (Object)pt.getName());
            q.setParameter("resourceType", (Object)rt);
            q.setParameter("architectureName", (Object)arch.getName());
            q.setParameter("version", (Object)newDetails.getVersion());
            try {
                PackageVersion pvExisting = (PackageVersion)q.getSingleResult();
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getExtraProperties(), pv, pv.getExtraProperties(), "ExtraProps");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getFileSize(), pv, pv.getFileSize(), "FileSize");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getFileName(), pv, pv.getFileName(), "FileName");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getMD5(), pv, pv.getMD5(), "MD5");
                this.packageVersionAttributeCheck(pvExisting, pvExisting.getSHA256(), pv, pv.getSHA256(), "SHA256");
                pv = pvExisting;
            }
            catch (NoResultException nre) {
                // empty catch block
            }
            pv = this.contentManager.persistOrMergePackageVersionSafely(pv);
            Set<String> resourceVersions = newDetails.getResourceVersions();
            if (resourceVersions != null && rt != null) {
                Map cachedProductVersions = (Map)knownProductVersions.get(rt);
                for (String version : resourceVersions) {
                    ProductVersion productVersion = (ProductVersion)cachedProductVersions.get(version);
                    if (productVersion == null) {
                        productVersion = this.productVersionManager.addProductVersion(rt, version);
                        cachedProductVersions.put(version, productVersion);
                    }
                    ProductVersionPackageVersion mapping = new ProductVersionPackageVersion(productVersion, pv);
                    this.entityManager.merge((Object)mapping);
                }
            } else if (resourceVersions != null) {
                this.log.info((Object)("Misbehaving content provider detected. It declares resource versions " + resourceVersions + " but no resource type in package " + (Object)((Object)newDetails) + "."));
            }
            PackageVersionContentSource newPvcs = new PackageVersionContentSource(pv, contentSource, newDetails.getLocation());
            newPvcs = (PackageVersionContentSource)this.entityManager.merge((Object)newPvcs);
            RepoPackageVersion mapping = new RepoPackageVersion(repo, pv);
            this.entityManager.merge((Object)mapping);
            if (++flushCount % 100 == 0) {
                knownResourceTypes.clear();
                knownPackageTypes.clear();
                knownArchitectures.clear();
                knownProductVersions.clear();
                this.entityManager.flush();
                this.entityManager.clear();
            }
            if (++addCount % 100 != 0) continue;
            progress.append("...").append(addCount);
            syncResults.setResults(progress.toString());
            syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        }
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public RepoSyncResults _mergePackageSyncReportUPDATE(ContentSource contentSource, PackageSyncReport report, Map<ContentProviderPackageDetailsKey, PackageVersionContentSource> previous, RepoSyncResults syncResults, StringBuilder progress) {
        progress.append(new Date()).append(": ").append("Updating");
        syncResults.setResults(progress.toString());
        syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        int flushCount = 0;
        int updateCount = 0;
        for (ContentProviderPackageDetails updatedDetails : report.getUpdatedPackages()) {
            ContentProviderPackageDetailsKey key = updatedDetails.getContentProviderPackageDetailsKey();
            PackageVersionContentSource previousPvcs = previous.get((Object)key);
            PackageVersionContentSource attachedPvcs = (PackageVersionContentSource)this.entityManager.find(PackageVersionContentSource.class, (Object)previousPvcs.getPackageVersionContentSourcePK());
            if (attachedPvcs == null) {
                this.log.warn((Object)("Content source adapter reported that a non-existing package was updated, adding it [" + (Object)((Object)key) + "]"));
                this.entityManager.persist((Object)previousPvcs);
                attachedPvcs = previousPvcs;
            }
            PackageVersion pv = previousPvcs.getPackageVersionContentSourcePK().getPackageVersion();
            pv.setDisplayName(updatedDetails.getDisplayName());
            pv.setDisplayVersion(updatedDetails.getDisplayVersion());
            pv.setExtraProperties(updatedDetails.getExtraProperties());
            pv.setFileCreatedDate(updatedDetails.getFileCreatedDate());
            pv.setFileName(updatedDetails.getFileName());
            pv.setFileSize(updatedDetails.getFileSize());
            pv.setLicenseName(updatedDetails.getLicenseName());
            pv.setLicenseVersion(updatedDetails.getLicenseVersion());
            pv.setLongDescription(updatedDetails.getLongDescription());
            pv.setMD5(updatedDetails.getMD5());
            pv.setMetadata(updatedDetails.getMetadata());
            pv.setSHA256(updatedDetails.getSHA256());
            pv.setShortDescription(updatedDetails.getShortDescription());
            pv = this.contentManager.persistOrMergePackageVersionSafely(pv);
            attachedPvcs.setLocation(updatedDetails.getLocation());
            if (++flushCount % 200 == 0) {
                this.entityManager.flush();
                this.entityManager.clear();
            }
            if (++updateCount % 200 != 0) continue;
            progress.append("...").append(updateCount);
            syncResults.setResults(progress.toString());
            syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        }
        progress.append("...").append(updateCount).append('\n');
        syncResults.setResults(progress.toString());
        syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public RepoSyncResults _mergeDistributionSyncReportREMOVE(ContentSource contentSource, DistributionSyncReport report, RepoSyncResults syncResults, StringBuilder progress) {
        progress.append(new Date()).append(": ").append("Removing");
        syncResults.setResults(progress.toString());
        syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        DistributionManagerLocal distManager = LookupUtil.getDistributionManagerLocal();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        for (DistributionDetails doomedDetails : report.getDeletedDistributions()) {
            Distribution doomedDist = distManager.getDistributionByLabel(doomedDetails.getLabel());
            distManager.deleteDistributionByDistId(overlord, doomedDist.getId());
            distManager.deleteDistributionFilesByDistId(overlord, doomedDist.getId());
            progress.append("Removed distribution & distribution files for: " + doomedDetails.getLabel());
            syncResults.setResults(progress.toString());
            syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        }
        progress.append("Finished Distribution removal...").append('\n');
        syncResults.setResults(progress.toString());
        syncResults = this.repoManager.mergeRepoSyncResults(syncResults);
        return syncResults;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public RepoSyncResults _mergeDistributionSyncReportADD(ContentSource contentSource, DistributionSyncReport report, RepoSyncResults syncResults, StringBuilder progress) {
        DistributionManagerLocal distManager = LookupUtil.getDistributionManagerLocal();
        RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        List<DistributionDetails> newDetails = report.getDistributions();
        for (DistributionDetails detail : newDetails) {
            try {
                this.log.debug((Object)("Attempting to create new distribution based off of: " + detail));
                DistributionType distType = distManager.getDistributionTypeByName(detail.getDistributionType());
                Distribution newDist = distManager.createDistribution(overlord, detail.getLabel(), detail.getDistributionPath(), distType);
                this.log.debug((Object)("Created new distribution: " + newDist));
                Repo repo = repoManager.getRepo(overlord, report.getRepoId());
                RepoDistribution repoDist = new RepoDistribution(repo, newDist);
                this.log.debug((Object)("Created new mapping of RepoDistribution repoId = " + repo.getId() + ", distId = " + newDist.getId()));
                this.entityManager.persist((Object)repoDist);
                List<DistributionFileDetails> files = detail.getFiles();
                for (DistributionFileDetails f : files) {
                    this.log.debug((Object)("Creating DistributionFile for: " + f));
                    DistributionFile df = new DistributionFile(newDist, f.getRelativeFilename(), f.getMd5sum());
                    df.setLastModified(f.getLastModified());
                    this.entityManager.persist((Object)df);
                    this.entityManager.flush();
                }
            }
            catch (DistributionException e) {
                progress.append("Caught exception when trying to add: " + detail.getLabel() + "\n");
                progress.append("Error is: " + e.getMessage());
                syncResults.setResults(progress.toString());
                syncResults = repoManager.mergeRepoSyncResults(syncResults);
                this.log.error((Object)e);
            }
        }
        return syncResults;
    }

    @Override
    public PageList<PackageVersionMetadataComposite> getPackageVersionMetadata(int resourceId, PageControl pc) {
        pc.initDefaultOrderingField("pv.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersion.findMetadataByResourceId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersion.findMetadataByResourceId");
        query.setParameter("resourceId", (Object)resourceId);
        countQuery.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public String getResourceSubscriptionMD5(int resourceId) {
        MessageDigestGenerator md5Generator = new MessageDigestGenerator();
        Query q = this.entityManager.createNamedQuery("Repo.findReposByResourceId");
        q.setParameter("resourceId", (Object)resourceId);
        List repos = q.getResultList();
        for (Repo repo : repos) {
            long modifiedTimestamp = repo.getLastModifiedDate();
            Date modifiedDate = new Date(modifiedTimestamp);
            md5Generator.add(Integer.toString(modifiedDate.hashCode()).getBytes());
        }
        String digestString = md5Generator.getDigestString();
        return digestString;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputPackageVersionBitsGivenResource(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream) {
        return this.outputPackageVersionBitsRangeGivenResource(resourceId, packageDetailsKey, outputStream, 0L, -1L);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputPackageBitsForChildResource(int parentResourceId, String resourceTypeName, PackageDetailsKey packageDetailsKey, OutputStream outputStream) {
        org.rhq.core.domain.resource.Resource parentResource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)parentResourceId);
        ResourceType parentResourceType = parentResource.getResourceType();
        Query query = this.entityManager.createNamedQuery("ResourceType.findByParentAndName");
        query.setParameter("parent", (Object)parentResourceType);
        query.setParameter("name", (Object)resourceTypeName);
        ResourceType childResourceType = (ResourceType)query.getSingleResult();
        query = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKeyWithNonNullResourceType");
        query.setParameter("packageName", (Object)packageDetailsKey.getName());
        query.setParameter("packageTypeName", (Object)packageDetailsKey.getPackageTypeName());
        query.setParameter("architectureName", (Object)packageDetailsKey.getArchitectureName());
        query.setParameter("version", (Object)packageDetailsKey.getVersion());
        query.setParameter("resourceTypeId", (Object)childResourceType.getId());
        PackageVersion packageVersion = (PackageVersion)query.getSingleResult();
        return this.outputPackageVersionBitsRangeHelper(parentResourceId, packageDetailsKey, outputStream, 0L, -1L, packageVersion.getId());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputPackageVersionBitsRangeGivenResource(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream, long startByte, long endByte) {
        if (startByte < 0L) {
            throw new IllegalArgumentException("startByte[" + startByte + "] < 0");
        }
        if (endByte > -1L && endByte < startByte) {
            throw new IllegalArgumentException("endByte[" + endByte + "] < startByte[" + startByte + "]");
        }
        Query query = this.entityManager.createNamedQuery("PackageVersion.findIdByPackageDetailsKeyAndResId");
        query.setParameter("packageName", (Object)packageDetailsKey.getName());
        query.setParameter("packageTypeName", (Object)packageDetailsKey.getPackageTypeName());
        query.setParameter("architectureName", (Object)packageDetailsKey.getArchitectureName());
        query.setParameter("version", (Object)packageDetailsKey.getVersion());
        query.setParameter("resourceId", (Object)resourceId);
        int packageVersionId = (Integer)query.getSingleResult();
        return this.outputPackageVersionBitsRangeHelper(resourceId, packageDetailsKey, outputStream, startByte, endByte, packageVersionId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputPackageVersionBits(PackageVersion packageVersion, OutputStream outputStream) {
        PackageDetailsKey packageDetailsKey = new PackageDetailsKey(packageVersion.getDisplayName(), packageVersion.getDisplayVersion(), packageVersion.getGeneralPackage().getPackageType().toString(), packageVersion.getArchitecture().toString());
        int resourceId = 0;
        this.log.debug((Object)("Calling outputPackageVersionBitsRangeHelper() with package details: " + packageDetailsKey));
        return this.outputPackageVersionBitsRangeHelper(resourceId, packageDetailsKey, outputStream, 0L, -1L, packageVersion.getId());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputPackageVersionBits(PackageVersion packageVersion, OutputStream outputStream, long startByte, long endByte) {
        PackageDetailsKey packageDetailsKey = new PackageDetailsKey(packageVersion.getDisplayName(), packageVersion.getDisplayVersion(), packageVersion.getGeneralPackage().getPackageType().toString(), packageVersion.getArchitecture().toString());
        int resourceId = 0;
        this.log.debug((Object)("Calling outputPackageVersionBitsRangeHelper() with package details: " + packageDetailsKey));
        return this.outputPackageVersionBitsRangeHelper(resourceId, packageDetailsKey, outputStream, startByte, endByte, packageVersion.getId());
    }

    @Override
    public boolean downloadPackageBits(int resourceId, PackageDetailsKey packageDetailsKey) {
        Query query = this.entityManager.createNamedQuery("PackageVersion.findIdByPackageDetailsKeyAndResId");
        query.setParameter("packageName", (Object)packageDetailsKey.getName());
        query.setParameter("packageTypeName", (Object)packageDetailsKey.getPackageTypeName());
        query.setParameter("architectureName", (Object)packageDetailsKey.getArchitectureName());
        query.setParameter("version", (Object)packageDetailsKey.getVersion());
        query.setParameter("resourceId", (Object)resourceId);
        int packageVersionId = (Integer)query.getSingleResult();
        Query queryA = this.entityManager.createNamedQuery("PackageBits.isLoaded");
        queryA.setParameter("id", (Object)packageVersionId);
        LoadedPackageBitsComposite composite = (LoadedPackageBitsComposite)queryA.getSingleResult();
        boolean packageBitsAreAvailable = composite.isPackageBitsAvailable();
        if (packageBitsAreAvailable && !composite.isPackageBitsInDatabase()) {
            try {
                File bitsFile = this.getPackageBitsLocalFileAndCreateParentDir(composite.getPackageVersionId(), composite.getFileName());
                if (!bitsFile.exists()) {
                    this.log.warn((Object)("Package version [" + packageDetailsKey + "] has had its bits file [" + bitsFile + "] deleted. Will attempt to download it again."));
                    packageBitsAreAvailable = false;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Package version [" + packageDetailsKey + "] has had its bits file deleted but cannot download it again.", e);
            }
        }
        PackageVersionContentSource pvcs = null;
        if (!packageBitsAreAvailable) {
            if (resourceId == -1) {
                throw new IllegalStateException("Package bits must be inserted prior to the agent asking for them during a cotent-based resource creation");
            }
            Query q2 = this.entityManager.createNamedQuery("PackageVersionContentSource.findByPkgVerIdAndResId");
            q2.setParameter("resourceId", (Object)resourceId);
            q2.setParameter("packageVersionId", (Object)packageVersionId);
            List pvcss = q2.getResultList();
            if (pvcss.size() == 0) {
                throw new RuntimeException("Resource [" + resourceId + "] cannot access package version [" + packageDetailsKey + "] - no content source exists to deliver it");
            }
            pvcs = (PackageVersionContentSource)pvcss.get(0);
            try {
                InputStream stream = this.preloadPackageBits(pvcs);
                PackageBits bits = null;
                bits = this.preparePackageBits(this.subjectManager.getOverlord(), stream, pvcs);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private long outputPackageVersionBitsRangeHelper(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream, long startByte, long endByte, int packageVersionId) {
        Query query = this.entityManager.createNamedQuery("PackageBits.isLoaded");
        query.setParameter("id", (Object)packageVersionId);
        LoadedPackageBitsComposite composite = (LoadedPackageBitsComposite)query.getSingleResult();
        boolean packageBitsAreAvailable = composite.isPackageBitsAvailable();
        if (packageBitsAreAvailable && !composite.isPackageBitsInDatabase()) {
            try {
                File bitsFile = this.getPackageBitsLocalFileAndCreateParentDir(composite.getPackageVersionId(), composite.getFileName());
                if (!bitsFile.exists()) {
                    this.log.warn((Object)("Package version [" + packageDetailsKey + "] has had its bits file [" + bitsFile + "] deleted. Will attempt to download it again."));
                    packageBitsAreAvailable = false;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Package version [" + packageDetailsKey + "] has had its bits file deleted but cannot download it again.", e);
            }
        }
        PackageVersionContentSource pvcs = null;
        if (!packageBitsAreAvailable) {
            if (resourceId == -1) {
                throw new IllegalStateException("Package bits must be inserted prior to the agent asking for them during a cotent-based resource creation");
            }
            Query q2 = this.entityManager.createNamedQuery("PackageVersionContentSource.findByPkgVerIdAndResId");
            q2.setParameter("resourceId", (Object)resourceId);
            q2.setParameter("packageVersionId", (Object)packageVersionId);
            List pvcss = q2.getResultList();
            if (pvcss.size() == 0) {
                throw new RuntimeException("Resource [" + resourceId + "] cannot access package version [" + packageDetailsKey + "] - no content source exists to deliver it");
            }
            pvcs = (PackageVersionContentSource)pvcss.get(0);
            PackageBits bits = null;
            bits = this.contentSourceManager.downloadPackageBits(this.subjectManager.getOverlord(), pvcs);
            if (bits != null) {
                query.setParameter("id", (Object)pvcs.getPackageVersionContentSourcePK().getPackageVersion().getId());
                composite = (LoadedPackageBitsComposite)query.getSingleResult();
                if (!composite.isPackageBitsAvailable()) {
                    throw new RuntimeException("Failed to download package bits [" + packageDetailsKey + "] for resource [" + resourceId + "]");
                }
            } else {
                composite = null;
            }
        }
        Connection conn = null;
        Statement ps = null;
        ResultSet results = null;
        InputStream bitsStream = null;
        try {
            long bytesRetrieved;
            if (composite == null) {
                ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
                ContentProviderManager adapterMgr = pc.getAdapterManager();
                int contentSourceId = pvcs.getPackageVersionContentSourcePK().getContentSource().getId();
                bitsStream = adapterMgr.loadPackageBits(contentSourceId, pvcs.getLocation());
            } else {
                if (composite.isPackageBitsInDatabase()) {
                    long length;
                    conn = this.dataSource.getConnection();
                    ps = conn.prepareStatement("SELECT BITS FROM RHQ_PACKAGE_BITS WHERE ID = ?");
                    ps.setInt(1, composite.getPackageBitsId());
                    results = ps.executeQuery();
                    results.next();
                    Blob blob = results.getBlob(1);
                    long bytesRetrieved2 = 0L;
                    if (endByte < 0L) {
                        if (startByte == 0L) {
                            bytesRetrieved2 = StreamUtil.copy((InputStream)blob.getBinaryStream(), (OutputStream)outputStream, (boolean)false);
                        }
                    } else {
                        length = endByte - startByte + 1L;
                        InputStream stream = blob.getBinaryStream();
                        bytesRetrieved2 = StreamUtil.copy((InputStream)stream, (OutputStream)outputStream, (long)startByte, (long)length);
                    }
                    this.log.debug((Object)("Retrieved and sent [" + bytesRetrieved2 + "] bytes for [" + packageDetailsKey + "]"));
                    ps.close();
                    conn.close();
                    length = bytesRetrieved2;
                    return length;
                }
                File bitsFile = this.getPackageBitsLocalFileAndCreateParentDir(composite.getPackageVersionId(), composite.getFileName());
                if (!bitsFile.exists()) {
                    throw new RuntimeException("Package bits at [" + bitsFile + "] are missing for [" + packageDetailsKey + "]");
                }
                bitsStream = new FileInputStream(bitsFile);
            }
            if (endByte < 0L) {
                if (startByte > 0L) {
                    bitsStream.skip(startByte);
                }
                bytesRetrieved = StreamUtil.copy((InputStream)bitsStream, (OutputStream)outputStream, (boolean)false);
            } else {
                BufferedInputStream bis = new BufferedInputStream(bitsStream);
                long length = endByte - startByte + 1L;
                bytesRetrieved = StreamUtil.copy((InputStream)bis, (OutputStream)outputStream, (long)startByte, (long)length);
            }
            try {
                bitsStream.close();
            }
            catch (Exception closeError) {
                this.log.warn((Object)"Failed to close the bits stream", (Throwable)closeError);
            }
            bitsStream = null;
            this.log.debug((Object)("Retrieved and sent [" + bytesRetrieved + "] bytes for [" + packageDetailsKey + "]"));
            long l = bytesRetrieved;
            return l;
        }
        catch (SQLException sql) {
            throw new RuntimeException("Did not download the package bits to the DB for [" + packageDetailsKey + "]", sql);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stream package bits for [" + packageDetailsKey + "]", e);
        }
        finally {
            if (bitsStream != null) {
                try {
                    bitsStream.close();
                }
                catch (IOException e) {
                    this.log.warn((Object)("Failed to close bits stream for: " + packageDetailsKey));
                }
            }
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    this.log.warn((Object)("Failed to close result set from jdbc blob query for: " + packageDetailsKey));
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    this.log.warn((Object)("Failed to close prepared statement from jdbc blob query for: " + packageDetailsKey));
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.log.warn((Object)("Failed to close prepared statement from jdbc blob query for: " + packageDetailsKey));
                }
            }
        }
    }

    private boolean packageVersionAttributeCheck(PackageVersion pv1, Object o1, PackageVersion pv2, Object o2, String logMsg) {
        boolean same = o1 == null ? o2 == null : o1.equals(o2);
        if (!same) {
            StringBuilder str = new StringBuilder();
            str.append("A new package version has data that is different than a previous package version. ");
            str.append("The new package version data will take effect and overwrite the old version: ");
            str.append(logMsg);
            str.append(": package-version1=[").append(pv1);
            str.append("] value1=[").append(o1);
            str.append("; package-version2=[").append(pv2);
            str.append("] value2=[").append(o2);
            str.append("]");
            this.log.warn((Object)str.toString());
        }
        return same;
    }

    private File getDistributionFileBitsLocalFilesystemFile(String distLabel, String fileName) {
        String filesystem = System.getProperty(FILESYSTEM_PROPERTY);
        if (filesystem == null) {
            throw new IllegalStateException("Server is misconfigured - missing system property 'rhq.server.content.filesystem'. Don't know where distribution bits are stored.");
        }
        filesystem = StringPropertyReplacer.replaceProperties((String)filesystem);
        String loc = "dists/" + distLabel;
        File parentDir = new File(filesystem, loc);
        File distBitsFile = new File(parentDir, fileName);
        return distBitsFile;
    }

    private File getPackageBitsLocalFilesystemFile(int packageVersionId, String fileName) {
        String filesystem = System.getProperty(FILESYSTEM_PROPERTY);
        if (filesystem == null) {
            throw new IllegalStateException("Server is misconfigured - missing system property 'rhq.server.content.filesystem'. Don't know where package bits are stored.");
        }
        filesystem = StringPropertyReplacer.replaceProperties((String)filesystem);
        String idGroup = String.valueOf(packageVersionId / 2000);
        StringBuilder bitsFileName = new StringBuilder();
        bitsFileName.append(packageVersionId).append('-').append(fileName);
        if (bitsFileName.length() > 255) {
            bitsFileName.setLength(255);
        }
        File parentDir = new File(filesystem, idGroup);
        File packageBitsFile = new File(parentDir, bitsFileName.toString());
        return packageBitsFile;
    }

    private File getDistLocalFileAndCreateParentDir(String distLabel, String fileName) throws Exception {
        File distBitsFile = this.getDistributionFileBitsLocalFilesystemFile(distLabel, fileName);
        File parentDir = distBitsFile.getParentFile();
        if (!parentDir.isDirectory()) {
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!parentDir.isDirectory()) {
                throw new Exception("Cannot create content filesystem directory [" + parentDir + "] for distribution bits storage.");
            }
        }
        return distBitsFile;
    }

    private File getPackageBitsLocalFileAndCreateParentDir(int packageVersionId, String fileName) throws Exception {
        File packageBitsFile = this.getPackageBitsLocalFilesystemFile(packageVersionId, fileName);
        File parentDir = packageBitsFile.getParentFile();
        if (!parentDir.isDirectory()) {
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!parentDir.isDirectory()) {
                throw new Exception("Cannot create content filesystem directory [" + parentDir + "] for package bits storage.");
            }
        }
        return packageBitsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=2700)
    public long outputDistributionFileBits(DistributionFile distFile, OutputStream outputStream) {
        long numBytes = 0L;
        InputStream bitStream = null;
        try {
            Distribution dist = distFile.getDistribution();
            this.log.info((Object)("Distribution has a basePath of " + dist.getBasePath()));
            String distFilePath = dist.getBasePath() + "/" + distFile.getRelativeFilename();
            File f = this.getDistributionFileBitsLocalFilesystemFile(dist.getLabel(), distFilePath);
            this.log.info((Object)("Fetching: " + distFilePath + " on local file store from: " + f.getAbsolutePath()));
            bitStream = new FileInputStream(f);
            numBytes = StreamUtil.copy((InputStream)bitStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            this.log.info((Object)e);
        }
        finally {
            try {
                bitStream.close();
            }
            catch (Exception closeError) {
                this.log.warn((Object)"Failed to close the bits stream", (Throwable)closeError);
            }
        }
        this.log.debug((Object)("Retrieved and sent [" + numBytes + "] bytes for [" + distFile.getRelativeFilename() + "]"));
        return numBytes;
    }
}

