/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.metadata;

import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationMetadataManagerLocal;
import org.rhq.enterprise.server.content.metadata.ContentSourceMetadataManagerLocal;

@Stateless
public class ContentSourceMetadataManagerBean
implements ContentSourceMetadataManagerLocal {
    private final Log log = LogFactory.getLog(ContentSourceMetadataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private ConfigurationMetadataManagerLocal configurationMetadataManager;

    @Override
    public void registerTypes(Set<ContentSourceType> typesToRegister) {
        HashSet existingTypes = new HashSet();
        Query q = this.entityManager.createNamedQuery("ContentSourceType.findAll");
        existingTypes.addAll(q.getResultList());
        Set<ContentSourceType> typesToPersist = this.missingInFirstSet(existingTypes, typesToRegister);
        Set<ContentSourceType> typesToDelete = this.missingInFirstSet(typesToRegister, existingTypes);
        Set<ContentSourceType> typesToUpdate = this.intersection(existingTypes, typesToRegister);
        for (ContentSourceType typeToPersist : typesToPersist) {
            this.entityManager.persist((Object)typeToPersist);
        }
        for (ContentSourceType typeToDelete : typesToDelete) {
            Set attachedSources = typeToDelete.getContentSources();
            if (attachedSources == null || attachedSources.size() == 0) {
                this.entityManager.remove((Object)typeToDelete);
                continue;
            }
            this.log.warn((Object)(typeToDelete.toString() + " is no longer supported by any deployed plugin, " + "but it still has some content sources associated with it. " + "Those content sources will no longer work."));
        }
        block2: for (ContentSourceType typeToUpdate : typesToUpdate) {
            for (ContentSourceType typeToRegister : typesToRegister) {
                if (!typeToRegister.equals((Object)typeToUpdate)) continue;
                typeToUpdate.setDisplayName(typeToRegister.getDisplayName());
                typeToUpdate.setDescription(typeToRegister.getDescription());
                typeToUpdate.setContentSourceApiClass(typeToRegister.getContentSourceApiClass());
                typeToUpdate.setDefaultSyncSchedule(typeToRegister.getDefaultSyncSchedule());
                typeToUpdate.setDefaultLazyLoad(typeToRegister.isDefaultLazyLoad());
                typeToUpdate.setDefaultDownloadMode(typeToRegister.getDefaultDownloadMode());
                this.updateConfigurationDefinition(typeToRegister, typeToUpdate);
                continue block2;
            }
        }
    }

    private void updateConfigurationDefinition(ContentSourceType newType, ContentSourceType existingType) {
        ConfigurationDefinition newConfigDef = newType.getContentSourceConfigurationDefinition();
        ConfigurationDefinition existingConfigDef = existingType.getContentSourceConfigurationDefinition();
        if (newConfigDef != null) {
            if (existingConfigDef == null) {
                this.entityManager.persist((Object)newConfigDef);
                existingType.setContentSourceConfigurationDefinition(newConfigDef);
            } else {
                this.configurationMetadataManager.updateConfigurationDefinition(newConfigDef, existingConfigDef);
            }
        } else if (existingConfigDef != null) {
            existingType.setContentSourceConfigurationDefinition(null);
            this.entityManager.remove((Object)existingConfigDef);
        }
    }

    private <T> Set<T> missingInFirstSet(Set<T> first, Set<T> reference) {
        HashSet<T> result = new HashSet<T>();
        if (reference != null) {
            if (first == null) {
                result.addAll(reference);
                return result;
            }
            for (T item : reference) {
                if (first.contains(item)) continue;
                result.add(item);
            }
        }
        return result;
    }

    private <T> Set<T> intersection(Set<T> first, Set<T> second) {
        HashSet<T> result = new HashSet<T>();
        if (first != null && second != null) {
            result.addAll(first);
            result.retainAll(second);
        }
        return result;
    }
}

