/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.MeasurementDefinitionCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementOOBManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
public class MeasurementDefinitionManagerBean
implements MeasurementDefinitionManagerLocal,
MeasurementDefinitionManagerRemote {
    private Log log = LogFactory.getLog(MeasurementDefinitionManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private MeasurementOOBManagerLocal oobManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    public MeasurementDefinition getMeasurementDefinition(Subject subject, int definitionId) {
        MeasurementDefinition definition = (MeasurementDefinition)this.entityManager.find(MeasurementDefinition.class, (Object)definitionId);
        return definition;
    }

    @Override
    public void removeMeasurementDefinition(MeasurementDefinition def) {
        long now = System.currentTimeMillis();
        List schedules = def.getSchedules();
        Iterator schedIter = schedules.iterator();
        while (schedIter.hasNext()) {
            MeasurementSchedule sched = (MeasurementSchedule)schedIter.next();
            if (sched.getBaseline() != null) {
                this.entityManager.remove((Object)sched.getBaseline());
                sched.setBaseline(null);
            }
            this.oobManager.removeOOBsForSchedule(this.subjectManager.getOverlord(), sched);
            sched.getResource().setMtime(now);
            this.entityManager.remove((Object)sched);
            schedIter.remove();
        }
        try {
            if (def.getId() != 0 && this.entityManager.contains((Object)def)) {
                this.entityManager.remove((Object)def);
            }
        }
        catch (EntityNotFoundException enfe) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Definition # " + def.getId() + " not found: " + enfe.getMessage()));
            }
        }
        catch (PersistenceException pe) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Exception when deleting Definition # " + def.getId() + ": " + pe.getMessage()));
            }
        }
        catch (Exception e) {
            this.log.warn((Object)e.fillInStackTrace());
        }
    }

    @Override
    public List<MeasurementDefinition> findMeasurementDefinitionsByResourceType(Subject user, int resourceTypeId, DataType dataType, DisplayType displayType) {
        Query query = this.entityManager.createNamedQuery("MeasurementDefinition.findByResourceTypeDataTypeDisplayType");
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        query.setParameter("dataType", (Object)dataType);
        query.setParameter("displayType", (Object)displayType);
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<MeasurementDefinition> findMeasurementDefinitionsByIds(Subject subject, Integer[] measurementDefinitionIds) {
        Query query = this.entityManager.createNamedQuery("MeasurementDefinition.findByIds");
        List<Integer> ids = Arrays.asList(measurementDefinitionIds);
        query.setParameter("ids", ids);
        List results = query.getResultList();
        return results;
    }

    @Override
    public PageList<MeasurementDefinition> findMeasurementDefinitionsByCriteria(Subject subject, MeasurementDefinitionCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }
}

