/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.operation;

import java.util.ArrayList;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.GroupOperationHistory;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.bean.GroupOperationSchedule;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.operation.CancelJobException;
import org.rhq.enterprise.server.operation.OperationJob;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.operation.ResourceOperationJob;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class GroupOperationJob
extends OperationJob {
    public static final String DATAMAP_INT_GROUP_ID = "groupId";
    public static final String DATAMAP_INT_ARRAY_EXECUTION_ORDER = "executionOrder";
    public static final String DATAMAP_BOOL_HALT_ON_FAILURE = "haltOnFailure";
    public static final int BREAK_VALUE = 86400000;
    private static final String GROUP_JOB_NAME_PREFIX = "rhq-group-";

    public static String createUniqueJobName(ResourceGroup group, String operationName) {
        return GROUP_JOB_NAME_PREFIX + group.getId() + "-" + operationName.hashCode() + "-" + System.currentTimeMillis();
    }

    public static String createJobGroupName(ResourceGroup group) {
        return GROUP_JOB_NAME_PREFIX + group.getId();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        GroupOperationSchedule schedule = null;
        try {
            PageList<Resource> resourcesToOperateOn;
            JobDetail jobDetail = context.getJobDetail();
            OperationManagerLocal operationManager = LookupUtil.getOperationManager();
            this.updateOperationScheduleEntity(jobDetail, context.getNextFireTime(), operationManager);
            schedule = operationManager.getGroupOperationSchedule(LookupUtil.getSubjectManager().getOverlord(), jobDetail);
            Subject user = this.getUserWithSession(schedule.getSubject(), false);
            ResourceGroup group = schedule.getGroup();
            OperationDefinition op = operationManager.getSupportedGroupOperation(user, group.getId(), schedule.getOperationName(), false);
            Configuration parameters = schedule.getParameters();
            if (parameters != null) {
                parameters = parameters.deepCopy(false);
            }
            GroupOperationHistory groupHistory = new GroupOperationHistory(jobDetail.getName(), jobDetail.getGroup(), user.getName(), op, parameters, group);
            groupHistory = (GroupOperationHistory)operationManager.updateOperationHistory(user, (OperationHistory)groupHistory);
            if (schedule.getExecutionOrder() != null) {
                resourcesToOperateOn = schedule.getExecutionOrder();
            } else {
                ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
                PageControl pageControl = PageControl.getUnlimitedInstance();
                resourcesToOperateOn = resourceManager.findExplicitResourcesByResourceGroup(user, group, pageControl);
            }
            ArrayList<ResourceOperationDetailsComposite> resourceComposites = new ArrayList<ResourceOperationDetailsComposite>();
            for (Resource nextResourceToOperateOn : resourcesToOperateOn) {
                ResourceOperationSchedule resourceSchedule = this.createScheduleForResource(schedule, jobDetail.getGroup(), this.getUserWithSession(user, true), nextResourceToOperateOn);
                ResourceOperationHistory resourceHistory = this.createOperationHistory(resourceSchedule.getJobName(), resourceSchedule.getJobGroup(), resourceSchedule, groupHistory, operationManager);
                resourceComposites.add(new ResourceOperationDetailsComposite(nextResourceToOperateOn, resourceHistory, resourceSchedule));
            }
            if (schedule.getExecutionOrder() != null) {
                boolean hadFailure = false;
                for (ResourceOperationDetailsComposite composite : resourceComposites) {
                    try {
                        OperationHistory updatedOperationHistory;
                        if (hadFailure) {
                            composite.history.setErrorMessage("This has been cancelled due to halt-on-error being set on the parent group operation schedule. A previous resource operation that executed prior to this resource operation failed, thus causing this resource operation to be cancelled.");
                            composite.history.setStatus(OperationRequestStatus.CANCELED);
                            composite.history = (ResourceOperationHistory)operationManager.updateOperationHistory(this.getUserWithSession(user, true), (OperationHistory)composite.history);
                            continue;
                        }
                        this.invokeOperationOnResource(composite, operationManager);
                        int resourceHistoryId = composite.history.getId();
                        do {
                            Thread.sleep(5000L);
                        } while ((updatedOperationHistory = operationManager.getOperationHistoryByHistoryId(this.getUserWithSession(user, true), resourceHistoryId)).getDuration() <= 86400000L && updatedOperationHistory.getStatus() == OperationRequestStatus.INPROGRESS);
                        if (updatedOperationHistory.getStatus() == OperationRequestStatus.SUCCESS || !schedule.isHaltOnFailure()) continue;
                        hadFailure = true;
                    }
                    catch (Exception e) {
                        groupHistory.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
                        groupHistory = (GroupOperationHistory)operationManager.updateOperationHistory(this.getUserWithSession(user, true), (OperationHistory)groupHistory);
                        if (!schedule.isHaltOnFailure()) continue;
                        hadFailure = true;
                    }
                }
            } else {
                for (ResourceOperationDetailsComposite composite : resourceComposites) {
                    try {
                        this.invokeOperationOnResource(composite, operationManager);
                    }
                    catch (Exception e) {
                        if (e instanceof CancelJobException) {
                            throw e;
                        }
                        groupHistory.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
                        groupHistory = (GroupOperationHistory)operationManager.updateOperationHistory(this.getUserWithSession(user, true), (OperationHistory)groupHistory);
                        if (!schedule.isHaltOnFailure()) continue;
                        throw e;
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof CancelJobException) {
                throw (CancelJobException)((Object)e);
            }
            String error = "Failed to execute scheduled operation [" + schedule + "]";
            LogFactory.getLog(GroupOperationJob.class).error((Object)error, (Throwable)e);
            throw new JobExecutionException(error, (Throwable)e, false);
        }
    }

    private ResourceOperationSchedule createScheduleForResource(GroupOperationSchedule schedule, String jobGroup, Subject user, Resource resource) throws Exception {
        String resourceJobName = ResourceOperationJob.createUniqueJobName(resource, schedule.getOperationName());
        ResourceOperationSchedule resourceSchedule = new ResourceOperationSchedule();
        resourceSchedule.setJobName(resourceJobName);
        resourceSchedule.setJobGroup(jobGroup);
        resourceSchedule.setDescription(schedule.getDescription());
        resourceSchedule.setOperationName(schedule.getOperationName());
        resourceSchedule.setParameters(schedule.getParameters());
        resourceSchedule.setSubject(user);
        resourceSchedule.setResource(resource);
        return resourceSchedule;
    }

    private void invokeOperationOnResource(ResourceOperationDetailsComposite composite, OperationManagerLocal operationManager) throws Exception {
        new ResourceOperationJob().invokeOperationOnResource(composite.schedule, composite.history, operationManager);
    }

    class ResourceOperationDetailsComposite {
        Resource resource;
        ResourceOperationHistory history;
        ResourceOperationSchedule schedule;

        public ResourceOperationDetailsComposite(Resource resource, ResourceOperationHistory history, ResourceOperationSchedule schedule) {
            this.resource = resource;
            this.history = history;
            this.schedule = schedule;
        }
    }
}

