/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.operation;

import java.util.Date;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.GroupOperationHistory;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.ScheduleJobId;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public abstract class OperationJob
implements Job {
    public static final String DATAMAP_STRING_OPERATION_NAME = "operationName";
    public static final String DATAMAP_STRING_OPERATION_DISPLAY_NAME = "operationDisplayName";
    public static final String DATAMAP_INT_PARAMETERS_ID = "parametersId";
    public static final String DATAMAP_INT_SUBJECT_ID = "subjectId";
    public static final String DATAMAP_INT_ENTITY_ID = "entityId";

    protected Subject getUserWithSession(Subject user, boolean reattach) throws Exception {
        return LookupUtil.getSubjectManager().loginUnauthenticated(user.getName(), reattach);
    }

    protected void updateOperationScheduleEntity(JobDetail jobDetail, Date nextFireTime, OperationManagerLocal operationManager) {
        try {
            String jobName = jobDetail.getName();
            String jobGroup = jobDetail.getGroup();
            ScheduleJobId jobId = new ScheduleJobId(jobName, jobGroup);
            if (nextFireTime == null) {
                operationManager.deleteOperationScheduleEntity(jobId);
            } else {
                operationManager.updateOperationScheduleEntity(jobId, nextFireTime.getTime());
            }
        }
        catch (Exception e) {
            LogFactory.getLog(OperationJob.class).error((Object)("Failed to update schedule entity for job: " + jobDetail), (Throwable)e);
        }
    }

    protected ResourceOperationHistory createOperationHistory(String jobName, String jobGroup, ResourceOperationSchedule schedule, GroupOperationHistory groupHistory, OperationManagerLocal operationManager) {
        OperationDefinition op = operationManager.getSupportedResourceOperation(schedule.getSubject(), schedule.getResource().getId(), schedule.getOperationName(), false);
        Configuration parameters = schedule.getParameters();
        if (parameters != null) {
            parameters = parameters.deepCopy(false);
        }
        ResourceOperationHistory history = new ResourceOperationHistory(jobName, jobGroup, schedule.getSubject().getName(), op, parameters, schedule.getResource(), groupHistory);
        ResourceOperationHistory persisted = (ResourceOperationHistory)operationManager.updateOperationHistory(schedule.getSubject(), (OperationHistory)history);
        history.setId(persisted.getId());
        return persisted;
    }
}

