/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.resource.ResourceAvailabilityManagerLocal;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class ResourceAvailabilityManagerBean
implements ResourceAvailabilityManagerLocal {
    private final Log log = LogFactory.getLog(ResourceAvailabilityManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    private DatabaseType dbType;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    @PostConstruct
    public void init() {
        Connection conn = null;
        try {
            conn = this.rhqDs.getConnection();
            this.dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            JDBCUtil.safeClose((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNeededAvailabilityForImportedResources(List<Integer> resourceIds) {
        block14: {
            Connection conn = null;
            PreparedStatement ps = null;
            try {
                int[] values = new int[resourceIds.size()];
                for (int i = 0; i < resourceIds.size(); ++i) {
                    values[i] = resourceIds.get(i);
                }
                String query = null;
                if (this.dbType instanceof SQLServerDatabaseType) {
                    query = "INSERT INTO RHQ_RESOURCE_AVAIL ( RESOURCE_ID )      SELECT res.ID        FROM RHQ_RESOURCE res   LEFT JOIN RHQ_RESOURCE_AVAIL avail ON res.ID = avail.RESOURCE_ID       WHERE res.ID IN ( :resourceIds )         AND avail.ID IS NULL ";
                } else {
                    query = "INSERT INTO RHQ_RESOURCE_AVAIL ( ID, RESOURCE_ID )      SELECT %s, res.ID        FROM RHQ_RESOURCE res   LEFT JOIN RHQ_RESOURCE_AVAIL avail ON res.ID = avail.RESOURCE_ID       WHERE res.ID IN ( :resourceIds )         AND avail.ID IS NULL ";
                    String nextValSqlFragment = null;
                    if (this.dbType instanceof PostgresqlDatabaseType) {
                        nextValSqlFragment = "nextval('%s_id_seq'::text)";
                    } else if (this.dbType instanceof OracleDatabaseType) {
                        nextValSqlFragment = "%s_id_seq.nextval";
                    } else if (this.dbType instanceof H2DatabaseType) {
                        nextValSqlFragment = "nextval('%s_id_seq')";
                    } else {
                        throw new IllegalStateException("insertNeededAvailabilityForImportedResources does not support " + this.dbType);
                    }
                    String nextValSql = String.format(nextValSqlFragment, "RHQ_RESOURCE_AVAIL");
                    query = String.format(query, nextValSql);
                }
                query = JDBCUtil.transformQueryForMultipleInParameters((String)query, (String)":resourceIds", (int)values.length);
                conn = this.rhqDs.getConnection();
                ps = conn.prepareStatement(query);
                JDBCUtil.bindNTimes((PreparedStatement)ps, (int[])values, (int)1);
                ps.execute();
                JDBCUtil.safeClose((Statement)ps);
            }
            catch (SQLException e) {
                this.log.warn((Object)("Could not create default  metrics for schedules: " + e.getMessage()));
                break block14;
            }
            finally {
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(conn);
            }
            JDBCUtil.safeClose((Connection)conn);
        }
    }

    @Override
    public AvailabilityType getLatestAvailabilityType(Subject whoami, int resourceId) {
        if (!this.authorizationManager.canViewResource(whoami, resourceId)) {
            throw new PermissionException("User [" + whoami.getName() + "] does not have permission to view resource");
        }
        ResourceAvailability ra = this.getLatestAvailability(resourceId);
        return ra != null ? ra.getAvailabilityType() : null;
    }

    @Override
    public ResourceAvailability getLatestAvailability(int resourceId) {
        Query query = this.entityManager.createNamedQuery("ResourceAvailability.findByResourceId");
        query.setParameter("resourceId", (Object)resourceId);
        try {
            ResourceAvailability result = (ResourceAvailability)query.getSingleResult();
            return result;
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Override
    public void updateAllResourcesAvailabilitiesForAgent(int agentId, AvailabilityType availabilityType) {
        Query query = this.entityManager.createNamedQuery("ResourceAvailability.updateByAgentId");
        query.setParameter("availabilityType", (Object)availabilityType);
        query.setParameter("agentId", (Object)agentId);
        query.executeUpdate();
    }
}

