/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.resource.group.LdapGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.exception.LdapCommunicationException;
import org.rhq.enterprise.server.exception.LdapFilterException;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.security.UntrustedSSLSocketFactory;

@Stateless
public class LdapGroupManagerBean
implements LdapGroupManagerLocal {
    private Log log = LogFactory.getLog(LdapGroupManagerBean.class);
    private static final String BASEDN_DELIMITER = ";";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private SystemManagerLocal systemManager;

    @Override
    public Set<Map<String, String>> findAvailableGroups() {
        Properties options = this.systemManager.getSystemConfiguration(this.subjectManager.getOverlord());
        HashSet<Map<String, String>> emptyAvailableGroups = new HashSet<Map<String, String>>();
        String groupFilter = (String)options.get("CAM_LDAP_GROUP_FILTER");
        if (groupFilter != null && !groupFilter.trim().isEmpty()) {
            String filter = String.format("(%s)", groupFilter);
            return this.buildGroup(options, filter);
        }
        return emptyAvailableGroups;
    }

    @Override
    public Set<String> findAvailableGroupsFor(String userName) {
        Properties options = this.systemManager.getSystemConfiguration(this.subjectManager.getOverlord());
        String groupFilter = options.getProperty("CAM_LDAP_GROUP_FILTER", "");
        String groupMember = options.getProperty("CAM_LDAP_GROUP_MEMBER", "");
        String userDN = this.getUserDN(options, userName);
        String filter = "";
        filter = String.format("(&(%s)(%s=%s))", groupFilter, groupMember, userDN);
        Set<Map<String, String>> matched = this.buildGroup(options, filter);
        this.log.trace((Object)("Located '" + matched.size() + "' LDAP groups for user '" + userName + "' using following ldap filter '" + filter + "'."));
        HashSet<String> ldapSet = new HashSet<String>();
        for (Map<String, String> match : matched) {
            ldapSet.add(match.get("id"));
        }
        return ldapSet;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void setLdapGroupsOnRole(Subject subject, int roleId, Set<LdapGroup> groups) {
        Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
        if (role == null) {
            throw new IllegalArgumentException("Role with id [" + roleId + "] does not exist.");
        }
        Set currentGroups = role.getLdapGroups();
        ArrayList<String> currentGroupNames = new ArrayList<String>(currentGroups.size());
        for (LdapGroup group : currentGroups) {
            currentGroupNames.add(group.getName());
        }
        ArrayList<String> newGroupNames = new ArrayList<String>(groups.size());
        for (LdapGroup group : groups) {
            newGroupNames.add(group.getName());
        }
        ArrayList<String> namesOfGroupsToBeAdded = new ArrayList<String>(newGroupNames);
        namesOfGroupsToBeAdded.removeAll(currentGroupNames);
        this.addLdapGroupsToRole(subject, roleId, namesOfGroupsToBeAdded);
        ArrayList namesOfGroupsToBeRemoved = new ArrayList(currentGroupNames);
        namesOfGroupsToBeRemoved.removeAll(newGroupNames);
        int[] idsOfGroupsToBeRemoved = new int[namesOfGroupsToBeRemoved.size()];
        int i = 0;
        for (LdapGroup group : currentGroups) {
            if (!namesOfGroupsToBeRemoved.contains(group.getName())) continue;
            idsOfGroupsToBeRemoved[i++] = group.getId();
        }
        this.removeLdapGroupsFromRole(subject, roleId, idsOfGroupsToBeRemoved);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void addLdapGroupsToRole(Subject subject, int roleId, List<String> groupNames) {
        if (groupNames != null && groupNames.size() > 0) {
            Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
            if (role == null) {
                throw new IllegalArgumentException("Could not find role[" + roleId + "] to add LDAP groups to.");
            }
            role.getLdapGroups().size();
            for (String groupId : groupNames) {
                LdapGroup group = new LdapGroup();
                group.setName(groupId);
                role.addLdapGroup(group);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void removeLdapGroupsFromRole(Subject subject, int roleId, int[] groupIds) {
        if (groupIds != null && groupIds.length > 0) {
            Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
            if (role == null) {
                throw new IllegalArgumentException("Could not find role[" + roleId + "] to remove LDAP groups from.");
            }
            role.getLdapGroups().size();
            int[] arr$ = groupIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer groupId = arr$[i$];
                LdapGroup doomedGroup = (LdapGroup)this.entityManager.find(LdapGroup.class, (Object)groupId);
                if (doomedGroup == null) {
                    throw new IllegalArgumentException("Tried to remove doomedGroup[" + groupId + "] from role[" + roleId + "], but doomedGroup was not found.");
                }
                role.removeLdapGroup(doomedGroup);
            }
            Query purgeQuery = this.entityManager.createNamedQuery("LdapGroup.deleteById");
            LinkedList<Integer> ids = new LinkedList<Integer>();
            for (int i : groupIds) {
                ids.add(i);
            }
            purgeQuery.setParameter("ids", ids);
            purgeQuery.executeUpdate();
        }
    }

    private List<Role> findRolesByLdapGroupNames(List<String> ldapGroupNames) {
        if (ldapGroupNames.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Query query = this.entityManager.createNamedQuery("LdapGroup.findRolesByGroupNames");
        query.setParameter("names", ldapGroupNames);
        return query.getResultList();
    }

    @Override
    public void assignRolesToLdapSubject(int subjectId, List<String> ldapGroupNames) {
        Subject sub = (Subject)this.entityManager.find(Subject.class, (Object)subjectId);
        List<Role> roles = this.findRolesByLdapGroupNames(ldapGroupNames);
        sub.getRoles().clear();
        sub.getLdapRoles().clear();
        for (Role role : roles) {
            sub.addRole(role);
            sub.addLdapRole(role);
        }
    }

    @Override
    public PageList<LdapGroup> findLdapGroupsByRole(int roleId, PageControl pageControl) {
        Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
        if (role == null) {
            throw new IllegalArgumentException("Could not find role[" + roleId + "] to lookup ldap Groups on");
        }
        return new PageList((Collection)role.getLdapGroups(), role.getLdapGroups().size(), pageControl);
    }

    @Override
    public PageList<LdapGroup> findLdapGroups(PageControl pc) {
        pc.initDefaultOrderingField("g.name");
        String queryName = "LdapGroup.findAll";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        long count = (Long)queryCount.getSingleResult();
        List groups = query.getResultList();
        return new PageList((Collection)groups, (int)count, pc);
    }

    private String getUserDN(Properties options, String userName) {
        Map<String, String> details = this.findLdapUserDetails(userName);
        String userDN = details.get("dn");
        return userDN;
    }

    @Override
    public Map<String, String> findLdapUserDetails(String userName) {
        Properties options = this.systemManager.getSystemConfiguration(this.subjectManager.getOverlord());
        HashMap<String, String> userDetails = new HashMap<String, String>();
        Properties env = this.getProperties(options);
        String baseDN = (String)options.get("CAM_LDAP_BASE_DN");
        String loginProperty = (String)options.get("CAM_LDAP_LOGIN_PROPERTY");
        if (loginProperty == null) {
            loginProperty = "cn";
        }
        String bindDN = (String)options.get("CAM_LDAP_BIND_DN");
        String bindPW = (String)options.get("CAM_LDAP_BIND_PW");
        String searchFilter = (String)options.get("CAM_LDAP_FILTER");
        if (bindDN != null) {
            env.setProperty("java.naming.security.principal", bindDN);
            env.setProperty("java.naming.security.credentials", bindPW);
            env.setProperty("java.naming.security.authentication", "simple");
        }
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            SearchControls searchControls = this.getSearchControls();
            String filter = searchFilter != null && searchFilter.length() != 0 ? "(&(" + loginProperty + "=" + userName + ")" + "(" + searchFilter + "))" : "(" + loginProperty + "=" + userName + ")";
            this.log.debug((Object)("Using LDAP filter=" + filter));
            String[] baseDNs = baseDN.split(BASEDN_DELIMITER);
            for (int x = 0; x < baseDNs.length; ++x) {
                NamingEnumeration<SearchResult> answer = ctx.search(baseDNs[x], filter, searchControls);
                if (answer.hasMoreElements()) {
                    SearchResult si = answer.next();
                    String userDN = si.getName() + "," + baseDNs[x];
                    userDetails.put("dn", userDN);
                    NamingEnumeration<String> keys = si.getAttributes().getIDs();
                    while (keys.hasMore()) {
                        String key = keys.next();
                        Attribute value = si.getAttributes().get(key);
                        if (value == null) continue;
                        userDetails.put(key, value.get() + "");
                    }
                    return userDetails;
                }
                this.log.debug((Object)("User " + userName + " not found for BaseDN " + baseDNs[x]));
            }
            return userDetails;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Set<Map<String, String>> buildGroup(Properties options, String filter) {
        HashSet<Map<String, String>> ret = new HashSet<Map<String, String>>();
        Properties env = this.getProperties(options);
        String baseDN = (String)options.get("CAM_LDAP_BASE_DN");
        String loginProperty = (String)options.get("CAM_LDAP_LOGIN_PROPERTY");
        if (loginProperty == null) {
            loginProperty = "cn";
        }
        String bindDN = (String)options.get("CAM_LDAP_BIND_DN");
        String bindPW = (String)options.get("CAM_LDAP_BIND_PW");
        if (bindDN != null) {
            env.setProperty("java.naming.security.principal", bindDN);
            env.setProperty("java.naming.security.credentials", bindPW);
            env.setProperty("java.naming.security.authentication", "simple");
        }
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            SearchControls searchControls = this.getSearchControls();
            String[] baseDNs = baseDN.split(BASEDN_DELIMITER);
            block4: for (int x = 0; x < baseDNs.length; ++x) {
                NamingEnumeration<SearchResult> answer = ctx.search(baseDNs[x], filter, searchControls);
                boolean ldapApiEnumerationBugEncountered = false;
                while (!ldapApiEnumerationBugEncountered && answer.hasMoreElements()) {
                    SearchResult si = null;
                    try {
                        si = answer.next();
                    }
                    catch (NullPointerException npe) {
                        ldapApiEnumerationBugEncountered = true;
                        continue block4;
                    }
                    HashMap<String, String> entry = new HashMap<String, String>();
                    String name = (String)si.getAttributes().get("cn").get();
                    name = name.trim();
                    Attribute desc = si.getAttributes().get("description");
                    String description = desc != null ? (String)desc.get() : "";
                    description = description.trim();
                    entry.put("id", name);
                    entry.put("name", name);
                    entry.put("description", description);
                    ret.add(entry);
                }
            }
        }
        catch (NamingException e) {
            if (e instanceof InvalidSearchFilterException) {
                InvalidSearchFilterException fException = (InvalidSearchFilterException)e;
                String message = "The ldap group filter defined is invalid ";
                this.log.error((Object)message, (Throwable)fException);
                throw new LdapFilterException(message + " " + fException.getMessage());
            }
            this.log.error((Object)("LDAP communication error: " + e.getMessage()), (Throwable)e);
            throw new LdapCommunicationException(e);
        }
        return ret;
    }

    private Properties getProperties(Properties options) {
        String providerUrl;
        Properties env = new Properties(options);
        String factoryName = env.getProperty("CAM_LDAP_NAMING_FACTORY_INITIAL");
        env.setProperty("java.naming.factory.initial", factoryName);
        String protocol = env.getProperty("CAM_LDAP_PROTOCOL");
        if (protocol != null && protocol.equals("ssl")) {
            String ldapSocketFactory = env.getProperty("java.naming.ldap.factory.socket");
            if (ldapSocketFactory == null) {
                env.put("java.naming.ldap.factory.socket", UntrustedSSLSocketFactory.class.getName());
            }
            env.put("java.naming.security.protocol", "ssl");
        }
        if ((providerUrl = env.getProperty("CAM_LDAP_NAMING_PROVIDER_URL")) == null) {
            providerUrl = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
        }
        env.setProperty("java.naming.provider.url", providerUrl);
        env.setProperty("java.naming.referral", "ignore");
        return env;
    }

    private SearchControls getSearchControls() {
        int scope = 2;
        int timeLimit = 0;
        long countLimit = 0L;
        String[] returnedAttributes = null;
        boolean returnObject = false;
        boolean deference = false;
        SearchControls constraints = new SearchControls(scope, countLimit, timeLimit, returnedAttributes, returnObject, deference);
        return constraints;
    }
}

