/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.resource.metadata.CollectionsUtil;
import org.rhq.enterprise.server.resource.metadata.EventMetdataManagerLocal;

@Stateless
public class EventMetadataManagerBean
implements EventMetdataManagerLocal {
    private static Log log = LogFactory.getLog(EventMetadataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityMgr;
    @EJB
    private EventManagerLocal eventMgr;

    @Override
    public void updateMetadata(ResourceType existingType, ResourceType newType) {
        log.debug((Object)("Updating event definitions for " + existingType));
        Set newEventDefs = newType.getEventDefinitions();
        for (EventDefinition def : newEventDefs) {
            def.setResourceTypeId(existingType.getId());
        }
        Set existingEventDefs = existingType.getEventDefinitions();
        for (EventDefinition def : existingEventDefs) {
            this.entityMgr.refresh((Object)def);
        }
        Set<EventDefinition> toDelete = CollectionsUtil.missingInFirstSet(newEventDefs, existingEventDefs);
        Set<EventDefinition> newOnes = CollectionsUtil.missingInFirstSet(existingEventDefs, newEventDefs);
        Set<EventDefinition> toUpdate = CollectionsUtil.intersection(newEventDefs, existingEventDefs);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event definitions to be added: " + newOnes));
            log.debug((Object)("Event defininitions to be updated: " + toUpdate));
            log.debug((Object)("Event definitions to be removed: " + toDelete));
        }
        for (EventDefinition eDef : existingEventDefs) {
            for (EventDefinition nDef : toUpdate) {
                if (!eDef.equals((Object)nDef)) continue;
                eDef.setDescription(nDef.getDescription());
                eDef.setDisplayName(nDef.getDisplayName());
            }
        }
        for (EventDefinition eDef : newOnes) {
            EventDefinition e2 = new EventDefinition(existingType, eDef.getName());
            e2.setDescription(eDef.getDescription());
            e2.setDisplayName(eDef.getDisplayName());
            this.entityMgr.persist((Object)e2);
            existingType.addEventDefinition(e2);
        }
        existingEventDefs.removeAll(toDelete);
        this.entityMgr.flush();
        for (EventDefinition eDef : toDelete) {
            this.eventMgr.deleteEventSourcesForDefinition(eDef);
            this.entityMgr.remove((Object)eDef);
        }
    }
}

