/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.SavedSearchCriteria;
import org.rhq.core.domain.search.SavedSearch;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.search.SavedSearchManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
public class SavedSearchManagerBean
implements SavedSearchManagerLocal {
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    @Override
    public int createSavedSearch(Subject subject, SavedSearch savedSearch) {
        this.validateManipulatePermission(subject, savedSearch);
        this.entityManager.persist((Object)savedSearch);
        return savedSearch.getId();
    }

    @Override
    public boolean updateSavedSearch(Subject subject, SavedSearch savedSearch) {
        this.validateManipulatePermission(subject, savedSearch);
        SavedSearch oldSavedSearch = (SavedSearch)this.entityManager.find(SavedSearch.class, (Object)savedSearch.getId());
        if (oldSavedSearch.equals((Object)savedSearch)) {
            return false;
        }
        this.entityManager.merge((Object)savedSearch);
        return true;
    }

    @Override
    public void deleteSavedSearch(Subject subject, int savedSearchId) {
        SavedSearch savedSearch = (SavedSearch)this.entityManager.find(SavedSearch.class, (Object)savedSearchId);
        this.validateManipulatePermission(subject, savedSearch);
        this.entityManager.remove((Object)savedSearch);
    }

    @Override
    public SavedSearch getSavedSearchById(Subject subject, int savedSearchId) {
        SavedSearch savedSearch = (SavedSearch)this.entityManager.find(SavedSearch.class, (Object)savedSearchId);
        this.validateReadPermission(subject, savedSearch);
        return savedSearch;
    }

    @Override
    public PageList<SavedSearch> findSavedSearchesByCriteria(Subject subject, SavedSearchCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationCustomConditionFragment("(subject.id=" + subject.getId() + " OR global=true)");
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    private void validateManipulatePermission(Subject subject, SavedSearch savedSearch) {
        if (savedSearch.isGlobal()) {
            throw new UnsupportedOperationException("Global saved searches are not yet supported");
        }
        if (subject.getId() != savedSearch.getSubjectId() && !this.authorizationManager.isInventoryManager(subject)) {
            throw new PermissionException("Users without inventory manager permission can only manipulate their own saved searches");
        }
    }

    private void validateReadPermission(Subject subject, SavedSearch savedSearch) {
        if (!savedSearch.isGlobal() && subject.getId() != savedSearch.getSubjectId() && !this.authorizationManager.isInventoryManager(subject)) {
            throw new PermissionException("Users without inventory manager permission can only view their own saved searches");
        }
    }
}

