/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.system;

import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.mx.util.MBeanServerLocator;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.ProductInfo;
import org.rhq.core.domain.common.ServerDetails;
import org.rhq.core.domain.common.SystemConfiguration;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.core.util.StopWatch;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.CustomJaasDeploymentServiceMBean;
import org.rhq.enterprise.server.system.InvalidSystemConfigurationException;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerRemote;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SystemDatabaseInformation;

@Stateless
public class SystemManagerBean
implements SystemManagerLocal,
SystemManagerRemote {
    private final String SQL_VACUUM = "VACUUM ANALYZE {0}";
    private final String SQL_ANALYZE = "ANALYZE";
    private final String SQL_REINDEX = "REINDEX TABLE {0}";
    private final String SQL_REBUILD = "ALTER INDEX {0} REBUILD UNRECOVERABLE";
    private final String[] TABLES_TO_VACUUM = new String[]{"RHQ_RESOURCE", "RHQ_CONFIG", "RHQ_CONFIG_PROPERTY", "RHQ_AGENT"};
    private final String[] TABLES_TO_REINDEX = new String[]{"RHQ_MEASUREMENT_DATA_NUM_1D", "RHQ_MEASUREMENT_DATA_NUM_6H", "RHQ_MEASUREMENT_DATA_NUM_1H", "RHQ_MEASUREMENT_DATA_TRAIT", "RHQ_CALLTIME_DATA_KEY", "RHQ_CALLTIME_DATA_VALUE", "RHQ_AVAILABILITY"};
    private final String[] ORA_INDEXES_TO_REBUILD = new String[]{"RHQ_MEAS_DATA_1H_ID_TIME_PK", "RHQ_MEAS_DATA_6H_ID_TIME_PK", "RHQ_MEAS_DATA_1D_ID_TIME_PK", "RHQ_MEAS_BASELINE_CTIME_IDX", "RHQ_MEAS_DATA_TRAIT_ID_TIME_PK"};
    private Log log = LogFactory.getLog(SystemManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS", mappedName="java:/RHQDS")
    private DataSource dataSource;
    @Resource
    private TimerService timerService;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    @IgnoreDependency
    private SubjectManagerLocal subjectManager;
    private static Properties systemConfigurationCache = null;
    private final String TIMER_DATA = "SystemManagerBean.reloadConfigCache";

    @Override
    public void scheduleConfigCacheReloader() {
        Collection timers = this.timerService.getTimers();
        for (Timer existingTimer : timers) {
            this.log.debug((Object)("Found timer - attempting to cancel: " + existingTimer.toString()));
            try {
                existingTimer.cancel();
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed in attempting to cancel timer: " + existingTimer.toString()));
            }
        }
        this.timerService.createTimer(60000L, (Serializable)((Object)"SystemManagerBean.reloadConfigCache"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    public void reloadConfigCache(Timer timer) {
        try {
            this.systemManager.loadSystemConfigurationCacheInNewTx();
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to reload the system config cache - will try again later. Cause: " + t));
        }
        finally {
            this.timerService.createTimer(60000L, (Serializable)((Object)"SystemManagerBean.reloadConfigCache"));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public DatabaseType getDatabaseType() {
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            conn = this.dataSource.getConnection();
            DatabaseType databaseType = dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            return databaseType;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.log.warn((Object)"Failed to close temporary connection", (Throwable)e);
                }
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public Properties getSystemConfiguration(Subject subject) {
        if (systemConfigurationCache == null) {
            this.loadSystemConfigurationCache();
        }
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)systemConfigurationCache);
        return copy;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void loadSystemConfigurationCacheInNewTx() {
        this.loadSystemConfigurationCache();
    }

    @Override
    public void loadSystemConfigurationCache() {
        List configs = this.entityManager.createNamedQuery("SystemConfiguration.findAll").getResultList();
        Properties properties = new Properties();
        for (SystemConfiguration config : configs) {
            this.transformSystemConfigurationProperty(config);
            if (config.getPropertyValue() == null) {
                String defaultValue = config.getDefaultPropertyValue();
                properties.put(config.getPropertyKey(), defaultValue != null ? defaultValue : "");
                continue;
            }
            properties.put(config.getPropertyKey(), config.getPropertyValue());
        }
        systemConfigurationCache = properties;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void setSystemConfiguration(Subject subject, Properties properties, boolean skipValidation) throws Exception {
        List configs = this.entityManager.createNamedQuery("SystemConfiguration.findAll").getResultList();
        HashMap<String, SystemConfiguration> existingConfigMap = new HashMap<String, SystemConfiguration>();
        for (SystemConfiguration config : configs) {
            existingConfigMap.put(config.getPropertyKey(), config);
        }
        Properties newCacheProperties = new Properties();
        for (Object key : properties.keySet()) {
            String name = (String)key;
            String value = properties.getProperty(name);
            if (!skipValidation) {
                this.verifyNewSystemConfigurationProperty(name, value, properties);
            }
            newCacheProperties.setProperty(name, value);
            SystemConfiguration existingConfig = (SystemConfiguration)existingConfigMap.get(name);
            if (existingConfig == null) {
                existingConfig = new SystemConfiguration(name, value);
                this.transformSystemConfigurationProperty(existingConfig);
                this.entityManager.persist((Object)existingConfig);
                continue;
            }
            if (existingConfig.getPropertyValue() != null && existingConfig.getPropertyValue().equals(value)) continue;
            if (existingConfig.getFreadOnly() != null && existingConfig.getFreadOnly().booleanValue()) {
                throw new IllegalArgumentException("The setting [" + name + "] is read-only - you cannot change its current value!");
            }
            existingConfig.setPropertyValue(value);
            this.transformSystemConfigurationProperty(existingConfig);
            this.entityManager.merge((Object)existingConfig);
        }
        systemConfigurationCache = newCacheProperties;
    }

    private void transformSystemConfigurationProperty(SystemConfiguration prop) {
        String propName = prop.getPropertyKey();
        if ("ENABLE_AGENT_AUTO_UPDATE".equals(propName) || "ENABLE_DEBUG_MODE".equals(propName) || "DATA_REINDEX_NIGHTLY".equals(propName) || "ENABLE_EXPERIMENTAL_FEATURES".equals(propName)) {
            String booleanValue = prop.getPropertyValue();
            if ("0".equals(booleanValue)) {
                prop.setPropertyValue(Boolean.FALSE.toString());
            } else if ("1".equals(booleanValue)) {
                prop.setPropertyValue(Boolean.TRUE.toString());
            }
        }
    }

    private void verifyNewSystemConfigurationProperty(String name, String value, Properties properties) {
        long time;
        if ("CAM_BASELINE_DATASET".equals(name)) {
            long baselineDataSet = Long.parseLong(value);
            if (baselineDataSet > 1209600000L) {
                throw new InvalidSystemConfigurationException("Baseline dataset must be less than 14 days");
            }
        } else if ("CAM_BASELINE_FREQUENCY".equals(name)) {
            long baselineDataSet;
            long baselineFrequency = Long.parseLong(value);
            if (baselineFrequency > (baselineDataSet = Long.parseLong(properties.getProperty("CAM_BASELINE_DATASET")))) {
                throw new InvalidSystemConfigurationException("baseline computation frequency must not be larger than baseline data set");
            }
        } else if ("AGENT_MAX_QUIET_TIME_ALLOWED".endsWith(name) && (time = Long.parseLong(value)) < 120000L) {
            throw new InvalidSystemConfigurationException("Agent Max Quiet Time Allowed must be at least 2 minutes");
        }
    }

    @Override
    public void enableHibernateStatistics() {
        PersistenceUtility.enableHibernateStatistics((EntityManager)this.entityManager, (MBeanServer)ManagementFactory.getPlatformMBeanServer());
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void reconfigureSystem(Subject whoami) {
        try {
            CustomJaasDeploymentServiceMBean mbean = MBeanServerInvocationHandler.newProxyInstance(MBeanServerLocator.locateJBoss(), CustomJaasDeploymentServiceMBean.OBJECT_NAME, CustomJaasDeploymentServiceMBean.class, false);
            mbean.installJaasModules();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long analyze(Subject whoami) {
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            long duration;
            conn = this.dataSource.getConnection();
            dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (!DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) {
                long l = -1L;
                return l;
            }
            long l = duration = this.doCommand(dbtype, conn, "ANALYZE", null);
            return l;
        }
        catch (Exception e) {
            this.log.error((Object)"Error analyzing database", (Throwable)e);
            throw new RuntimeException("Error analyzing database", e);
        }
        finally {
            if (dbtype != null) {
                dbtype.closeConnection(conn);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long reindex(Subject whoami) {
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            int i;
            conn = this.dataSource.getConnection();
            dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            long duration = 0L;
            if (DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) {
                for (i = 0; i < this.TABLES_TO_REINDEX.length; ++i) {
                    duration += this.doCommand(dbtype, conn, "REINDEX TABLE {0}", this.TABLES_TO_REINDEX[i]);
                }
            } else if (DatabaseTypeFactory.isOracle((DatabaseType)dbtype)) {
                for (i = 0; i < this.ORA_INDEXES_TO_REBUILD.length; ++i) {
                    duration += this.doCommand(dbtype, conn, "ALTER INDEX {0} REBUILD UNRECOVERABLE", this.ORA_INDEXES_TO_REBUILD[i]);
                }
            } else {
                long l = -1L;
                return l;
            }
            long l = duration;
            return l;
        }
        catch (Exception e) {
            this.log.error((Object)"Error reindexing database", (Throwable)e);
            throw new RuntimeException("Error reindexing database", e);
        }
        finally {
            if (dbtype != null) {
                dbtype.closeConnection(conn);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuum(Subject whoami) {
        return this.vacuum(whoami, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuum(Subject whoami, String[] tableNames) {
        long duration = 0L;
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            conn = this.dataSource.getConnection();
            dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (!DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) {
                long l = -1L;
                return l;
            }
            if (tableNames == null) {
                tableNames = new String[]{null};
            }
            for (String tableName : tableNames) {
                duration += this.doCommand(dbtype, conn, "VACUUM ANALYZE {0}", tableName);
            }
            long arr$ = duration;
            return arr$;
        }
        catch (Exception e) {
            this.log.error((Object)("Error vacuuming database: " + e.getMessage()), (Throwable)e);
            long l = duration;
            return l;
        }
        finally {
            if (dbtype != null) {
                dbtype.closeConnection(conn);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuumAppdef(Subject whoami) {
        return this.vacuum(whoami, this.TABLES_TO_VACUUM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doCommand(DatabaseType dbtype, Connection conn, String command, String table) {
        Statement stmt = null;
        StopWatch watch = new StopWatch();
        if (table == null) {
            table = "";
        }
        command = command.replace("{0}", table);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Execute command: " + command));
        }
        try {
            stmt = conn.createStatement();
            stmt.execute(command);
            long l = watch.getElapsed();
            return l;
        }
        catch (SQLException e) {
            this.log.error((Object)("Error in command: " + command + ": " + e), (Throwable)e);
            long l = watch.getElapsed();
            return l;
        }
        finally {
            dbtype.closeStatement(stmt);
        }
    }

    @Override
    public void undeployInstaller() {
        block17: {
            try {
                File serverHomeDir = LookupUtil.getCoreServer().getJBossServerHomeDir();
                File deployDirectory = new File(serverHomeDir, "deploy");
                if (deployDirectory.exists()) {
                    File deployedInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-installer.war");
                    File undeployedInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-installer.war.rej");
                    if (deployedInstallWar.exists()) {
                        ObjectName name = ObjectNameFactory.create((String)"jboss.system:service=MainDeployer");
                        MBeanServer mbs = MBeanServerLocator.locateJBoss();
                        MainDeployerMBean mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, MainDeployerMBean.class, false);
                        URL url = deployedInstallWar.toURI().toURL();
                        String urlString = url.toString().replace("%20", " ");
                        mbean.undeploy(urlString);
                        if (!mbean.isDeployed(urlString)) {
                            this.log.info((Object)"Installer war has been hot-undeployed from memory");
                        } else {
                            this.log.warn((Object)"Installer hot-undeploy failed - full installer undeploy may not work...");
                        }
                        if (!deployedInstallWar.renameTo(undeployedInstallWar)) {
                            throw new RuntimeException("Cannot undeploy the installer war: " + deployedInstallWar);
                        }
                        if (deployedInstallWar.exists()) {
                            throw new RuntimeException("Failed to undeploy the installer war: " + deployedInstallWar);
                        }
                        File deployedPostInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-postinstaller.war");
                        File undeployedPostInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-postinstaller.war.rej");
                        if (!deployedPostInstallWar.exists()) {
                            if (undeployedPostInstallWar.exists()) {
                                if (undeployedPostInstallWar.renameTo(deployedPostInstallWar)) {
                                    this.log.debug((Object)"Post-install notification war has been deployed");
                                } else {
                                    this.log.info((Object)"Post-install notification war failed to deploy - this can be ignored");
                                }
                            } else {
                                this.log.info((Object)"Post-install notification war not found and not deployed - this can be ignored");
                            }
                        } else {
                            this.log.info((Object)"Post-install notification war already deployed");
                        }
                    } else if (undeployedInstallWar.exists()) {
                        this.log.debug((Object)("Installer looks to be undeployed already, this is good: " + undeployedInstallWar));
                    } else {
                        this.log.debug((Object)("Installer can't be found - assume it has been completely purged: " + deployedInstallWar));
                    }
                    break block17;
                }
                throw new RuntimeException("Your deployment seems corrupted - missing deploy dir: " + deployDirectory);
            }
            catch (Exception e) {
                this.log.warn((Object)("Please manually remove installer war to secure your deployment: " + e));
                return;
            }
        }
        this.log.info((Object)"Confirmed that the installer has been undeployed");
    }

    @Override
    public boolean isDebugModeEnabled() {
        try {
            Subject su = this.subjectManager.getOverlord();
            return Boolean.valueOf(this.getSystemConfiguration(su).getProperty("ENABLE_DEBUG_MODE", "false"));
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public boolean isExperimentalFeaturesEnabled() {
        try {
            Subject su = this.subjectManager.getOverlord();
            return Boolean.valueOf(this.getSystemConfiguration(su).getProperty("ENABLE_EXPERIMENTAL_FEATURES", "false"));
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public ServerDetails getServerDetails(Subject subject) {
        CoreServerMBean coreServerMBean = LookupUtil.getCoreServer();
        ServerDetails serverDetails = new ServerDetails();
        serverDetails.setProductInfo(this.getProductInfo(subject));
        HashMap details = serverDetails.getDetails();
        DateFormat localTimeFormatter = DateFormat.getDateTimeInstance(1, 0);
        details.put(ServerDetails.Detail.SERVER_LOCAL_TIME, localTimeFormatter.format(new Date()));
        details.put(ServerDetails.Detail.SERVER_TIMEZONE, TimeZone.getDefault().getDisplayName());
        details.put(ServerDetails.Detail.SERVER_HOME_DIR, coreServerMBean.getJBossServerHomeDir().getAbsolutePath());
        details.put(ServerDetails.Detail.SERVER_INSTALL_DIR, coreServerMBean.getInstallDir().getAbsolutePath());
        SystemDatabaseInformation dbInfo = SystemDatabaseInformation.getInstance();
        details.put(ServerDetails.Detail.DATABASE_CONNECTION_URL, dbInfo.getDatabaseConnectionURL());
        details.put(ServerDetails.Detail.DATABASE_DRIVER_NAME, dbInfo.getDatabaseDriverName());
        details.put(ServerDetails.Detail.DATABASE_DRIVER_VERSION, dbInfo.getDatabaseDriverVersion());
        details.put(ServerDetails.Detail.DATABASE_PRODUCT_NAME, dbInfo.getDatabaseProductName());
        details.put(ServerDetails.Detail.DATABASE_PRODUCT_VERSION, dbInfo.getDatabaseProductVersion());
        details.put(ServerDetails.Detail.CURRENT_MEASUREMENT_TABLE, dbInfo.getCurrentMeasurementTable());
        details.put(ServerDetails.Detail.NEXT_MEASUREMENT_TABLE_ROTATION, dbInfo.getNextMeasurementTableRotation());
        return serverDetails;
    }

    @Override
    public ProductInfo getProductInfo(Subject subject) {
        CoreServerMBean coreServer = LookupUtil.getCoreServer();
        ProductInfo productInfo = coreServer.getProductInfo();
        return productInfo;
    }
}

