/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.enterprise.server.alert.engine.model.AbstractCacheElement;
import org.rhq.enterprise.server.alert.engine.model.UnsupportedAlertConditionOperatorException;

public abstract class AbstractEnumCacheElement<E extends Enum<E>>
extends AbstractCacheElement<E> {
    public AbstractEnumCacheElement(AlertConditionOperator operator, E value, int conditionTriggerId) {
        super(operator, value, conditionTriggerId);
    }

    public AbstractEnumCacheElement(AlertConditionOperator operator, Object operatorOption, E value, int conditionTriggerId) {
        super(operator, operatorOption, value, conditionTriggerId);
    }

    @Override
    public boolean matches(E providedValue, Object ... extraParams) {
        if (providedValue == null) {
            return false;
        }
        if (this.alertConditionOperator == AlertConditionOperator.EQUALS) {
            return ((Enum)providedValue).equals(this.alertConditionValue);
        }
        if (this.alertConditionOperator == AlertConditionOperator.CHANGES) {
            boolean result = null == this.alertConditionValue ? null != providedValue : !((Enum)this.alertConditionValue).equals(providedValue);
            this.alertConditionValue = providedValue;
            return result;
        }
        if (this.alertConditionOperator == AlertConditionOperator.LESS_THAN_OR_EQUAL_TO) {
            return ((Enum)providedValue).ordinal() <= ((Enum)this.alertConditionValue).ordinal();
        }
        if (this.alertConditionOperator == AlertConditionOperator.LESS_THAN) {
            return ((Enum)providedValue).ordinal() < ((Enum)this.alertConditionValue).ordinal();
        }
        if (this.alertConditionOperator == AlertConditionOperator.GREATER_THAN) {
            return ((Enum)providedValue).ordinal() > ((Enum)this.alertConditionValue).ordinal();
        }
        if (this.alertConditionOperator == AlertConditionOperator.GREATER_THAN_OR_EQUAL_TO) {
            return ((Enum)providedValue).ordinal() >= ((Enum)this.alertConditionValue).ordinal();
        }
        if (this.alertConditionOperator == AlertConditionOperator.CHANGES_TO) {
            boolean result = !this.alertConditionOperatorOption.equals(this.alertConditionValue) && this.alertConditionOperatorOption.equals(providedValue);
            this.alertConditionValue = providedValue;
            return result;
        }
        if (this.alertConditionOperator == AlertConditionOperator.CHANGES_FROM) {
            Boolean result = this.alertConditionOperatorOption.equals(this.alertConditionValue) && !this.alertConditionOperatorOption.equals(providedValue);
            this.alertConditionValue = providedValue;
            return result;
        }
        throw new UnsupportedAlertConditionOperatorException(this.getClass().getSimpleName() + " does not yet support " + this.alertConditionOperator);
    }

    @Override
    public AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator operator) {
        if (operator == AlertConditionOperator.LESS_THAN_OR_EQUAL_TO || operator == AlertConditionOperator.LESS_THAN || operator == AlertConditionOperator.EQUALS || operator == AlertConditionOperator.GREATER_THAN || operator == AlertConditionOperator.GREATER_THAN_OR_EQUAL_TO || operator == AlertConditionOperator.CHANGES || operator == AlertConditionOperator.CHANGES_TO || operator == AlertConditionOperator.CHANGES_FROM) {
            return operator.getDefaultType();
        }
        return AlertConditionOperator.Type.NONE;
    }
}

