/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import java.util.List;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.alert.engine.model.AbstractEnumCacheElement;
import org.rhq.enterprise.server.util.LookupUtil;

public final class AvailabilityDurationCacheElement
extends AbstractEnumCacheElement<AvailabilityType> {
    private int alertDefinitionId;

    public AvailabilityDurationCacheElement(int alertDefinitionId, AlertConditionOperator operator, String operatorOption, AvailabilityType value, int conditionTriggerId) {
        super(operator, (Object)operatorOption, value, conditionTriggerId);
        this.alertDefinitionId = alertDefinitionId;
    }

    public static void checkCacheElements(List<AvailabilityDurationCacheElement> cacheElements, Resource resource, AvailabilityType providedValue) {
        if (null == cacheElements) {
            return;
        }
        for (AvailabilityDurationCacheElement cacheElement : cacheElements) {
            switch (cacheElement.getAlertConditionOperator()) {
                case AVAIL_DURATION_DOWN: {
                    if (AvailabilityType.DOWN != providedValue || AvailabilityType.DOWN == cacheElement.getAlertConditionValue()) break;
                    LookupUtil.getAvailabilityManager().scheduleAvailabilityDurationCheck(cacheElement, resource);
                    break;
                }
                case AVAIL_DURATION_NOT_UP: {
                    if (AvailabilityType.UP == providedValue || AvailabilityType.UP != cacheElement.getAlertConditionValue()) break;
                    LookupUtil.getAvailabilityManager().scheduleAvailabilityDurationCheck(cacheElement, resource);
                }
            }
            cacheElement.setAlertConditionValue(providedValue);
        }
    }

    public int getAlertDefinitionId() {
        return this.alertDefinitionId;
    }

    @Override
    public boolean matches(AvailabilityType providedValue, Object ... extraParams) {
        if (null == providedValue) {
            return false;
        }
        boolean result = false;
        switch (this.alertConditionOperator) {
            case AVAIL_DURATION_DOWN: {
                result = AvailabilityType.DOWN == providedValue;
                break;
            }
            case AVAIL_DURATION_NOT_UP: {
                result = AvailabilityType.UP != providedValue;
                break;
            }
        }
        this.alertConditionValue = providedValue;
        return result;
    }

    @Override
    public AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator operator) {
        switch (operator) {
            case AVAIL_DURATION_DOWN: 
            case AVAIL_DURATION_NOT_UP: {
                return operator.getDefaultType();
            }
        }
        return AlertConditionOperator.Type.NONE;
    }
}

