/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.bundle;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.rhq.core.clientapi.agent.bundle.BundleAgentService;
import org.rhq.core.clientapi.agent.bundle.BundlePurgeRequest;
import org.rhq.core.clientapi.agent.bundle.BundlePurgeResponse;
import org.rhq.core.clientapi.agent.bundle.BundleScheduleRequest;
import org.rhq.core.clientapi.agent.bundle.BundleScheduleResponse;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDeploymentStatus;
import org.rhq.core.domain.bundle.BundleDestination;
import org.rhq.core.domain.bundle.BundleFile;
import org.rhq.core.domain.bundle.BundleGroup;
import org.rhq.core.domain.bundle.BundleNotFoundException;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.bundle.ResourceTypeBundleConfiguration;
import org.rhq.core.domain.bundle.composite.BundleGroupAssignmentComposite;
import org.rhq.core.domain.bundle.composite.BundleWithLatestVersionComposite;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageCategory;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.criteria.BundleCriteria;
import org.rhq.core.domain.criteria.BundleDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleDestinationCriteria;
import org.rhq.core.domain.criteria.BundleFileCriteria;
import org.rhq.core.domain.criteria.BundleGroupCriteria;
import org.rhq.core.domain.criteria.BundleResourceDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleVersionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.criteria.RoleCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.StringUtils;
import org.rhq.core.util.NumberUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.bundle.BundleDistributionInfo;
import org.rhq.enterprise.server.bundle.BundleManagerHelper;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.bundle.BundleManagerRemote;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginManager;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.safeinvoker.HibernateDetachUtility;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.BundleDeploymentStatusCheckJob;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.QuartzUtil;

@Stateless
public class BundleManagerBean
implements BundleManagerLocal,
BundleManagerRemote {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String AUDIT_ACTION_DEPLOYMENT = "Deployment";
    private final String AUDIT_ACTION_DEPLOYMENT_REQUESTED = "Deployment Requested";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private BundleManagerLocal bundleManager;
    @EJB
    private ContentManagerLocal contentManager;
    @EJB
    private RepoManagerLocal repoManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private SchedulerLocal quartzScheduler;

    @Override
    public ResourceTypeBundleConfiguration getResourceTypeBundleConfiguration(Subject subject, int compatGroupId) throws Exception {
        if (this.authorizationManager.canViewGroup(subject, compatGroupId)) {
            Query q = this.entityManager.createNamedQuery("ResourceType.getBundleConfigByGroupResourceType");
            q.setParameter("groupId", (Object)compatGroupId);
            ResourceTypeBundleConfiguration bundleConfig = null;
            try {
                Configuration config = (Configuration)q.getSingleResult();
                if (config != null) {
                    bundleConfig = new ResourceTypeBundleConfiguration(config);
                }
            }
            catch (EntityNotFoundException enfe) {
                // empty catch block
            }
            return bundleConfig;
        }
        throw new Exception("[" + subject.getName() + "] is not authorized to access the group");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public BundleResourceDeploymentHistory addBundleResourceDeploymentHistoryInNewTrans(Subject subject, int bundleDeploymentId, BundleResourceDeploymentHistory history) throws Exception {
        BundleResourceDeployment resourceDeployment = (BundleResourceDeployment)this.entityManager.find(BundleResourceDeployment.class, (Object)bundleDeploymentId);
        if (null == resourceDeployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + bundleDeploymentId);
        }
        resourceDeployment.addBundleResourceDeploymentHistory(history);
        this.entityManager.persist((Object)resourceDeployment);
        return history;
    }

    @Override
    public Bundle createBundle(Subject subject, String name, String description, int bundleTypeId, int[] bundleGroupIds) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleName: " + name);
        }
        BundleType bundleType = (BundleType)this.entityManager.find(BundleType.class, (Object)bundleTypeId);
        if (null == bundleType) {
            throw new IllegalArgumentException("Invalid bundleTypeId: " + bundleTypeId);
        }
        bundleGroupIds = null != bundleGroupIds ? bundleGroupIds : new int[]{};
        ArrayList<BundleGroup> bundleGroups = new ArrayList<BundleGroup>(bundleGroupIds.length);
        for (int bundleGroupId : bundleGroupIds) {
            BundleGroup bundleGroup = (BundleGroup)this.entityManager.find(BundleGroup.class, (Object)bundleGroupId);
            if (null == bundleGroup) {
                throw new IllegalArgumentException("Invalid bundleGroupId: " + bundleGroupId);
            }
            bundleGroups.add(bundleGroup);
        }
        this.checkCreateInitialBundleVersionAuthz(subject, bundleGroupIds);
        Repo repo = new Repo(name);
        repo.setCandidate(false);
        repo.setSyncSchedule(null);
        repo = this.repoManager.createRepo(this.subjectManager.getOverlord(), repo);
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)bundleType.getResourceType().getId());
        PackageType packageType = new PackageType(name, resourceType);
        packageType.setDescription("Package type for content of bundle " + name);
        packageType.setCategory(PackageCategory.BUNDLE);
        packageType.setSupportsArchitecture(false);
        packageType.setDisplayName(StringUtils.deCamelCase((String)name));
        packageType.setDiscoveryInterval(-1L);
        packageType.setCreationData(false);
        packageType.setDeploymentConfigurationDefinition(null);
        Bundle bundle = new Bundle(name, bundleType, repo, packageType);
        bundle.setDescription(description);
        bundle.setPackageType(packageType);
        this.log.info((Object)("Creating bundle: " + bundle));
        this.entityManager.persist((Object)bundle);
        for (BundleGroup bundleGroup : bundleGroups) {
            bundleGroup.addBundle(bundle);
        }
        return bundle;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public BundleDeployment createBundleDeploymentInNewTrans(Subject subject, int bundleVersionId, int bundleDestinationId, String name, String description, Configuration configuration) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        BundleDestination bundleDestination = (BundleDestination)this.entityManager.find(BundleDestination.class, (Object)bundleDestinationId);
        if (null == bundleDestination) {
            throw new IllegalArgumentException("Invalid bundleDestinationId: " + bundleDestinationId);
        }
        return this.createBundleDeploymentImpl(subject, bundleVersion, bundleDestination, name, description, configuration);
    }

    @Override
    public BundleDeployment createBundleDeployment(Subject subject, int bundleVersionId, int bundleDestinationId, String description, Configuration configuration) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        BundleDestination bundleDestination = (BundleDestination)this.entityManager.find(BundleDestination.class, (Object)bundleDestinationId);
        if (null == bundleDestination) {
            throw new IllegalArgumentException("Invalid bundleDestinationId: " + bundleDestinationId);
        }
        this.checkDeployBundleAuthz(subject, bundleVersion.getBundle().getId(), bundleDestination.getGroup().getId());
        String name = this.getBundleDeploymentNameImpl(subject, bundleDestination, bundleVersion, null);
        return this.createBundleDeploymentImpl(subject, bundleVersion, bundleDestination, name, description, configuration);
    }

    private BundleDeployment createBundleDeploymentImpl(Subject subject, BundleVersion bundleVersion, BundleDestination bundleDestination, String name, String description, Configuration configuration) throws Exception {
        ConfigurationDefinition configDef = bundleVersion.getConfigurationDefinition();
        if (null != configDef) {
            if (null == configuration) {
                throw new IllegalArgumentException("Missing Configuration. Configuration is required when the specified BundleVersion defines Configuration Properties.");
            }
            List errors = ConfigurationUtility.validateConfiguration((Configuration)configuration, (ConfigurationDefinition)configDef);
            if (null != errors && !errors.isEmpty()) {
                throw new IllegalArgumentException("Invalid Configuration: " + errors.toString());
            }
        }
        BundleDeployment deployment = new BundleDeployment(bundleVersion, bundleDestination, name);
        deployment.setDescription(description);
        deployment.setConfiguration(configuration);
        deployment.setSubjectName(subject.getName());
        this.entityManager.persist((Object)deployment);
        return deployment;
    }

    @Override
    public BundleDestination createBundleDestination(Subject subject, int bundleId, String name, String description, String destBaseDirName, String deployDir, Integer groupId) throws Exception {
        if (deployDir.startsWith("..") || deployDir.matches(".*[/:\\\\]\\.\\..*")) {
            throw new IllegalArgumentException("Destination directories are not allowed to have '..' parent directory path elements");
        }
        Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
        if (null == bundle) {
            throw new IllegalArgumentException("Invalid bundleId [" + bundleId + "]");
        }
        ResourceGroupCriteria c = new ResourceGroupCriteria();
        c.addFilterId(groupId);
        c.addFilterBundleTargetableOnly(true);
        PageList<ResourceGroup> groups = this.resourceGroupManager.findResourceGroupsByCriteria(subject, c);
        if (null == groups || groups.isEmpty()) {
            throw new IllegalArgumentException("Invalid groupId [" + groupId + "]. It must be an existing compatible group whose members must be able to support bundle deployments");
        }
        ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)((ResourceGroup)groups.get(0)).getId());
        this.checkDeployBundleAuthz(subject, bundle.getId(), groupId);
        BundleDestination dest = new BundleDestination(bundle, name, group, destBaseDirName, deployDir);
        dest.setDescription(description);
        this.entityManager.persist((Object)dest);
        return dest;
    }

    @Override
    public String getBundleDeploymentName(Subject subject, int bundleDestinationId, int bundleVersionId, int prevDeploymentId) {
        BundleDestination bundleDestination = (BundleDestination)this.entityManager.find(BundleDestination.class, (Object)bundleDestinationId);
        if (null == bundleDestination) {
            throw new IllegalArgumentException("Invalid bundleDestinationId: " + bundleDestinationId);
        }
        BundleVersion bundleVersion = null;
        BundleDeployment prevDeployment = null;
        if (bundleVersionId > 0) {
            bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
            if (null == bundleVersion) {
                throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
            }
        } else if (prevDeploymentId > 0) {
            prevDeployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)prevDeploymentId);
            if (null == prevDeployment) {
                throw new IllegalArgumentException("Invalid prevDeploymentId: " + prevDeploymentId);
            }
        } else {
            throw new IllegalArgumentException("Must specify either a valid bundleVersionId [" + bundleVersionId + "] or prevDeploymentId [" + prevDeploymentId + "]");
        }
        if (bundleVersion != null) {
            this.checkDeployBundleAuthz(subject, bundleVersion.getBundle().getId(), bundleDestination.getGroup().getId());
        }
        return this.getBundleDeploymentNameImpl(subject, bundleDestination, bundleVersion, prevDeployment);
    }

    private String getBundleDeploymentNameImpl(Subject subject, BundleDestination bundleDestination, BundleVersion bundleVersion, BundleDeployment prevDeployment) {
        String deploymentName;
        int deploy;
        boolean isInitialDeployment;
        BundleDeploymentCriteria criteria = new BundleDeploymentCriteria();
        criteria.addFilterDestinationId(Integer.valueOf(bundleDestination.getId()));
        criteria.addFilterIsLive(Boolean.valueOf(true));
        criteria.fetchBundleVersion(true);
        PageList<BundleDeployment> liveDeployments = this.bundleManager.findBundleDeploymentsByCriteria(subject, criteria);
        BundleDeployment liveDeployment = liveDeployments.isEmpty() ? null : (BundleDeployment)liveDeployments.get(0);
        boolean bl = isInitialDeployment = null == liveDeployment;
        if (isInitialDeployment) {
            deploy = 1;
        } else {
            try {
                String liveName = liveDeployment.getName();
                int iStart = liveName.indexOf("[") + 1;
                int iEnd = liveName.indexOf("]");
                deploy = Integer.valueOf(liveName.substring(iStart, iEnd)) + 1;
            }
            catch (Exception e) {
                this.log.warn((Object)("Cannot determine next deployment number. Using -1. liveDeployment=" + liveDeployment));
                deploy = -1;
            }
        }
        if (null != bundleVersion) {
            String liveVersion;
            String version = bundleVersion.getVersion();
            String dest = bundleDestination.getName();
            deploymentName = isInitialDeployment ? "Deployment [" + deploy + "] of Version [" + version + "] to [" + dest + "]" : ((liveVersion = liveDeployment.getBundleVersion().getVersion()).equals(version) ? "Deployment [" + deploy + "] of Version [" + version + "] to [" + dest + "]" : "Deployment [" + deploy + "] of Version [" + version + "] to [" + dest + "]. Upgrade from Version [" + liveVersion + "]");
        } else {
            if (null == liveDeployment) {
                throw new IllegalArgumentException("Invalid Revert, no live deployment for destination" + bundleDestination);
            }
            deploymentName = "Deployment [" + deploy + "] Revert To: " + prevDeployment.getName();
        }
        if (deploymentName.length() > 200) {
            deploymentName = deploymentName.substring(0, 197) + "...";
        }
        return deploymentName;
    }

    @Override
    @RequiredPermission(value=Permission.CREATE_BUNDLES)
    public BundleType createBundleType(Subject subject, String name, int resourceTypeId) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleTypeName: " + name);
        }
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
        if (null == resourceType) {
            throw new IllegalArgumentException("Invalid resourceeTypeId: " + resourceTypeId);
        }
        BundleType bundleType = new BundleType(name, resourceType);
        this.entityManager.persist((Object)bundleType);
        return bundleType;
    }

    @Override
    public BundleVersion createBundleAndBundleVersion(Subject subject, String bundleName, String bundleDescription, int bundleTypeId, int[] bundleGroupIds, String bundleVersionName, String bundleVersionDescription, String version, String recipe) throws Exception {
        BundleCriteria criteria = new BundleCriteria();
        criteria.setStrict(true);
        criteria.addFilterBundleTypeId(Integer.valueOf(bundleTypeId));
        criteria.addFilterName(bundleName);
        criteria.clearPaging();
        PageList<Bundle> bundles = this.findBundlesByCriteria(subject, criteria);
        Bundle bundle = bundles.getTotalSize() == 0 ? this.createBundle(subject, bundleName, bundleDescription, bundleTypeId, bundleGroupIds) : (Bundle)bundles.get(0);
        BundleVersion bv = this.createBundleVersion(subject, bundle.getId(), bundleVersionName, bundleVersionDescription, version, recipe);
        return bv;
    }

    @Override
    public BundleVersion createBundleVersion(Subject subject, int bundleId, String name, String description, String version, String recipe) throws Exception {
        RecipeParseResults results;
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleVersionName: " + name);
        }
        Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
        if (null == bundle) {
            throw new IllegalArgumentException("Invalid bundleId: " + bundleId);
        }
        this.checkCreateBundleVersionAuthz(subject, bundleId);
        BundleType bundleType = bundle.getBundleType();
        try {
            results = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager().parseRecipe(bundleType.getName(), recipe);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse recipe", e);
        }
        version = this.getVersion(version, bundle);
        ComparableVersion comparableVersion = new ComparableVersion(version);
        Query q = this.entityManager.createNamedQuery("BundleVersion.findVersionsByBundleId");
        q.setParameter("bundleId", (Object)bundle.getId());
        List list = q.getResultList();
        int versionOrder = list.size();
        boolean needToUpdateOrder = false;
        for (Object[] bv : list) {
            ComparableVersion bvv = new ComparableVersion(bv[0].toString());
            int comparision = comparableVersion.compareTo((Object)bvv);
            if (comparision == 0) {
                throw new RuntimeException("Cannot create bundle with version [" + version + "], it already exists");
            }
            if (comparision >= 0) break;
            versionOrder = ((Number)bv[1]).intValue();
            needToUpdateOrder = true;
        }
        if (needToUpdateOrder) {
            this.entityManager.flush();
            q = this.entityManager.createNamedQuery("BundleVersion.updateVersionOrderByBundleId");
            q.setParameter("bundleId", (Object)bundle.getId());
            q.setParameter("versionOrder", (Object)versionOrder);
            q.executeUpdate();
            this.entityManager.flush();
            this.entityManager.clear();
        }
        BundleVersion bundleVersion = new BundleVersion(name, version, bundle, recipe);
        bundleVersion.setVersionOrder(versionOrder);
        bundleVersion.setDescription(description);
        bundleVersion.setConfigurationDefinition(results.getConfigurationDefinition());
        this.entityManager.persist((Object)bundleVersion);
        return bundleVersion;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createBundleVersionViaRecipe(Subject subject, String recipe) throws Exception {
        return this.createBundleVersionViaRecipeImpl(subject, recipe, false, null);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createInitialBundleVersionViaRecipe(Subject subject, int[] bundleGroupIds, String recipe) throws Exception {
        return this.createBundleVersionViaRecipeImpl(subject, recipe, true, bundleGroupIds);
    }

    private BundleVersion createBundleVersionViaRecipeImpl(Subject subject, String recipe, boolean mustBeInitialVersion, int[] initialBundleGroupIds) throws Exception {
        BundleServerPluginManager manager = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager();
        BundleDistributionInfo info = manager.parseRecipe(recipe);
        BundleVersion bundleVersion = this.createBundleVersionViaDistributionInfo(subject, info, mustBeInitialVersion, initialBundleGroupIds);
        return bundleVersion;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createBundleVersionViaFile(Subject subject, File distributionFile) throws Exception {
        return this.createBundleVersionViaFileImpl(subject, distributionFile, false, null);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createBundleVersionViaContentHandle(Subject subject, String temporaryContentHandle) throws Exception {
        return this.createBundleVersionViaFileImpl(subject, this.contentManager.getTemporaryContentFile(temporaryContentHandle), false, null);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createOrStoreBundleVersionViaFile(Subject subject, File distributionFile) throws Exception {
        try {
            return this.createBundleVersionViaFileImpl(subject, distributionFile, false, null);
        }
        catch (PermissionException e) {
            if (null != e.getCause() && e.getCause() instanceof BundleNotFoundException) {
                throw new BundleNotFoundException("[" + distributionFile.getName() + "]");
            }
            throw e;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createInitialBundleVersionViaFile(Subject subject, int[] bundleGroupIds, File distributionFile) throws Exception {
        return this.createBundleVersionViaFileImpl(subject, distributionFile, true, bundleGroupIds);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createInitialBundleVersionViaContentHandle(Subject subject, int[] bundleGroupIds, String temporaryContentHandle) throws Exception {
        return this.createBundleVersionViaFileImpl(subject, this.contentManager.getTemporaryContentFile(temporaryContentHandle), true, bundleGroupIds);
    }

    private BundleVersion createBundleVersionViaFileImpl(Subject subject, File distributionFile, boolean mustBeInitialVersion, int[] initialBundleGroupIds) throws Exception {
        BundleServerPluginManager manager = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager();
        BundleDistributionInfo info = manager.processBundleDistributionFile(distributionFile);
        BundleVersion bundleVersion = this.createBundleVersionViaDistributionInfo(subject, info, mustBeInitialVersion, initialBundleGroupIds);
        return bundleVersion;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createBundleVersionViaByteArray(Subject subject, byte[] fileBytes) throws Exception {
        return this.createBundleVersionViaByteArrayImpl(subject, fileBytes, false, null);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createInitialBundleVersionViaByteArray(Subject subject, int[] bundleGroupIds, byte[] fileBytes) throws Exception {
        return this.createBundleVersionViaByteArrayImpl(subject, fileBytes, true, bundleGroupIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleVersion createBundleVersionViaByteArrayImpl(Subject subject, byte[] fileBytes, boolean mustBeInitialVersion, int[] bundleGroupIds) throws Exception {
        File tmpFile = File.createTempFile("bundleDistroBits", ".zip");
        try {
            BundleVersion bundleVersion;
            StreamUtil.copy((InputStream)new ByteArrayInputStream(fileBytes), (OutputStream)new FileOutputStream(tmpFile));
            BundleVersion bundleVersion2 = bundleVersion = this.createBundleVersionViaFileImpl(subject, tmpFile, mustBeInitialVersion, bundleGroupIds);
            return bundleVersion2;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createBundleVersionViaURL(Subject subject, String distributionFileUrl) throws Exception {
        return this.createBundleVersionViaURL(subject, distributionFileUrl, null, null);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createBundleVersionViaURL(Subject subject, String distributionFileUrl, String username, String password) throws Exception {
        return this.createBundleVersionViaURLImpl(subject, distributionFileUrl, username, password, false, null);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createInitialBundleVersionViaURL(Subject subject, int[] bundleGroupIds, String distributionFileUrl) throws Exception {
        return this.createInitialBundleVersionViaURL(subject, bundleGroupIds, distributionFileUrl, null, null);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createInitialBundleVersionViaURL(Subject subject, int[] bundleGroupIds, String distributionFileUrl, String username, String password) throws Exception {
        return this.createBundleVersionViaURLImpl(subject, distributionFileUrl, username, password, true, bundleGroupIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleVersion createBundleVersionViaURLImpl(Subject subject, String distributionFileUrl, String username, String password, boolean mustBeInitialVersion, int[] initialBundleGroupIds) throws Exception {
        File file = null;
        try {
            file = this.downloadFile(distributionFileUrl, username, password);
            this.log.debug((Object)("Copied [" + file.length() + "] bytes from [" + distributionFileUrl + "] into [" + file.getPath() + "]"));
            BundleVersion bundleVersion = this.createBundleVersionViaFileImpl(subject, file, mustBeInitialVersion, initialBundleGroupIds);
            return bundleVersion;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createOrStoreBundleVersionViaURL(Subject subject, String distributionFileUrl, String username, String password) throws Exception {
        File file = null;
        boolean deleteFile = true;
        try {
            file = this.downloadFile(distributionFileUrl, username, password);
            this.log.debug((Object)("Copied [" + file.length() + "] bytes from [" + distributionFileUrl + "] into [" + file.getPath() + "]"));
            BundleVersion bundleVersion = this.createBundleVersionViaFileImpl(subject, file, false, null);
            return bundleVersion;
        }
        catch (PermissionException e) {
            if (null != e.getCause() && e.getCause() instanceof BundleNotFoundException) {
                deleteFile = false;
                throw new BundleNotFoundException("[" + file.getName() + "]");
            }
            throw e;
        }
        finally {
            if (deleteFile && file != null) {
                file.delete();
            }
        }
    }

    private File downloadFile(String fileUrl, String username, String password) throws IOException, URISyntaxException {
        URL url = new URL(fileUrl);
        if ("http".equalsIgnoreCase(url.getProtocol()) || "https".equalsIgnoreCase(url.getProtocol())) {
            return this.downloadFileFromHttp(url, username, password);
        }
        return this.slurp(url.openStream());
    }

    private File downloadFileFromHttp(URL url, String username, String password) throws URISyntaxException, IOException {
        HttpResponse response;
        BasicHttpParams params = new BasicHttpParams();
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
        DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)params);
        HttpGet get = new HttpGet(url.toURI());
        if (username != null) {
            get.addHeader(BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials(username, password), (String)"UTF-8", (boolean)false));
        }
        if ((response = httpClient.execute((HttpUriRequest)get)).getStatusLine().getStatusCode() != 200) {
            throw new IllegalArgumentException("Failed to download the file from the URL [" + url + "]. The server responded: " + response.getStatusLine().toString());
        }
        InputStream contents = response.getEntity().getContent();
        return this.slurp(contents);
    }

    private File slurp(InputStream is) throws IOException {
        File file = File.createTempFile("bundle-distribution", ".zip");
        StreamUtil.copy((InputStream)is, (OutputStream)new FileOutputStream(file));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleVersion createBundleVersionViaDistributionInfo(Subject subject, BundleDistributionInfo info, boolean mustBeInitialVersion, int[] initialBundleGroupIds) throws Exception {
        BundleVersion bundleVersion;
        block15: {
            boolean createdBundle;
            Bundle bundle;
            boolean isInitialVersion;
            BundleType bundleType = this.bundleManager.getBundleType(subject, info.getBundleTypeName());
            String bundleName = info.getRecipeParseResults().getBundleMetadata().getBundleName();
            String bundleDescription = info.getRecipeParseResults().getBundleMetadata().getDescription();
            String name = bundleName;
            String description = bundleDescription;
            String version = info.getRecipeParseResults().getBundleMetadata().getBundleVersion();
            String recipe = info.getRecipe();
            BundleCriteria criteria = new BundleCriteria();
            criteria.setStrict(true);
            criteria.addFilterBundleTypeId(Integer.valueOf(bundleType.getId()));
            criteria.addFilterName(bundleName);
            PageList<Bundle> bundles = this.bundleManager.findBundlesByCriteria(subject, criteria);
            boolean bl = isInitialVersion = bundles.getTotalSize() == 0;
            if (!isInitialVersion && mustBeInitialVersion) {
                throw new PermissionException("This must be the initial version of a new Bundle.");
            }
            if (isInitialVersion) {
                bundle = this.bundleManager.createBundle(subject, bundleName, bundleDescription, bundleType.getId(), initialBundleGroupIds);
                createdBundle = true;
            } else {
                bundle = (Bundle)bundles.get(0);
                this.checkCreateBundleVersionAuthz(subject, bundle.getId());
                createdBundle = false;
            }
            bundleVersion = this.bundleManager.createBundleVersion(this.subjectManager.getOverlord(), bundle.getId(), name, description, version, recipe);
            try {
                Map<String, File> bundleFiles = info.getBundleFiles();
                if (bundleFiles == null) break block15;
                for (String fileName : bundleFiles.keySet()) {
                    File file = bundleFiles.get(fileName);
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(file);
                        BundleFile bundleFile = this.bundleManager.addBundleFile(subject, bundleVersion.getId(), fileName, bundleVersion.getVersion(), null, is);
                        this.log.debug((Object)("Added bundle file [" + bundleFile + "] to BundleVersion [" + bundleVersion + "]"));
                    }
                    finally {
                        this.safeClose(is);
                        if (null == file) continue;
                        file.delete();
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to add bundle file to new bundle version [" + bundleVersion + "], will not create the new bundle"), (Throwable)e);
                try {
                    this.bundleManager.deleteBundleVersion(this.subjectManager.getOverlord(), bundleVersion.getId(), createdBundle);
                }
                catch (Exception e1) {
                    this.log.error((Object)("Failed to delete the partially created bundle version: " + bundleVersion), (Throwable)e1);
                }
                throw e;
            }
        }
        BundleVersionCriteria bvCriteria = new BundleVersionCriteria();
        bvCriteria.addFilterId(Integer.valueOf(bundleVersion.getId()));
        bvCriteria.fetchBundle(true);
        bvCriteria.fetchBundleFiles(true);
        bvCriteria.fetchConfigurationDefinition(true);
        bvCriteria.fetchTags(true);
        PageList<BundleVersion> bundleVersions = this.bundleManager.findBundleVersionsByCriteria(subject, bvCriteria);
        if (bundleVersions != null && bundleVersions.size() == 1) {
            bundleVersion = (BundleVersion)bundleVersions.get(0);
            List bundleFiles = bundleVersion.getBundleFiles();
            if (bundleFiles != null && bundleFiles.size() > 0) {
                final BundleFileCriteria bfCriteria = new BundleFileCriteria();
                bfCriteria.addFilterBundleVersionId(Integer.valueOf(bundleVersion.getId()));
                bfCriteria.fetchPackageVersion(true);
                CriteriaQueryExecutor<BundleFile, BundleFileCriteria> queryExecutor = new CriteriaQueryExecutor<BundleFile, BundleFileCriteria>(){

                    @Override
                    public PageList<BundleFile> execute(BundleFileCriteria criteria) {
                        return BundleManagerBean.this.bundleManager.findBundleFilesByCriteria(BundleManagerBean.this.subjectManager.getOverlord(), bfCriteria);
                    }
                };
                CriteriaQuery<BundleFile, BundleFileCriteria> bfs = new CriteriaQuery<BundleFile, BundleFileCriteria>(bfCriteria, queryExecutor);
                bundleFiles.clear();
                for (BundleFile bf : bfs) {
                    bundleFiles.add(bf);
                }
            }
            bundleVersion.setBundleDeployments(new ArrayList());
        } else {
            this.log.error((Object)("Failed to obtain the full bundle version, returning only what we currently know about it: " + bundleVersion));
        }
        return bundleVersion;
    }

    private String getVersion(String version, Bundle bundle) {
        if (null != version && version.trim().length() > 0) {
            return version;
        }
        BundleVersion latestBundleVersion = null;
        Query q = this.entityManager.createNamedQuery("BundleVersion.findLatestByBundleId");
        q.setParameter("bundleId", (Object)bundle.getId());
        List list = q.getResultList();
        if (list.size() > 0) {
            if (list.size() == 1) {
                latestBundleVersion = (BundleVersion)list.get(0);
            } else {
                throw new RuntimeException("Bundle [" + bundle.getName() + "] (id=" + bundle.getId() + ") has more than 1 'latest' version. This should not happen - aborting");
            }
        }
        String latestVersion = latestBundleVersion != null ? latestBundleVersion.getVersion() : null;
        String newVersion = NumberUtil.autoIncrementVersion((String)latestVersion);
        return newVersion;
    }

    @Override
    public BundleFile addBundleFile(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, InputStream fileStream) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileName: " + name);
        }
        if (null == version || "".equals(version.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileVersion: " + version);
        }
        if (null == fileStream) {
            throw new IllegalArgumentException("Invalid fileStream: " + null);
        }
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        this.checkCreateBundleVersionAuthz(subject, bundleVersion.getBundle().getId());
        Bundle bundle = bundleVersion.getBundle();
        PackageType packageType = bundle.getPackageType();
        Architecture architecture2 = architecture = null == architecture ? this.contentManager.getNoArchitecture() : architecture;
        if (architecture.getId() == 0) {
            Query q = this.entityManager.createNamedQuery("Architecture.findByName");
            q.setParameter("name", (Object)architecture.getName());
            architecture = (Architecture)q.getSingleResult();
        }
        PackageVersion packageVersion = this.contentManager.createPackageVersionWithDisplayVersion(subject, name, packageType.getId(), version, null, architecture.getId(), fileStream);
        packageVersion.setFileName(name);
        packageVersion = (PackageVersion)this.entityManager.merge((Object)packageVersion);
        Repo repo = bundle.getRepo();
        this.repoManager.addPackageVersionsToRepo(this.subjectManager.getOverlord(), repo.getId(), new int[]{packageVersion.getId()});
        Package generalPackage = packageVersion.getGeneralPackage();
        generalPackage.setClassification(bundle.getName());
        BundleFile bundleFile = new BundleFile();
        bundleFile.setBundleVersion(bundleVersion);
        bundleFile.setPackageVersion(packageVersion);
        this.entityManager.persist((Object)bundleFile);
        return bundleFile;
    }

    @Override
    public BundleFile addBundleFileViaByteArray(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, byte[] fileBytes) throws Exception {
        return this.addBundleFile(subject, bundleVersionId, name, version, architecture, new ByteArrayInputStream(fileBytes));
    }

    @Override
    public BundleFile addBundleFileViaURL(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, String bundleFileUrl) throws Exception {
        URL url = new URL(bundleFileUrl);
        return this.addBundleFile(subject, bundleVersionId, name, version, architecture, url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleFile addBundleFileViaURL(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, String bundleFileUrl, String userName, String password) throws Exception {
        BundleFile bundleFile;
        block6: {
            BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
            if (null == bundleVersion) {
                throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
            }
            this.checkCreateBundleVersionAuthz(subject, bundleVersion.getBundle().getId());
            File file = null;
            FileInputStream fis = null;
            try {
                file = this.downloadFile(bundleFileUrl, userName, password);
                fis = new FileInputStream(file);
                bundleFile = this.addBundleFile(subject, bundleVersionId, name, version, architecture, fis);
                if (fis != null) {
                    this.safeClose(fis);
                }
                if (file == null) break block6;
                file.delete();
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    this.safeClose(fis);
                }
                if (file != null) {
                    file.delete();
                }
                throw throwable;
            }
        }
        return bundleFile;
    }

    @Override
    public BundleFile addBundleFileViaPackageVersion(Subject subject, int bundleVersionId, String name, int packageVersionId) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileName: " + name);
        }
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        PackageVersion packageVersion = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
        if (null == packageVersion) {
            throw new IllegalArgumentException("Invalid packageVersionId: " + packageVersionId);
        }
        this.checkCreateBundleVersionAuthz(subject, bundleVersion.getBundle().getId());
        BundleFile bundleFile = new BundleFile();
        bundleFile.setBundleVersion(bundleVersion);
        bundleFile.setPackageVersion(packageVersion);
        this.entityManager.persist((Object)bundleFile);
        return bundleFile;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void purgeBundleDestination(final Subject subject, int bundleDestinationId) throws Exception {
        BundleDeploymentCriteria bdc = new BundleDeploymentCriteria();
        bdc.addFilterDestinationId(Integer.valueOf(bundleDestinationId));
        bdc.addFilterIsLive(Boolean.valueOf(true));
        bdc.fetchBundleVersion(true);
        bdc.fetchResourceDeployments(true);
        bdc.fetchDestination(true);
        PageList<BundleDeployment> liveDeployments = this.bundleManager.findBundleDeploymentsByCriteria(subject, bdc);
        if (1 != liveDeployments.size()) {
            throw new IllegalArgumentException("No live deployment to purge is found for destinationId [" + bundleDestinationId + "]");
        }
        BundleDeployment liveDeployment = (BundleDeployment)liveDeployments.get(0);
        List resourceDeploys = liveDeployment.getResourceDeployments();
        if (resourceDeploys == null || resourceDeploys.isEmpty()) {
            return;
        }
        this.checkDeployBundleAuthz(subject, liveDeployment.getBundleVersion().getBundle().getId(), liveDeployment.getDestination().getGroup().getId());
        BundleVersionCriteria bvc = new BundleVersionCriteria();
        bvc.addFilterId(Integer.valueOf(liveDeployment.getBundleVersion().getId()));
        bvc.fetchBundle(true);
        PageList<BundleVersion> bvs = this.bundleManager.findBundleVersionsByCriteria(subject, bvc);
        liveDeployment.setBundleVersion((BundleVersion)bvs.get(0));
        ResourceTypeCriteria rtc = new ResourceTypeCriteria();
        rtc.addFilterIgnored(null);
        rtc.addFilterBundleTypeId(Integer.valueOf(liveDeployment.getBundleVersion().getBundle().getBundleType().getId()));
        PageList<ResourceType> rts = this.resourceTypeManager.findResourceTypesByCriteria(subject, rtc);
        liveDeployment.getBundleVersion().getBundle().getBundleType().setResourceType((ResourceType)rts.get(0));
        ArrayList<Integer> resourceDeployIds = new ArrayList<Integer>();
        for (BundleResourceDeployment resourceDeploy : resourceDeploys) {
            resourceDeployIds.add(resourceDeploy.getId());
        }
        final BundleResourceDeploymentCriteria brdc = new BundleResourceDeploymentCriteria();
        brdc.addFilterIds(resourceDeployIds.toArray(new Integer[resourceDeployIds.size()]));
        brdc.fetchResource(true);
        CriteriaQueryExecutor<BundleResourceDeployment, BundleResourceDeploymentCriteria> queryExecutor = new CriteriaQueryExecutor<BundleResourceDeployment, BundleResourceDeploymentCriteria>(){

            @Override
            public PageList<BundleResourceDeployment> execute(BundleResourceDeploymentCriteria criteria) {
                return BundleManagerBean.this.bundleManager.findBundleResourceDeploymentsByCriteria(subject, brdc);
            }
        };
        CriteriaQuery<BundleResourceDeployment, BundleResourceDeploymentCriteria> brdResults = new CriteriaQuery<BundleResourceDeployment, BundleResourceDeploymentCriteria>(brdc, queryExecutor);
        resourceDeploys.clear();
        for (BundleResourceDeployment brd : brdResults) {
            resourceDeploys.add(brd);
            brd.setBundleDeployment(liveDeployment);
        }
        HashMap<BundleResourceDeployment, String> failedToPurge = new HashMap<BundleResourceDeployment, String>();
        for (BundleResourceDeployment resourceDeploy : resourceDeploys) {
            try {
                BundlePurgeRequest request;
                BundleResourceDeploymentHistory history = new BundleResourceDeploymentHistory(subject.getName(), "Purge Requested", "User [" + subject.getName() + "] requested to purge this deployment", null, BundleResourceDeploymentHistory.Status.SUCCESS, null, null);
                this.bundleManager.addBundleResourceDeploymentHistoryInNewTrans(this.subjectManager.getOverlord(), resourceDeploy.getId(), history);
                Subject overlord = this.subjectManager.getOverlord();
                AgentClient agentClient = this.agentManager.getAgentClient(overlord, resourceDeploy.getResource().getId());
                BundleAgentService bundleAgentService = agentClient.getBundleAgentService();
                BundlePurgeResponse results = bundleAgentService.purge(request = new BundlePurgeRequest(resourceDeploy));
                if (results.isSuccess()) continue;
                String errorMessage = results.getErrorMessage();
                failedToPurge.put(resourceDeploy, errorMessage);
            }
            catch (Exception e) {
                String errorMessage = ThrowableUtil.getStackAsString((Throwable)e);
                failedToPurge.put(resourceDeploy, errorMessage);
            }
        }
        this.bundleManager._finalizePurge(this.subjectManager.getOverlord(), liveDeployment, failedToPurge);
        if (!failedToPurge.isEmpty()) {
            int totalDeployments = liveDeployment.getResourceDeployments().size();
            int failedPurges = failedToPurge.size();
            throw new Exception("Failed to purge [" + failedPurges + "] of [" + totalDeployments + "] remote resource deployments");
        }
    }

    @Override
    public void _finalizePurge(Subject subject, BundleDeployment bundleDeployment, Map<BundleResourceDeployment, String> failedToPurge) throws Exception {
        bundleDeployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeployment.getId());
        if (failedToPurge.isEmpty()) {
            bundleDeployment.setLive(false);
            bundleDeployment.setErrorMessage(null);
            bundleDeployment.setStatus(BundleDeploymentStatus.SUCCESS);
        } else {
            bundleDeployment.setLive(true);
            StringBuilder errorStr = new StringBuilder();
            int totalDeployments = bundleDeployment.getResourceDeployments().size();
            int failedPurges = failedToPurge.size();
            if (failedPurges < totalDeployments) {
                bundleDeployment.setStatus(BundleDeploymentStatus.MIXED);
                errorStr.append("Failed to purge [" + failedPurges + "] of [" + totalDeployments + "] remote resource deployments");
            } else {
                bundleDeployment.setStatus(BundleDeploymentStatus.FAILURE);
                errorStr.append("Failed to purge all [" + failedPurges + "] remote resource deployments");
            }
            for (Map.Entry<BundleResourceDeployment, String> entry : failedToPurge.entrySet()) {
                errorStr.append("\n\n");
                errorStr.append(entry.getKey().getResource().getName()).append(": ").append(entry.getValue());
            }
            bundleDeployment.setErrorMessage(errorStr.toString());
        }
    }

    @Override
    public BundleDeployment scheduleBundleDeployment(Subject subject, int bundleDeploymentId, boolean isCleanDeployment) throws Exception {
        return this.scheduleBundleDeploymentImpl(subject, bundleDeploymentId, isCleanDeployment, false, null);
    }

    @Override
    public BundleDeployment scheduleRevertBundleDeployment(Subject subject, int bundleDestinationId, String deploymentDescription, boolean isCleanDeployment) throws Exception {
        BundleDeploymentCriteria c = new BundleDeploymentCriteria();
        c.addFilterDestinationId(Integer.valueOf(bundleDestinationId));
        c.addFilterIsLive(Boolean.valueOf(true));
        c.fetchDestination(true);
        PageList<BundleDeployment> liveDeployments = this.bundleManager.findBundleDeploymentsByCriteria(subject, c);
        if (1 != liveDeployments.size()) {
            throw new IllegalArgumentException("No live deployment found for destinationId [" + bundleDestinationId + "]");
        }
        BundleDeployment liveDeployment = (BundleDeployment)liveDeployments.get(0);
        Integer prevDeploymentId = liveDeployment.getReplacedBundleDeploymentId();
        if (null == prevDeploymentId) {
            throw new IllegalArgumentException("Live deployment [" + liveDeployment + "] can not be reverted. The Live deployment is either an initial deployment or a reverted deployment for destinationId [" + bundleDestinationId + "]");
        }
        BundleDeployment prevDeployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)prevDeploymentId);
        if (null == prevDeployment) {
            throw new IllegalArgumentException("Live deployment [" + liveDeployment + "] can not be reverted. There is no prior deployment for destinationId [" + bundleDestinationId + "]");
        }
        this.checkDeployBundleAuthz(subject, liveDeployment.getBundleVersion().getBundle().getId(), liveDeployment.getDestination().getGroup().getId());
        String name = this.getBundleDeploymentNameImpl(subject, liveDeployment.getDestination(), null, prevDeployment);
        String desc = null != deploymentDescription ? deploymentDescription : prevDeployment.getDescription();
        Configuration config = null == prevDeployment.getConfiguration() ? null : prevDeployment.getConfiguration().deepCopy(false);
        BundleDeployment revertDeployment = this.bundleManager.createBundleDeploymentInNewTrans(subject, prevDeployment.getBundleVersion().getId(), bundleDestinationId, name, desc, config);
        return this.scheduleBundleDeploymentImpl(subject, revertDeployment.getId(), isCleanDeployment, true, prevDeployment.getReplacedBundleDeploymentId());
    }

    private BundleDeployment scheduleBundleDeploymentImpl(Subject subject, int bundleDeploymentId, boolean isCleanDeployment, boolean isRevert, Integer revertedDeploymentReplacedDeployment) throws Exception {
        BundleDeployment newDeployment = this.bundleManager.scheduleBundleDeploymentInNewTransaction(subject, bundleDeploymentId, isCleanDeployment, isRevert, revertedDeploymentReplacedDeployment);
        try {
            JobDetail jobDetail = BundleDeploymentStatusCheckJob.getJobDetail(bundleDeploymentId);
            Trigger trigger = QuartzUtil.getFireOnceImmediateTrigger(jobDetail);
            this.quartzScheduler.scheduleJob(jobDetail, trigger);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to schedule bundle deployment status check job for deployment:" + newDeployment), (Throwable)e);
        }
        return newDeployment;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public BundleDeployment scheduleBundleDeploymentInNewTransaction(Subject subject, int bundleDeploymentId, boolean isCleanDeployment, boolean isRevert, Integer revertedDeploymentReplacedDeployment) throws Exception {
        BundleDeployment newDeployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeploymentId);
        if (null == newDeployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + bundleDeploymentId);
        }
        BundleDestination destination = newDeployment.getDestination();
        ResourceGroup group = destination.getGroup();
        Set groupMembers = group.getExplicitResources();
        if (groupMembers.isEmpty()) {
            throw new IllegalArgumentException("Destination [" + destination + "] group has no members. Invalid deployment destination");
        }
        this.checkDeployBundleAuthz(subject, newDeployment.getBundleVersion().getBundle().getId(), group.getId());
        for (Resource groupMember : groupMembers) {
            try {
                this.scheduleBundleResourceDeployment(subject, newDeployment, groupMember, isCleanDeployment, isRevert);
            }
            catch (Throwable t) {
                this.log.error((Object)("Failed to complete scheduling of bundle deployment to [" + groupMember + "]. Other bundle deployments to other resources may have been scheduled. "), t);
            }
        }
        List currentDeployments = (destination = (BundleDestination)this.entityManager.find(BundleDestination.class, (Object)destination.getId())).getDeployments();
        if (null != currentDeployments) {
            for (BundleDeployment d : currentDeployments) {
                if (!d.isLive()) continue;
                d.setLive(false);
                if (!isRevert) {
                    newDeployment.setReplacedBundleDeploymentId(Integer.valueOf(d.getId()));
                    break;
                }
                newDeployment.setReplacedBundleDeploymentId(revertedDeploymentReplacedDeployment);
                break;
            }
        }
        newDeployment.setLive(true);
        return newDeployment;
    }

    private BundleResourceDeployment scheduleBundleResourceDeployment(Subject subject, BundleDeployment deployment, Resource bundleTarget, boolean isCleanDeployment, boolean isRevert) throws Exception {
        int bundleTargetResourceId = bundleTarget.getId();
        AgentClient agentClient = this.agentManager.getAgentClient(this.subjectManager.getOverlord(), bundleTargetResourceId);
        BundleAgentService bundleAgentService = agentClient.getBundleAgentService();
        BundleResourceDeployment resourceDeployment = this.bundleManager.createBundleResourceDeploymentInNewTrans(this.subjectManager.getOverlord(), deployment.getId(), bundleTargetResourceId);
        if (null != bundleTarget.getResourceType().getResourceTypeBundleConfiguration()) {
            try {
                BundleScheduleRequest request = this.bundleManager.getScheduleRequest(subject, resourceDeployment.getId(), isCleanDeployment, isRevert);
                BundleResourceDeploymentHistory history = new BundleResourceDeploymentHistory(subject.getName(), "Deployment Requested", deployment.getName(), null, BundleResourceDeploymentHistory.Status.SUCCESS, "Requested deployment time: " + request.getRequestedDeployTimeAsString(), null);
                this.bundleManager.addBundleResourceDeploymentHistoryInNewTrans(this.subjectManager.getOverlord(), resourceDeployment.getId(), history);
                BundleScheduleResponse response = bundleAgentService.schedule(request);
                if (!response.isSuccess()) {
                    this.bundleManager.setBundleResourceDeploymentStatusInNewTransaction(subject, resourceDeployment.getId(), BundleDeploymentStatus.FAILURE);
                    history = new BundleResourceDeploymentHistory(subject.getName(), "Deployment", deployment.getName(), null, BundleResourceDeploymentHistory.Status.FAILURE, response.getErrorMessage(), null);
                    this.bundleManager.addBundleResourceDeploymentHistoryInNewTrans(subject, resourceDeployment.getId(), history);
                }
            }
            catch (Throwable t) {
                BundleResourceDeploymentHistory failureHistory = new BundleResourceDeploymentHistory(subject.getName(), this.AUDIT_ACTION_DEPLOYMENT, deployment.getName(), null, BundleResourceDeploymentHistory.Status.FAILURE, "Failed to schedule, agent on [" + bundleTarget + "] may be down: " + t, null);
                this.bundleManager.addBundleResourceDeploymentHistoryInNewTrans(subject, resourceDeployment.getId(), failureHistory);
                this.bundleManager.setBundleResourceDeploymentStatusInNewTransaction(subject, resourceDeployment.getId(), BundleDeploymentStatus.FAILURE);
            }
        } else {
            this.bundleManager.setBundleResourceDeploymentStatusInNewTransaction(subject, resourceDeployment.getId(), BundleDeploymentStatus.FAILURE);
            BundleResourceDeploymentHistory history = new BundleResourceDeploymentHistory(subject.getName(), "Deployment", deployment.getName(), null, BundleResourceDeploymentHistory.Status.FAILURE, "Target resource is not of a type that can have bundles deployed to it [resource=" + bundleTarget.getName() + "; id=" + bundleTarget.getId() + "]. Fix target group for destination [" + deployment.getDestination().getName() + "]", null);
            this.bundleManager.addBundleResourceDeploymentHistoryInNewTrans(subject, resourceDeployment.getId(), history);
        }
        return resourceDeployment;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public BundleScheduleRequest getScheduleRequest(Subject subject, int resourceDeploymentId, boolean isCleanDeployment, boolean isRevert) throws Exception {
        BundleResourceDeploymentCriteria brdc = new BundleResourceDeploymentCriteria();
        brdc.addFilterId(Integer.valueOf(resourceDeploymentId));
        brdc.fetchResource(true);
        brdc.fetchBundleDeployment(true);
        PageList<BundleResourceDeployment> resourceDeployments = this.bundleManager.findBundleResourceDeploymentsByCriteria(subject, brdc);
        if (null == resourceDeployments || resourceDeployments.isEmpty()) {
            throw new IllegalArgumentException("Can not deploy using invalid resourceDeploymentId [" + resourceDeploymentId + "].");
        }
        BundleResourceDeployment resourceDeployment = (BundleResourceDeployment)resourceDeployments.get(0);
        ResourceCriteria rc = new ResourceCriteria();
        rc.addFilterId(Integer.valueOf(resourceDeployment.getResource().getId()));
        rc.fetchTags(true);
        Resource resource = (Resource)this.resourceManager.findResourcesByCriteria(subject, rc).get(0);
        resourceDeployment.setResource(resource);
        BundleDeploymentCriteria bdc = new BundleDeploymentCriteria();
        bdc.addFilterId(Integer.valueOf(resourceDeployment.getBundleDeployment().getId()));
        bdc.fetchBundleVersion(true);
        bdc.fetchConfiguration(true);
        bdc.fetchDestination(true);
        BundleDeployment deployment = (BundleDeployment)this.bundleManager.findBundleDeploymentsByCriteria(subject, bdc).get(0);
        BundleCriteria bc = new BundleCriteria();
        bc.addFilterDestinationId(Integer.valueOf(deployment.getDestination().getId()));
        Bundle bundle = (Bundle)this.bundleManager.findBundlesByCriteria(subject, bc).get(0);
        ResourceTypeCriteria rtc = new ResourceTypeCriteria();
        rtc.addFilterIgnored(false);
        rtc.addFilterBundleTypeId(Integer.valueOf(bundle.getBundleType().getId()));
        ResourceType resourceType = (ResourceType)this.resourceTypeManager.findResourceTypesByCriteria(subject, rtc).get(0);
        bundle.getBundleType().setResourceType(resourceType);
        deployment.getBundleVersion().setBundle(bundle);
        deployment.getDestination().setBundle(bundle);
        resourceDeployment.setBundleDeployment(deployment);
        HibernateDetachUtility.nullOutUninitializedFields((Object)resourceDeployment, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
        BundleScheduleRequest request = new BundleScheduleRequest(resourceDeployment);
        request.setCleanDeployment(isCleanDeployment);
        request.setRevert(isRevert);
        this.entityManager.clear();
        return request;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public BundleResourceDeployment createBundleResourceDeploymentInNewTrans(Subject subject, int bundleDeploymentId, int resourceId) throws Exception {
        BundleDeployment deployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeploymentId);
        if (null == deployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + bundleDeploymentId);
        }
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (null == resource) {
            throw new IllegalArgumentException("Invalid resourceId (Resource does not exist): " + resourceId);
        }
        BundleResourceDeployment resourceDeployment = new BundleResourceDeployment(deployment, resource);
        this.entityManager.persist((Object)resourceDeployment);
        return resourceDeployment;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public BundleResourceDeployment setBundleResourceDeploymentStatusInNewTransaction(Subject subject, int resourceDeploymentId, BundleDeploymentStatus status) throws Exception {
        BundleResourceDeployment resourceDeployment = (BundleResourceDeployment)this.entityManager.find(BundleResourceDeployment.class, (Object)resourceDeploymentId);
        if (null == resourceDeployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + resourceDeploymentId);
        }
        resourceDeployment.setStatus(status);
        return resourceDeployment;
    }

    @Override
    public BundleDeploymentStatus determineBundleDeploymentStatus(int bundleDeploymentId) {
        BundleDeployment deployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeploymentId);
        if (deployment.getStatus().isTerminal()) {
            return deployment.getStatus();
        }
        List deployments = deployment.getResourceDeployments();
        boolean someInProgress = false;
        boolean someSuccess = false;
        boolean someFailure = false;
        for (BundleResourceDeployment rd : deployments) {
            switch (rd.getStatus()) {
                case SUCCESS: {
                    someSuccess = true;
                    break;
                }
                case FAILURE: {
                    someFailure = true;
                    break;
                }
                case IN_PROGRESS: {
                    someInProgress = true;
                }
            }
        }
        if (someInProgress) {
            deployment.setStatus(BundleDeploymentStatus.IN_PROGRESS);
        } else if (someSuccess) {
            deployment.setStatus(someFailure ? BundleDeploymentStatus.MIXED : BundleDeploymentStatus.SUCCESS);
        } else {
            deployment.setStatus(BundleDeploymentStatus.FAILURE);
        }
        return deployment.getStatus();
    }

    @Override
    public Set<String> getBundleVersionFilenames(Subject subject, int bundleVersionId, boolean withoutBundleFileOnly) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        this.checkCreateBundleVersionAuthz(subject, bundleVersion.getBundle().getId());
        BundleType bundleType = bundleVersion.getBundle().getBundleType();
        RecipeParseResults parseResults = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager().parseRecipe(bundleType.getName(), bundleVersion.getRecipe());
        Set<String> result = parseResults.getBundleFileNames();
        if (withoutBundleFileOnly) {
            List bundleFiles = bundleVersion.getBundleFiles();
            Set<String> allFilenames = result;
            result = new HashSet<String>(allFilenames.size() - bundleFiles.size());
            for (String filename : allFilenames) {
                boolean found = false;
                for (BundleFile bundleFile : bundleFiles) {
                    String name = bundleFile.getPackageVersion().getGeneralPackage().getName();
                    if (!name.equals(filename)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                result.add(filename);
            }
        }
        return result;
    }

    @Override
    public HashMap<String, Boolean> getAllBundleVersionFilenames(Subject subject, int bundleVersionId) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        this.checkCreateBundleVersionAuthz(subject, bundleVersion.getBundle().getId());
        BundleType bundleType = bundleVersion.getBundle().getBundleType();
        RecipeParseResults parseResults = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager().parseRecipe(bundleType.getName(), bundleVersion.getRecipe());
        Set<String> filenames = parseResults.getBundleFileNames();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(filenames.size());
        List bundleFiles = bundleVersion.getBundleFiles();
        for (String filename : filenames) {
            boolean found = false;
            for (BundleFile bundleFile : bundleFiles) {
                String name = bundleFile.getPackageVersion().getGeneralPackage().getName();
                if (!name.equals(filename)) continue;
                found = true;
                break;
            }
            result.put(filename, found);
        }
        return result;
    }

    @Override
    public List<BundleType> getAllBundleTypes(Subject subject) {
        Query q = this.entityManager.createNamedQuery("BundleType.findAll");
        List types = q.getResultList();
        return types;
    }

    @Override
    public BundleType getBundleType(Subject subject, String bundleTypeName) {
        Query q = this.entityManager.createNamedQuery("BundleType.findByName");
        q.setParameter("name", (Object)bundleTypeName);
        BundleType type = (BundleType)q.getSingleResult();
        return type;
    }

    @Override
    public PageList<BundleDeployment> findBundleDeploymentsByCriteria(Subject subject, BundleDeploymentCriteria criteria) {
        CriteriaQueryRunner queryRunner;
        PageList result;
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.hasGlobalPermission(subject, Permission.VIEW_BUNDLES)) {
            generator.setAuthorizationBundleFragment(CriteriaQueryGenerator.AuthorizationTokenType.BUNDLE, subject.getId(), "bundleVersion.bundle");
        }
        if (!(result = (queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager)).execute()).isEmpty() && !this.authorizationManager.isInventoryManager(subject)) {
            Iterator i = result.iterator();
            while (i.hasNext()) {
                BundleDeployment bd = (BundleDeployment)i.next();
                int groupId = bd.getDestination().getGroup().getId();
                if (this.authorizationManager.canViewGroup(subject, groupId)) continue;
                i.remove();
            }
        }
        return result;
    }

    @Override
    public PageList<BundleDestination> findBundleDestinationsByCriteria(Subject subject, BundleDestinationCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.GROUP, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleResourceDeployment> findBundleResourceDeploymentsByCriteria(Subject subject, BundleResourceDeploymentCriteria criteria) {
        CriteriaQueryRunner queryRunner;
        PageList result;
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.hasGlobalPermission(subject, Permission.VIEW_BUNDLES)) {
            generator.setAuthorizationBundleFragment(CriteriaQueryGenerator.AuthorizationTokenType.BUNDLE, subject.getId(), "bundleDeployment.bundleVersion.bundle");
        }
        if (!(result = (queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager)).execute()).isEmpty() && criteria.isInventoryManagerRequired() && !this.authorizationManager.isInventoryManager(subject)) {
            ArrayList<Integer> resourceIds = new ArrayList<Integer>(result.size());
            for (BundleResourceDeployment brd : result) {
                int resourceId = brd.getResource().getId();
                resourceIds.add(resourceId);
            }
            if (!this.authorizationManager.canViewResources(subject, resourceIds)) {
                for (Integer resourceId : resourceIds) {
                    if (this.authorizationManager.canViewResource(subject, resourceId)) continue;
                    Iterator i = result.iterator();
                    while (i.hasNext()) {
                        BundleResourceDeployment brd = (BundleResourceDeployment)i.next();
                        if (brd.getResource().getId() != resourceId.intValue()) continue;
                        i.remove();
                    }
                }
            }
        }
        return result;
    }

    @Override
    public PageList<BundleVersion> findBundleVersionsByCriteria(Subject subject, BundleVersionCriteria criteria) {
        CriteriaQueryRunner queryRunner;
        PageList result;
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.hasGlobalPermission(subject, Permission.VIEW_BUNDLES)) {
            generator.setAuthorizationBundleFragment(CriteriaQueryGenerator.AuthorizationTokenType.BUNDLE, subject.getId());
        }
        if (!(result = (queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager)).execute()).isEmpty() && criteria.isInventoryManagerRequired() && !this.authorizationManager.isInventoryManager(subject)) {
            for (BundleVersion bundleVersion : result) {
                int numDeployments = bundleVersion.getBundleDeployments().size();
                if (0 == numDeployments) continue;
                Bundle bundle = bundleVersion.getBundle();
                BundleDestinationCriteria destinationCriteria = new BundleDestinationCriteria();
                destinationCriteria.clearPaging();
                destinationCriteria.addFilterBundleId(Integer.valueOf(bundle.getId()));
                PageList<BundleDestination> destinations = this.findBundleDestinationsByCriteria(subject, destinationCriteria);
                ArrayList<BundleDeployment> filteredDeployments = new ArrayList<BundleDeployment>(numDeployments);
                this.entityManager.detach((Object)bundleVersion);
                for (BundleDeployment deployment : bundleVersion.getBundleDeployments()) {
                    if (!this.containsDestination((List<BundleDestination>)destinations, deployment.getDestination())) continue;
                    filteredDeployments.add(deployment);
                }
                bundleVersion.setBundleDeployments(filteredDeployments);
            }
        }
        return result;
    }

    private boolean containsDestination(List<BundleDestination> list, BundleDestination dest) {
        int id = dest.getId();
        for (BundleDestination destination : list) {
            if (destination.getId() != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public PageList<BundleFile> findBundleFilesByCriteria(Subject subject, BundleFileCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.hasGlobalPermission(subject, Permission.VIEW_BUNDLES)) {
            generator.setAuthorizationBundleFragment(CriteriaQueryGenerator.AuthorizationTokenType.BUNDLE, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<Bundle> findBundlesByCriteria(Subject subject, BundleCriteria criteria) {
        CriteriaQueryRunner queryRunner;
        PageList result;
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.hasGlobalPermission(subject, Permission.VIEW_BUNDLES)) {
            generator.setAuthorizationBundleFragment(CriteriaQueryGenerator.AuthorizationTokenType.BUNDLE, subject.getId(), null);
        }
        if (!(result = (queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager)).execute()).isEmpty() && criteria.isInventoryManagerRequired() && !this.authorizationManager.isInventoryManager(subject)) {
            for (Bundle bundle : result) {
                if (bundle.getDestinations().isEmpty()) continue;
                BundleDestinationCriteria destinationCriteria = new BundleDestinationCriteria();
                destinationCriteria.clearPaging();
                destinationCriteria.addFilterBundleId(Integer.valueOf(bundle.getId()));
                PageList<BundleDestination> destinations = this.findBundleDestinationsByCriteria(subject, destinationCriteria);
                this.entityManager.detach((Object)bundle);
                bundle.setDestinations(destinations);
            }
        }
        return result;
    }

    @Override
    public PageList<BundleWithLatestVersionComposite> findBundlesWithLatestVersionCompositesByCriteria(Subject subject, BundleCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        String replacementSelectList = " new org.rhq.core.domain.bundle.composite.BundleWithLatestVersionComposite(    bundle.id,   bundle.name,   bundle.description,   ( SELECT bv1.version FROM bundle.bundleVersions bv1 WHERE bv1.versionOrder = (SELECT MAX(bv2.versionOrder) FROM BundleVersion bv2 WHERE bv2.bundle.id = bundle.id) ) AS latestVersion,   ( SELECT COUNT(bv3) FROM bundle.bundleVersions bv3 WHERE bv3.bundle.id = bundle.id) AS deploymentCount ) ";
        generator.alterProjection(replacementSelectList);
        if (!this.authorizationManager.hasGlobalPermission(subject, Permission.VIEW_BUNDLES)) {
            generator.setAuthorizationBundleFragment(CriteriaQueryGenerator.AuthorizationTokenType.BUNDLE, subject.getId(), null);
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList results = queryRunner.execute();
        return results;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void deleteBundles(Subject subject, int[] bundleIds) throws Exception {
        if (bundleIds != null) {
            for (int bundleId : bundleIds) {
                this.bundleManager.deleteBundle(subject, bundleId);
            }
        }
    }

    @Override
    public void deleteBundle(Subject subject, int bundleId) throws Exception {
        Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
        if (null == bundle) {
            return;
        }
        this.checkDeleteBundleAuthz(subject, bundleId);
        Query q = this.entityManager.createNamedQuery("BundleVersion.findByBundleId");
        q.setParameter("bundleId", (Object)bundleId);
        List bvs = q.getResultList();
        for (BundleVersion bv : bvs) {
            this.bundleManager.deleteBundleVersion(subject, bv.getId(), false);
            this.entityManager.flush();
        }
        HashSet BundleGroupsToRemove = new HashSet(bundle.getBundleGroups());
        for (BundleGroup bg : BundleGroupsToRemove) {
            bg.removeBundle(bundle);
        }
        Repo bundleRepo = bundle.getRepo();
        this.entityManager.remove((Object)bundle);
        this.entityManager.flush();
        this.repoManager.deleteRepo(this.subjectManager.getOverlord(), bundleRepo.getId());
    }

    @Override
    public void deleteBundleDeployment(Subject subject, int bundleDeploymentId) throws Exception {
        BundleDeployment doomed = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeploymentId);
        if (null == doomed) {
            return;
        }
        this.checkDeployBundleAuthz(subject, doomed.getBundleVersion().getBundle().getId(), doomed.getDestination().getGroup().getId());
        if (BundleDeploymentStatus.PENDING != doomed.getStatus() && BundleDeploymentStatus.SUCCESS != doomed.getStatus() && BundleDeploymentStatus.FAILURE != doomed.getStatus() && BundleDeploymentStatus.MIXED != doomed.getStatus()) {
            throw new IllegalArgumentException("Can not delete deployment with status [" + doomed.getStatus() + "]");
        }
        Query q = this.entityManager.createNamedQuery("BundleDeployment.updateForDeploymentRemove");
        q.setParameter("bundleId", (Object)doomed.getId());
        q.executeUpdate();
        this.entityManager.flush();
        this.entityManager.remove((Object)doomed);
    }

    @Override
    public void deleteBundleDestination(Subject subject, int destinationId) throws Exception {
        BundleDestination doomed = (BundleDestination)this.entityManager.find(BundleDestination.class, (Object)destinationId);
        if (null == doomed) {
            return;
        }
        this.checkDeployBundleAuthz(subject, doomed.getBundle().getId(), doomed.getGroup().getId());
        Query q = this.entityManager.createNamedQuery("BundleDeployment.updateForDestinationRemove");
        q.setParameter("destinationId", (Object)destinationId);
        q.executeUpdate();
        this.entityManager.flush();
        this.entityManager.remove((Object)doomed);
    }

    @Override
    public void deleteBundleVersion(Subject subject, int bundleVersionId, boolean deleteBundleIfEmpty) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            return;
        }
        int bundleId = bundleVersion.getBundle().getId();
        this.checkDeleteBundleAuthz(subject, bundleId);
        int doomedBundleVersionOrder = bundleVersion.getVersionOrder();
        Query q = this.entityManager.createNamedQuery("BundleDeployment.updateForVersionRemove");
        q.setParameter("bundleVersionId", (Object)bundleVersionId);
        int rowsUpdated = q.executeUpdate();
        this.entityManager.flush();
        this.entityManager.remove((Object)bundleVersion);
        if (deleteBundleIfEmpty) {
            this.entityManager.flush();
            q = this.entityManager.createNamedQuery("BundleVersion.findVersionsByBundleId");
            q.setParameter("bundleId", (Object)bundleId);
            if (q.getResultList().size() == 0) {
                this.deleteBundle(subject, bundleId);
                doomedBundleVersionOrder = -1;
            }
        }
        if (doomedBundleVersionOrder >= 0) {
            q = this.entityManager.createNamedQuery("BundleVersion.updateVersionOrderByBundleIdAfterDelete");
            q.setParameter("bundleId", (Object)bundleId);
            q.setParameter("versionOrder", (Object)doomedBundleVersionOrder);
            q.executeUpdate();
        }
    }

    private void safeClose(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to close InputStream", (Throwable)e);
            }
        }
    }

    private void safeClose(OutputStream os) {
        if (null != os) {
            try {
                os.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to close OutputStream", (Throwable)e);
            }
        }
    }

    @Override
    public void assignBundlesToBundleGroups(Subject subject, int[] bundleGroupIds, int[] bundleIds) {
        if (null == bundleGroupIds || null == bundleIds) {
            return;
        }
        for (int bundleGroupId : bundleGroupIds) {
            BundleGroup bundleGroup = (BundleGroup)this.entityManager.find(BundleGroup.class, (Object)bundleGroupId);
            if (null == bundleGroup) {
                throw new IllegalArgumentException("BundleGroup does not exist for bundleGroupId [" + bundleGroupId + "]");
            }
            this.checkAssignBundleGroupAuthz(subject, bundleGroupId, bundleIds);
            for (int bundleId : bundleIds) {
                Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
                if (null == bundle) {
                    throw new IllegalArgumentException("Bundle does not exist for bundleId [" + bundleId + "]");
                }
                bundleGroup.addBundle(bundle);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE_GROUPS)
    public BundleGroup createBundleGroup(Subject subject, BundleGroup bundleGroup) throws Exception {
        String name = bundleGroup.getName();
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleGroupName: " + name);
        }
        BundleGroupCriteria c = new BundleGroupCriteria();
        c.addFilterName(name);
        c.setStrict(true);
        if (!this.bundleManager.findBundleGroupsByCriteria(subject, c).isEmpty()) {
            throw new IllegalArgumentException("Invalid bundleGroupName, bundle group already exists with name: " + name);
        }
        this.entityManager.persist((Object)bundleGroup);
        Set bundles = bundleGroup.getBundles();
        if (null != bundles) {
            int[] bundleIds = new int[bundles.size()];
            int i = 0;
            for (Bundle b : bundles) {
                bundleIds[i++] = b.getId();
            }
            this.assignBundlesToBundleGroups(subject, new int[]{bundleGroup.getId()}, bundleIds);
        }
        return bundleGroup;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE_GROUPS)
    public void deleteBundleGroups(Subject subject, int[] bundleGroupIds) throws Exception {
        for (int bundleGroupId : bundleGroupIds) {
            BundleGroup bundleGroup = (BundleGroup)this.entityManager.find(BundleGroup.class, (Object)bundleGroupId);
            if (null == bundleGroup) {
                return;
            }
            HashSet bundlesToRemove = new HashSet(bundleGroup.getBundles());
            for (Bundle b : bundlesToRemove) {
                bundleGroup.removeBundle(b);
            }
            for (Role r : bundleGroup.getRoles()) {
                r.removeBundleGroup(bundleGroup);
            }
            bundleGroup = (BundleGroup)this.entityManager.merge((Object)bundleGroup);
            this.entityManager.remove((Object)bundleGroup);
        }
    }

    @Override
    public PageList<BundleGroup> findBundleGroupsByCriteria(Subject subject, BundleGroupCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_BUNDLE_GROUPS)) {
            generator.setAuthorizationBundleFragment(CriteriaQueryGenerator.AuthorizationTokenType.BUNDLE_GROUP, subject.getId(), null);
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public void unassignBundlesFromBundleGroups(Subject subject, int[] bundleGroupIds, int[] bundleIds) {
        if (null == bundleGroupIds || null == bundleIds) {
            return;
        }
        for (int bundleGroupId : bundleGroupIds) {
            BundleGroup bundleGroup = (BundleGroup)this.entityManager.find(BundleGroup.class, (Object)bundleGroupId);
            if (null == bundleGroup) {
                throw new IllegalArgumentException("BundleGroup does not exist for bundleGroupId [" + bundleGroupId + "]");
            }
            this.checkUnassignBundleGroupAuthz(subject, bundleGroupId, bundleIds);
            for (int bundleId : bundleIds) {
                Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
                if (null == bundle) {
                    throw new IllegalArgumentException("Bundle does not exist for bundleId [" + bundleId + "]");
                }
                bundleGroup.removeBundle(bundle);
            }
        }
    }

    private void checkCreateInitialBundleVersionAuthz(Subject subject, int[] bundleGroupIds) throws PermissionException {
        Set<Permission> globalPerms = this.authorizationManager.getExplicitGlobalPermissions(subject);
        boolean hasGlobalCreateBundles = globalPerms.contains(Permission.CREATE_BUNDLES);
        if (hasGlobalCreateBundles && globalPerms.contains(Permission.VIEW_BUNDLES)) {
            return;
        }
        if (null == bundleGroupIds || bundleGroupIds.length == 0) {
            String msg = "Subject [" + subject.getName() + "] requires Global CREATE_BUNDLES and VIEW_BUNDLES to create unassigned initial bundle version.";
            throw new PermissionException(msg, (Throwable)new BundleNotFoundException());
        }
        for (int bundleGroupId : bundleGroupIds) {
            boolean authzPassed = hasGlobalCreateBundles ? this.authorizationManager.canViewBundleGroup(subject, bundleGroupId) : this.authorizationManager.hasBundleGroupPermission(subject, Permission.CREATE_BUNDLES_IN_GROUP, bundleGroupId);
            if (authzPassed) continue;
            String msg = "Subject [" + subject.getName() + "] requires either Global.CREATE_BUNDLES + BundleGroup.VIEW_BUNDLES_IN_GROUP, or BundleGroup.CREATE_BUNDLES_IN_GROUP, to create or update a bundle in bundle group [" + bundleGroupIds + "].";
            throw new PermissionException(msg);
        }
    }

    private void checkCreateBundleVersionAuthz(Subject subject, int bundleId) throws PermissionException {
        if (bundleId <= 0) {
            throw new IllegalArgumentException("Must supply valid bundleId for bundle version being created. BundleId specified [" + bundleId + "]");
        }
        Set<Permission> globalPerms = this.authorizationManager.getExplicitGlobalPermissions(subject);
        boolean hasGlobalCreateBundles = globalPerms.contains(Permission.CREATE_BUNDLES);
        if (hasGlobalCreateBundles && globalPerms.contains(Permission.VIEW_BUNDLES)) {
            return;
        }
        if (hasGlobalCreateBundles ? this.authorizationManager.canViewBundle(subject, bundleId) : this.authorizationManager.hasBundlePermission(subject, Permission.CREATE_BUNDLES_IN_GROUP, bundleId)) {
            return;
        }
        String msg = "Subject [" + subject.getName() + "] requires either Global.CREATE_BUNDLES + BundleGroup.VIEW_BUNDLES_IN_GROUP, or BundleGroup.CREATE_BUNDLES_IN_GROUP, to create or update a bundleVersion for bundle [" + bundleId + "].";
        throw new PermissionException(msg);
    }

    private void checkAssignBundleGroupAuthz(Subject subject, int bundleGroupId, int[] bundleIds) throws PermissionException {
        boolean canAssign;
        Set<Permission> globalPerms = this.authorizationManager.getExplicitGlobalPermissions(subject);
        boolean hasGlobalManageBundleGroups = globalPerms.contains(Permission.MANAGE_BUNDLE_GROUPS);
        boolean hasGlobalCreateBundles = globalPerms.contains(Permission.CREATE_BUNDLES);
        boolean hasGlobalViewBundles = globalPerms.contains(Permission.VIEW_BUNDLES);
        if ((hasGlobalManageBundleGroups || hasGlobalCreateBundles) && hasGlobalViewBundles) {
            return;
        }
        boolean bl = canAssign = hasGlobalManageBundleGroups || hasGlobalCreateBundles || this.authorizationManager.hasBundleGroupPermission(subject, Permission.CREATE_BUNDLES_IN_GROUP, bundleGroupId) || this.authorizationManager.hasBundleGroupPermission(subject, Permission.ASSIGN_BUNDLES_TO_GROUP, bundleGroupId);
        if (!canAssign) {
            String msg = "Subject [" + subject.getName() + "] requires one of Global.MANAGE_BUNDLE_GROUPS, Global.CREATE_BUNDLES, BundleGroup.CREATE_BUNDLES_IN_GROUP, or BundleGroup.ASSIGN_BUNDLES_TO_GROUP to assign a bundle to bundle group  [" + bundleGroupId + "].";
            throw new PermissionException(msg);
        }
        for (int bundleId : bundleIds) {
            if (bundleId <= 0) {
                throw new IllegalArgumentException("Invalid bundleId: [" + bundleId + "]");
            }
            if (this.authorizationManager.canViewBundle(subject, bundleId)) continue;
            String msg = "Subject [" + subject.getName() + "] requires either Global.VIEW_BUNDLES or BundleGroup.VIEW_BUNDLES_IN_GROUP to assign bundle [" + bundleId + "] to bundle group [" + bundleGroupId + "]";
            throw new PermissionException(msg);
        }
    }

    private void checkUnassignBundleGroupAuthz(Subject subject, int bundleGroupId, int[] bundleIds) throws PermissionException {
        boolean canUnassign;
        Set<Permission> globalPerms = this.authorizationManager.getExplicitGlobalPermissions(subject);
        boolean hasGlobalManageBundleGroups = globalPerms.contains(Permission.MANAGE_BUNDLE_GROUPS);
        boolean hasGlobalDeleteBundles = globalPerms.contains(Permission.DELETE_BUNDLES);
        boolean hasGlobalViewBundles = globalPerms.contains(Permission.VIEW_BUNDLES);
        if ((hasGlobalManageBundleGroups || hasGlobalDeleteBundles) && hasGlobalViewBundles) {
            return;
        }
        boolean bl = canUnassign = hasGlobalManageBundleGroups || hasGlobalDeleteBundles || this.authorizationManager.hasBundleGroupPermission(subject, Permission.DELETE_BUNDLES_FROM_GROUP, bundleGroupId) || this.authorizationManager.hasBundleGroupPermission(subject, Permission.UNASSIGN_BUNDLES_FROM_GROUP, bundleGroupId);
        if (!canUnassign) {
            String msg = "Subject [" + subject.getName() + "] requires one of Global.MANAGE_BUNDLE_GROUPS, Global.DELETE_BUNDLES, BundleGroup.DELETE_BUNDLES_FROM_GROUP, or BundleGroup.UNASSIGN_BUNDLES_FROM_GROUP to unassign a bundle from bundle group  [" + bundleGroupId + "].";
            throw new PermissionException(msg);
        }
        for (int bundleId : bundleIds) {
            if (bundleId <= 0) {
                throw new IllegalArgumentException("Invalid bundleId: [" + bundleId + "]");
            }
            if (this.authorizationManager.canViewBundle(subject, bundleId)) continue;
            String msg = "Subject [" + subject.getName() + "] requires either Global.VIEW_BUNDLES or BundleGroup.VIEW_BUNDLES_IN_GROUP to unassign bundle [" + bundleId + "] from bundle group [" + bundleGroupId + "]";
            throw new PermissionException(msg);
        }
    }

    private void checkDeployBundleAuthz(Subject subject, int bundleId, int resourceGroupId) throws PermissionException {
        boolean hasBundleView;
        boolean hasResourceGroupView = this.authorizationManager.canViewGroup(subject, resourceGroupId);
        if (!hasResourceGroupView) {
            String msg = "Subject [" + subject.getName() + "] requires VIEW permission on resource group  [" + resourceGroupId + "].";
            throw new PermissionException(msg);
        }
        Set<Permission> globalPerms = this.authorizationManager.getExplicitGlobalPermissions(subject);
        boolean hasGlobalDeployBundles = globalPerms.contains(Permission.DEPLOY_BUNDLES);
        boolean hasGlobalViewBundles = globalPerms.contains(Permission.VIEW_BUNDLES);
        if (hasGlobalDeployBundles && hasGlobalViewBundles) {
            return;
        }
        boolean hasResourceGroupDeploy = hasGlobalDeployBundles || this.authorizationManager.hasGroupPermission(subject, Permission.DEPLOY_BUNDLES_TO_GROUP, resourceGroupId);
        boolean bl = hasBundleView = hasGlobalViewBundles || this.authorizationManager.canViewBundle(subject, bundleId);
        if (!hasResourceGroupDeploy || !hasBundleView) {
            String msg = "Subject [" + subject.getName() + "] requires DEPLOY permission (global or on for resource group [" + resourceGroupId + "] and VIEW permission for bundle [" + bundleId + "]";
            throw new PermissionException(msg);
        }
    }

    private void checkDeleteBundleAuthz(Subject subject, int bundleId) throws PermissionException {
        if (bundleId <= 0) {
            throw new IllegalArgumentException("Must supply valid bundleId for bundle version being deleted. BundleId specified [" + bundleId + "]");
        }
        Set<Permission> globalPerms = this.authorizationManager.getExplicitGlobalPermissions(subject);
        boolean hasGlobalDeleteBundles = globalPerms.contains(Permission.DELETE_BUNDLES);
        if (hasGlobalDeleteBundles && globalPerms.contains(Permission.VIEW_BUNDLES)) {
            return;
        }
        if (hasGlobalDeleteBundles ? this.authorizationManager.canViewBundle(subject, bundleId) : this.authorizationManager.hasBundlePermission(subject, Permission.DELETE_BUNDLES_FROM_GROUP, bundleId)) {
            return;
        }
        String msg = "Subject [" + subject.getName() + "] requires either Global.DELETE_BUNDLES + BundleGroup.VIEW_BUNDLES_IN_GROUP, or BundleGroup.DELETE_BUNDLES_FROM_GROUP, to delete bundle [" + bundleId + "].";
        throw new PermissionException(msg);
    }

    @Override
    public BundleGroup updateBundleGroup(Subject subject, BundleGroup bundleGroup) throws Exception {
        BundleGroup attachedBundleGroup = (BundleGroup)this.entityManager.find(BundleGroup.class, (Object)bundleGroup.getId());
        if (attachedBundleGroup == null) {
            throw new IllegalArgumentException("Cannot update " + bundleGroup + ", because no bundle group exists with id [" + bundleGroup.getId() + "].");
        }
        attachedBundleGroup.setName(bundleGroup.getName());
        attachedBundleGroup.setDescription(bundleGroup.getDescription());
        Set newBundles = bundleGroup.getBundles();
        if (newBundles != null) {
            Set currentBundles = attachedBundleGroup.getBundles();
            HashSet BundlesToRemove = new HashSet(currentBundles);
            for (Bundle bg : newBundles) {
                BundlesToRemove.remove(bg);
            }
            for (Bundle bg : BundlesToRemove) {
                attachedBundleGroup.removeBundle(bg);
            }
            for (Bundle bg : newBundles) {
                Bundle attachedBundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bg.getId());
                attachedBundleGroup.addBundle(attachedBundle);
            }
        }
        attachedBundleGroup.getBundles().size();
        return attachedBundleGroup;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createInitialBundleVersionViaToken(Subject subject, int[] bundleGroupIds, String token) throws Exception {
        File distributionFile = new File(System.getProperty("java.io.tmpdir"), token);
        if (!distributionFile.isFile()) {
            throw new IllegalArgumentException("Token did not result in valid file [" + distributionFile.getAbsolutePath() + "]");
        }
        return this.createInitialBundleVersionViaFile(subject, bundleGroupIds, distributionFile);
    }

    @Override
    public BundleGroupAssignmentComposite getAssignableBundleGroups(Subject subject, Subject assigningSubject, int bundleId) throws Exception {
        Object bundleGroups;
        Bundle bundle = null;
        if (0 != bundleId && null == (bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId))) {
            throw new BundleNotFoundException("Bundle ID [" + bundleId + "]");
        }
        BundleGroupAssignmentComposite result = new BundleGroupAssignmentComposite(assigningSubject, bundle);
        Set<Permission> globalPermissions = this.authorizationManager.getExplicitGlobalPermissions(assigningSubject);
        boolean hasManageBundleGroups = globalPermissions.contains(Permission.MANAGE_BUNDLE_GROUPS);
        if (hasManageBundleGroups) {
            BundleGroupCriteria criteria = new BundleGroupCriteria();
            PageList<BundleGroup> bundleGroups2 = this.findBundleGroupsByCriteria(this.subjectManager.getOverlord(), criteria);
            result.setCanBeUnassigned(true);
            result.setBundleGroupMap(this.populateBundleGroupMap((List<BundleGroup>)bundleGroups2, bundle));
            return result;
        }
        boolean hasViewBundles = globalPermissions.contains(Permission.VIEW_BUNDLES);
        boolean hasCreateBundles = globalPermissions.contains(Permission.CREATE_BUNDLES);
        boolean isNewBundle = null == bundle;
        ArrayList<Permission> permFilter = new ArrayList<Permission>(1);
        if (isNewBundle) {
            result.setCanBeUnassigned(hasCreateBundles && hasViewBundles);
            permFilter.add(Permission.CREATE_BUNDLES_IN_GROUP);
        } else {
            if (!hasViewBundles && !this.authorizationManager.canViewBundle(assigningSubject, bundleId)) {
                throw new PermissionException("Bundle ID [" + bundleId + "] is not viewable by subject [" + assigningSubject.getName() + "]");
            }
            permFilter.add(Permission.CREATE_BUNDLES_IN_GROUP);
            permFilter.add(Permission.ASSIGN_BUNDLES_TO_GROUP);
        }
        if (hasCreateBundles) {
            BundleGroupCriteria criteria = new BundleGroupCriteria();
            bundleGroups = this.findBundleGroupsByCriteria(assigningSubject, criteria);
        } else {
            RoleCriteria criteria = new RoleCriteria();
            criteria.addFilterSubjectId(Integer.valueOf(assigningSubject.getId()));
            criteria.addFilterPermissions(permFilter);
            criteria.fetchBundleGroups(true);
            PageList<Role> roles = LookupUtil.getRoleManager().findRolesByCriteria(this.subjectManager.getOverlord(), criteria);
            bundleGroups = new ArrayList();
            for (Role role : roles) {
                for (BundleGroup bundleGroup : role.getBundleGroups()) {
                    if (bundleGroups.contains(bundleGroup)) continue;
                    bundleGroups.add(bundleGroup);
                }
            }
        }
        result.setBundleGroupMap(this.populateBundleGroupMap((List<BundleGroup>)bundleGroups, bundle));
        return result;
    }

    private Map<BundleGroup, Boolean> populateBundleGroupMap(List<BundleGroup> bundleGroups, Bundle bundle) {
        HashMap<BundleGroup, Boolean> result = new HashMap<BundleGroup, Boolean>(bundleGroups.size());
        for (BundleGroup bundleGroup : bundleGroups) {
            Boolean assigned = null != bundle && bundle.getBundleGroups().contains(bundleGroup) ? Boolean.TRUE : Boolean.FALSE;
            result.put(bundleGroup, assigned);
        }
        return result;
    }
}

