/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.comm;

import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.ServiceContainerConfiguration;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderConfiguration;
import org.rhq.enterprise.server.core.comm.ServerConfigurationConstants;
import org.rhq.enterprise.server.core.comm.ServerI18NFactory;

public class ServerConfiguration {
    private static final Logger LOG = ServerI18NFactory.getLogger(ServerConfiguration.class);
    private final Preferences m_preferences;

    public ServerConfiguration(Preferences prefs) {
        if (prefs == null) {
            throw new IllegalArgumentException("prefs=null");
        }
        this.m_preferences = prefs;
    }

    public Preferences getPreferences() {
        return this.m_preferences;
    }

    public ServiceContainerConfiguration getServiceContainerPreferences() {
        return new ServiceContainerConfiguration(this.m_preferences);
    }

    public int getServerConfigurationVersion() {
        int value = this.m_preferences.getInt("rhq.server.configuration-schema-version", 0);
        return value;
    }

    public void tagWithServerConfigurationVersion() {
        this.m_preferences.putInt("rhq.server.configuration-schema-version", 1);
    }

    public File getDataDirectory() {
        return this.getServiceContainerPreferences().getDataDirectory();
    }

    public String getDataDirectoryIfDefined() {
        return this.getServiceContainerPreferences().getDataDirectoryIfDefined();
    }

    public String getAgentFilesDirectory() {
        String dir_str = this.m_preferences.get("rhq.server.agent-files-directory", null);
        return dir_str;
    }

    public int getClientSenderQueueSize() {
        int value = this.m_preferences.getInt("rhq.server.client.queue-size", 50000);
        return value;
    }

    public int getClientSenderMaxConcurrent() {
        int value = this.m_preferences.getInt("rhq.server.client.max-concurrent", 1);
        if (value < 1) {
            LOG.warn("ServerConfiguration.pref-must-be-greater-than-0", new Object[]{"rhq.server.client.max-concurrent", value, 1});
            value = 1;
        }
        return value;
    }

    public long getClientSenderCommandTimeout() {
        long value = this.m_preferences.getLong("rhq.server.client.command-timeout-msecs", -1L);
        return value;
    }

    public long getClientSenderRetryInterval() {
        long value = this.m_preferences.getLong("rhq.server.client.retry-interval-msecs", 15000L);
        return value;
    }

    public int getClientSenderMaxRetries() {
        int value = this.m_preferences.getInt("rhq.server.client.max_retries", 10);
        return value;
    }

    public String getClientSenderCommandSpoolFileName() {
        String str = this.m_preferences.get("rhq.server.client.command-spool-file.name", ServerConfigurationConstants.DEFAULT_CLIENT_SENDER_COMMAND_SPOOL_FILE_NAME);
        if (str != null && str.length() == 0) {
            str = null;
        }
        return str;
    }

    public long[] getClientSenderCommandSpoolFileParams() {
        String value = this.m_preferences.get("rhq.server.client.command-spool-file.params", "1000000:75");
        long[] ret_params = this.isClientSenderCommandSpoolFileParamsValueValid(value);
        return ret_params;
    }

    public long[] isClientSenderCommandSpoolFileParamsValueValid(String pref_value) {
        long[] ret_params;
        block5: {
            ret_params = null;
            try {
                String[] numbers = pref_value.split("\\s*:\\s*");
                if (numbers.length == 2) {
                    ret_params = new long[]{Long.parseLong(numbers[0]), Long.parseLong(numbers[1])};
                    if (ret_params[0] < 10000L) {
                        throw new NumberFormatException(LOG.getMsgString("ServerConfiguration.command-spool-invalid-max-size", new Object[0]));
                    }
                    if (ret_params[1] < 0L || ret_params[1] >= 100L) {
                        throw new NumberFormatException(LOG.getMsgString("ServerConfiguration.command-spool-invalid-purge-percentage", new Object[0]));
                    }
                    break block5;
                }
                throw new NumberFormatException(LOG.getMsgString("ServerConfiguration.command-spool-invalid-format", new Object[0]));
            }
            catch (Exception e) {
                ret_params = null;
                LOG.warn("ServerConfiguration.bad-command-spool-pref", new Object[]{"rhq.server.client.command-spool-file.params", pref_value, e});
            }
        }
        return ret_params;
    }

    public boolean isClientSenderCommandSpoolFileCompressed() {
        boolean flag = this.m_preferences.getBoolean("rhq.server.client.command-spool-file.compressed", false);
        return flag;
    }

    public long[] getClientSenderSendThrottling() {
        String value = this.m_preferences.get("rhq.server.client.send-throttling", null);
        long[] ret_throttling_params = this.isClientSenderSendThrottlingValueValid(value);
        return ret_throttling_params;
    }

    public long[] isClientSenderSendThrottlingValueValid(String pref_value) {
        long[] ret_throttling_params;
        block6: {
            ret_throttling_params = null;
            if (pref_value != null) {
                try {
                    String[] numbers = pref_value.split("\\s*:\\s*");
                    if (numbers.length == 2) {
                        ret_throttling_params = new long[]{Long.parseLong(numbers[0]), Long.parseLong(numbers[1])};
                        if (ret_throttling_params[0] <= 0L) {
                            throw new NumberFormatException(LOG.getMsgString("ServerConfiguration.send-throttle-invalid-max", new Object[0]));
                        }
                        if (ret_throttling_params[1] < 100L) {
                            throw new NumberFormatException(LOG.getMsgString("ServerConfiguration.send-throttle-invalid-quiet-period", new Object[]{100L}));
                        }
                        break block6;
                    }
                    throw new NumberFormatException(LOG.getMsgString("ServerConfiguration.send-throttle-invalid-format", new Object[0]));
                }
                catch (Exception e) {
                    ret_throttling_params = null;
                    LOG.warn("ServerConfiguration.bad-send-throttle-pref", new Object[]{"rhq.server.client.send-throttling", pref_value, e});
                }
            }
        }
        return ret_throttling_params;
    }

    public int[] getClientSenderQueueThrottling() {
        String value = this.m_preferences.get("rhq.server.client.queue-throttling", null);
        int[] ret_throttling_params = this.isClientSenderQueueThrottlingValueValid(value);
        return ret_throttling_params;
    }

    public int[] isClientSenderQueueThrottlingValueValid(String pref_value) {
        int[] ret_throttling_params;
        block6: {
            ret_throttling_params = null;
            if (pref_value != null) {
                try {
                    String[] numbers = pref_value.split("\\s*:\\s*");
                    if (numbers.length == 2) {
                        ret_throttling_params = new int[]{Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1])};
                        if ((long)ret_throttling_params[0] <= 0L) {
                            throw new NumberFormatException(LOG.getMsgString("ServerConfiguration.queue-throttle-invalid-max", new Object[0]));
                        }
                        if ((long)ret_throttling_params[1] < 100L) {
                            throw new NumberFormatException(LOG.getMsgString("ServerConfiguration.queue-throttle-invalid-burst-period", new Object[]{100L}));
                        }
                        break block6;
                    }
                    throw new NumberFormatException(LOG.getMsgString("ServerConfiguration.queue-throttle-invalid-format", new Object[0]));
                }
                catch (Exception e) {
                    ret_throttling_params = null;
                    LOG.warn("ServerConfiguration.bad-queue-throttle-pref", new Object[]{"rhq.server.client.queue-throttling", pref_value, e});
                }
            }
        }
        return ret_throttling_params;
    }

    public ClientCommandSenderConfiguration getClientCommandSenderConfiguration() {
        ClientCommandSenderConfiguration config = new ClientCommandSenderConfiguration();
        config.defaultTimeoutMillis = this.getClientSenderCommandTimeout();
        config.maxConcurrent = this.getClientSenderMaxConcurrent();
        config.queueSize = this.getClientSenderQueueSize();
        config.dataDirectory = this.getDataDirectory();
        config.serverPollingIntervalMillis = -1L;
        config.commandSpoolFileCompressData = this.isClientSenderCommandSpoolFileCompressed();
        config.retryInterval = this.getClientSenderRetryInterval();
        config.maxRetries = this.getClientSenderMaxRetries();
        config.commandSpoolFileName = this.getClientSenderCommandSpoolFileName();
        long[] cmd_spool_file_params = this.getClientSenderCommandSpoolFileParams();
        config.commandSpoolFileMaxSize = cmd_spool_file_params[0];
        config.commandSpoolFilePurgePercentage = (int)cmd_spool_file_params[1];
        int[] queue_throttling = this.getClientSenderQueueThrottling();
        if (queue_throttling != null) {
            config.enableQueueThrottling = true;
            config.queueThrottleMaxCommands = queue_throttling[0];
            config.queueThrottleBurstPeriodMillis = queue_throttling[1];
        } else {
            config.enableQueueThrottling = false;
        }
        long[] send_throttling = this.getClientSenderSendThrottling();
        if (send_throttling != null) {
            config.enableSendThrottling = true;
            config.sendThrottleMaxCommands = send_throttling[0];
            config.sendThrottleQuietPeriodDurationMillis = send_throttling[1];
        } else {
            config.enableSendThrottling = false;
        }
        config.securityServerAuthMode = this.isClientSenderSecurityServerAuthMode();
        config.securityKeystoreFile = this.getClientSenderSecurityKeystoreFile();
        config.securityKeystoreType = this.getClientSenderSecurityKeystoreType();
        config.securityKeystoreAlgorithm = this.getClientSenderSecurityKeystoreAlgorithm();
        config.securityKeystorePassword = this.getClientSenderSecurityKeystorePassword();
        config.securityKeystoreKeyPassword = this.getClientSenderSecurityKeystoreKeyPassword();
        config.securityKeystoreAlias = this.getClientSenderSecurityKeystoreAlias();
        config.securityTruststoreFile = this.getClientSenderSecurityTruststoreFile();
        config.securityTruststoreType = this.getClientSenderSecurityTruststoreType();
        config.securityTruststoreAlgorithm = this.getClientSenderSecurityTruststoreAlgorithm();
        config.securityTruststorePassword = this.getClientSenderSecurityTruststorePassword();
        config.securitySecureSocketProtocol = this.getClientSenderSecuritySocketProtocol();
        return config;
    }

    public String getClientSenderSecuritySocketProtocol() {
        String value = this.m_preferences.get("rhq.server.client.security.secure-socket-protocol", "TLS");
        return value;
    }

    public String getClientSenderSecurityKeystoreAlias() {
        String value = this.m_preferences.get("rhq.server.client.security.keystore.alias", "rhq");
        return value;
    }

    public String getClientSenderSecurityKeystoreFile() {
        String value = this.m_preferences.get("rhq.server.client.security.keystore.file", null);
        if (value == null) {
            value = new File(this.getDataDirectory(), "keystore.dat").getAbsolutePath();
        }
        return value;
    }

    public String getClientSenderSecurityKeystoreAlgorithm() {
        String value = this.m_preferences.get("rhq.server.client.security.keystore.algorithm", this.isIBM() ? "IbmX509" : "SunX509");
        return value;
    }

    public String getClientSenderSecurityKeystoreType() {
        String value = this.m_preferences.get("rhq.server.client.security.keystore.type", "JKS");
        return value;
    }

    public String getClientSenderSecurityKeystorePassword() {
        String value = this.m_preferences.get("rhq.server.client.security.keystore.password", "rhqpwd");
        return value;
    }

    public String getClientSenderSecurityKeystoreKeyPassword() {
        String value = this.m_preferences.get("rhq.server.client.security.keystore.key-password", null);
        if (value == null) {
            value = this.getClientSenderSecurityKeystorePassword();
        }
        return value;
    }

    public String getClientSenderSecurityTruststoreFile() {
        String value = this.m_preferences.get("rhq.server.client.security.truststore.file", null);
        if (value == null) {
            value = new File(this.getDataDirectory(), "truststore.dat").getAbsolutePath();
        }
        return value;
    }

    public String getClientSenderSecurityTruststoreAlgorithm() {
        String value = this.m_preferences.get("rhq.server.client.security.truststore.algorithm", this.isIBM() ? "IbmX509" : "SunX509");
        return value;
    }

    public String getClientSenderSecurityTruststoreType() {
        String value = this.m_preferences.get("rhq.server.client.security.truststore.type", "JKS");
        return value;
    }

    public String getClientSenderSecurityTruststorePassword() {
        String value = this.m_preferences.get("rhq.server.client.security.truststore.password", null);
        return value;
    }

    public boolean isClientSenderSecurityServerAuthMode() {
        boolean flag = this.m_preferences.getBoolean("rhq.server.client.security.server-auth-mode-enabled", false);
        return flag;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.m_preferences.absolutePath());
        buf.append('[');
        try {
            String[] keys = this.m_preferences.keys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                buf.append(key);
                buf.append('=');
                if (key.toLowerCase().contains("password")) {
                    buf.append("***");
                } else {
                    buf.append(this.m_preferences.get(key, LOG.getMsgString("ServerConfiguration.unknown", new Object[0])));
                }
                if (i + 1 >= keys.length) continue;
                buf.append(',');
            }
        }
        catch (BackingStoreException e) {
            buf.append(LOG.getMsgString("ServerConfiguration.cannot-get-preferences", new Object[]{e}));
        }
        buf.append(']');
        return buf.toString();
    }

    private boolean isIBM() {
        return System.getProperty("java.vendor", "").contains("IBM");
    }
}

