/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import com.google.common.base.Stopwatch;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.annotation.TransactionTimeout;
import org.jboss.remoting.CannotConnectException;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.MeasurementDataTraitCriteria;
import org.rhq.core.domain.criteria.MeasurementScheduleCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.domain.measurement.ui.MetricDisplaySummary;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceIdWithAgentComposite;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementAggregate;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementException;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementStorageException;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;
import org.rhq.enterprise.server.measurement.util.MeasurementDataManagerUtility;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.server.metrics.MetricsServer;
import org.rhq.server.metrics.RawDataInsertedCallback;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.RawNumericMetric;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:jboss/datasources/RHQDS")
public class MeasurementDataManagerBean
implements MeasurementDataManagerLocal,
MeasurementDataManagerRemote {
    private static final String TRAIT_INSERT_STATEMENT = "INSERT INTO RHQ_measurement_data_trait \n  SELECT ?, ?, ?  FROM RHQ_numbers n \n  WHERE n.i = 42 \n    AND NOT EXISTS \n      ( \n      SELECT 1 \n      FROM (SELECT dt2.value as v \n            FROM RHQ_measurement_data_trait dt2 \n      WHERE dt2.schedule_id = ? \n        AND dt2.time_stamp = \n          (SELECT max(dt3.time_stamp) FROM RHQ_measurement_data_trait dt3 WHERE dt3.schedule_id = ?))  lastValue \n      WHERE NOT ((? is null AND lastValue.v is not null) \n        OR (? is not null AND lastValue.v is null) \n              OR (? is not null AND lastValue.v is not null AND ? <> lastValue.v)) \n      )";
    private final Log log = LogFactory.getLog(MeasurementDataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private AlertConditionCacheManagerLocal alertConditionCacheManager;
    @EJB
    private AlertManagerLocal alertManager;
    @EJB
    private AgentManagerLocal agentClientManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private CallTimeDataManagerLocal callTimeDataManager;
    @EJB
    private MeasurementDataManagerLocal measurementDataManager;
    @EJB
    private MeasurementDefinitionManagerLocal measurementDefinitionManager;
    @EJB
    private StorageClientManager storageClientManager;
    @EJB
    private MeasurementScheduleManagerLocal measurementScheduleManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=21600L)
    public int purgeTraits(long oldest) {
        int n;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.rhqDs.getConnection();
            stmt = conn.prepareStatement("DELETE FROM rhq_measurement_data_trait WHERE EXISTS   (SELECT t2.schedule_id, t2.time_stamp    FROM rhq_measurement_data_trait t2,      (SELECT max(t4.time_stamp) as mx, t4.schedule_id as schedule_id       FROM rhq_measurement_data_trait t4       WHERE t4.time_stamp < ?       GROUP BY t4.schedule_id) t3    WHERE t2.schedule_id = t3.schedule_id    AND t2.time_stamp < t3.mx    AND rhq_measurement_data_trait.time_stamp = t2.time_stamp    AND rhq_measurement_data_trait.schedule_id = t2.schedule_id) ");
            stmt.setLong(1, oldest);
            long startTime = System.currentTimeMillis();
            int deleted = stmt.executeUpdate();
            MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
            MeasurementMonitor.getMBean().setPurgedMeasurementTraits(deleted);
            n = deleted;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Failed to purge traits older than [" + oldest + "]", e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)stmt, null);
        return n;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void mergeMeasurementReport(MeasurementReport report) {
        long start = System.currentTimeMillis();
        if (report.getNumericData() != null && !report.getNumericData().isEmpty()) {
            this.measurementDataManager.addNumericData(report.getNumericData());
        }
        if (report.getTraitData() != null && !report.getTraitData().isEmpty()) {
            this.measurementDataManager.addTraitData(report.getTraitData());
        }
        if (report.getCallTimeData() != null && !report.getCallTimeData().isEmpty()) {
            this.callTimeDataManager.addCallTimeData(report.getCallTimeData());
        }
        long time = System.currentTimeMillis() - start;
        MeasurementMonitor.getMBean().incrementMeasurementInsertTime(time);
        MeasurementMonitor.getMBean().incrementMeasurementsInserted(report.getDataCount());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Measurement storage for [" + report.getDataCount() + "] took " + time + "ms"));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void addNumericData(Set<MeasurementDataNumeric> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        MetricsServer metricsServer = this.storageClientManager.getMetricsServer();
        metricsServer.addNumericData(data, new RawDataInsertedCallback(){
            private ReentrantLock lock = new ReentrantLock();
            private Set<MeasurementData> insertedData = new TreeSet<MeasurementData>(new Comparator<MeasurementData>(){

                @Override
                public int compare(MeasurementData d1, MeasurementData d2) {
                    return d1.getTimestamp() < d2.getTimestamp() ? -1 : (d1.getTimestamp() == d2.getTimestamp() ? 0 : 1);
                }
            });

            public void onFinish() {
                MeasurementDataManagerBean.this.measurementDataManager.updateAlertConditionCache("mergeMeasurementReport", this.insertedData.toArray(new MeasurementData[this.insertedData.size()]));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(MeasurementDataNumeric measurementDataNumeric) {
                try {
                    this.lock.lock();
                    this.insertedData.add((MeasurementData)measurementDataNumeric);
                }
                finally {
                    this.lock.unlock();
                }
            }

            public void onFailure(Throwable throwable) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void addTraitData(Set<MeasurementDataTrait> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.rhqDs.getConnection();
            ps = conn.prepareStatement(TRAIT_INSERT_STATEMENT);
            for (MeasurementDataTrait aData : data) {
                ps.setLong(1, aData.getTimestamp());
                ps.setInt(2, aData.getScheduleId());
                ps.setString(3, aData.getValue());
                ps.setInt(4, aData.getScheduleId());
                ps.setInt(5, aData.getScheduleId());
                ps.setString(6, aData.getValue());
                ps.setString(7, aData.getValue());
                ps.setString(8, aData.getValue());
                ps.setString(9, aData.getValue());
                ps.addBatch();
            }
            int[] res = ps.executeBatch();
            if (res.length != data.size()) {
                throw new MeasurementStorageException("Failure to store measurement trait data.");
            }
            this.notifyAlertConditionCacheManager("mergeMeasurementReport", data.toArray(new MeasurementData[data.size()]));
        }
        catch (SQLException e) {
            this.log.warn((Object)("Failure saving measurement trait data:\n" + ThrowableUtil.getAllMessages((Throwable)e)));
            JDBCUtil.safeClose((Connection)conn, (Statement)ps, null);
        }
        catch (Exception e2) {
            this.log.error((Object)"Error persisting trait data", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    JDBCUtil.safeClose((Connection)conn, ps, null);
                    throw throwable;
                }
            }
            JDBCUtil.safeClose((Connection)conn, (Statement)ps, null);
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)ps, null);
    }

    @Override
    public Map<Integer, List<MetricDisplaySummary>> findNarrowedMetricDisplaySummariesForResourcesAndParent(Subject subject, int resourceTypeId, int parentId, List<Integer> resourceIds, long begin, long end) {
        HashMap<Integer, List<MetricDisplaySummary>> sumMap = new HashMap<Integer, List<MetricDisplaySummary>>();
        if (parentId <= 0 || resourceIds == null || resourceIds.isEmpty() || end < begin) {
            return sumMap;
        }
        Query q = this.entityManager.createNamedQuery("MeasurementSchedule.FIND_ENABLED_BY_ResourceIds_AND_RESOURCE_TYPE");
        q.setFlushMode(FlushModeType.COMMIT);
        q.setParameter("resourceTypeId", (Object)resourceTypeId);
        q.setParameter("resourceIds", resourceIds);
        List triples = q.getResultList();
        HashMap resDefSchedMap = new HashMap();
        ArrayList<Integer> scheduleIds = new ArrayList<Integer>(triples.size());
        for (Object[] triple : triples) {
            Map<Integer, Integer> defSchedMap;
            int sid = (Integer)triple[0];
            scheduleIds.add(sid);
            int res = (Integer)triple[1];
            int def = (Integer)triple[2];
            if (!resDefSchedMap.containsKey(res)) {
                defSchedMap = new HashMap();
                resDefSchedMap.put(res, defSchedMap);
            } else {
                defSchedMap = (Map)resDefSchedMap.get(res);
            }
            defSchedMap.put(def, sid);
        }
        Map<Integer, Integer> alerts = this.alertManager.getAlertCountForSchedules(begin, end, scheduleIds);
        List<MeasurementDefinition> definitions = this.measurementDefinitionManager.findMeasurementDefinitionsByResourceType(subject, resourceTypeId, DataType.MEASUREMENT, null);
        HashMap<Integer, MeasurementDefinition> defMap = new HashMap<Integer, MeasurementDefinition>(definitions.size());
        for (MeasurementDefinition def : definitions) {
            defMap.put(def.getId(), def);
        }
        Iterator<Object> i$ = resourceIds.iterator();
        while (i$.hasNext()) {
            int resourceId = (Integer)i$.next();
            ArrayList<MetricDisplaySummary> summaries = new ArrayList<MetricDisplaySummary>();
            if (resDefSchedMap.containsKey(resourceId)) {
                Map defSchedMap = (Map)resDefSchedMap.get(resourceId);
                Iterator i$2 = defSchedMap.keySet().iterator();
                while (i$2.hasNext()) {
                    int defId = (Integer)i$2.next();
                    if (defMap.get(defId) == null) continue;
                    int sid = (Integer)defSchedMap.get(defId);
                    MetricDisplaySummary mds = new MetricDisplaySummary();
                    mds.setAlertCount(alerts.get(sid).intValue());
                    mds.setBeginTimeFrame(Long.valueOf(begin));
                    mds.setEndTimeFrame(Long.valueOf(end));
                    mds.setDefinitionId(Integer.valueOf(defId));
                    mds.setMetricName(((MeasurementDefinition)defMap.get(defId)).getName());
                    mds.setLabel(((MeasurementDefinition)defMap.get(defId)).getDisplayName());
                    mds.setParentId(parentId);
                    mds.setChildTypeId(resourceTypeId);
                    summaries.add(mds);
                }
            }
            sumMap.put(resourceId, summaries);
        }
        return sumMap;
    }

    @Override
    public Map<Integer, List<MetricDisplaySummary>> findNarrowedMetricsDisplaySummariesForCompGroup(Subject subject, ResourceGroup group, long beginTime, long endTime) {
        group = (ResourceGroup)this.entityManager.merge((Object)group);
        Set resources = group.getExplicitResources();
        Map<Integer, List<MetricDisplaySummary>> resMap = this.findNarrowedMetricDisplaySummariesForCompatibleResources(subject, resources, beginTime, endTime);
        for (List<MetricDisplaySummary> summaries : resMap.values()) {
            for (MetricDisplaySummary sum : summaries) {
                sum.setGroupId(group.getId());
            }
        }
        return resMap;
    }

    @Override
    public Map<Integer, List<MetricDisplaySummary>> findNarrowedMetricsDisplaySummariesForAutoGroup(Subject subject, int parentId, int cType, long beginTime, long endTime) {
        List<org.rhq.core.domain.resource.Resource> resources = this.resourceGroupManager.findResourcesForAutoGroup(subject, parentId, cType);
        HashSet<org.rhq.core.domain.resource.Resource> resSet = new HashSet<org.rhq.core.domain.resource.Resource>(resources.size());
        Map<Integer, List<MetricDisplaySummary>> resMap = this.findNarrowedMetricDisplaySummariesForCompatibleResources(subject, resSet, beginTime, endTime);
        for (List<MetricDisplaySummary> summaries : resMap.values()) {
            for (MetricDisplaySummary sum : summaries) {
                sum.setChildTypeId(cType);
                sum.setParentId(parentId);
            }
        }
        return resMap;
    }

    @Override
    public Map<Integer, List<MetricDisplaySummary>> findNarrowedMetricDisplaySummariesForCompatibleResources(Subject subject, Collection<org.rhq.core.domain.resource.Resource> resources, long beginTime, long endTime) {
        HashMap<Integer, List<MetricDisplaySummary>> resMap = new HashMap<Integer, List<MetricDisplaySummary>>();
        if (resources == null || resources.isEmpty()) {
            return resMap;
        }
        Iterator<org.rhq.core.domain.resource.Resource> it = resources.iterator();
        ResourceType type = it.next().getResourceType();
        boolean found = false;
        while (it.hasNext()) {
            ResourceType tmp = it.next().getResourceType();
            if (tmp == type) continue;
            found = true;
            break;
        }
        if (found) {
            throw new IllegalArgumentException("Resources were of different type: " + resources);
        }
        Set defs = type.getMetricDefinitions();
        Query q = this.entityManager.createNamedQuery("MeasurementSchedule.FIND_ENABLED_BY_ResourcesS_AND_RESOURCE_TYPE");
        q.setFlushMode(FlushModeType.COMMIT);
        q.setParameter("resourceType", (Object)type);
        q.setParameter("resources", resources);
        q.setParameter("dataType", (Object)DataType.MEASUREMENT);
        List schedules = q.getResultList();
        HashMap resDefSchedMap = new HashMap();
        ArrayList<Integer> scheduleIds = new ArrayList<Integer>(schedules.size());
        for (Object[] sched : schedules) {
            Map<Integer, Integer> defSchedMap;
            int sid = (Integer)sched[0];
            scheduleIds.add(sid);
            int res = (Integer)sched[1];
            int def = (Integer)sched[2];
            if (!resDefSchedMap.containsKey(res)) {
                defSchedMap = new HashMap();
                resDefSchedMap.put(res, defSchedMap);
            } else {
                defSchedMap = (Map)resDefSchedMap.get(res);
            }
            defSchedMap.put(def, sid);
        }
        Map<Integer, Integer> alerts = this.alertManager.getAlertCountForSchedules(beginTime, endTime, scheduleIds);
        for (org.rhq.core.domain.resource.Resource res : resources) {
            ArrayList<MetricDisplaySummary> summaries = new ArrayList<MetricDisplaySummary>();
            for (MeasurementDefinition def : defs) {
                Map defSched;
                MetricDisplaySummary sum = new MetricDisplaySummary();
                sum.setDefinitionId(Integer.valueOf(def.getId()));
                sum.setMetricName(def.getName());
                sum.setLabel(def.getDisplayName());
                sum.setBeginTimeFrame(Long.valueOf(beginTime));
                sum.setEndTimeFrame(Long.valueOf(endTime));
                int resId = res.getId();
                if (!resDefSchedMap.containsKey(resId) || !(defSched = (Map)resDefSchedMap.get(resId)).containsKey(def.getId())) continue;
                int sid = (Integer)defSched.get(def.getId());
                sum.setScheduleId(Integer.valueOf(sid));
                sum.setAlertCount(alerts.get(sid).intValue());
                summaries.add(sum);
            }
            resMap.put(res.getId(), summaries);
        }
        return resMap;
    }

    private MeasurementDataTrait fillMeasurementDataTraitFromObjectArray(Object[] objs) {
        if (objs == null) {
            return null;
        }
        MeasurementDataTrait mdt = (MeasurementDataTrait)objs[0];
        String name = (String)objs[1];
        mdt.setName(name);
        return mdt;
    }

    @Override
    @Nullable
    public MeasurementDataTrait getCurrentTraitForSchedule(int scheduleId) {
        Query q = this.entityManager.createNamedQuery("MeasurementDataTrait.FIND_CURRENT_FOR_SCHEDULES");
        q.setParameter("scheduleIds", Collections.singletonList(scheduleId));
        try {
            Object[] res = (Object[])q.getSingleResult();
            MeasurementDataTrait trait = this.fillMeasurementDataTraitFromObjectArray(res);
            return trait;
        }
        catch (NoResultException nre) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No current trait data for schedule with id [" + scheduleId + "] found"));
            }
            return null;
        }
    }

    @Override
    @Nullable
    public MeasurementDataNumeric getCurrentNumericForSchedule(int scheduleId) {
        MetricsServer metricsServer = this.storageClientManager.getMetricsServer();
        RawNumericMetric metric = metricsServer.findLatestValueForResource(scheduleId);
        if (null != metric) {
            return new MeasurementDataNumeric(metric.getTimestamp(), scheduleId, metric.getValue());
        }
        return new MeasurementDataNumeric(System.currentTimeMillis(), scheduleId, Double.valueOf(Double.NaN));
    }

    @Override
    @Asynchronous
    public void updateAlertConditionCache(String callingMethod, MeasurementData[] data) {
        AlertConditionCacheStats stats = this.alertConditionCacheManager.checkConditions(data);
        this.log.debug((Object)(callingMethod + ": " + stats.toString()));
    }

    private void notifyAlertConditionCacheManager(String callingMethod, MeasurementData[] data) {
        AlertConditionCacheStats stats = this.alertConditionCacheManager.checkConditions(data);
        this.log.debug((Object)(callingMethod + ": " + stats.toString()));
    }

    @Override
    @Deprecated
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public MeasurementAggregate getAggregate(Subject subject, int scheduleId, long startTime, long endTime) {
        MeasurementScheduleCriteria criteria = new MeasurementScheduleCriteria();
        criteria.addFilterId(Integer.valueOf(scheduleId));
        criteria.fetchResource(true);
        PageList<MeasurementSchedule> schedules = this.measurementScheduleManager.findSchedulesByCriteria(this.subjectManager.getOverlord(), criteria);
        if (schedules.isEmpty()) {
            throw new MeasurementException("Could not fine MeasurementSchedule with the id[" + scheduleId + "]");
        }
        MeasurementSchedule schedule = (MeasurementSchedule)schedules.get(0);
        if (!this.authorizationManager.canViewResource(subject, schedule.getResource().getId())) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view schedule[id=" + scheduleId + "]");
        }
        if (schedule.getDefinition().getDataType() != DataType.MEASUREMENT) {
            throw new IllegalArgumentException(schedule + " is not about numerical values. Can't compute aggregates");
        }
        if (startTime > endTime) {
            throw new IllegalArgumentException("Start date " + startTime + " is not before " + endTime);
        }
        MetricsServer metricsServer = this.storageClientManager.getMetricsServer();
        AggregateNumericMetric summary = metricsServer.getSummaryAggregate(scheduleId, startTime, endTime);
        return new MeasurementAggregate(summary.getMin(), summary.getAvg(), summary.getMax());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.rhq.core.domain.measurement.MeasurementAggregate getMeasurementAggregate(Subject subject, int scheduleId, long startTime, long endTime) {
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            MeasurementScheduleCriteria criteria = new MeasurementScheduleCriteria();
            criteria.addFilterId(Integer.valueOf(scheduleId));
            criteria.fetchResource(true);
            PageList<MeasurementSchedule> schedules = this.measurementScheduleManager.findSchedulesByCriteria(this.subjectManager.getOverlord(), criteria);
            if (schedules.isEmpty()) {
                throw new MeasurementException("Could not fine MeasurementSchedule with the id[" + scheduleId + "]");
            }
            MeasurementSchedule schedule = (MeasurementSchedule)schedules.get(0);
            if (!this.authorizationManager.canViewResource(subject, schedule.getResource().getId())) {
                throw new PermissionException("User[" + subject.getName() + "] does not have permission to view schedule[id=" + scheduleId + "]");
            }
            if (schedule.getDefinition().getDataType() != DataType.MEASUREMENT) {
                throw new IllegalArgumentException(schedule + " is not about numerical values. Can't compute aggregates");
            }
            if (startTime > endTime) {
                throw new IllegalArgumentException("Start date " + startTime + " is not before " + endTime);
            }
            MetricsServer metricsServer = this.storageClientManager.getMetricsServer();
            AggregateNumericMetric summary = metricsServer.getSummaryAggregate(scheduleId, startTime, endTime);
            org.rhq.core.domain.measurement.MeasurementAggregate measurementAggregate = new org.rhq.core.domain.measurement.MeasurementAggregate(summary.getMin(), summary.getAvg(), summary.getMax());
            return measurementAggregate;
        }
        finally {
            stopwatch.stop();
            this.log.debug((Object)("Finished loading measurement aggregate in " + stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public org.rhq.core.domain.measurement.MeasurementAggregate getAggregate(Subject subject, int groupId, int definitionId, long startTime, long endTime) {
        if (!this.authorizationManager.canViewGroup(subject, groupId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to calculate measurement aggregate for group[id=" + groupId + "], definition[id=" + definitionId + "]");
        }
        MeasurementDefinition def = this.measurementDefinitionManager.getMeasurementDefinition(subject, definitionId);
        if (def.getDataType() != DataType.MEASUREMENT) {
            throw new IllegalArgumentException(def + " is not about numerical values. Can't compute aggregates");
        }
        if (startTime > endTime) {
            throw new IllegalArgumentException("Start date " + startTime + " is not before " + endTime);
        }
        MeasurementScheduleCriteria criteria = new MeasurementScheduleCriteria();
        criteria.addFilterResourceGroupId(Integer.valueOf(groupId));
        criteria.addFilterDefinitionIds(new Integer[]{definitionId});
        criteria.setPageControl(PageControl.getUnlimitedInstance());
        PageList<MeasurementSchedule> schedules = this.measurementScheduleManager.findSchedulesByCriteria(subject, criteria);
        MetricsServer metricsServer = this.storageClientManager.getMetricsServer();
        AggregateNumericMetric summary = metricsServer.getSummaryAggregate(this.map((List<MeasurementSchedule>)schedules), startTime, endTime);
        return new org.rhq.core.domain.measurement.MeasurementAggregate(summary.getMin(), summary.getAvg(), summary.getMax());
    }

    @Override
    public List<MeasurementDataTrait> findCurrentTraitsForResource(Subject subject, int resourceId, DisplayType displayType) {
        Query query;
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view traits for resource[id=" + resourceId + "]");
        }
        if (displayType == null) {
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"MeasurementDataTrait.FindCurrentForResource", (OrderingField[])new OrderingField[]{new OrderingField("d.displayOrder", PageOrdering.ASC)});
        } else {
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"MeasurementDataTrait.FindCurrentForResourceAndDislayType", (OrderingField[])new OrderingField[]{new OrderingField("d.displayOrder", PageOrdering.ASC)});
            query.setParameter("displayType", (Object)displayType);
        }
        query.setParameter("resourceId", (Object)resourceId);
        List qres = query.getResultList();
        ArrayList<MeasurementDataTrait> result = new ArrayList<MeasurementDataTrait>(qres.size());
        for (Object[] objs : qres) {
            MeasurementDataTrait mdt = this.fillMeasurementDataTraitFromObjectArray(objs);
            result.add(mdt);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getCurrentTraitsForResource(" + resourceId + ") -> result is " + result));
        }
        return result;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<List<MeasurementDataNumericHighLowComposite>> findDataForCompatibleGroup(Subject subject, int groupId, int definitionId, long beginTime, long endTime, int numPoints) {
        List<List<MeasurementDataNumericHighLowComposite>> ret = this.findDataForContext(subject, EntityContext.forGroup((int)groupId), definitionId, beginTime, endTime, numPoints);
        return ret;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<List<MeasurementDataNumericHighLowComposite>> findDataForContext(Subject subject, EntityContext context, int definitionId, long beginTime, long endTime, int numDataPoints) {
        MetricsServer metricsServer = this.storageClientManager.getMetricsServer();
        if (context.type == EntityContext.Type.Resource) {
            if (!this.authorizationManager.canViewResource(subject, context.resourceId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view measurement data for resource[id=" + context.resourceId + "]");
            }
            MeasurementSchedule schedule = this.measurementScheduleManager.getSchedule(subject, context.getResourceId(), definitionId, false);
            ArrayList<List<MeasurementDataNumericHighLowComposite>> data = new ArrayList<List<MeasurementDataNumericHighLowComposite>>();
            ArrayList<MeasurementDataNumericHighLowComposite> tempList = new ArrayList<MeasurementDataNumericHighLowComposite>();
            for (MeasurementDataNumericHighLowComposite object : metricsServer.findDataForResource(schedule.getId(), beginTime, endTime, numDataPoints)) {
                tempList.add(object);
            }
            data.add(tempList);
            return data;
        }
        if (context.type == EntityContext.Type.ResourceGroup) {
            if (!this.authorizationManager.canViewGroup(subject, context.groupId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view measurement data for resourceGroup[id=" + context.groupId + "]");
            }
            MeasurementScheduleCriteria criteria = new MeasurementScheduleCriteria();
            criteria.addFilterResourceGroupId(Integer.valueOf(context.getGroupId()));
            criteria.addFilterDefinitionIds(new Integer[]{definitionId});
            criteria.setPageControl(PageControl.getUnlimitedInstance());
            PageList<MeasurementSchedule> schedules = this.measurementScheduleManager.findSchedulesByCriteria(subject, criteria);
            ArrayList<List<MeasurementDataNumericHighLowComposite>> data = new ArrayList<List<MeasurementDataNumericHighLowComposite>>();
            ArrayList<MeasurementDataNumericHighLowComposite> tempList = new ArrayList<MeasurementDataNumericHighLowComposite>();
            for (MeasurementDataNumericHighLowComposite object : metricsServer.findDataForGroup(this.map((List<MeasurementSchedule>)schedules), beginTime, endTime, numDataPoints)) {
                tempList.add(object);
            }
            data.add(tempList);
            return data;
        }
        throw new UnsupportedOperationException("The findDataForContext method does not support " + context);
    }

    private List<Integer> map(List<MeasurementSchedule> schedules) {
        ArrayList<Integer> scheduleIds = new ArrayList<Integer>(schedules.size());
        for (MeasurementSchedule schedule : schedules) {
            scheduleIds.add(schedule.getId());
        }
        return scheduleIds;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<List<MeasurementDataNumericHighLowComposite>> findDataForResource(Subject subject, int resourceId, int[] definitionIds, long beginTime, long endTime, int numDataPoints) {
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view measurement data for resource[id=" + resourceId + "]");
        }
        MetricsServer metricsServer = this.storageClientManager.getMetricsServer();
        ArrayList<List<MeasurementDataNumericHighLowComposite>> results = new ArrayList<List<MeasurementDataNumericHighLowComposite>>();
        for (int nextDefinitionId : definitionIds) {
            MeasurementSchedule schedule = this.measurementScheduleManager.getSchedule(subject, resourceId, nextDefinitionId, false);
            ArrayList<MeasurementDataNumericHighLowComposite> tempList = new ArrayList<MeasurementDataNumericHighLowComposite>();
            for (MeasurementDataNumericHighLowComposite object : metricsServer.findDataForResource(schedule.getId(), beginTime, endTime, numDataPoints)) {
                tempList.add(object);
            }
            results.add(tempList);
        }
        return results;
    }

    @Override
    public Set<MeasurementData> findLiveData(Subject subject, int resourceId, int[] definitionIds) {
        return this.findLiveData(subject, resourceId, definitionIds, null);
    }

    @Override
    public Set<MeasurementData> findLiveData(Subject subject, int resourceId, int[] definitionIds, Long timeout) {
        Set<MeasurementData> result;
        block7: {
            if (!this.authorizationManager.canViewResource(subject, resourceId)) {
                throw new PermissionException("User[" + subject.getName() + "] does not have permission to view live measurement data for resource[id=" + resourceId + "]");
            }
            Query query = this.entityManager.createNamedQuery("Agent.findByResourceId");
            query.setParameter("resourceId", (Object)resourceId);
            Agent agent = (Agent)query.getSingleResult();
            if (agent.getName().startsWith("dummy-agent:name") && agent.getAgentToken().startsWith("abc-")) {
                return Collections.emptySet();
            }
            query = this.entityManager.createNamedQuery("MeasurementSchedule.findByResourceIdsAndDefinitionIds");
            query.setParameter("definitionIds", (Object)ArrayUtils.wrapInList((int[])definitionIds));
            query.setParameter("resourceIds", Arrays.asList(resourceId));
            List schedules = query.getResultList();
            HashSet<MeasurementScheduleRequest> requests = new HashSet<MeasurementScheduleRequest>(schedules.size());
            for (MeasurementSchedule schedule : schedules) {
                requests.add(new MeasurementScheduleRequest(schedule));
            }
            result = null;
            try {
                AgentClient ac = this.agentClientManager.getAgentClient(agent);
                result = ac.getMeasurementAgentService(timeout).getRealTimeMeasurementValue(resourceId, requests);
            }
            catch (RuntimeException e) {
                if (e instanceof CannotConnectException || null != e.getCause() && e.getCause() instanceof TimeoutException) break block7;
                throw e;
            }
        }
        if (result != null && !result.isEmpty()) {
            this.pushToAlertSubsystem(result);
        }
        if (null == result) {
            result = Collections.emptySet();
        }
        return result;
    }

    @Override
    public Set<MeasurementData> findLiveDataForGroup(Subject subject, int groupId, int[] resourceIds, int[] definitionIds) {
        if (!this.authorizationManager.canViewGroup(subject, groupId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view measurement data for resourceGroup[id=" + groupId + "]");
        }
        HashSet<MeasurementData> values = new HashSet<MeasurementData>();
        if (resourceIds != null) {
            Query query = this.entityManager.createNamedQuery("Agent.findResourceIdsWithAgentsByResourceIds");
            query.setParameter("resourceIds", (Object)ArrayUtils.wrapInList((int[])resourceIds));
            List resourceIdsWithAgents = query.getResultList();
            for (ResourceIdWithAgentComposite resourceIdWithAgent : resourceIdsWithAgents) {
                if (resourceIdWithAgent.getAgent().getName().startsWith("dummy-agent:name") && resourceIdWithAgent.getAgent().getAgentToken().startsWith("abc-")) {
                    values.addAll(Collections.emptySet());
                    continue;
                }
                query = this.entityManager.createNamedQuery("MeasurementSchedule.findByResourceIdsAndDefinitionIds");
                query.setParameter("definitionIds", (Object)ArrayUtils.wrapInList((int[])definitionIds));
                query.setParameter("resourceIds", Arrays.asList(resourceIdWithAgent.getResourceId()));
                List schedules = query.getResultList();
                HashMap<Integer, Integer> scheduleIdToResourceIdMap = new HashMap<Integer, Integer>(schedules.size());
                HashSet<MeasurementScheduleRequest> requests = new HashSet<MeasurementScheduleRequest>(schedules.size());
                for (MeasurementSchedule schedule : schedules) {
                    requests.add(new MeasurementScheduleRequest(schedule));
                    scheduleIdToResourceIdMap.put(schedule.getId(), resourceIdWithAgent.getResourceId());
                }
                AgentClient ac = this.agentClientManager.getAgentClient(resourceIdWithAgent.getAgent());
                Set newValues = ac.getMeasurementAgentService().getRealTimeMeasurementValue(resourceIdWithAgent.getResourceId(), requests);
                values.addAll(newValues);
                for (MeasurementData value : newValues) {
                    value.setName(String.valueOf(scheduleIdToResourceIdMap.get(value.getScheduleId())) + ":" + value.getName());
                }
            }
        }
        if (values != null && !values.isEmpty()) {
            this.pushToAlertSubsystem(values);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MeasurementDataNumeric> findRawData(Subject subject, int scheduleId, long startTime, long endTime) {
        ArrayList<MeasurementDataNumeric> result = new ArrayList<MeasurementDataNumeric>();
        String table = MeasurementDataManagerUtility.getCurrentRawTable();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.rhqDs.getConnection();
            ps = connection.prepareStatement("SELECT time_stamp,value FROM " + table + " WHERE schedule_id= ? AND time_stamp BETWEEN ? AND ?");
            ps.setLong(1, scheduleId);
            ps.setLong(2, startTime);
            ps.setLong(3, endTime);
            rs = ps.executeQuery();
            while (rs.next()) {
                MeasurementDataNumeric point = new MeasurementDataNumeric(rs.getLong(1), scheduleId, Double.valueOf(rs.getDouble(2)));
                result.add(point);
            }
            JDBCUtil.safeClose((Connection)connection, (Statement)ps, (ResultSet)rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            JDBCUtil.safeClose((Connection)connection, ps, rs);
        }
        return result;
    }

    @Override
    public List<MeasurementDataTrait> findTraits(Subject subject, int resourceId, int definitionId) {
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view trait data for resource[id=" + resourceId + "] and definition[id=" + definitionId + "]");
        }
        Query q = this.entityManager.createNamedQuery("MeasurementDataTrait.FIND_ALL_FOR_RESOURCE_AND_DEFINITION");
        q.setParameter("resourceId", (Object)resourceId);
        q.setParameter("definitionId", (Object)definitionId);
        List queryResult = q.getResultList();
        ArrayList<MeasurementDataTrait> result = new ArrayList<MeasurementDataTrait>(queryResult.size());
        for (Object[] objs : queryResult) {
            MeasurementDataTrait mdt = this.fillMeasurementDataTraitFromObjectArray(objs);
            result.add(mdt);
        }
        return result;
    }

    @Override
    public PageList<MeasurementDataTrait> findTraitsByCriteria(Subject subject, MeasurementDataTraitCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        Map<String, Object> filterFields = generator.getFilterFields((Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, "schedule.resource", subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList results = queryRunner.execute();
        for (MeasurementDataTrait result : results) {
            result.getSchedule().getDefinition().getName();
        }
        if (filterFields.get("groupId") != null) {
            for (MeasurementDataTrait result : results) {
                result.getSchedule().getResource().getName();
            }
        }
        return results;
    }

    private MeasurementDataManagerUtility getConnectedUtilityInstance() {
        return MeasurementDataManagerUtility.getInstance(this.rhqDs);
    }

    private void pushToAlertSubsystem(Set<MeasurementData> data) {
        MeasurementReport fakeReport = new MeasurementReport();
        for (MeasurementData datum : data) {
            if (datum instanceof MeasurementDataTrait) {
                fakeReport.addData((MeasurementDataTrait)datum);
                continue;
            }
            if (!(datum instanceof MeasurementDataNumeric)) continue;
            fakeReport.addData((MeasurementDataNumeric)datum);
        }
        this.measurementDataManager.mergeMeasurementReport(fakeReport);
    }
}

