/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.instrumentation;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitorMBean;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.util.JMXUtil;
import org.rhq.enterprise.server.util.LookupUtil;

@Singleton
@Startup
@LocalBean
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class MeasurementMonitor
implements MeasurementMonitorMBean {
    private static final ObjectName OBJECT_NAME = ObjectNameFactory.create((String)"rhq:service=MeasurementMonitor");
    @EJB
    private StorageClientManager storageClientManager;
    private AtomicLong measurementInsertTime = new AtomicLong();
    private AtomicLong measurementsInserted = new AtomicLong();
    private AtomicLong callTimeInsertTime = new AtomicLong();
    private AtomicLong calltimeValuesInserted = new AtomicLong();
    private AtomicLong availabilityInsertTime = new AtomicLong();
    private AtomicLong availabilitiesInserted = new AtomicLong();
    private AtomicLong changesOnlyAvailabilityReports = new AtomicLong();
    private AtomicLong fullAvailabilityReports = new AtomicLong();
    private AtomicLong purgeTime = new AtomicLong();
    private AtomicLong baselineCalculationTime = new AtomicLong();
    private AtomicLong purgedAlerts = new AtomicLong();
    private AtomicLong purgedAlertConditions = new AtomicLong();
    private AtomicLong purgedAlertNotifications = new AtomicLong();
    private AtomicLong purgedAvailabilities = new AtomicLong();
    private AtomicLong purgedCallTimeData = new AtomicLong();
    private AtomicLong purgedEvents = new AtomicLong();
    private AtomicLong purgedMeasurementTraits = new AtomicLong();
    private static MBeanServer mbeanServer;
    private static ObjectName objectName;
    private static MeasurementMonitorMBean proxy;

    public static MeasurementMonitorMBean getMBean() {
        if (proxy == null) {
            proxy = objectName != null ? MBeanServerInvocationHandler.newProxyInstance(mbeanServer, objectName, MeasurementMonitorMBean.class, false) : new MeasurementMonitor();
        }
        return proxy;
    }

    @Override
    public long getMeasurementInsertTime() {
        return this.measurementInsertTime.get();
    }

    @Override
    public void incrementMeasurementInsertTime(long delta) {
        this.measurementInsertTime.addAndGet(delta);
    }

    @Override
    public long getMeasurementsInserted() {
        return this.measurementsInserted.get();
    }

    @Override
    public void incrementMeasurementsInserted(long delta) {
        this.measurementsInserted.addAndGet(delta);
    }

    @Override
    public long getCalltimeValuesInserted() {
        return this.calltimeValuesInserted.get();
    }

    @Override
    public void incrementCalltimeValuesInserted(long delta) {
        this.calltimeValuesInserted.addAndGet(delta);
    }

    @Override
    public long getCallTimeInsertTime() {
        return this.callTimeInsertTime.get();
    }

    @Override
    public void incrementCallTimeInsertTime(long delta) {
        this.callTimeInsertTime.addAndGet(delta);
    }

    @Override
    public long getAvailabilityInsertTime() {
        return this.availabilityInsertTime.get();
    }

    @Override
    public void incrementAvailabilityInsertTime(long delta) {
        this.availabilityInsertTime.addAndGet(delta);
    }

    @Override
    public long getAvailabilitiesInserted() {
        return this.availabilitiesInserted.get();
    }

    @Override
    public void incrementAvailabilitiesInserted(long delta) {
        this.availabilitiesInserted.addAndGet(delta);
    }

    @Override
    public long getChangesOnlyAvailabilityReports() {
        return this.changesOnlyAvailabilityReports.get();
    }

    @Override
    public long getFullAvailabilityReports() {
        return this.fullAvailabilityReports.get();
    }

    @Override
    public long getTotalAvailabilityReports() {
        return this.getChangesOnlyAvailabilityReports() + this.getFullAvailabilityReports();
    }

    @Override
    public void incrementAvailabilityReports(boolean changesOnlyReport) {
        if (changesOnlyReport) {
            this.changesOnlyAvailabilityReports.incrementAndGet();
        } else {
            this.fullAvailabilityReports.incrementAndGet();
        }
    }

    @Override
    public int getScheduledMeasurementsPerMinute() {
        return LookupUtil.getMeasurementScheduleManager().getScheduledMeasurementsPerMinute();
    }

    @Override
    public long getMeasurementCompressionTime() {
        return this.storageClientManager.getMetricsServer().getTotalAggregationTime();
    }

    @Override
    public long getPurgeTime() {
        return this.purgeTime.get();
    }

    @Override
    public void incrementPurgeTime(long delta) {
        this.purgeTime.addAndGet(delta);
    }

    @Override
    public long getBaselineCalculationTime() {
        return this.baselineCalculationTime.get();
    }

    @Override
    public void incrementBaselineCalculationTime(long delta) {
        this.baselineCalculationTime.addAndGet(delta);
    }

    @Override
    public long getPurgedAlerts() {
        return this.purgedAlerts.get();
    }

    @Override
    public void setPurgedAlerts(long delta) {
        this.purgedAlerts.set(delta);
    }

    @Override
    public long getPurgedAlertConditions() {
        return this.purgedAlertConditions.get();
    }

    @Override
    public void setPurgedAlertConditions(long delta) {
        this.purgedAlertConditions.set(delta);
    }

    @Override
    public long getPurgedAlertNotifications() {
        return this.purgedAlertNotifications.get();
    }

    @Override
    public void setPurgedAlertNotifications(long delta) {
        this.purgedAlertNotifications.set(delta);
    }

    @Override
    public long getPurgedAvailabilities() {
        return this.purgedAvailabilities.get();
    }

    @Override
    public void setPurgedAvailabilities(long delta) {
        this.purgedAvailabilities.set(delta);
    }

    @Override
    public long getPurgedCallTimeData() {
        return this.purgedCallTimeData.get();
    }

    @Override
    public void setPurgedCallTimeData(long delta) {
        this.purgedCallTimeData.set(delta);
    }

    @Override
    public long getPurgedEvents() {
        return this.purgedEvents.get();
    }

    @Override
    public void setPurgedEvents(long delta) {
        this.purgedEvents.set(delta);
    }

    @Override
    public long getPurgedMeasurementTraits() {
        return this.purgedMeasurementTraits.get();
    }

    @Override
    public void setPurgedMeasurementTraits(long delta) {
        this.purgedMeasurementTraits.set(delta);
    }

    @Override
    public int getAggregationBatchSize() {
        return this.storageClientManager.getMetricsServer().getAggregationBatchSize();
    }

    @Override
    public void setAggregationBatchSize(int size) {
        this.storageClientManager.setAggregationBatchSize(size);
    }

    @Override
    public int getAggregationParallelism() {
        return this.storageClientManager.getAggregationParallelism();
    }

    @Override
    public void setAggregationParallelism(int parallelism) {
        this.storageClientManager.setAggregationParallelism(parallelism);
    }

    @Override
    public int getAggregationWorkers() {
        return this.storageClientManager.getAggregationWorkers();
    }

    @Override
    public void setAggregationWorkers(int numWorkers) {
        this.storageClientManager.setAggregationWorkers(numWorkers);
    }

    @PostConstruct
    private void init() {
        JMXUtil.registerMBean(this, OBJECT_NAME);
        mbeanServer = JMXUtil.getPlatformMBeanServer();
        objectName = OBJECT_NAME;
    }

    @PreDestroy
    private void destroy() {
        mbeanServer = null;
        objectName = null;
        JMXUtil.unregisterMBeanQuietly(OBJECT_NAME);
    }
}

