/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.InventorySummary;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceBossLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerLocal;

@Stateless
public class ResourceBossBean
implements ResourceBossLocal {
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceGroupManagerLocal groupManager;
    @EJB
    private MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    private GroupDefinitionManagerLocal groupDefinitionManager;

    @Override
    public InventorySummary getInventorySummary(Subject user) {
        InventorySummary summary = new InventorySummary();
        int[] categoryCounts = this.resourceManager.getResourceCountSummary(user, InventoryStatus.COMMITTED);
        summary.setPlatformCount(categoryCounts[0]);
        summary.setServerCount(categoryCounts[1]);
        summary.setServiceCount(categoryCounts[2]);
        categoryCounts = this.groupManager.getResourceGroupCountSummary(user);
        summary.setMixedGroupCount(categoryCounts[0]);
        summary.setCompatibleGroupCount(categoryCounts[1]);
        summary.setGroupDefinitionCount(this.groupDefinitionManager.getGroupDefinitionCount(user));
        summary.setScheduledMeasurementsPerMinute(this.scheduleManager.getScheduledMeasurementsPerMinute());
        return summary;
    }
}

