/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.CannotConnectException;
import org.rhq.core.clientapi.agent.inventory.CreateResourceRequest;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceRequest;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceResponse;
import org.rhq.core.clientapi.agent.inventory.ResourceFactoryAgentService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.CannotConnectToAgentException;
import org.rhq.core.domain.resource.CreateResourceHistory;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.DeleteResourceHistory;
import org.rhq.core.domain.resource.DeleteResourceStatus;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.content.ContentManagerHelper;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerRemote;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;

@Stateless
public class ResourceFactoryManagerBean
implements ResourceFactoryManagerLocal,
ResourceFactoryManagerRemote {
    private static final Log LOG = LogFactory.getLog(ResourceFactoryManagerBean.class);
    private static final int REQUEST_TIMEOUT = 3600000;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ResourceFactoryManagerLocal resourceFactoryManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ContentManagerLocal contentManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void completeCreateResource(CreateResourceResponse response) {
        CreateResourceHistory history;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received call to complete create resource: " + response));
        }
        if ((history = (CreateResourceHistory)this.entityManager.find(CreateResourceHistory.class, (Object)response.getRequestId())) == null) {
            LOG.error((Object)("Attempting to complete a request that was not found in the database: " + response.getRequestId()));
            return;
        }
        history.setNewResourceKey(response.getResourceKey());
        history.setErrorMessage(response.getErrorMessage());
        history.setStatus(response.getStatus());
        if (response.getResourceConfiguration() != null) {
            this.entityManager.merge((Object)response.getResourceConfiguration());
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void completeDeleteResourceRequest(DeleteResourceResponse response) {
        DeleteResourceHistory history;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received call to complete delete resource: " + response));
        }
        if ((history = (DeleteResourceHistory)this.entityManager.find(DeleteResourceHistory.class, (Object)response.getRequestId())) == null) {
            LOG.error((Object)("Attempting to complete a request that was not found in the database: " + response.getRequestId()));
            return;
        }
        history.setErrorMessage(response.getErrorMessage());
        history.setStatus(response.getStatus());
        if (response.getStatus() == DeleteResourceStatus.SUCCESS) {
            Resource resource = history.getResource();
            Set children = resource.getChildResources();
            resource.setInventoryStatus(InventoryStatus.DELETED);
            resource.setItime(System.currentTimeMillis());
            this.entityManager.merge((Object)resource);
            this.uninventoryChildren(children);
        }
    }

    private void uninventoryChildren(Set<Resource> children) {
        for (Resource child : children) {
            this.resourceManager.uninventoryResourceInNewTransaction(child.getId());
        }
    }

    @Override
    public void checkForTimedOutRequests() {
        try {
            Query query = this.entityManager.createNamedQuery("CreateResourceHistory.findWithStatus");
            query.setParameter("status", (Object)CreateResourceStatus.IN_PROGRESS);
            List createHistories = query.getResultList();
            if (createHistories == null) {
                return;
            }
            for (CreateResourceHistory request : createHistories) {
                long duration = request.getDuration();
                if (duration <= 3600000L) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Timing out request after duration: " + duration + " Request: " + request));
                }
                request.setErrorMessage("Request with duration " + duration + " exceeded the timeout threshold of " + 3600000);
                request.setStatus(CreateResourceStatus.TIMED_OUT);
            }
            query = this.entityManager.createNamedQuery("CreateResourceHistory.findWithStatus");
            query.setParameter("status", (Object)CreateResourceStatus.IN_PROGRESS);
            List deleteHistories = query.getResultList();
            if (deleteHistories == null) {
                return;
            }
            for (DeleteResourceHistory request : deleteHistories) {
                long duration = request.getDuration();
                if (duration <= 3600000L) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Timing out request after duration: " + duration + " Request: " + request));
                }
                request.setErrorMessage("Request with duration " + duration + " exceeded the timeout threshold of " + 3600000);
                request.setStatus(DeleteResourceStatus.TIMED_OUT);
            }
        }
        catch (Throwable e) {
            LOG.error((Object)"Error while processing timed out requests", e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public CreateResourceHistory persistCreateHistory(Subject user, int parentResourceId, int resourceTypeId, String createResourceName, Configuration configuration) {
        Resource parentResource = (Resource)this.entityManager.getReference(Resource.class, (Object)parentResourceId);
        ResourceType resourceType = (ResourceType)this.entityManager.getReference(ResourceType.class, (Object)resourceTypeId);
        Configuration configurationClone = configuration != null ? configuration.deepCopy(false) : null;
        CreateResourceHistory history = new CreateResourceHistory(parentResource, resourceType, user.getName(), configurationClone);
        history.setCreatedResourceName(createResourceName);
        history.setStatus(CreateResourceStatus.IN_PROGRESS);
        this.entityManager.persist((Object)history);
        parentResource.addCreateChildResourceHistory(history);
        parentResource.getAgent();
        return history;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public CreateResourceHistory persistCreateHistory(Subject user, int parentResourceId, int resourceTypeId, String createResourceName, PackageVersion packageVersion, Configuration deploymentTimeConfiguration) {
        Resource parentResource = (Resource)this.entityManager.getReference(Resource.class, (Object)parentResourceId);
        ResourceType resourceType = (ResourceType)this.entityManager.getReference(ResourceType.class, (Object)resourceTypeId);
        CreateResourceHistory history = new CreateResourceHistory(parentResource, resourceType, user.getName(), (InstalledPackage)null);
        history.setCreatedResourceName(createResourceName);
        history.setConfiguration(deploymentTimeConfiguration);
        history.setStatus(CreateResourceStatus.IN_PROGRESS);
        this.entityManager.persist((Object)history);
        parentResource.addCreateChildResourceHistory(history);
        parentResource.getAgent();
        return history;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public DeleteResourceHistory persistDeleteHistory(Subject user, int resourceId) {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        DeleteResourceHistory history = new DeleteResourceHistory(resource, user.getName());
        history.setStatus(DeleteResourceStatus.IN_PROGRESS);
        this.entityManager.persist((Object)history);
        resource.addDeleteResourceHistory(history);
        resource.getAgent();
        return history;
    }

    @Override
    public CreateResourceHistory getCreateHistoryItem(int historyItemId) {
        Query query = this.entityManager.createNamedQuery("CreateResourceHistory.findById");
        query.setParameter("id", (Object)historyItemId);
        CreateResourceHistory history = (CreateResourceHistory)query.getSingleResult();
        return history;
    }

    @Override
    public int getCreateChildResourceHistoryCount(int parentResourceId, Long beginDate, Long endDate) {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"CreateResourceHistory.findByParentResourceId");
        query.setParameter("id", (Object)parentResourceId);
        query.setParameter("startTime", (Object)beginDate);
        query.setParameter("endTime", (Object)endDate);
        long totalCount = (Long)query.getSingleResult();
        return (int)totalCount;
    }

    @Override
    public PageList<CreateResourceHistory> findCreateChildResourceHistory(Subject subject, int parentResourceId, Long beginDate, Long endDate, PageControl pageControl) {
        pageControl.initDefaultOrderingField("crh.id", PageOrdering.DESC);
        int totalCount = this.getCreateChildResourceHistoryCount(parentResourceId, beginDate, endDate);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"CreateResourceHistory.findByParentResourceId", (PageControl)pageControl);
        query.setParameter("id", (Object)parentResourceId);
        query.setParameter("startTime", (Object)beginDate);
        query.setParameter("endTime", (Object)endDate);
        List history = query.getResultList();
        PageList pageList = new PageList((Collection)history, totalCount, pageControl);
        return pageList;
    }

    @Override
    public int getDeleteChildResourceHistoryCount(int parentResourceId, Long beginDate, Long endDate) {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"DeleteResourceHistory.findByParentResourceId");
        query.setParameter("id", (Object)parentResourceId);
        query.setParameter("startTime", (Object)beginDate);
        query.setParameter("endTime", (Object)endDate);
        long totalCount = (Long)query.getSingleResult();
        return (int)totalCount;
    }

    @Override
    public PageList<DeleteResourceHistory> findDeleteChildResourceHistory(Subject subject, int parentResourceId, Long beginDate, Long endDate, PageControl pageControl) {
        pageControl.initDefaultOrderingField("drh.id", PageOrdering.DESC);
        int totalCount = this.getDeleteChildResourceHistoryCount(parentResourceId, beginDate, endDate);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"DeleteResourceHistory.findByParentResourceId", (PageControl)pageControl);
        query.setParameter("id", (Object)parentResourceId);
        query.setParameter("startTime", (Object)beginDate);
        query.setParameter("endTime", (Object)endDate);
        List history = query.getResultList();
        PageList pageList = new PageList((Collection)history, totalCount, pageControl);
        return pageList;
    }

    @Override
    public CreateResourceHistory createResource(Subject user, int parentResourceId, int newResourceTypeId, String newResourceName, Configuration pluginConfiguration, String packageName, String packageVersionNumber, Integer architectureId, Configuration deploymentTimeConfiguration, InputStream packageBitStream) {
        return this.createResource(user, parentResourceId, newResourceTypeId, newResourceName, pluginConfiguration, packageName, packageVersionNumber, architectureId, deploymentTimeConfiguration, packageBitStream, null, null);
    }

    @Override
    public CreateResourceHistory createResource(Subject user, int parentResourceId, int newResourceTypeId, String newResourceName, Configuration pluginConfiguration, String packageName, String packageVersionNumber, Integer architectureId, Configuration deploymentTimeConfiguration, InputStream packageBitStream, Map<String, String> packageUploadDetails) {
        return this.createResource(user, parentResourceId, newResourceTypeId, newResourceName, pluginConfiguration, packageName, packageVersionNumber, architectureId, deploymentTimeConfiguration, packageBitStream, packageUploadDetails, null);
    }

    public CreateResourceHistory createResource(Subject user, int parentResourceId, int newResourceTypeId, String newResourceName, Configuration pluginConfiguration, String packageName, String packageVersionNumber, Integer architectureId, Configuration deploymentTimeConfiguration, InputStream packageBitStream, Map<String, String> packageUploadDetails, Integer timeout) {
        LOG.info((Object)("Received call to create package backed resource under parent [" + parentResourceId + "]"));
        Resource parentResource = (Resource)this.entityManager.find(Resource.class, (Object)parentResourceId);
        if (!this.authorizationManager.hasResourcePermission(user, Permission.CREATE_CHILD_RESOURCES, parentResource.getId())) {
            throw new PermissionException("User [" + user.getName() + "] does not have permission to create a child resource for resource [" + parentResource + "]");
        }
        ResourceType newResourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)newResourceTypeId);
        PackageType newPackageType = this.contentManager.getResourceCreationPackageType(newResourceTypeId);
        if (!newResourceType.isCreatable() || newResourceType.getCreationDataType() != ResourceCreationDataType.CONTENT) {
            throw new RuntimeException("Cannot create " + newResourceType + " child Resource under parent " + parentResource + ", since the " + newResourceType + " type does not support content-based Resource creation.");
        }
        this.abortResourceCreationIfExistingSingleton(parentResource, newResourceType);
        packageVersionNumber = null == packageVersionNumber ? Long.toString(System.currentTimeMillis()) : packageVersionNumber;
        architectureId = null != architectureId ? architectureId.intValue() : this.contentManager.getNoArchitecture().getId();
        PackageVersion packageVersion = null;
        packageVersion = packageUploadDetails == null ? this.contentManager.createPackageVersionWithDisplayVersion(user, packageName, newPackageType.getId(), packageVersionNumber, null, (int)architectureId, packageBitStream) : this.contentManager.getUploadedPackageVersion(user, packageName, newPackageType.getId(), packageVersionNumber, architectureId, packageBitStream, packageUploadDetails, null);
        return this.doCreatePackageBackedResource(user, parentResource, newResourceType, newResourceName, pluginConfiguration, deploymentTimeConfiguration, packageVersion, timeout);
    }

    @Override
    public CreateResourceHistory createResource(Subject user, int parentResourceId, int resourceTypeId, String resourceName, Configuration pluginConfiguration, Configuration resourceConfiguration) {
        return this.createResource(user, parentResourceId, resourceTypeId, resourceName, pluginConfiguration, resourceConfiguration, null);
    }

    @Override
    public CreateResourceHistory createResource(Subject user, int parentResourceId, int resourceTypeId, String resourceName, Configuration pluginConfiguration, Configuration resourceConfiguration, Integer timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received call to create configuration backed resource under parent: " + parentResourceId + " of type: " + resourceTypeId));
        }
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
        Resource parentResource = (Resource)this.entityManager.find(Resource.class, (Object)parentResourceId);
        Agent agent = parentResource.getAgent();
        if (!this.authorizationManager.hasResourcePermission(user, Permission.CREATE_CHILD_RESOURCES, parentResource.getId())) {
            throw new PermissionException("User [" + user.getName() + "] does not have permission to create a child resource for resource [" + parentResource + "]");
        }
        if (!resourceType.isCreatable() || resourceType.getCreationDataType() != ResourceCreationDataType.CONFIGURATION) {
            throw new RuntimeException("Cannot create " + resourceType + " child Resource under parent " + parentResource + ", since the " + resourceType + " type does not support configuration-based Resource creation.");
        }
        this.abortResourceCreationIfExistingSingleton(parentResource, resourceType);
        CreateResourceHistory persistedHistory = this.resourceFactoryManager.persistCreateHistory(user, parentResourceId, resourceTypeId, resourceName, resourceConfiguration);
        CreateResourceRequest request = new CreateResourceRequest(persistedHistory.getId(), parentResourceId, resourceName, resourceType.getName(), resourceType.getPlugin(), pluginConfiguration, resourceConfiguration, timeout);
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            ResourceFactoryAgentService resourceFactoryAgentService = agentClient.getResourceFactoryAgentService();
            resourceFactoryAgentService.createResource(request);
            return persistedHistory;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while sending create resource request to agent service", (Throwable)e);
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            CreateResourceResponse response = new CreateResourceResponse(persistedHistory.getId(), null, null, CreateResourceStatus.FAILURE, errorMessage, resourceConfiguration);
            this.resourceFactoryManager.completeCreateResource(response);
            throw new RuntimeException("Error while sending create resource request to agent service", e);
        }
    }

    @Override
    public CreateResourceHistory createPackageBackedResource(Subject subject, int parentResourceId, int newResourceTypeId, String newResourceName, Configuration pluginConfiguration, String packageName, String packageVersionNumber, Integer architectureId, Configuration deploymentTimeConfiguration, byte[] packageBits, Integer timeout) {
        return this.createResource(subject, parentResourceId, newResourceTypeId, newResourceName, pluginConfiguration, packageName, packageVersionNumber, architectureId, deploymentTimeConfiguration, new ByteArrayInputStream(packageBits), null, timeout);
    }

    @Override
    public CreateResourceHistory createPackageBackedResourceViaContentHandle(Subject subject, int parentResourceId, int newResourceTypeId, String newResourceName, Configuration pluginConfiguration, String packageName, String packageVersion, Integer architectureId, Configuration deploymentTimeConfiguration, String temporaryContentHandle, Integer timeout) {
        FileInputStream packageBitStream = null;
        try {
            packageBitStream = new FileInputStream(this.contentManager.getTemporaryContentFile(temporaryContentHandle));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.createResource(subject, parentResourceId, newResourceTypeId, newResourceName, pluginConfiguration, packageName, packageVersion, architectureId, deploymentTimeConfiguration, packageBitStream, null, timeout);
    }

    @Override
    public CreateResourceHistory createPackageBackedResource(Subject subject, int parentResourceId, int newResourceTypeId, String newResourceName, Configuration pluginConfiguration, String packageName, String packageVersionNumber, Integer architectureId, Configuration deploymentTimeConfiguration, byte[] packageBits) {
        return this.createResource(subject, parentResourceId, newResourceTypeId, newResourceName, pluginConfiguration, packageName, packageVersionNumber, architectureId, deploymentTimeConfiguration, new ByteArrayInputStream(packageBits));
    }

    @Override
    public CreateResourceHistory createPackageBackedResourceViaPackageVersion(Subject subject, int parentResourceId, int newResourceTypeId, String newResourceName, Configuration pluginConfiguration, Configuration deploymentTimeConfiguration, int packageVersionId) {
        return this.createPackageBackedResourceViaPackageVersion(subject, parentResourceId, newResourceTypeId, newResourceName, pluginConfiguration, deploymentTimeConfiguration, packageVersionId, null);
    }

    @Override
    public CreateResourceHistory createPackageBackedResourceViaPackageVersion(Subject subject, int parentResourceId, int newResourceTypeId, String newResourceName, Configuration pluginConfiguration, Configuration deploymentTimeConfiguration, int packageVersionId, Integer timeout) {
        Resource parentResource = (Resource)this.entityManager.find(Resource.class, (Object)parentResourceId);
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.CREATE_CHILD_RESOURCES, parentResource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to create a child resource for resource [" + parentResource + "]");
        }
        ResourceType newResourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)newResourceTypeId);
        PackageVersion packageVersion = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
        if (!newResourceType.isCreatable() || newResourceType.getCreationDataType() != ResourceCreationDataType.CONTENT) {
            throw new RuntimeException("Cannot create " + newResourceType + " child Resource under parent " + parentResource + ", since the " + newResourceType + " type does not support content-based Resource creation.");
        }
        this.abortResourceCreationIfExistingSingleton(parentResource, newResourceType);
        return this.doCreatePackageBackedResource(subject, parentResource, newResourceType, newResourceName, pluginConfiguration, deploymentTimeConfiguration, packageVersion, timeout);
    }

    private CreateResourceHistory doCreatePackageBackedResource(Subject subject, Resource parentResource, ResourceType newResourceType, String newResourceName, Configuration pluginConfiguration, Configuration deploymentTimeConfiguration, PackageVersion packageVersion, Integer timeout) {
        Agent agent = parentResource.getAgent();
        if (deploymentTimeConfiguration != null && timeout != null) {
            deploymentTimeConfiguration.put((Property)new PropertySimple("userProvidedTimeoutMillis", (Object)timeout));
        }
        CreateResourceHistory persistedHistory = this.resourceFactoryManager.persistCreateHistory(subject, parentResource.getId(), newResourceType.getId(), newResourceName, packageVersion, deploymentTimeConfiguration);
        ResourcePackageDetails packageDetails = ContentManagerHelper.packageVersionToDetails(packageVersion);
        packageDetails.setDeploymentTimeConfiguration(deploymentTimeConfiguration);
        CreateResourceRequest request = new CreateResourceRequest(persistedHistory.getId(), parentResource.getId(), newResourceName, newResourceType.getName(), newResourceType.getPlugin(), pluginConfiguration, packageDetails, timeout);
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            ResourceFactoryAgentService resourceFactoryAgentService = agentClient.getResourceFactoryAgentService();
            resourceFactoryAgentService.createResource(request);
            return persistedHistory;
        }
        catch (NoResultException nre) {
            return null;
        }
        catch (CannotConnectException e) {
            LOG.error((Object)"Error while sending create resource request to agent service", (Throwable)e);
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            CreateResourceResponse response = new CreateResourceResponse(persistedHistory.getId(), null, null, CreateResourceStatus.FAILURE, errorMessage, null);
            this.resourceFactoryManager.completeCreateResource(response);
            throw new CannotConnectToAgentException("Error while sending create resource request to agent service", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while sending create resource request to agent service", (Throwable)e);
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            CreateResourceResponse response = new CreateResourceResponse(persistedHistory.getId(), null, null, CreateResourceStatus.FAILURE, errorMessage, null);
            this.resourceFactoryManager.completeCreateResource(response);
            throw new RuntimeException("Error while sending create resource request to agent service", e);
        }
    }

    @Override
    public List<DeleteResourceHistory> deleteResources(Subject user, int[] resourceIds) {
        ArrayList deleteResourceIds = new ArrayList();
        ArrayList<DeleteResourceHistory> deleteResourceHistories = new ArrayList<DeleteResourceHistory>();
        int[] arr$ = resourceIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer resourceId = arr$[i$];
            if (deleteResourceIds.contains(resourceId)) continue;
            deleteResourceHistories.add(this.deleteResource(user, resourceId));
        }
        return deleteResourceHistories;
    }

    @Override
    public DeleteResourceHistory deleteResource(Subject subject, int resourceId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received call to delete resource: " + resourceId));
        }
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        Agent agent = resource.getAgent();
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.DELETE_RESOURCE, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to delete resource [" + resource + "]");
        }
        DeleteResourceHistory persistedHistory = this.resourceFactoryManager.persistDeleteHistory(subject, resourceId);
        DeleteResourceRequest request = new DeleteResourceRequest(persistedHistory.getId(), resourceId);
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            ResourceFactoryAgentService resourceFactoryAgentService = agentClient.getResourceFactoryAgentService();
            resourceFactoryAgentService.deleteResource(request);
            return persistedHistory;
        }
        catch (CannotConnectException e) {
            LOG.error((Object)"Error while sending delete resource request to agent service", (Throwable)e);
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            DeleteResourceResponse response = new DeleteResourceResponse(persistedHistory.getId(), DeleteResourceStatus.FAILURE, errorMessage);
            this.resourceFactoryManager.completeDeleteResourceRequest(response);
            throw new CannotConnectToAgentException("Error while sending delete resource request to agent service", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while sending delete resource request to agent service", (Throwable)e);
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            DeleteResourceResponse response = new DeleteResourceResponse(persistedHistory.getId(), DeleteResourceStatus.FAILURE, errorMessage);
            this.resourceFactoryManager.completeDeleteResourceRequest(response);
            throw new RuntimeException("Error while sending delete resource request to agent service", e);
        }
    }

    private void abortResourceCreationIfExistingSingleton(Resource parentResource, ResourceType resourceType) {
        if (resourceType.isSingleton()) {
            ResourceCriteria resourceCriteria = new ResourceCriteria();
            resourceCriteria.addFilterParentResourceId(Integer.valueOf(parentResource.getId()));
            resourceCriteria.addFilterResourceTypeId(Integer.valueOf(resourceType.getId()));
            resourceCriteria.clearPaging();
            PageList<Resource> childResourcesOfType = this.resourceManager.findResourcesByCriteria(this.subjectManager.getOverlord(), resourceCriteria);
            if (childResourcesOfType.size() >= 1) {
                throw new RuntimeException("Cannot create " + resourceType + " child Resource under parent " + parentResource + ", since " + resourceType + " is a singleton type, and there is already a child Resource of that type. " + "If the existing child Resource corresponds to a managed Resource which no longer exists, " + "uninventory it and then try again.");
            }
        }
    }
}

