/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group;

import java.io.UnsupportedEncodingException;

public class LDAPStringUtil {
    public static String encodeForFilter(String filterString) {
        if (filterString != null && filterString.length() > 0) {
            StringBuilder encString = new StringBuilder(filterString.length());
            block9: for (int i = 0; i < filterString.length(); ++i) {
                char ch = filterString.charAt(i);
                switch (ch) {
                    case '*': {
                        encString.append("\\2a");
                        continue block9;
                    }
                    case '(': {
                        encString.append("\\28");
                        continue block9;
                    }
                    case ')': {
                        encString.append("\\29");
                        continue block9;
                    }
                    case '\\': {
                        encString.append("\\5c");
                        continue block9;
                    }
                    case '\u0000': {
                        encString.append("\\00");
                        continue block9;
                    }
                    default: {
                        if (ch <= '\u007f') {
                            encString.append(ch);
                            continue block9;
                        }
                        if (ch < '\u0080') continue block9;
                        try {
                            byte[] utf8bytes;
                            for (byte b : utf8bytes = String.valueOf(ch).getBytes("UTF8")) {
                                encString.append(String.format("\\%02x", b));
                            }
                            continue block9;
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                    }
                }
            }
            return encString.toString();
        }
        return filterString;
    }
}

