/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementAggregate;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataPK;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.ParameterMissingException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.UILinkTemplate;
import org.rhq.enterprise.server.rest.domain.Baseline;
import org.rhq.enterprise.server.rest.domain.Datapoint;
import org.rhq.enterprise.server.rest.domain.DoubleValue;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.MetricAggregate;
import org.rhq.enterprise.server.rest.domain.MetricDefinitionAggregate;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.NumericDataPoint;
import org.rhq.enterprise.server.rest.domain.StringValue;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.domain.RawNumericMetric;

@Api(value="Deal with metrics", description="This part of the API deals with exporting and adding metrics")
@Produces(value={"application/json", "application/xml", "text/html"})
@Path(value="/metric")
@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class MetricHandlerBean
extends AbstractRestBean {
    static final String NO_RESOURCE_FOR_ID = "If no resource with the passed id exists";
    static final String NO_SCHEDULE_FOR_ID = "No schedule with the passed id exists";
    @EJB
    MeasurementDataManagerLocal dataManager;
    @EJB
    MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    MeasurementDefinitionManagerLocal definitionManager;
    @EJB
    ResourceManagerLocal resMgr;
    @EJB
    ResourceGroupManagerLocal groupMgr;
    @EJB
    MetricHandlerBean metricHandlerBean;
    @EJB
    private StorageClientManager sessionManager;
    @PersistenceContext(unitName="rhqpu")
    EntityManager em;
    private static final long EIGHT_HOURS = 28800000L;
    private static final long SEVEN_DAYS = 604800000L;

    @GZIP
    @GET
    @Path(value="data/{scheduleId}")
    @Produces(value={"application/json", "application/xml", "text/html"})
    @ApiOperation(value="Get the bucketized metric values for the schedule.")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Response getMetricData(@ApiParam(value="Schedule Id of the values to query") @PathParam(value="scheduleId") int scheduleId, @ApiParam(value="Start time since epoch.", defaultValue="End time - 8h") @QueryParam(value="startTime") long startTime, @ApiParam(value="End time since epoch.", defaultValue="Now") @QueryParam(value="endTime") long endTime, @ApiParam(value="Number of buckets") @QueryParam(value="dataPoints") @DefaultValue(value="60") int dataPoints, @ApiParam(value="Hide rows that are NaN only", defaultValue="false") @QueryParam(value="hideEmpty") boolean hideEmpty, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        if (dataPoints <= 0) {
            throw new BadArgumentException("dataPoints", "must be >0");
        }
        if (startTime == 0L) {
            endTime = System.currentTimeMillis();
            startTime = endTime - 28800000L;
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        boolean isHtml = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE);
        MeasurementSchedule schedule = this.obtainSchedule(scheduleId, false, DataType.MEASUREMENT);
        MeasurementAggregate aggr = this.dataManager.getMeasurementAggregate(this.caller, scheduleId, startTime, endTime);
        MetricAggregate res = new MetricAggregate(scheduleId, aggr.getMin(), aggr.getAvg(), aggr.getMax());
        int definitionId = schedule.getDefinition().getId();
        List<List<MeasurementDataNumericHighLowComposite>> listList = this.dataManager.findDataForResource(this.caller, schedule.getResource().getId(), new int[]{definitionId}, startTime, endTime, dataPoints);
        if (!listList.isEmpty()) {
            List<MeasurementDataNumericHighLowComposite> list = listList.get(0);
            this.fillInDatapoints(res, list, scheduleId, hideEmpty, isHtml);
        }
        CacheControl cc = new CacheControl();
        int maxAge = (int)(schedule.getInterval() / 1000L) / 2;
        cc.setMaxAge(maxAge);
        cc.setPrivate(false);
        cc.setNoCache(false);
        if (isHtml) {
            String htmlString = this.renderTemplate("metricData", res);
            builder = Response.ok((Object)htmlString, (MediaType)mediaType);
        } else {
            builder = Response.ok((Object)res, (MediaType)mediaType);
        }
        builder.cacheControl(cc);
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="data/group/{groupId}/{definitionId}")
    @ApiOperation(value="Get the bucketized metric values for the metric definition of the group ")
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response getMetricDataForGroupAndDefinition(@ApiParam(value="Id of the group to query") @PathParam(value="groupId") int groupId, @ApiParam(value="Id of the metric definition to retrieve") @PathParam(value="definitionId") int definitionId, @ApiParam(value="Start time since epoch.", defaultValue="End time - 8h") @QueryParam(value="startTime") long startTime, @ApiParam(value="End time since epoch.", defaultValue="Now") @QueryParam(value="endTime") long endTime, @ApiParam(value="Number of buckets") @QueryParam(value="dataPoints") @DefaultValue(value="60") int dataPoints, @ApiParam(value="Hide rows that are NaN only", defaultValue="false") @QueryParam(value="hideEmpty") boolean hideEmpty, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        if (startTime == 0L) {
            endTime = System.currentTimeMillis();
            startTime = endTime - 28800000L;
        }
        if (dataPoints < 1) {
            throw new BadArgumentException("dataPoints", "must be >=0");
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        boolean isHtml = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE);
        this.fetchGroup(groupId, true);
        MeasurementDefinition definition = this.definitionManager.getMeasurementDefinition(this.caller, definitionId);
        if (definition == null) {
            throw new StuffNotFoundException("There is no definition with id " + definitionId);
        }
        MeasurementAggregate aggr = this.dataManager.getAggregate(this.caller, groupId, definitionId, startTime, endTime);
        MetricAggregate res = new MetricAggregate(definitionId, aggr.getMin(), aggr.getAvg(), aggr.getMax());
        res.setGroup(true);
        List<List<MeasurementDataNumericHighLowComposite>> listList = this.dataManager.findDataForCompatibleGroup(this.caller, groupId, definitionId, startTime, endTime, dataPoints);
        if (listList.isEmpty()) {
            throw new StuffNotFoundException("Data for group with id " + groupId + " and definition " + definitionId);
        }
        List<MeasurementDataNumericHighLowComposite> list = listList.get(0);
        if (!listList.isEmpty()) {
            this.fillInDatapoints(res, list, definitionId, hideEmpty, isHtml);
        }
        CacheControl cc = new CacheControl();
        int maxAge = (int)(definition.getDefaultInterval() / 1000L) / 2;
        cc.setMaxAge(maxAge);
        cc.setPrivate(false);
        cc.setNoCache(false);
        if (isHtml) {
            String htmlString = this.renderTemplate("metricData", res);
            builder = Response.ok((Object)htmlString, (MediaType)mediaType);
        } else {
            builder = Response.ok((Object)res, (MediaType)mediaType);
        }
        builder.cacheControl(cc);
        return builder.build();
    }

    private MeasurementSchedule obtainSchedule(int scheduleId, boolean force, DataType type) {
        MeasurementSchedule schedule = null;
        if (!force) {
            schedule = this.getFromCache(scheduleId, MeasurementSchedule.class);
        }
        if (schedule == null) {
            schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId);
            if (schedule == null) {
                throw new StuffNotFoundException("Schedule with id " + scheduleId);
            }
            this.putToCache(scheduleId, MeasurementSchedule.class, schedule);
        }
        if (schedule.getDefinition().getDataType() != type) {
            throw new BadArgumentException("Schedule [" + scheduleId + "]", "it is not a (" + type + ") metric");
        }
        return schedule;
    }

    private MetricAggregate fillInDatapoints(MetricAggregate res, List<MeasurementDataNumericHighLowComposite> list, int scheduleId, boolean hideEmpty, boolean isHtmlOutput) {
        long minTime = Long.MAX_VALUE;
        long maxTime = 0L;
        res.setScheduleId(scheduleId);
        for (MeasurementDataNumericHighLowComposite c : list) {
            MetricAggregate.DataPoint dp;
            long timestamp = c.getTimestamp();
            if (Double.isNaN(c.getValue()) && hideEmpty) continue;
            if (isHtmlOutput) {
                dp = new MetricAggregate.DataPoint(timestamp);
                Double v = c.getLowValue();
                v = this.nullifyIfNaN(v);
                dp.setLow(v);
                v = c.getHighValue();
                v = this.nullifyIfNaN(v);
                dp.setHigh(v);
                v = c.getValue();
                v = this.nullifyIfNaN(v);
                dp.setValue(v);
            } else {
                dp = new MetricAggregate.DataPoint(timestamp, c.getValue(), c.getHighValue(), c.getLowValue());
            }
            res.addDataPoint(dp);
            if (timestamp < minTime) {
                minTime = timestamp;
            }
            if (timestamp <= maxTime) continue;
            maxTime = timestamp;
        }
        res.setNumDataPoints(list.size());
        res.setMaxTimeStamp(maxTime);
        res.setMinTimeStamp(minTime);
        return res;
    }

    private Double nullifyIfNaN(Double v) {
        if (Double.isNaN(v)) {
            v = null;
        }
        return v;
    }

    @GZIP
    @GET
    @Path(value="data")
    @Produces(value={"application/json", "application/xml", "text/html"})
    @ApiOperation(value="Return bucketized metric data (60 points) for the passed schedules")
    @ApiErrors(value={@ApiError(code=404, reason="No schedule with the passed id exists"), @ApiError(code=406, reason="No schedules requested"), @ApiError(code=406, reason="Schedule Ids are not numeric")})
    public Response getMetricDataMulti(@ApiParam(value="A comma separated list of schedule ids") @QueryParam(value="sid") String schedules, @ApiParam(value="Start time in ms since epoch. Default is now -8h") @QueryParam(value="startTime") long startTime, @ApiParam(value="End time in ms since epoch. Default is now") @QueryParam(value="endTime") long endTime, @ApiParam(value="Number of buckets") @QueryParam(value="dataPoints") @DefaultValue(value="60") int dataPoints, @ApiParam(value="Should empty datapoints be hidden") @DefaultValue(value="false") @QueryParam(value="hideEmpty") boolean hideEmpty, @Context HttpHeaders headers) {
        if (dataPoints <= 0) {
            throw new BadArgumentException("dataPoints", "must be >0");
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        long now = System.currentTimeMillis();
        if (endTime == 0L) {
            endTime = now;
        }
        if (startTime == 0L) {
            endTime = System.currentTimeMillis();
            startTime = endTime - 28800000L;
        }
        if (schedules == null) {
            throw new ParameterMissingException("sid");
        }
        String[] tmp = schedules.split(",");
        Integer[] scheduleIds = new Integer[tmp.length];
        try {
            for (int i = 0; i < tmp.length; ++i) {
                scheduleIds[i] = Integer.parseInt(tmp[i]);
            }
        }
        catch (NumberFormatException nfe) {
            throw new BadArgumentException("Sid", nfe.getMessage());
        }
        ArrayList<MetricAggregate> resList = new ArrayList<MetricAggregate>(scheduleIds.length);
        for (Integer scheduleId : scheduleIds) {
            MeasurementSchedule sched = this.scheduleManager.getScheduleById(this.caller, scheduleId);
            if (sched == null) {
                throw new StuffNotFoundException("Schedule with id " + scheduleId);
            }
            int definitionId = sched.getDefinition().getId();
            List<List<MeasurementDataNumericHighLowComposite>> listList = this.dataManager.findDataForContext(this.caller, EntityContext.forResource((int)sched.getResource().getId()), definitionId, startTime, endTime, dataPoints);
            if (listList.isEmpty()) {
                throw new StuffNotFoundException("Metrics for schedule " + scheduleId);
            }
            MeasurementAggregate measurementAggregate = this.dataManager.getMeasurementAggregate(this.caller, scheduleId, startTime, endTime);
            List<MeasurementDataNumericHighLowComposite> list = listList.get(0);
            MetricAggregate res = new MetricAggregate(scheduleId, measurementAggregate.getMin(), measurementAggregate.getAvg(), measurementAggregate.getMax());
            boolean isHtml = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE);
            res = this.fillInDatapoints(res, list, scheduleId, hideEmpty, isHtml);
            resList.add(res);
        }
        GenericEntity<List<MetricAggregate>> metAgg = new GenericEntity<List<MetricAggregate>>(resList){};
        return Response.ok((Object)metAgg, (MediaType)mediaType).build();
    }

    @GET
    @Path(value="/schedule/{id}")
    @Produces(value={"application/json", "application/xml", "text/html"})
    @ApiOperation(value="Get the metric schedule for the passed id")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Response getSchedule(@ApiParam(value="Schedule Id") @PathParam(value="id") int scheduleId, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        EntityTag eTag;
        long tim;
        EntityTag eTag2;
        long tim2;
        Response.ResponseBuilder builder;
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        CacheControl cc = new CacheControl();
        cc.setMaxAge(300);
        cc.setPrivate(false);
        MeasurementSchedule schedule = this.getFromCache(scheduleId, MeasurementSchedule.class);
        if (schedule != null && (builder = request.evaluatePreconditions(new Date(tim2 = schedule.getMtime() != null ? schedule.getMtime() : 0L), eTag2 = new EntityTag(Long.toOctalString((long)schedule.hashCode() + tim2)))) != null) {
            builder.cacheControl(cc);
            return builder.build();
        }
        if (schedule == null) {
            schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId);
            if (schedule == null) {
                throw new StuffNotFoundException("Schedule with id " + scheduleId);
            }
            this.putToCache(scheduleId, MeasurementSchedule.class, schedule);
        }
        MeasurementDefinition definition = schedule.getDefinition();
        MetricSchedule metricSchedule = new MetricSchedule(schedule.getId(), definition.getName(), definition.getDisplayName(), schedule.isEnabled(), schedule.getInterval(), definition.getUnits().toString(), definition.getDataType().toString());
        metricSchedule.setDefinitionId(definition.getId());
        if (schedule.getMtime() != null) {
            metricSchedule.setMtime(schedule.getMtime());
        }
        if ((builder = request.evaluatePreconditions(new Date(tim = schedule.getMtime() != null ? schedule.getMtime() : 0L), eTag = new EntityTag(Long.toOctalString((long)schedule.hashCode() + tim)))) == null) {
            Link link;
            URI uri;
            UriBuilder uriBuilder;
            if (definition.getDataType() == DataType.MEASUREMENT) {
                uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("metric/data/" + scheduleId);
                uri = uriBuilder.build(new Object[0]);
                link = new Link("metric", uri.toString());
                metricSchedule.addLink(link);
            }
            uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("resource/" + schedule.getResource().getId());
            uri = uriBuilder.build(new Object[0]);
            link = new Link("resource", uri.toString());
            metricSchedule.addLink(link);
            uriBuilder = uriInfo.getAbsolutePathBuilder();
            uri = uriBuilder.build(new Object[0]);
            Link updateLink = new Link("edit", uri.toString());
            metricSchedule.addLink(updateLink);
            updateLink = new Link("self", uri.toString());
            metricSchedule.addLink(updateLink);
            metricSchedule.addLink(this.createUILink(uriInfo, UILinkTemplate.METRIC_SCHEDULE, schedule.getResource().getId()));
            builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("metricSchedule", metricSchedule), (MediaType)mediaType) : Response.ok((Object)metricSchedule, (MediaType)mediaType);
        }
        builder.cacheControl(cc);
        builder.tag(eTag);
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="data/resource/{resourceId}")
    @ApiOperation(value="Retrieve a list of high/low/average/data aggregates for the resource")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public List<MetricAggregate> getAggregatesForResource(@ApiParam(value="Id of the resource to query") @PathParam(value="resourceId") int resourceId, @ApiParam(value="Start time since epoch.", defaultValue="End time - 8h") @QueryParam(value="startTime") long startTime, @ApiParam(value="End time since epoch.", defaultValue="Now") @QueryParam(value="endTime") long endTime, @ApiParam(value="Include data points") @DefaultValue(value="false") @QueryParam(value="includeDataPoints") boolean includeDataPoints, @ApiParam(value="Number of buckets (if include data points))") @QueryParam(value="dataPoints") @DefaultValue(value="60") int dataPoints, @ApiParam(value="Hide rows that are NaN only", defaultValue="false") @QueryParam(value="hideEmpty") boolean hideEmpty) {
        long now = System.currentTimeMillis();
        if (endTime == 0L) {
            endTime = now;
        }
        if (startTime == 0L) {
            startTime = endTime - 28800000L;
        }
        this.fetchResource(resourceId);
        List<MeasurementSchedule> schedules = this.scheduleManager.findSchedulesForResourceAndType(this.caller, resourceId, DataType.MEASUREMENT, null, false);
        for (MeasurementSchedule sched : schedules) {
            this.putToCache(sched.getId(), MeasurementSchedule.class, sched);
        }
        ArrayList<MetricAggregate> ret = new ArrayList<MetricAggregate>(schedules.size());
        for (MeasurementSchedule schedule : schedules) {
            MeasurementAggregate aggr = this.dataManager.getMeasurementAggregate(this.caller, schedule.getId(), startTime, endTime);
            MetricAggregate res = new MetricAggregate(schedule.getId(), aggr.getMin(), aggr.getAvg(), aggr.getMax());
            if (includeDataPoints) {
                int definitionId = schedule.getDefinition().getId();
                List<List<MeasurementDataNumericHighLowComposite>> listList = this.dataManager.findDataForResource(this.caller, schedule.getResource().getId(), new int[]{definitionId}, startTime, endTime, dataPoints);
                if (!listList.isEmpty()) {
                    List<MeasurementDataNumericHighLowComposite> list = listList.get(0);
                    this.fillInDatapoints(res, list, schedule.getId(), hideEmpty, false);
                }
            }
            ret.add(res);
        }
        return ret;
    }

    @GZIP
    @GET
    @Path(value="data/group/{groupId}")
    @ApiOperation(value="Retrieve a list of high/low/average/data aggregates for the group")
    @ApiError(code=404, reason="There is no group with the passed id")
    public List<MetricDefinitionAggregate> getAggregatesForGroup(@ApiParam(value="Id of the group to query") @PathParam(value="groupId") int groupId, @ApiParam(value="Start time since epoch.", defaultValue="End time - 8h") @QueryParam(value="startTime") long startTime, @ApiParam(value="End time since epoch.", defaultValue="Now") @QueryParam(value="endTime") long endTime) {
        long now = System.currentTimeMillis();
        if (endTime == 0L) {
            endTime = now;
        }
        if (startTime == 0L) {
            startTime = endTime - 28800000L;
        }
        ResourceGroup group = this.fetchGroup(groupId, true);
        Set definitions = group.getResourceType().getMetricDefinitions();
        ArrayList<MetricDefinitionAggregate> ret = new ArrayList<MetricDefinitionAggregate>(definitions.size());
        for (MeasurementDefinition def : definitions) {
            if (def.getDataType() != DataType.MEASUREMENT) continue;
            MeasurementAggregate aggregate = this.dataManager.getAggregate(this.caller, groupId, def.getId(), startTime, endTime);
            MetricDefinitionAggregate res = new MetricDefinitionAggregate(def.getId(), aggregate.getMin(), aggregate.getAvg(), aggregate.getMax());
            ret.add(res);
        }
        return ret;
    }

    @PUT
    @Path(value="/schedule/{id}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Update the schedule (enabled, interval) ", responseClass="MetricSchedule")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Response updateSchedule(@ApiParam(value="Id of the schedule to update") @PathParam(value="id") int scheduleId, @ApiParam(value="New schedule data", required=true) MetricSchedule in, @Context HttpHeaders headers) {
        MeasurementSchedule schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId);
        if (schedule == null) {
            throw new StuffNotFoundException("Schedule with id " + scheduleId);
        }
        schedule.setEnabled(in.getEnabled().booleanValue());
        schedule.setInterval(in.getCollectionInterval());
        this.scheduleManager.updateSchedule(this.caller, schedule);
        schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId);
        this.putToCache(scheduleId, MeasurementSchedule.class, schedule);
        MeasurementDefinition def = schedule.getDefinition();
        MetricSchedule ret = new MetricSchedule(scheduleId, def.getName(), def.getDisplayName(), schedule.isEnabled(), schedule.getInterval(), def.getUnits().toString(), def.getDataType().toString());
        ret.setDefinitionId(def.getId());
        return Response.ok((Object)ret, (MediaType)((MediaType)headers.getAcceptableMediaTypes().get(0))).build();
    }

    @GET
    @Path(value="/definition/{id}")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Get the definition ", responseClass="MetricSchedule")
    @ApiError(code=404, reason="No definition exists for the given id.")
    public Response getDefinition(@ApiParam(value="Id of the definition to obtain") @PathParam(value="id") int definitionId, @Context HttpHeaders headers) {
        MeasurementDefinition measurementDefinition = this.definitionManager.getMeasurementDefinition(this.caller, definitionId);
        if (measurementDefinition == null) {
            throw new StuffNotFoundException("Definition with id " + definitionId);
        }
        MetricSchedule schedule = new MetricSchedule(definitionId, measurementDefinition.getName(), measurementDefinition.getDisplayName(), measurementDefinition.isDefaultOn(), measurementDefinition.getDefaultInterval(), measurementDefinition.getUnits().getName(), measurementDefinition.getDataType().name());
        return Response.ok((Object)schedule, (MediaType)((MediaType)headers.getAcceptableMediaTypes().get(0))).build();
    }

    @PUT
    @Path(value="/definition/{id}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Update the definition (default enabled, default interval)", notes="This operation may internally take a long time to complete and is thus only triggered by this call. A return code of 200 only indicates that the operation was successfully submitted.", responseClass="MetricSchedule")
    @ApiError(code=404, reason="No definition exists for the given id.")
    public Response updateDefinition(@ApiParam(value="Id of the definition to update") @PathParam(value="id") int definitionId, @ApiParam(value="New definition data", required=true) MetricSchedule in, @ApiParam(value="Update existing schedules for this definition as well?") @QueryParam(value="updateExisting") @DefaultValue(value="false") boolean updateExisting, @Context HttpHeaders headers) {
        MeasurementDefinition measurementDefinition = this.definitionManager.getMeasurementDefinition(this.caller, definitionId);
        if (measurementDefinition == null) {
            throw new StuffNotFoundException("Definition with id " + definitionId);
        }
        this.metricHandlerBean.submitDefinitionChange(definitionId, in, updateExisting);
        StringValue ret = new StringValue("Request submitted - this may take a while to complete.");
        return Response.ok((Object)ret, (MediaType)((MediaType)headers.getAcceptableMediaTypes().get(0))).build();
    }

    @Asynchronous
    public void submitDefinitionChange(int definitionId, MetricSchedule in, boolean updateExisting) {
        this.scheduleManager.updateDefaultCollectionIntervalAndEnablementForMeasurementDefinitions(this.caller, new int[]{definitionId}, in.getCollectionInterval(), in.getEnabled(), updateExisting);
    }

    @GZIP
    @ApiOperation(value="Expose the raw metrics of a single schedule. This can only expose raw data, which means the start date may not be older than 7 days.")
    @GET
    @Path(value="data/{scheduleId}/raw")
    @Produces(value={"application/json", "application/xml", "text/csv", "text/html"})
    @ApiErrors(value={@ApiError(code=404, reason="No schedule with the passed id exists")})
    public StreamingOutput getMetricDataRaw(@ApiParam(required=true) @PathParam(value="scheduleId") int scheduleId, @ApiParam(value="Start time since epoch", defaultValue="Now - 8h") @QueryParam(value="startTime") long startTime, @ApiParam(value="End time since epoch", defaultValue="Now") @QueryParam(value="endTime") long endTime, @ApiParam(defaultValue="8h = 28800000ms", value="Timespan in ms") @QueryParam(value="duration") long duration, @Context HttpHeaders headers) {
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        long now = System.currentTimeMillis();
        if (endTime == 0L) {
            endTime = now;
        }
        if (startTime == 0L) {
            startTime = endTime - 28800000L;
        }
        if (duration > 0L) {
            startTime = endTime - duration * 1000L;
        }
        if (startTime < now - 604800000L) {
            throw new IllegalArgumentException("(Computed) start time is older than 7 days");
        }
        if (startTime == endTime) {
            ++endTime;
        }
        this.obtainSchedule(scheduleId, false, DataType.MEASUREMENT);
        RawNumericStreamingOutput so = new RawNumericStreamingOutput();
        so.scheduleId = scheduleId;
        so.startTime = startTime;
        so.endTime = endTime;
        so.mediaType = mediaType;
        return so;
    }

    @PUT
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Submit a single (numerical) metric to the server")
    @ApiErrors(value={@ApiError(code=404, reason="No schedule with the passed id exists"), @ApiError(code=406, reason="Timestamp is older than 7 days")})
    @Path(value="data/{scheduleId}/raw/{timeStamp}")
    public Response putMetricValue(@ApiParam(value="Id of the schedule") @PathParam(value="scheduleId") int scheduleId, @ApiParam(value="Timestamp of the metric") @PathParam(value="timeStamp") long timestamp, @ApiParam(value="Data value", required=true) DoubleValue value, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        this.obtainSchedule(scheduleId, false, DataType.MEASUREMENT);
        long now = System.currentTimeMillis();
        if (timestamp < now - 604800000L) {
            throw new IllegalArgumentException("Timestamp is older than 7 days");
        }
        HashSet<MeasurementDataNumeric> data = new HashSet<MeasurementDataNumeric>(1);
        data.add(new MeasurementDataNumeric(timestamp, scheduleId, value.getValue()));
        this.dataManager.addNumericData(data);
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/metric/data/{scheduleId}/raw");
        uriBuilder.queryParam("startTime", new Object[]{timestamp});
        uriBuilder.queryParam("endTime", new Object[]{timestamp});
        URI uri = uriBuilder.build(new Object[]{scheduleId});
        return Response.created((URI)uri).type(mediaType).build();
    }

    @PUT
    @Path(value="data/{scheduleId}/trait/{timeStamp}")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Submit a new trait value for the passed schedule id")
    @ApiErrors(value={@ApiError(code=404, reason="No schedule with the passed id exists"), @ApiError(code=406, reason="Timestamp is older than 7 days")})
    public Response putTraitValue(@ApiParam(value="Id of the schedule") @PathParam(value="scheduleId") int scheduleId, @ApiParam(value="Timestamp of the metric") @PathParam(value="timeStamp") long timestamp, @ApiParam(value="Data value", required=true) StringValue value) {
        this.obtainSchedule(scheduleId, false, DataType.TRAIT);
        long now = System.currentTimeMillis();
        if (timestamp < now - 604800000L) {
            throw new IllegalArgumentException("Timestamp is older than 7 days");
        }
        HashSet<MeasurementDataTrait> traits = new HashSet<MeasurementDataTrait>(1);
        MeasurementDataPK pk = new MeasurementDataPK(timestamp, scheduleId);
        traits.add(new MeasurementDataTrait(pk, value.getValue()));
        this.dataManager.addTraitData(traits);
        return Response.ok().build();
    }

    @GET
    @Path(value="data/{scheduleId}/trait")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Get the current value of the trait with the passed schedule id", responseClass="StringValue")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Response getTraitValue(@ApiParam(value="Id of the schedule") @PathParam(value="scheduleId") int scheduleId) {
        Response.ResponseBuilder builder;
        MeasurementSchedule schedule = this.obtainSchedule(scheduleId, false, DataType.TRAIT);
        List<MeasurementDataTrait> traits = this.dataManager.findTraits(this.caller, schedule.getResource().getId(), schedule.getDefinition().getId());
        if (traits != null && traits.size() > 0) {
            builder = Response.ok();
            StringValue value = new StringValue(traits.get(0).getValue());
            builder.entity((Object)value);
        } else {
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
        }
        return builder.build();
    }

    @POST
    @Path(value="data/raw")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Submit a series of (numerical) metric values to the server", responseClass="No response")
    public Response postMetricValues(Collection<NumericDataPoint> points, @Context HttpHeaders headers) {
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        HashSet<MeasurementDataNumeric> data = new HashSet<MeasurementDataNumeric>(points.size());
        for (NumericDataPoint point : points) {
            data.add(new MeasurementDataNumeric(point.getTimeStamp(), point.getScheduleId(), point.getValue()));
        }
        this.dataManager.addNumericData(data);
        return Response.noContent().type(mediaType).build();
    }

    @POST
    @Path(value="data/raw/{resourceId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Submit a series of (numerical) metric values for a single resource to the server", responseClass="No response")
    public Response postMetricValues2(@PathParam(value="resourceId") int resourceId, Collection<Datapoint> points, @Context HttpHeaders headers) {
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        HashSet<MeasurementDataNumeric> data = new HashSet<MeasurementDataNumeric>(points.size());
        for (Datapoint point : points) {
            int scheduleId = this.findScheduleId(resourceId, point.getMetric());
            if (scheduleId <= 0) continue;
            data.add(new MeasurementDataNumeric(point.getTimestamp(), scheduleId, point.getValue()));
        }
        this.dataManager.addNumericData(data);
        return Response.noContent().type(mediaType).build();
    }

    private int findScheduleId(int resourceId, String metric) {
        AbstractRestBean.CacheKey key = new AbstractRestBean.CacheKey("schedulesForResource", resourceId);
        HashMap<String, Integer> schedulesForResource = (HashMap<String, Integer>)this.cache.get((Object)key);
        if (schedulesForResource != null && schedulesForResource.containsKey(metric)) {
            return (Integer)schedulesForResource.get(metric);
        }
        Resource res = this.fetchResource(resourceId);
        ResourceType resourceType = res.getResourceType();
        int[] definitionIds = new int[resourceType.getMetricDefinitions().size()];
        int i = 0;
        for (MeasurementDefinition def : resourceType.getMetricDefinitions()) {
            definitionIds[i] = def.getId();
            ++i;
        }
        List<MeasurementSchedule> schedules = this.scheduleManager.findSchedulesByResourceIdAndDefinitionIds(this.caller, resourceId, definitionIds);
        schedulesForResource = new HashMap<String, Integer>(schedules.size());
        for (MeasurementSchedule schedule : schedules) {
            schedulesForResource.put(schedule.getDefinition().getName(), schedule.getId());
        }
        this.cache.put((Object)key, schedulesForResource);
        return (Integer)schedulesForResource.get(metric);
    }

    @GET
    @Path(value="data/{scheduleId}/baseline")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Get the current baseline for the schedule")
    @ApiError(code=404, reason="No schedule with the passed id exists")
    public Baseline getBaseline(@ApiParam(value="Id of the schedule") @PathParam(value="scheduleId") int scheduleId) {
        MeasurementSchedule schedule = this.obtainSchedule(scheduleId, true, DataType.MEASUREMENT);
        MeasurementBaseline mBase = schedule.getBaseline();
        if (mBase == null) {
            throw new StuffNotFoundException("Baseline for schedule [" + scheduleId + "]");
        }
        Baseline b = new Baseline(mBase.getMin(), mBase.getMax(), mBase.getMean(), mBase.getComputeTime().getTime());
        return b;
    }

    @PUT
    @Path(value="data/{scheduleId}/baseline")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Set a new baseline for the schedule")
    @ApiErrors(value={@ApiError(code=404, reason="No schedule with the passed id exists"), @ApiError(code=406, reason="Baseline data is incorrect")})
    public Response setBaseline(@ApiParam(value="Id of the schedule") @PathParam(value="scheduleId") int scheduleId, Baseline baseline, @Context UriInfo uriInfo) {
        MeasurementSchedule schedule = this.obtainSchedule(scheduleId, false, DataType.MEASUREMENT);
        if (baseline.getMin() > baseline.getMean() || baseline.getMean() > baseline.getMax() || baseline.getMin() > baseline.getMax()) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
            builder.entity((Object)"Baseline not correct. it should be min<=mean<=max");
            return builder.build();
        }
        MeasurementBaseline mBase = schedule.getBaseline();
        if (mBase == null) {
            mBase = new MeasurementBaseline();
            mBase.setSchedule(schedule);
            schedule.setBaseline(mBase);
            this.em.persist((Object)mBase);
        }
        mBase.setMax(Double.valueOf(baseline.getMax()));
        mBase.setMin(Double.valueOf(baseline.getMin()));
        mBase.setMean(Double.valueOf(baseline.getMean()));
        mBase.setUserEntered(true);
        this.scheduleManager.updateSchedule(this.caller, schedule);
        return Response.created((URI)uriInfo.getRequestUriBuilder().build(new Object[0])).build();
    }

    private class RawNumericStreamingOutput
    implements StreamingOutput {
        int scheduleId;
        long startTime;
        long endTime;
        MediaType mediaType;

        private RawNumericStreamingOutput() {
        }

        public void write(OutputStream outputStream) throws IOException, WebApplicationException {
            MetricsDAO metricsDAO = MetricHandlerBean.this.sessionManager.getMetricsDAO();
            Iterable resultSet = metricsDAO.findRawMetrics(this.scheduleId, this.startTime, this.endTime);
            PrintWriter pw = new PrintWriter(outputStream);
            if (this.mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                boolean needsComma = false;
                pw.println("[");
                for (RawNumericMetric metric : resultSet) {
                    if (needsComma) {
                        pw.print(",\n");
                    }
                    needsComma = true;
                    pw.print("{");
                    pw.print("\"scheduleId\":");
                    pw.print(this.scheduleId);
                    pw.print(", ");
                    pw.print("\"timeStamp\":");
                    pw.print(metric.getTimestamp());
                    pw.print(", ");
                    pw.print("\"value\":");
                    pw.print(metric.getValue());
                    pw.print("}");
                }
                pw.println("]");
            } else if (this.mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
                pw.println("<collection>");
                for (RawNumericMetric metric : resultSet) {
                    pw.print("  <numericDataPoint scheduleId=\"");
                    pw.print(this.scheduleId);
                    pw.print("\" timeStamp=\"");
                    pw.print(metric.getTimestamp());
                    pw.print("\" value=\"");
                    pw.print(metric.getValue());
                    pw.println("\"/>");
                }
                pw.println("</collection>");
            } else if (this.mediaType.toString().equals("text/csv")) {
                pw.println("#schedule,timestamp,value");
                for (RawNumericMetric metric : resultSet) {
                    pw.print(this.scheduleId);
                    pw.print(',');
                    pw.print(metric.getTimestamp());
                    pw.print(',');
                    pw.println(metric.getValue());
                }
            } else if (this.mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
                pw.println("<table>");
                pw.print("<tr><th>time</th><th>value</th></tr>\n");
                for (RawNumericMetric metric : resultSet) {
                    pw.print("  <tr>");
                    pw.print("<td>");
                    pw.print(new Date(metric.getTimestamp()));
                    pw.print("</td><td>");
                    pw.print(metric.getValue());
                    pw.print("</td>");
                    pw.println("</tr>");
                }
                pw.println("</table>");
            }
            pw.flush();
            pw.close();
        }
    }
}

