/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.storage;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.cloud.StorageClusterSettings;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.storage.StorageClusterSettingsManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.server.metrics.StorageSession;

@Stateless
public class StorageClusterSettingsManagerBean
implements StorageClusterSettingsManagerLocal {
    private static final String UPDATE_PASSWORD_QUERY = "ALTER USER '%s' WITH PASSWORD '%s'";
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    private StorageClientManager storageClienManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public StorageClusterSettings getClusterSettings(Subject subject) {
        SystemSettings settings = this.systemManager.getUnmaskedSystemSettings(true);
        StorageClusterSettings clusterSettings = new StorageClusterSettings();
        if (!settings.containsKey((Object)SystemSetting.STORAGE_CQL_PORT)) {
            return null;
        }
        clusterSettings.setCqlPort(Integer.parseInt((String)settings.get((Object)SystemSetting.STORAGE_CQL_PORT)));
        if (!settings.containsKey((Object)SystemSetting.STORAGE_GOSSIP_PORT)) {
            return null;
        }
        clusterSettings.setGossipPort(Integer.parseInt((String)settings.get((Object)SystemSetting.STORAGE_GOSSIP_PORT)));
        if (!settings.containsKey((Object)SystemSetting.STORAGE_AUTOMATIC_DEPLOYMENT)) {
            return null;
        }
        clusterSettings.setAutomaticDeployment(Boolean.valueOf(Boolean.parseBoolean((String)settings.get((Object)SystemSetting.STORAGE_AUTOMATIC_DEPLOYMENT))));
        if (!settings.containsKey((Object)SystemSetting.STORAGE_USERNAME)) {
            return null;
        }
        clusterSettings.setUsername((String)settings.get((Object)SystemSetting.STORAGE_USERNAME));
        if (!settings.containsKey((Object)SystemSetting.STORAGE_PASSWORD)) {
            return null;
        }
        clusterSettings.setPasswordHash((String)settings.get((Object)SystemSetting.STORAGE_PASSWORD));
        return clusterSettings;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void setClusterSettings(Subject subject, StorageClusterSettings clusterSettings) {
        SystemSettings settings = new SystemSettings();
        settings.put(SystemSetting.STORAGE_CQL_PORT, Integer.toString(clusterSettings.getCqlPort()));
        settings.put(SystemSetting.STORAGE_GOSSIP_PORT, Integer.toString(clusterSettings.getGossipPort()));
        if (clusterSettings.getAutomaticDeployment() != null) {
            settings.put(SystemSetting.STORAGE_AUTOMATIC_DEPLOYMENT, Boolean.toString(clusterSettings.getAutomaticDeployment()));
        }
        if (clusterSettings.getUsername() != null) {
            settings.put(SystemSetting.STORAGE_USERNAME, clusterSettings.getUsername());
        }
        if (clusterSettings.getPasswordHash() != null) {
            this.updateStorageClusterCredentials(clusterSettings);
            settings.put(SystemSetting.STORAGE_PASSWORD, clusterSettings.getPasswordHash());
        }
        this.systemManager.setStorageClusterSettings(subject, settings);
    }

    private void updateStorageClusterCredentials(StorageClusterSettings newClusterSettings) {
        SystemSettings currentSettings = this.systemManager.getUnmaskedSystemSettings(true);
        String currentPassword = (String)currentSettings.get((Object)SystemSetting.STORAGE_PASSWORD);
        if (!currentPassword.equals(newClusterSettings.getPasswordHash())) {
            StorageSession session = this.storageClienManager.getSession();
            session.execute(String.format(UPDATE_PASSWORD_QUERY, currentSettings.get((Object)SystemSetting.STORAGE_USERNAME), newClusterSettings.getPasswordHash()));
        }
    }
}

