/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertDampeningEvent;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.enterprise.server.alert.AlertConditionLogManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.CachedConditionManagerLocal;
import org.rhq.enterprise.server.alert.engine.jms.model.AbstractAlertConditionMessage;
import org.rhq.enterprise.server.alert.engine.jms.model.ActiveAlertConditionMessage;
import org.rhq.enterprise.server.alert.engine.jms.model.InactiveAlertConditionMessage;

@Stateless
public class CachedConditionManagerBean
implements CachedConditionManagerLocal {
    private final Log log = LogFactory.getLog(CachedConditionManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    private AlertConditionLogManagerLocal alertConditionLogManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Alert processCachedConditionMessage(AbstractAlertConditionMessage conditionMessage, Integer definitionId) {
        Alert result = null;
        if (conditionMessage instanceof ActiveAlertConditionMessage) {
            ActiveAlertConditionMessage activeConditionMessage = (ActiveAlertConditionMessage)conditionMessage;
            if (!this.alertDefinitionManager.isEnabled(definitionId)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("AlertDefinition[id=" + activeConditionMessage.getAlertConditionId() + "] was already disabled " + "(likely due to recovery logic disablement on earlier messages in this process batch), " + "ignoring " + activeConditionMessage));
                }
                return result;
            }
            this.alertConditionLogManager.updateUnmatchedLogByAlertConditionId(activeConditionMessage.getAlertConditionId(), activeConditionMessage.getTimestamp(), activeConditionMessage.getValue());
            result = this.alertConditionLogManager.checkForCompletedAlertConditionSet(activeConditionMessage.getAlertConditionId());
        } else if (conditionMessage instanceof InactiveAlertConditionMessage) {
            this.alertConditionLogManager.removeUnmatchedLogByAlertConditionId(conditionMessage.getAlertConditionId());
            AlertDefinition flyWeightDefinition = new AlertDefinition();
            flyWeightDefinition.setId(definitionId.intValue());
            AlertDampeningEvent event = new AlertDampeningEvent(flyWeightDefinition, AlertDampeningEvent.Type.NEGATIVE);
            this.entityManager.persist((Object)event);
        } else {
            this.log.error((Object)("Unsupported message type sent to consumer for processing: " + conditionMessage.getClass().getSimpleName()));
        }
        return result;
    }
}

