/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.FutureFallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.cloud.StorageClusterSettings;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.cloud.StorageNodeConfigurationComposite;
import org.rhq.core.domain.cloud.StorageNodeLoadComposite;
import org.rhq.core.domain.common.JobTrigger;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceConfigurationUpdateCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.criteria.StorageNodeCriteria;
import org.rhq.core.domain.measurement.MeasurementAggregate;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.domain.util.collection.ArrayUtils;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.cloud.StorageNodeManagerRemote;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.rest.reporting.MeasurementConverter;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.storage.StorageClusterSettingsManagerLocal;
import org.rhq.enterprise.server.storage.StorageNodeOperationsHandlerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.server.metrics.MetricsServer;
import org.rhq.server.metrics.domain.AggregateNumericMetric;

@Stateless
public class StorageNodeManagerBean
implements StorageNodeManagerLocal,
StorageNodeManagerRemote {
    private final Log log = LogFactory.getLog(StorageNodeManagerBean.class);
    private static final String RHQ_STORAGE_JMX_PORT_PROPERTY = "jmxPort";
    private static final String RHQ_STORAGE_ADDRESS_PROPERTY = "host";
    private static final String RESTART_OPERATION = "restart";
    private static final String METRIC_TOKENS = "Tokens";
    private static final String METRIC_OWNERSHIP = "Ownership";
    private static final String METRIC_DATA_DISK_USED_PERCENTAGE = "Calculated.DataDiskUsedPercentage";
    private static final String METRIC_TOTAL_DISK_USED_PERCENTAGE = "Calculated.TotalDiskUsedPercentage";
    private static final String METRIC_FREE_DISK_TO_DATA_RATIO = "Calculated.FreeDiskToDataSizeRatio";
    private static final String METRIC_LOAD = "Load";
    private static final String METRIC_KEY_CACHE_SIZE = "KeyCacheSize";
    private static final String METRIC_ROW_CACHE_SIZE = "RowCacheSize";
    private static final String METRIC_TOTAL_COMMIT_LOG_SIZE = "TotalCommitlogSize";
    private static final String METRIC_HEAP_COMMITED = "{HeapMemoryUsage.committed}";
    private static final String METRIC_HEAP_USED = "{HeapMemoryUsage.used}";
    private static final String METRIC_HEAP_USED_PERCENTAGE = "Calculated.HeapUsagePercentage";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private MeasurementDataManagerLocal measurementManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private OperationManagerLocal operationManager;
    @EJB
    private AlertManagerLocal alertManager;
    @EJB
    private ConfigurationManagerLocal configurationManager;
    @EJB
    private StorageNodeManagerLocal storageNodeManager;
    @EJB
    private StorageClientManager storageClientManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private StorageClusterSettingsManagerLocal storageClusterSettingsManager;
    @EJB
    private StorageNodeOperationsHandlerLocal storageNodeOperationsHandler;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void linkResource(Resource resource) {
        Configuration pluginConfig = this.configurationManager.getPluginConfiguration(resource.getId());
        String address = pluginConfig.getSimpleValue(RHQ_STORAGE_ADDRESS_PROPERTY);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Linking " + resource + " to storage node at " + address));
        }
        try {
            StorageNode storageNode = this.storageNodeManager.findStorageNodeByAddress(address);
            if (storageNode == null) {
                if (InetAddresses.isInetAddress((String)address)) {
                    String hostName = InetAddresses.forString((String)address).getHostName();
                    this.log.info((Object)("Did not find storage node with address [" + address + "]. Searching by hostname [" + hostName + "]"));
                    storageNode = this.storageNodeManager.findStorageNodeByAddress(hostName);
                } else {
                    String ipAddress = InetAddress.getByName(address).getHostAddress();
                    this.log.info((Object)("Did not find storage node with address [" + address + "] Searching by IP address [" + ipAddress + "]"));
                    storageNode = this.storageNodeManager.findStorageNodeByAddress(ipAddress);
                }
            }
            if (storageNode != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)(storageNode + " is an existing storage node. No cluster maintenance is necessary."));
                }
                storageNode.setAddress(address);
                storageNode.setResource(resource);
                storageNode.setOperationMode(StorageNode.OperationMode.NORMAL);
                this.storageNodeManager.linkExistingStorageNodeToResource(storageNode);
            } else {
                StorageClusterSettings clusterSettings = this.storageClusterSettingsManager.getClusterSettings(this.subjectManager.getOverlord());
                storageNode = this.storageNodeManager.createStorageNode(resource, clusterSettings);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Scheduling cluster maintenance to deploy " + storageNode + " into the storage cluster..."));
                }
                if (clusterSettings.getAutomaticDeployment().booleanValue()) {
                    this.log.info((Object)("Deploying " + storageNode));
                    this.storageNodeManager.deployStorageNode(this.subjectManager.getOverlord(), storageNode);
                } else {
                    this.log.info((Object)("Automatic deployment is disabled. " + storageNode + " will not become part of the " + "cluster until it is deployed."));
                }
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Could not resolve address [" + address + "]. The resource " + resource + " cannot be linked to a storage node", e);
        }
    }

    @Override
    public StorageNode linkExistingStorageNodeToResource(StorageNode storageNode) {
        StorageNode existingStorageNode = (StorageNode)this.entityManager.find(StorageNode.class, (Object)storageNode.getId());
        if (null != existingStorageNode) {
            existingStorageNode.setAddress(storageNode.getAddress());
            existingStorageNode.setResource(storageNode.getResource());
            existingStorageNode.setOperationMode(storageNode.getOperationMode());
            storageNode = (StorageNode)this.entityManager.merge((Object)existingStorageNode);
        } else {
            this.log.info((Object)("Storage node did not exist, could not link to Resource. Returning unpersisted Storage Node " + storageNode));
        }
        return storageNode;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public StorageNode createStorageNode(Resource resource, StorageClusterSettings clusterSettings) {
        Configuration pluginConfig = resource.getPluginConfiguration();
        StorageNode storageNode = new StorageNode();
        storageNode.setAddress(pluginConfig.getSimpleValue(RHQ_STORAGE_ADDRESS_PROPERTY));
        storageNode.setCqlPort(clusterSettings.getCqlPort());
        storageNode.setResource(resource);
        storageNode.setOperationMode(StorageNode.OperationMode.INSTALLED);
        this.entityManager.persist((Object)storageNode);
        return storageNode;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void deployStorageNode(Subject subject, StorageNode storageNode) {
        StorageNodeCriteria c = new StorageNodeCriteria();
        c.addFilterId(Integer.valueOf(storageNode.getId()));
        c.fetchResource(true);
        PageList<StorageNode> storageNodes = this.storageNodeManager.findStorageNodesByCriteria(subject, c);
        if (storageNodes.isEmpty()) {
            throw new RuntimeException("Storage node not found, can not undeploy " + storageNode);
        }
        storageNode = (StorageNode)storageNodes.get(0);
        switch (storageNode.getOperationMode()) {
            case INSTALLED: {
                this.storageNodeOperationsHandler.setMode(storageNode, StorageNode.OperationMode.ANNOUNCE);
            }
            case ANNOUNCE: {
                this.storageNodeManager.resetInNewTransaction();
                this.storageNodeOperationsHandler.announceStorageNode(subject, storageNode);
                break;
            }
            case BOOTSTRAP: {
                this.storageNodeManager.resetInNewTransaction();
                this.storageNodeOperationsHandler.bootstrapStorageNode(subject, storageNode);
                break;
            }
            case ADD_MAINTENANCE: {
                this.storageNodeManager.resetInNewTransaction();
                this.storageNodeOperationsHandler.performAddNodeMaintenance(subject, storageNode);
                break;
            }
            default: {
                throw new RuntimeException("Cannot deploy " + storageNode);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void undeployStorageNode(Subject subject, StorageNode storageNode) {
        StorageNodeCriteria c = new StorageNodeCriteria();
        c.addFilterId(Integer.valueOf(storageNode.getId()));
        c.fetchResource(true);
        PageList<StorageNode> storageNodes = this.storageNodeManager.findStorageNodesByCriteria(subject, c);
        if (storageNodes.isEmpty()) {
            throw new RuntimeException("Storage node not found, can not undeploy " + storageNode);
        }
        storageNode = (StorageNode)storageNodes.get(0);
        switch (storageNode.getOperationMode()) {
            case INSTALLED: {
                this.storageNodeManager.resetInNewTransaction();
                this.storageNodeOperationsHandler.uninstall(subject, storageNode);
                break;
            }
            case ANNOUNCE: 
            case BOOTSTRAP: {
                this.storageNodeManager.resetInNewTransaction();
                this.storageNodeOperationsHandler.unannounceStorageNode(subject, storageNode);
                break;
            }
            case ADD_MAINTENANCE: 
            case NORMAL: 
            case DECOMMISSION: {
                this.storageNodeManager.resetInNewTransaction();
                this.storageNodeOperationsHandler.decommissionStorageNode(subject, storageNode);
                break;
            }
            case REMOVE_MAINTENANCE: {
                this.storageNodeManager.resetInNewTransaction();
                this.storageNodeOperationsHandler.performRemoveNodeMaintenance(subject, storageNode);
                break;
            }
            case UNANNOUNCE: {
                this.storageNodeManager.resetInNewTransaction();
                this.storageNodeOperationsHandler.unannounceStorageNode(subject, storageNode);
                break;
            }
            case UNINSTALL: {
                this.storageNodeManager.resetInNewTransaction();
                this.storageNodeOperationsHandler.uninstall(subject, storageNode);
                break;
            }
            default: {
                throw new RuntimeException("Cannot undeploy " + storageNode);
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void resetInNewTransaction() {
        for (StorageNode storageNode : this.getClusterNodes()) {
            storageNode.setErrorMessage(null);
            storageNode.setFailedOperation(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public StorageNodeLoadComposite getLoad(Subject subject, StorageNode node, long beginTime, long endTime) {
        Stopwatch stopwatch = this.stopwatchStart();
        try {
            Integer scheduleId;
            String definitionName;
            int storageNodeResourceId;
            if (!this.storageClientManager.isClusterAvailable()) {
                StorageNodeLoadComposite storageNodeLoadComposite = new StorageNodeLoadComposite(node, beginTime, endTime);
                return storageNodeLoadComposite;
            }
            try {
                storageNodeResourceId = this.getResourceIdFromStorageNode(node);
            }
            catch (ResourceNotFoundException e) {
                this.log.warn((Object)e.getMessage());
                StorageNodeLoadComposite storageNodeLoadComposite = new StorageNodeLoadComposite(node, beginTime, endTime);
                if (this.log.isDebugEnabled()) {
                    this.stopwatchEnd(stopwatch, "Retrieved load metrics for " + node + " in ");
                }
                return storageNodeLoadComposite;
            }
            HashMap<String, Integer> scheduleIdsMap = new HashMap<String, Integer>();
            for (Object[] tupple : this.getChildrenScheduleIds(storageNodeResourceId, false)) {
                definitionName = (String)tupple[0];
                scheduleId = (Integer)tupple[2];
                scheduleIdsMap.put(definitionName, scheduleId);
            }
            for (Object[] tupple : this.getGrandchildrenScheduleIds(storageNodeResourceId, false)) {
                definitionName = (String)tupple[0];
                scheduleId = (Integer)tupple[2];
                scheduleIdsMap.put(definitionName, scheduleId);
            }
            StorageNodeLoadComposite result = new StorageNodeLoadComposite(node, beginTime, endTime);
            MeasurementAggregate totalDiskUsedAggregate = new MeasurementAggregate(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0));
            Integer scheduleId2 = null;
            if (!scheduleIdsMap.isEmpty()) {
                try {
                    scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_TOKENS);
                    if (scheduleId2 != null) {
                        MeasurementAggregate tokensAggregate = this.measurementManager.getMeasurementAggregate(subject, scheduleId2, beginTime, endTime);
                        result.setTokens(tokensAggregate);
                    }
                    if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_OWNERSHIP)) != null) {
                        StorageNodeLoadComposite.MeasurementAggregateWithUnits ownershipAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.PERCENTAGE, beginTime, endTime);
                        result.setActuallyOwns(ownershipAggregateWithUnits);
                    }
                    if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_DATA_DISK_USED_PERCENTAGE)) != null) {
                        StorageNodeLoadComposite.MeasurementAggregateWithUnits dataDiskUsedPercentageAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.PERCENTAGE, beginTime, endTime);
                        result.setDataDiskUsedPercentage(dataDiskUsedPercentageAggregateWithUnits);
                    }
                    if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_TOTAL_DISK_USED_PERCENTAGE)) != null) {
                        StorageNodeLoadComposite.MeasurementAggregateWithUnits totalDiskUsedPercentageAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.PERCENTAGE, beginTime, endTime);
                        result.setTotalDiskUsedPercentage(totalDiskUsedPercentageAggregateWithUnits);
                    }
                    if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_FREE_DISK_TO_DATA_RATIO)) != null) {
                        MeasurementAggregate freeDiskToDataRatioAggregate = this.measurementManager.getMeasurementAggregate(subject, scheduleId2, beginTime, endTime);
                        result.setFreeDiskToDataSizeRatio(freeDiskToDataRatioAggregate);
                    }
                    if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_LOAD)) != null) {
                        StorageNodeLoadComposite.MeasurementAggregateWithUnits loadAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.BYTES, beginTime, endTime);
                        result.setLoad(loadAggregateWithUnits);
                        this.updateAggregateTotal(totalDiskUsedAggregate, loadAggregateWithUnits.getAggregate());
                    }
                    if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_KEY_CACHE_SIZE)) != null) {
                        this.updateAggregateTotal(totalDiskUsedAggregate, this.measurementManager.getMeasurementAggregate(subject, scheduleId2, beginTime, endTime));
                    }
                    if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_ROW_CACHE_SIZE)) != null) {
                        this.updateAggregateTotal(totalDiskUsedAggregate, this.measurementManager.getMeasurementAggregate(subject, scheduleId2, beginTime, endTime));
                    }
                    if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_TOTAL_COMMIT_LOG_SIZE)) != null) {
                        this.updateAggregateTotal(totalDiskUsedAggregate, this.measurementManager.getMeasurementAggregate(subject, scheduleId2, beginTime, endTime));
                    }
                    if (totalDiskUsedAggregate.getMax() > 0.0) {
                        StorageNodeLoadComposite.MeasurementAggregateWithUnits totalDiskUsedAggregateWithUnits = new StorageNodeLoadComposite.MeasurementAggregateWithUnits(totalDiskUsedAggregate, MeasurementUnits.BYTES);
                        totalDiskUsedAggregateWithUnits.setFormattedValue(this.getSummaryString(totalDiskUsedAggregate, MeasurementUnits.BYTES));
                        result.setDataDiskUsed(totalDiskUsedAggregateWithUnits);
                    }
                    if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_HEAP_COMMITED)) != null) {
                        StorageNodeLoadComposite.MeasurementAggregateWithUnits heapCommittedAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.BYTES, beginTime, endTime);
                        result.setHeapCommitted(heapCommittedAggregateWithUnits);
                    }
                    if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_HEAP_USED)) != null) {
                        StorageNodeLoadComposite.MeasurementAggregateWithUnits heapUsedAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.BYTES, beginTime, endTime);
                        result.setHeapUsed(heapUsedAggregateWithUnits);
                    }
                    if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_HEAP_USED_PERCENTAGE)) != null) {
                        StorageNodeLoadComposite.MeasurementAggregateWithUnits heapUsedPercentageAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.PERCENTAGE, beginTime, endTime);
                        result.setHeapPercentageUsed(heapUsedPercentageAggregateWithUnits);
                    }
                }
                catch (NoHostAvailableException nhae) {
                    StorageNodeLoadComposite storageNodeLoadComposite = new StorageNodeLoadComposite(node, beginTime, endTime);
                    if (this.log.isDebugEnabled()) {
                        this.stopwatchEnd(stopwatch, "Retrieved load metrics for " + node + " in ");
                    }
                    return storageNodeLoadComposite;
                }
            }
            StorageNodeLoadComposite storageNodeLoadComposite = result;
            return storageNodeLoadComposite;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.stopwatchEnd(stopwatch, "Retrieved load metrics for " + node + " in ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public ListenableFuture<List<StorageNodeLoadComposite>> getLoadAsync(Subject subject, StorageNode node, long beginTime, long endTime) {
        Stopwatch stopwatch = this.stopwatchStart();
        final StorageNodeLoadComposite result = new StorageNodeLoadComposite(node, beginTime, endTime);
        try {
            ListenableFuture compositeFuture;
            ListenableFuture<StorageNodeLoadComposite.MeasurementAggregateWithUnits> dataFuture;
            Integer scheduleId;
            String definitionName;
            int storageNodeResourceId;
            if (!this.storageClientManager.isClusterAvailable()) {
                ListenableFuture listenableFuture = Futures.successfulAsList((Iterable)Lists.newArrayList((Object[])new ListenableFuture[]{Futures.immediateFuture((Object)result)}));
                return listenableFuture;
            }
            try {
                storageNodeResourceId = this.getResourceIdFromStorageNode(node);
            }
            catch (ResourceNotFoundException e) {
                this.log.warn((Object)e.getMessage());
                ListenableFuture listenableFuture = Futures.successfulAsList((Iterable)Lists.newArrayList((Object[])new ListenableFuture[]{Futures.immediateFuture((Object)result)}));
                if (this.log.isDebugEnabled()) {
                    this.stopwatchEnd(stopwatch, "Retrieved load metrics for " + node + " in ");
                }
                return listenableFuture;
            }
            try {
                String host = InetAddress.getByName(node.getAddress()).getCanonicalHostName();
                if (!node.getAddress().equals(host)) {
                    result.setHostname(host + " (" + node.getAddress() + ")");
                }
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            MetricsServer metricsServer = this.storageClientManager.getMetricsServer();
            HashMap<String, Integer> scheduleIdsMap = new HashMap<String, Integer>();
            for (Object[] tupple : this.getChildrenScheduleIds(storageNodeResourceId, true)) {
                definitionName = (String)tupple[0];
                scheduleId = (Integer)tupple[2];
                scheduleIdsMap.put(definitionName, scheduleId);
            }
            for (Object[] tupple : this.getGrandchildrenScheduleIds(storageNodeResourceId, true)) {
                definitionName = (String)tupple[0];
                scheduleId = (Integer)tupple[2];
                scheduleIdsMap.put(definitionName, scheduleId);
            }
            ArrayList<ListenableFuture<StorageNodeLoadComposite>> compositeFutures = new ArrayList<ListenableFuture<StorageNodeLoadComposite>>();
            MeasurementAggregate totalDiskUsedAggregate = new MeasurementAggregate(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0));
            Integer scheduleId2 = null;
            if (scheduleIdsMap.isEmpty()) {
                scheduleId = Futures.successfulAsList((Iterable)Lists.newArrayList((Object[])new ListenableFuture[]{Futures.immediateFuture((Object)result)}));
                return scheduleId;
            }
            scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_FREE_DISK_TO_DATA_RATIO);
            if (scheduleId2 != null) {
                dataFuture = metricsServer.getSummaryAggregateAsync(scheduleId2.intValue(), beginTime, endTime);
                compositeFuture = Futures.transform((ListenableFuture)dataFuture, (Function)new Function<AggregateNumericMetric, StorageNodeLoadComposite>(){

                    public StorageNodeLoadComposite apply(AggregateNumericMetric metric) {
                        result.setFreeDiskToDataSizeRatio(new MeasurementAggregate(metric.getMin(), metric.getAvg(), metric.getMax()));
                        return result;
                    }
                });
                compositeFutures.add(this.wrapFuture((ListenableFuture<StorageNodeLoadComposite>)compositeFuture, result, "Failed to retrieve metric [Calculated.FreeDiskToDataSizeRatio] data for " + node));
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_HEAP_USED_PERCENTAGE)) != null) {
                dataFuture = this.getMeasurementAggregateWithUnitsAsync(scheduleId2, MeasurementUnits.PERCENTAGE, beginTime, endTime);
                compositeFuture = Futures.transform(dataFuture, (Function)new Function<StorageNodeLoadComposite.MeasurementAggregateWithUnits, StorageNodeLoadComposite>(){

                    public StorageNodeLoadComposite apply(StorageNodeLoadComposite.MeasurementAggregateWithUnits metric) {
                        result.setHeapPercentageUsed(metric);
                        return result;
                    }
                });
                compositeFutures.add(this.wrapFuture((ListenableFuture<StorageNodeLoadComposite>)compositeFuture, result, "Failed to retrieve metric [Calculated.HeapUsagePercentage] data for " + node));
            }
            ListenableFuture listenableFuture = Futures.successfulAsList(compositeFutures);
            return listenableFuture;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.stopwatchEnd(stopwatch, "Retrieved load metrics for " + node + " in ");
            }
        }
    }

    private ListenableFuture<StorageNodeLoadComposite> wrapFuture(ListenableFuture<StorageNodeLoadComposite> future, final StorageNodeLoadComposite value, final String msg) {
        return Futures.withFallback(future, (FutureFallback)new FutureFallback<StorageNodeLoadComposite>(){

            public ListenableFuture<StorageNodeLoadComposite> create(Throwable t) throws Exception {
                if (StorageNodeManagerBean.this.log.isDebugEnabled()) {
                    StorageNodeManagerBean.this.log.debug((Object)msg, t);
                } else {
                    StorageNodeManagerBean.this.log.info((Object)(msg + ": " + t.getMessage()));
                }
                return Futures.immediateFuture((Object)value);
            }
        });
    }

    private List<Object[]> getChildrenScheduleIds(int storageNodeResourceId, boolean lightWeight) {
        TypedQuery query = this.entityManager.createNamedQuery("StorageNode.findScheduleIdsByParentResourceIdAndMeasurementDefinitionNames", Object[].class);
        query.setParameter("parrentId", (Object)storageNodeResourceId).setParameter("metricNames", lightWeight ? METRIC_FREE_DISK_TO_DATA_RATIO : Arrays.asList(METRIC_TOKENS, METRIC_OWNERSHIP, METRIC_LOAD, METRIC_KEY_CACHE_SIZE, METRIC_ROW_CACHE_SIZE, METRIC_TOTAL_COMMIT_LOG_SIZE, METRIC_DATA_DISK_USED_PERCENTAGE, METRIC_TOTAL_DISK_USED_PERCENTAGE, METRIC_FREE_DISK_TO_DATA_RATIO));
        return query.getResultList();
    }

    private List<Object[]> getGrandchildrenScheduleIds(int storageNodeResourceId, boolean lightWeight) {
        TypedQuery query = this.entityManager.createNamedQuery("StorageNode.findScheduleIdsByGrandparentResourceIdAndMeasurementDefinitionNames", Object[].class);
        query.setParameter("grandparrentId", (Object)storageNodeResourceId).setParameter("metricNames", lightWeight ? METRIC_HEAP_USED_PERCENTAGE : Arrays.asList(METRIC_HEAP_COMMITED, METRIC_HEAP_USED, METRIC_HEAP_USED_PERCENTAGE));
        return query.getResultList();
    }

    private void updateAggregateTotal(MeasurementAggregate accumulator, MeasurementAggregate input) {
        if (!(accumulator == null || input == null || input.getMax() == null || Double.isNaN(input.getMax()) || input.getMin() == null || Double.isNaN(input.getMin()) || input.getAvg() == null || Double.isNaN(input.getAvg()))) {
            accumulator.setAvg(Double.valueOf(accumulator.getAvg() + input.getAvg()));
            accumulator.setMax(Double.valueOf(accumulator.getMax() + input.getMax()));
            accumulator.setMin(Double.valueOf(accumulator.getMin() + input.getMin()));
        }
    }

    @Override
    public List<StorageNode> getStorageNodes() {
        TypedQuery query = this.entityManager.createNamedQuery("StorageNode.findAll", StorageNode.class);
        return query.getResultList();
    }

    @Override
    public List<StorageNode> getClusterNodes() {
        return this.entityManager.createNamedQuery("StorageNode.findAllByModes", StorageNode.class).setParameter("operationModes", Arrays.asList(StorageNode.OperationMode.NORMAL, StorageNode.OperationMode.MAINTENANCE)).getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<StorageNodeLoadComposite> getStorageNodeComposites(Subject subject) {
        Stopwatch stopwatch = this.stopwatchStart();
        List<StorageNode> nodes = this.getStorageNodes();
        final CountDownLatch latch = new CountDownLatch(nodes.size());
        final PageList result = new PageList();
        try {
            long endTime = System.currentTimeMillis();
            long beginTime = endTime - 28800000L;
            Iterator<StorageNode> i$ = nodes.iterator();
            while (i$.hasNext()) {
                StorageNode node;
                final StorageNode theNode = node = i$.next();
                if (node.getOperationMode() != StorageNode.OperationMode.INSTALLED) {
                    ListenableFuture<List<StorageNodeLoadComposite>> compositesFuture = this.getLoadAsync(subject, node, beginTime, endTime);
                    Futures.addCallback(compositesFuture, (FutureCallback)new FutureCallback<List<StorageNodeLoadComposite>>(){

                        public void onSuccess(List<StorageNodeLoadComposite> composites) {
                            for (StorageNodeLoadComposite composite : composites) {
                                if (composites.isEmpty()) {
                                    StorageNodeManagerBean.this.log.warn((Object)"The results from getLoadAsync() should not be empty. This is likely a bug.");
                                    continue;
                                }
                                result.add((Object)composite);
                                break;
                            }
                            latch.countDown();
                        }

                        public void onFailure(Throwable t) {
                            StorageNodeManagerBean.this.log.warn((Object)("An error occurred while fetching load data for " + theNode), t);
                            latch.countDown();
                        }
                    });
                    continue;
                }
                result.add((Object)new StorageNodeLoadComposite(node, beginTime, endTime));
                latch.countDown();
            }
            Map<Integer, Integer> alertCounts = this.findUnackedAlertCounts(nodes);
            for (StorageNodeLoadComposite composite : result) {
                Integer count = alertCounts.get(composite.getStorageNode().getId());
                if (count == null) continue;
                composite.setUnackAlerts(count.intValue());
            }
            latch.await();
            PageList pageList = result;
            return pageList;
        }
        catch (InterruptedException e) {
            this.log.info((Object)"There was an interrupt while waiting for storage node load data.", (Throwable)e);
            PageList pageList = result;
            return pageList;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.stopwatchEnd(stopwatch, "Retrieved storage node composites in ");
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<StorageNode> findStorageNodesByCriteria(Subject subject, StorageNodeCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner runner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return runner.execute();
    }

    @Override
    public StorageNode findStorageNodeByAddress(String address) {
        TypedQuery query = this.entityManager.createNamedQuery("StorageNode.findByAddress", StorageNode.class);
        query.setParameter("address", (Object)address);
        List result = query.getResultList();
        if (result != null && result.size() > 0) {
            return (StorageNode)result.get(0);
        }
        return null;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void prepareNodeForUpgrade(Subject subject, StorageNode storageNode) {
        int storageNodeResourceId = this.getResourceIdFromStorageNode(storageNode);
        OperationManagerLocal operationManager = LookupUtil.getOperationManager();
        Configuration parameters = new Configuration();
        parameters.setSimpleValue("snapshotName", String.valueOf(System.currentTimeMillis()));
        operationManager.scheduleResourceOperation(subject, storageNodeResourceId, "prepareForUpgrade", 0L, 0L, 0, 0, parameters, "Run by StorageNodeManagerBean.prepareNodeForUpgrade()");
    }

    private String getSummaryString(MeasurementAggregate aggregate, MeasurementUnits units) {
        String formattedValue = "Min: " + MeasurementConverter.format(aggregate.getMin(), units, true) + ", Max: " + MeasurementConverter.format(aggregate.getMax(), units, true) + ", Avg: " + MeasurementConverter.format(aggregate.getAvg(), units, true);
        return formattedValue;
    }

    private StorageNodeLoadComposite.MeasurementAggregateWithUnits getMeasurementAggregateWithUnits(Subject subject, int schedId, MeasurementUnits units, long beginTime, long endTime) {
        MetricsServer metricsServer = this.storageClientManager.getMetricsServer();
        AggregateNumericMetric metric = metricsServer.getSummaryAggregate(schedId, beginTime, endTime);
        MeasurementAggregate measurementAggregate = new MeasurementAggregate(metric.getMin(), metric.getAvg(), metric.getMax());
        StorageNodeLoadComposite.MeasurementAggregateWithUnits measurementAggregateWithUnits = new StorageNodeLoadComposite.MeasurementAggregateWithUnits(measurementAggregate, units);
        measurementAggregateWithUnits.setFormattedValue(this.getSummaryString(measurementAggregate, units));
        return measurementAggregateWithUnits;
    }

    private ListenableFuture<StorageNodeLoadComposite.MeasurementAggregateWithUnits> getMeasurementAggregateWithUnitsAsync(int schedId, final MeasurementUnits units, long beginTime, long endTime) {
        MetricsServer metricsServer = this.storageClientManager.getMetricsServer();
        ListenableFuture dataFuture = metricsServer.getSummaryAggregateAsync(schedId, beginTime, endTime);
        return Futures.transform((ListenableFuture)dataFuture, (Function)new Function<AggregateNumericMetric, StorageNodeLoadComposite.MeasurementAggregateWithUnits>(){

            public StorageNodeLoadComposite.MeasurementAggregateWithUnits apply(AggregateNumericMetric metric) {
                MeasurementAggregate measurementAggregate = new MeasurementAggregate(metric.getMin(), metric.getAvg(), metric.getMax());
                StorageNodeLoadComposite.MeasurementAggregateWithUnits measurementAggregateWithUnits = new StorageNodeLoadComposite.MeasurementAggregateWithUnits(measurementAggregate, units);
                return measurementAggregateWithUnits;
            }
        });
    }

    private int getResourceIdFromStorageNode(StorageNode storageNode) {
        int storageNodeId = storageNode.getId();
        if (storageNode.getResource() == null) {
            if ((storageNode = (StorageNode)this.entityManager.find(StorageNode.class, (Object)storageNode.getId())) == null) {
                throw new ResourceNotFoundException("There is no storage node with id [" + storageNodeId + "] stored in the database.");
            }
            if (storageNode.getResource() == null) {
                throw new IllegalStateException("This storage node [" + storageNode.getId() + "] has no associated resource.");
            }
        }
        int resourceId = storageNode.getResource().getId();
        return resourceId;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void runClusterMaintenance(Subject subject) {
        List<StorageNode> storageNodes = this.getClusterNodes();
        for (StorageNode storageNode : storageNodes) {
            Resource test = storageNode.getResource();
            ResourceCriteria criteria = new ResourceCriteria();
            criteria.addFilterParentResourceId(Integer.valueOf(test.getId()));
            criteria.addFilterResourceTypeName("StorageService");
            criteria.setPageControl(PageControl.getUnlimitedInstance());
            PageList<Resource> resources = this.resourceManager.findResourcesByCriteria(this.subjectManager.getOverlord(), criteria);
            if (resources.size() <= 0) continue;
            Resource storageServiceResource = (Resource)resources.get(0);
            ResourceOperationSchedule newSchedule = new ResourceOperationSchedule();
            newSchedule.setJobTrigger(JobTrigger.createNowTrigger());
            newSchedule.setResource(storageServiceResource);
            newSchedule.setOperationName("takeSnapshot");
            newSchedule.setDescription("Run by StorageNodeManagerBean");
            newSchedule.setParameters(new Configuration());
            this.storageNodeManager.scheduleOperationInNewTransaction(this.subjectManager.getOverlord(), newSchedule);
        }
        if (storageNodes.size() == 1) {
            this.log.info((Object)"Skipping scheduled repair since this is a single-node cluster");
        } else {
            this.storageNodeOperationsHandler.runRepair(this.subjectManager.getOverlord(), storageNodes);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<Alert> findNotAcknowledgedStorageNodeAlerts(Subject subject) {
        return this.findStorageNodeAlerts(subject, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<Alert> findNotAcknowledgedStorageNodeAlerts(Subject subject, StorageNode storageNode) {
        Stopwatch stopwatch = this.stopwatchStart();
        try {
            PageList<Alert> pageList = this.findStorageNodeAlerts(subject, false, storageNode);
            return pageList;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.stopwatchEnd(stopwatch, "Retrieved unacked alerts for " + storageNode + " in ");
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<Alert> findAllStorageNodeAlerts(Subject subject) {
        return this.findStorageNodeAlerts(subject, true, null);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<Alert> findAllStorageNodeAlerts(Subject subject, StorageNode storageNode) {
        return this.findStorageNodeAlerts(subject, true, storageNode);
    }

    private PageList<Alert> findStorageNodeAlerts(Subject subject, boolean allAlerts, StorageNode storageNode) {
        Integer[] resouceIdsWithAlertDefinitions = this.findResourcesWithAlertDefinitions(storageNode);
        PageList alerts = new PageList();
        if (resouceIdsWithAlertDefinitions != null && resouceIdsWithAlertDefinitions.length != 0) {
            AlertCriteria criteria = new AlertCriteria();
            criteria.setPageControl(PageControl.getUnlimitedInstance());
            criteria.addFilterResourceIds(resouceIdsWithAlertDefinitions);
            criteria.addSortCtime(PageOrdering.DESC);
            alerts = this.alertManager.findAlertsByCriteria(subject, criteria);
            if (!allAlerts) {
                PageList trimmedAlerts = new PageList();
                for (Alert alert : alerts) {
                    if (alert.getAcknowledgeTime() != null && alert.getAcknowledgeTime() > 0L) continue;
                    trimmedAlerts.add((Object)alert);
                }
                alerts = trimmedAlerts;
            }
        }
        return alerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Integer> findUnackedAlertCounts(List<StorageNode> storageNodes) {
        Stopwatch stopwatch = this.stopwatchStart();
        try {
            TreeMap<Integer, StorageNode> resourceIdToStorageNodeMap = new TreeMap<Integer, StorageNode>();
            for (StorageNode storageNode : storageNodes) {
                if (storageNode.getResource() == null) continue;
                resourceIdToStorageNodeMap.put(storageNode.getResource().getId(), storageNode);
            }
            TreeMap<Integer, Integer> storageNodeAlertCounts = new TreeMap<Integer, Integer>();
            Map<Integer, Integer> alertCountsByResource = this.findStorageNodeAlertCountsByResource();
            Iterator<Integer> i$ = alertCountsByResource.keySet().iterator();
            while (i$.hasNext()) {
                Integer resourceId;
                Integer currentResourceId = resourceId = i$.next();
                while (!resourceIdToStorageNodeMap.containsKey(currentResourceId)) {
                    currentResourceId = ((Resource)this.entityManager.find(Resource.class, (Object)currentResourceId)).getParentResource().getId();
                }
                Integer alertsForResource = alertCountsByResource.get(resourceId);
                StorageNode storageNode = (StorageNode)resourceIdToStorageNodeMap.get(currentResourceId);
                Integer count = (Integer)storageNodeAlertCounts.get(storageNode.getId());
                if (count == null) {
                    storageNodeAlertCounts.put(storageNode.getId(), alertsForResource);
                    continue;
                }
                storageNodeAlertCounts.put(storageNode.getId(), count + alertsForResource);
            }
            TreeMap<Integer, Integer> treeMap = storageNodeAlertCounts;
            return treeMap;
        }
        finally {
            this.stopwatchEnd(stopwatch, "Finished calculating storage node alert counts in ");
        }
    }

    private Map<Integer, Integer> findStorageNodeAlertCountsByResource() {
        List counts = this.entityManager.createNamedQuery("StorageNode.findUnackedAlertsCounts").getResultList();
        TreeMap<Integer, Integer> alertCounts = new TreeMap<Integer, Integer>();
        for (Object[] row : counts) {
            Integer resourceId = (Integer)row[0];
            Integer count = ((Long)row[1]).intValue();
            alertCounts.put(resourceId, count);
        }
        return alertCounts;
    }

    @Override
    public Map<Integer, Integer> findResourcesWithAlertDefinitions() {
        return this.findResourcesWithAlertsToStorageNodeMap(null);
    }

    @Override
    public Integer[] findResourcesWithAlertDefinitions(StorageNode storageNode) {
        Map<Integer, Integer> result = this.findResourcesWithAlertsToStorageNodeMap(storageNode);
        if (result != null) {
            Set<Integer> resourceIds = result.keySet();
            return resourceIds.toArray(new Integer[resourceIds.size()]);
        }
        return new Integer[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Integer> findResourcesWithAlertsToStorageNodeMap(StorageNode storageNode) {
        Stopwatch stopwatch = this.stopwatchStart();
        List<StorageNode> initialStorageNodes = this.getStorageNodes();
        try {
            initialStorageNodes = storageNode == null ? this.getStorageNodes() : Arrays.asList(storageNode.getResource() == null ? (StorageNode)this.entityManager.find(StorageNode.class, (Object)storageNode.getId()) : storageNode);
            HashMap<Integer, Integer> resourceIdsToStorageNodeMap = new HashMap<Integer, Integer>();
            LinkedList<Resource> unvisitedResources = new LinkedList<Resource>();
            for (StorageNode initialStorageNode : initialStorageNodes) {
                if (initialStorageNode.getResource() == null) continue;
                unvisitedResources.add(initialStorageNode.getResource());
                while (!unvisitedResources.isEmpty()) {
                    Set childResources;
                    Resource resource = (Resource)unvisitedResources.poll();
                    if (!resource.getAlertDefinitions().isEmpty()) {
                        resourceIdsToStorageNodeMap.put(resource.getId(), initialStorageNode.getId());
                    }
                    if ((childResources = resource.getChildResources()) == null) continue;
                    for (Resource child : childResources) {
                        unvisitedResources.add(child);
                    }
                }
            }
            HashMap<Integer, Integer> hashMap = resourceIdsToStorageNodeMap;
            return hashMap;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.stopwatchEnd(stopwatch, "Found storage node resources with alert defs in ");
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public StorageNodeConfigurationComposite retrieveConfiguration(Subject subject, StorageNode storageNode) {
        StorageNodeConfigurationComposite configuration = new StorageNodeConfigurationComposite(storageNode);
        if (storageNode != null && storageNode.getResource() != null) {
            Resource storageNodeResource = storageNode.getResource();
            ResourceConfigurationUpdate configurationUpdate = this.configurationManager.getLatestResourceConfigurationUpdate(subject, storageNodeResource.getId());
            Configuration storageNodeConfiguration = configurationUpdate.getConfiguration();
            Configuration storageNodePluginConfiguration = this.configurationManager.getPluginConfiguration(subject, storageNodeResource.getId());
            if (configurationUpdate != null) {
                configuration.setHeapSize(storageNodeConfiguration.getSimpleValue("maxHeapSize"));
                configuration.setHeapNewSize(storageNodeConfiguration.getSimpleValue("heapNewSize"));
                configuration.setThreadStackSize(storageNodeConfiguration.getSimpleValue("threadStackSize"));
            }
            configuration.setJmxPort(Integer.parseInt(storageNodePluginConfiguration.getSimpleValue(RHQ_STORAGE_JMX_PORT_PROPERTY)));
        }
        return configuration;
    }

    @Override
    @Asynchronous
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void updateConfigurationAsync(Subject subject, StorageNodeConfigurationComposite storageNodeConfiguration) {
        this.updateConfiguration(subject, storageNodeConfiguration);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public boolean updateConfiguration(Subject subject, StorageNodeConfigurationComposite storageNodeConfiguration) {
        StorageNode storageNode = this.findStorageNodeByAddress(storageNodeConfiguration.getStorageNode().getAddress());
        if (storageNode == null || storageNode.getResource() == null || !storageNodeConfiguration.validate()) {
            return false;
        }
        Resource storageNodeResource = storageNode.getResource();
        Configuration storageNodeResourceConfig = this.configurationManager.getResourceConfiguration(subject, storageNodeResource.getId());
        String existingHeapSize = storageNodeResourceConfig.getSimpleValue("maxHeapSize");
        String newHeapSize = storageNodeConfiguration.getHeapSize();
        String existingHeapNewSize = storageNodeResourceConfig.getSimpleValue("heapNewSize");
        String newHeapNewSize = storageNodeConfiguration.getHeapNewSize();
        String existingThreadStackSize = storageNodeResourceConfig.getSimpleValue("threadStackSize");
        String newThreadStackSize = storageNodeConfiguration.getThreadStackSize();
        Configuration storageNodePluginConfig = this.configurationManager.getPluginConfiguration(subject, storageNodeResource.getId());
        String existingJMXPort = storageNodePluginConfig.getSimpleValue(RHQ_STORAGE_JMX_PORT_PROPERTY);
        String newJMXPort = storageNodeConfiguration.getJmxPort() + "";
        boolean resourceConfigNeedsUpdate = !existingHeapSize.equals(newHeapSize) || !existingHeapNewSize.equals(newHeapNewSize) || !existingThreadStackSize.equals(newThreadStackSize) || !existingJMXPort.equals(newJMXPort);
        ResourceConfigurationUpdate resourceUpdate = null;
        if (resourceConfigNeedsUpdate) {
            storageNodeResourceConfig.setSimpleValue(RHQ_STORAGE_JMX_PORT_PROPERTY, storageNodeConfiguration.getJmxPort() + "");
            if (storageNodeConfiguration.getHeapSize() != null) {
                storageNodeResourceConfig.setSimpleValue("maxHeapSize", newHeapSize + "");
                storageNodeResourceConfig.setSimpleValue("minHeapSize", newHeapSize + "");
            }
            if (storageNodeConfiguration.getHeapNewSize() != null) {
                storageNodeResourceConfig.setSimpleValue("heapNewSize", newHeapNewSize + "");
            }
            if (storageNodeConfiguration.getThreadStackSize() != null) {
                storageNodeResourceConfig.setSimpleValue("threadStackSize", newThreadStackSize + "");
            }
            resourceUpdate = this.configurationManager.updateResourceConfiguration(subject, storageNodeResource.getId(), storageNodeResourceConfig);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ResourceConfigurationUpdateCriteria criteria = new ResourceConfigurationUpdateCriteria();
            criteria.addFilterId(Integer.valueOf(resourceUpdate.getId()));
            criteria.addFilterStartTime(Long.valueOf(System.currentTimeMillis() - 300000L));
            boolean updateSuccess = this.waitForConfigurationUpdateToFinish(subject, criteria, 10);
            boolean restartSuccess = this.runOperationAndWaitForResult(subject, storageNodeResource, RESTART_OPERATION, null, 5000L, 15);
            if (!updateSuccess || !restartSuccess) {
                return false;
            }
        }
        if (existingJMXPort.equals(newJMXPort)) {
            return true;
        }
        storageNodePluginConfig.setSimpleValue(RHQ_STORAGE_JMX_PORT_PROPERTY, newJMXPort);
        String existingConnectionURL = storageNodePluginConfig.getSimpleValue("connectorAddress");
        String newConnectionURL = existingConnectionURL.replace(":" + existingJMXPort + "/", ":" + storageNodeConfiguration.getJmxPort() + "/");
        storageNodePluginConfig.setSimpleValue("connectorAddress", newConnectionURL);
        this.configurationManager.updatePluginConfiguration(subject, storageNodeResource.getId(), storageNodePluginConfig);
        return true;
    }

    private boolean waitForConfigurationUpdateToFinish(Subject subject, ResourceConfigurationUpdateCriteria criteria, int maxAttempts) {
        if (maxAttempts == 0) {
            return false;
        }
        PageList<ResourceConfigurationUpdate> configUpdates = this.configurationManager.findResourceConfigurationUpdatesByCriteria(subject, criteria);
        switch (((ResourceConfigurationUpdate)configUpdates.get(0)).getStatus()) {
            case INPROGRESS: {
                break;
            }
            case FAILURE: {
                return false;
            }
            default: {
                return true;
            }
        }
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException e) {
            return false;
        }
        return this.waitForConfigurationUpdateToFinish(subject, criteria, maxAttempts - 1);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void scheduleOperationInNewTransaction(Subject subject, ResourceOperationSchedule schedule) {
        this.operationManager.scheduleResourceOperation(subject, schedule);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public Map<String, List<MeasurementDataNumericHighLowComposite>> findStorageNodeLoadDataForLast(Subject subject, StorageNode node, long beginTime, long endTime, int numPoints) {
        int storageNodeResourceId;
        if (!this.storageClientManager.isClusterAvailable()) {
            return Collections.emptyMap();
        }
        try {
            storageNodeResourceId = this.getResourceIdFromStorageNode(node);
        }
        catch (ResourceNotFoundException e) {
            this.log.warn((Object)e.getMessage());
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<MeasurementDataNumericHighLowComposite>> result = new LinkedHashMap<String, List<MeasurementDataNumericHighLowComposite>>();
        List<Object[]> tupples = this.getChildrenScheduleIds(storageNodeResourceId, false);
        ArrayList<String> defNames = new ArrayList<String>();
        HashMap resourceWithDefinitionIds = new HashMap();
        for (Object[] tupple : tupples) {
            String defName = (String)tupple[0];
            int definitionId = (Integer)tupple[1];
            int resId = (Integer)tupple[3];
            defNames.add(defName);
            if (resourceWithDefinitionIds.get(resId) == null) {
                resourceWithDefinitionIds.put(resId, new ArrayList(tupples.size()));
            }
            ((List)resourceWithDefinitionIds.get(resId)).add(definitionId);
        }
        int defNameIndex = 0;
        for (Map.Entry entry : resourceWithDefinitionIds.entrySet()) {
            List<List<MeasurementDataNumericHighLowComposite>> storageServiceData = this.measurementManager.findDataForResource(subject, (Integer)entry.getKey(), ArrayUtils.unwrapCollection((Collection)((Collection)entry.getValue())), beginTime, endTime, numPoints);
            for (int i = 0; i < storageServiceData.size(); ++i) {
                List<MeasurementDataNumericHighLowComposite> oneRecord = storageServiceData.get(i);
                result.put((String)defNames.get(defNameIndex++), this.filterNans(oneRecord));
            }
        }
        tupples = this.getGrandchildrenScheduleIds(storageNodeResourceId, false);
        defNames = new ArrayList();
        int[] definitionIds = new int[tupples.size()];
        definitionIds = new int[tupples.size()];
        int resId = -1;
        int index = 0;
        for (Object[] tupple : tupples) {
            String defName = (String)tupple[0];
            int definitionId = (Integer)tupple[1];
            resId = (Integer)tupple[3];
            defNames.add(defName);
            definitionIds[index++] = definitionId;
        }
        List<List<MeasurementDataNumericHighLowComposite>> memorySubsystemData = this.measurementManager.findDataForResource(subject, resId, definitionIds, beginTime, endTime, numPoints);
        for (int i = 0; i < memorySubsystemData.size(); ++i) {
            List<MeasurementDataNumericHighLowComposite> oneRecord = memorySubsystemData.get(i);
            result.put((String)defNames.get(i), this.filterNans(oneRecord));
        }
        return result;
    }

    private List<MeasurementDataNumericHighLowComposite> filterNans(List<MeasurementDataNumericHighLowComposite> data) {
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MeasurementDataNumericHighLowComposite> filteredData = new ArrayList<MeasurementDataNumericHighLowComposite>(data.size());
        for (MeasurementDataNumericHighLowComposite number : data) {
            if (Double.isNaN(number.getValue())) continue;
            filteredData.add(number);
        }
        return filteredData;
    }

    private boolean runOperationAndWaitForResult(Subject subject, Resource storageNodeResource, String operationToRun, Configuration parameters, long operationQueryTimeout, int maxIterations) {
        long operationStartTime = System.currentTimeMillis();
        ResourceOperationSchedule newSchedule = new ResourceOperationSchedule();
        newSchedule.setJobTrigger(JobTrigger.createNowTrigger());
        newSchedule.setResource(storageNodeResource);
        newSchedule.setOperationName(operationToRun);
        newSchedule.setDescription("Run by StorageNodeManagerBean");
        newSchedule.setParameters(parameters);
        this.storageNodeManager.scheduleOperationInNewTransaction(subject, newSchedule);
        boolean successResultFound = false;
        for (int iteration = 0; iteration < maxIterations && !successResultFound; ++iteration) {
            ResourceOperationHistoryCriteria criteria = new ResourceOperationHistoryCriteria();
            criteria.addFilterResourceIds(new Integer[]{storageNodeResource.getId()});
            criteria.addFilterStartTime(Long.valueOf(operationStartTime));
            criteria.addFilterOperationName(operationToRun);
            criteria.addFilterStatus(OperationRequestStatus.SUCCESS);
            criteria.setPageControl(PageControl.getUnlimitedInstance());
            PageList<ResourceOperationHistory> results = this.operationManager.findResourceOperationHistoriesByCriteria(subject, criteria);
            if (results != null && results.size() > 0) {
                successResultFound = true;
            }
            if (successResultFound) break;
            try {
                Thread.sleep(operationQueryTimeout);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
        return successResultFound;
    }

    private Stopwatch stopwatchStart() {
        if (this.log.isDebugEnabled()) {
            return new Stopwatch().start();
        }
        return null;
    }

    private void stopwatchEnd(Stopwatch stopwatch, String message) {
        if (stopwatch != null && this.log.isDebugEnabled()) {
            stopwatch.stop();
            this.log.debug((Object)(message + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
        }
    }
}

