/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.measurement.MeasurementAggregate;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.RHQConstants;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.cloud.StatusManagerLocal;
import org.rhq.enterprise.server.measurement.BaselineCreationException;
import org.rhq.enterprise.server.measurement.DataNotAvailableException;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementNotFoundException;
import org.rhq.enterprise.server.measurement.MeasurementOOBManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.server.metrics.MetricsBaselineCalculator;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:jboss/datasources/RHQDS")
public class MeasurementBaselineManagerBean
implements MeasurementBaselineManagerLocal,
MeasurementBaselineManagerRemote {
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private StatusManagerLocal agentStatusManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private MeasurementDataManagerLocal dataManager;
    @EJB
    private MeasurementScheduleManagerLocal measurementScheduleManager;
    @EJB
    private MeasurementBaselineManagerLocal measurementBaselineManager;
    @EJB
    private MeasurementOOBManagerLocal oobManager;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private StorageClientManager sessionManager;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    private final Log log = LogFactory.getLog(MeasurementBaselineManagerBean.class);
    private static final int BASELINE_PROCESSING_LIMIT = 100;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void calculateAutoBaselines() {
        Properties conf = this.systemManager.getSystemConfiguration(this.subjectManager.getOverlord());
        String baselineFrequencyString = conf.getProperty(RHQConstants.BaselineFrequency);
        String baselineDataSetString = conf.getProperty(RHQConstants.BaselineDataSet);
        this.log.debug((Object)("Found baseline defaults: frequency=" + baselineFrequencyString + " dataset=" + baselineDataSetString));
        long amountOfData = Long.parseLong(baselineDataSetString);
        long baselineFrequency = Long.parseLong(baselineFrequencyString);
        if (baselineFrequency == 0L) {
            this.log.info((Object)"Baseline frequency is set to 0 - not recomputing baselines. Go to Admin->System settings to change this.");
            return;
        }
        long baselinesOlderThanTime = System.currentTimeMillis() - baselineFrequency;
        this.measurementBaselineManager.calculateAutoBaselines(amountOfData, baselinesOlderThanTime);
        conf = this.systemManager.getSystemConfiguration(this.subjectManager.getOverlord());
        try {
            this.systemManager.setSystemConfiguration(this.subjectManager.getOverlord(), conf, true);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to remember the time when we just calc'ed baselines - it may recalculate again soon.", (Throwable)e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public long calculateAutoBaselines(long amountOfData, long baselinesOlderThanTime) {
        try {
            long now;
            this.log.info((Object)"Calculating auto baselines");
            this.log.info((Object)("Deleting baselines computations older than " + new Date(baselinesOlderThanTime)));
            this.log.info((Object)("Inserting new baselines using last " + amountOfData / 86400000L + " days of 1H data"));
            long computeTime = now = System.currentTimeMillis();
            this.log.debug((Object)("computeTime = " + computeTime));
            int deleted = this.measurementBaselineManager._calculateAutoBaselinesDELETE(baselinesOlderThanTime);
            this.log.info((Object)("Removed [" + deleted + "] old baselines - they will now be recalculated (" + (System.currentTimeMillis() - now) + ")ms"));
            now = System.currentTimeMillis();
            List<Integer> schedulesWithoutBaselines = this.measurementBaselineManager.getSchedulesWithoutBaselines();
            ArrayList<Integer> accumulator = new ArrayList<Integer>();
            for (Integer value : schedulesWithoutBaselines) {
                accumulator.add(value);
                if (accumulator.size() != 100) continue;
                this.measurementBaselineManager.calculateBaselines(accumulator, now, amountOfData);
                accumulator.clear();
            }
            if (!accumulator.isEmpty()) {
                this.measurementBaselineManager.calculateBaselines(accumulator, now, amountOfData);
                accumulator.clear();
            }
            this.log.info((Object)("Calculated and inserted [" + schedulesWithoutBaselines.size() + "] new baselines. (" + (System.currentTimeMillis() - now) + ")ms"));
            MeasurementMonitor.getMBean().incrementBaselineCalculationTime(System.currentTimeMillis() - computeTime);
            this.agentStatusManager.updateByAutoBaselineCalculationJob();
            return computeTime;
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to auto-calculate baselines", (Throwable)e);
            throw new RuntimeException("Auto-calculation failure", e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int _calculateAutoBaselinesDELETE(long olderThanTime) throws Exception {
        Query query = this.entityManager.createNamedQuery("MeasurementBaseline.deleteByComputeTime");
        query.setParameter("timestamp", (Object)olderThanTime);
        int rowsAffected = query.executeUpdate();
        return rowsAffected;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<Integer> getSchedulesWithoutBaselines() {
        Connection connection = null;
        try {
            connection = this.rhqDs.getConnection();
            DatabaseType databaseType = DatabaseTypeFactory.getDatabaseType((Connection)connection);
            String sql = "SELECT s.id FROM rhq_measurement_sched s INNER JOIN rhq_measurement_def d ON s.definition = d.id LEFT JOIN rhq_measurement_bline b ON s.id = b.schedule_id WHERE s.enabled = " + databaseType.getBooleanValue(true) + " AND b.schedule_id IS NULL AND d.numeric_type = 0";
            Query query = this.entityManager.createNativeQuery(sql);
            List results = query.getResultList();
            ArrayList<Integer> scheduleIds = new ArrayList<Integer>();
            for (Object object : results) {
                scheduleIds.add(databaseType.getInteger(object));
            }
            ArrayList<Integer> arrayList = scheduleIds;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("An unexpected error occurred while trying to retrieve schedules without baselines", e);
        }
        finally {
            JDBCUtil.safeClose((Connection)connection);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void calculateBaselines(List<Integer> schedules, long olderThan, long amountOfData) {
        long endTime = olderThan;
        long startTime = endTime - amountOfData;
        this.log.debug((Object)("Computing baselines for " + schedules.size() + " schedules"));
        MetricsBaselineCalculator baselineCalculator = new MetricsBaselineCalculator(this.sessionManager.getMetricsDAO());
        long calcStartTime = System.currentTimeMillis();
        List results = baselineCalculator.calculateBaselines(schedules, startTime, endTime);
        long calcEndTime = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finished computing " + results.size() + " new baselines in " + (calcEndTime - calcStartTime) + " ms"));
        }
        this.log.debug((Object)"Persisting baselines calculations");
        long saveStartTime = System.currentTimeMillis();
        this.measurementBaselineManager.saveNewBaselines(results);
        long saveEndTime = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finished persisting " + results.size() + " baselines in " + (saveEndTime - saveStartTime) + " ms"));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void saveNewBaselines(List<MeasurementBaseline> baselines) {
        for (MeasurementBaseline baseline : baselines) {
            MeasurementSchedule schedule = new MeasurementSchedule();
            schedule.setId(baseline.getScheduleId());
            baseline.setSchedule(schedule);
            this.entityManager.merge((Object)baseline);
        }
    }

    @Override
    public MeasurementBaseline getBaselineIfEqual(Subject subject, int groupId, int definitionId) {
        Query query = this.entityManager.createQuery("SELECT MIN(mb.baselineMin),  MAX(mb.baselineMin),        MIN(mb.baselineMean), MAX(mb.baselineMean),        MIN(mb.baselineMax),  MAX(mb.baselineMax),        COUNT(mb.id)   FROM MeasurementBaseline mb   JOIN mb.schedule ms   JOIN ms.resource res   JOIN res.implicitGroups rg  WHERE rg.id = :groupId    AND ms.definition.id = :definitionId ");
        query.setParameter("groupId", (Object)groupId);
        query.setParameter("definitionId", (Object)definitionId);
        Object[] results = (Object[])query.getSingleResult();
        MeasurementBaseline baseline = new MeasurementBaseline();
        if ((Long)results[6] == 0L) {
            return null;
        }
        if (results[0] == null || results[1] == null) {
            baseline.setMin(null);
        } else if (Math.abs((Double)results[0] - (Double)results[1]) < 1.0E-9) {
            baseline.setMin((Double)results[0]);
        } else {
            baseline.setMin(Double.valueOf(-1.0));
        }
        if (results[2] == null || results[3] == null) {
            baseline.setMean(null);
        } else if (Math.abs((Double)results[2] - (Double)results[3]) < 1.0E-9) {
            baseline.setMean((Double)results[2]);
        } else {
            baseline.setMean(Double.valueOf(-1.0));
        }
        if (results[4] == null || results[5] == null) {
            baseline.setMax(null);
        } else if (Math.abs((Double)results[4] - (Double)results[5]) < 1.0E-9) {
            baseline.setMax((Double)results[4]);
        } else {
            baseline.setMax(Double.valueOf(-1.0));
        }
        return baseline;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public MeasurementBaseline calculateAutoBaseline(Subject subject, Integer measurementScheduleId, long startDate, long endDate, boolean save) throws BaselineCreationException, MeasurementNotFoundException {
        MeasurementBaseline result = this.measurementBaselineManager.calculateAutoBaselineInNewTransaction(subject, measurementScheduleId, startDate, endDate, save);
        if (save) {
            this.agentStatusManager.updateByMeasurementBaseline(result.getId());
        }
        return result;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public MeasurementBaseline calculateAutoBaselineInNewTransaction(Subject subject, Integer measurementScheduleId, long startDate, long endDate, boolean save) throws BaselineCreationException, MeasurementNotFoundException {
        MeasurementBaseline baseline;
        MeasurementSchedule sched = (MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)measurementScheduleId);
        if (sched != null) {
            org.rhq.core.domain.resource.Resource resource = sched.getResource();
            if (save && !this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_MEASUREMENTS, resource.getId())) {
                this.log.error((Object)("Cannot calculate baseline - permission denied. resource=" + resource + "; user=" + subject + "; perm=" + Permission.MANAGE_MEASUREMENTS));
                throw new PermissionException("Cannot calculate baseline - you do not have permission on this resource");
            }
        } else {
            throw new MeasurementNotFoundException("Scheduled measurement [" + measurementScheduleId + "] not found");
        }
        try {
            baseline = this.calculateBaseline(sched, true, startDate, endDate, save);
            if (save) {
                this.oobManager.removeOOBsForSchedule(subject, sched);
            }
        }
        catch (DataNotAvailableException e) {
            throw new BaselineCreationException("Error fetching data for baseline calculation for measurementSchedule[id=" + measurementScheduleId + "]");
        }
        return baseline;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public MeasurementBaseline calculateAutoBaseline(Subject subject, int groupId, int definitionId, long startDate, long endDate, boolean save) throws BaselineCreationException, MeasurementNotFoundException {
        MeasurementBaseline result = this.measurementBaselineManager.calculateAutoBaselineForGroupInNewTransaction(subject, groupId, definitionId, startDate, endDate, save);
        if (save) {
            this.agentStatusManager.updateByMeasurementBaseline(result.getId());
        }
        return result;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public MeasurementBaseline calculateAutoBaselineForGroupInNewTransaction(Subject subject, int groupId, int definitionId, long startDate, long endDate, boolean save) throws BaselineCreationException, MeasurementNotFoundException {
        MeasurementBaseline baseline;
        if (save && !this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_MEASUREMENTS, groupId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to calculate and set baselines for group[id=" + groupId + "]");
        }
        try {
            baseline = this.calculateBaselineForGroup(groupId, definitionId, true, startDate, endDate, save);
            if (save) {
                this.oobManager.removeOOBsForGroupAndDefinition(subject, groupId, definitionId);
            }
        }
        catch (DataNotAvailableException e) {
            throw new BaselineCreationException("Error fetching data for baseline calculation for group[id=" + groupId + "], definition[id=" + definitionId + "]");
        }
        return baseline;
    }

    @Override
    public void enableAutoBaselineCalculation(Subject subject, Integer[] resourceIds, Integer[] definitionIds) {
        if (resourceIds.length < 1 || definitionIds.length < 1) {
            return;
        }
        List<MeasurementBaseline> bList = this.getBaselinesForResourcesAndDefinitionIds(resourceIds, definitionIds);
        for (MeasurementBaseline bl : bList) {
            if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_MEASUREMENTS, bl.getSchedule().getResource().getId())) {
                throw new PermissionException("Cannot enable baseline [" + bl + "] - you do not have permission");
            }
            bl.setUserEntered(false);
        }
    }

    private List<MeasurementBaseline> getBaselinesForResourcesAndDefinitionIds(Integer[] resourceIds, Integer[] definitionIds) {
        Query q = this.entityManager.createNamedQuery("MeasurementBaseline.findBaselineForResourceIdsAndDefinitionIds");
        q.setParameter("resourceIds", Arrays.asList(resourceIds));
        q.setParameter("definitionIds", Arrays.asList(definitionIds));
        List bList = q.getResultList();
        return bList;
    }

    private MeasurementBaseline calculateBaseline(MeasurementSchedule schedule, boolean userEntered, long startDate, long endDate, boolean save) throws DataNotAvailableException, BaselineCreationException {
        if (schedule.getDefinition().getNumericType() != NumericType.DYNAMIC) {
            throw new BaselineCreationException("Baseline calculation is only valid for a dynamic measurement");
        }
        MeasurementAggregate agg = this.dataManager.getMeasurementAggregate(this.subjectManager.getOverlord(), schedule.getId(), startDate, endDate);
        schedule = (MeasurementSchedule)this.entityManager.merge((Object)schedule);
        MeasurementBaseline baseline = null;
        if (save && schedule.getBaseline() != null) {
            baseline = schedule.getBaseline();
        } else {
            baseline = new MeasurementBaseline();
            if (save) {
                baseline.setSchedule(schedule);
            }
        }
        baseline.setUserEntered(userEntered);
        baseline.setMean(agg.getAvg());
        baseline.setMin(agg.getMin());
        baseline.setMax(agg.getMax());
        if (save) {
            this.entityManager.persist((Object)baseline);
            this.entityManager.merge((Object)schedule);
        }
        return baseline;
    }

    private MeasurementBaseline calculateBaselineForGroup(int groupId, int definitionId, boolean userEntered, long startDate, long endDate, boolean save) throws DataNotAvailableException, BaselineCreationException {
        MeasurementAggregate agg = this.dataManager.getAggregate(this.subjectManager.getOverlord(), groupId, definitionId, startDate, endDate);
        Subject overlord = this.subjectManager.getOverlord();
        List<Integer> resourceIds = this.resourceManager.findImplicitResourceIdsByResourceGroup(groupId);
        List<MeasurementSchedule> schedules = this.measurementScheduleManager.findSchedulesByResourceIdsAndDefinitionId(overlord, ArrayUtils.unwrapCollection(resourceIds), definitionId);
        MeasurementBaseline baseline = null;
        for (MeasurementSchedule schedule : schedules) {
            schedule = (MeasurementSchedule)this.entityManager.merge((Object)schedule);
            if (save && schedule.getBaseline() != null) {
                baseline = schedule.getBaseline();
            } else {
                baseline = new MeasurementBaseline();
                if (save) {
                    baseline.setSchedule(schedule);
                }
            }
            baseline.setUserEntered(userEntered);
            baseline.setMean(agg.getAvg());
            baseline.setMin(agg.getMin());
            baseline.setMax(agg.getMax());
            if (!save) continue;
            this.entityManager.persist((Object)baseline);
            this.entityManager.merge((Object)schedule);
        }
        return baseline;
    }

    @Override
    public List<MeasurementBaseline> findBaselinesForResource(Subject subject, int resourceId) {
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User[" + subject.getName() + " ] does not have permission to view baselines for resource[id=" + resourceId + "]");
        }
        Query query = this.entityManager.createNamedQuery("MeasurementBaseline.findBaselinesForResource");
        query.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        return results;
    }
}

