/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScannerMBean;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.IntegerValue;
import org.rhq.enterprise.server.rest.domain.StringValue;
import org.rhq.enterprise.server.util.LookupUtil;

@Path(value="/content")
@Api(value="Content related", description="This endpoint deals with content (upload)")
@Produces(value={"application/json", "application/xml"})
@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class ContentHandlerBean
extends AbstractRestBean {
    private static final String TMP_FILE_PREFIX = "rhq-rest-";
    private static final String TMP_FILE_SUFFIX = ".bin";

    @POST
    @Path(value="/fresh")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/xml", "application/json"})
    @ApiOperation(value="Upload content to the server. This will return a handle that can be used later to retrieve and further process the content")
    public Response uploadContent(InputStream contentStream, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws IOException {
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        File outFile = File.createTempFile(TMP_FILE_PREFIX, TMP_FILE_SUFFIX, tmpDir);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outFile));
        StreamUtil.copy((InputStream)contentStream, (OutputStream)bos, (boolean)true);
        String fileHandle = outFile.getName();
        StringValue sv = new StringValue(fileHandle);
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/content/{handle}");
        URI uri = uriBuilder.build(new Object[]{fileHandle});
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = Response.created((URI)uri);
        builder.entity((Object)sv);
        builder.type(mediaType);
        return builder.build();
    }

    @GET
    @Path(value="/{handle}/info")
    @ApiOperation(value="Retrieve the length of the content with the passed handle")
    public IntegerValue getInfo(@PathParam(value="handle") String handle) {
        File content = this.getFileForHandle(handle);
        if (!content.exists() || !content.canRead()) {
            throw new StuffNotFoundException("Content with handle " + handle);
        }
        long len = content.length();
        IntegerValue iv = new IntegerValue((int)len);
        return iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{handle}/plugins")
    @ApiErrors(value={@ApiError(code=406, reason="No name provided"), @ApiError(code=404, reason="No content for handle found"), @ApiError(code=403, reason="Caller has not rights to upload plugins")})
    @ApiOperation(value="Put the uploaded content into the plugin drop box. ", notes="This endpoint allows to deploy previously uploaded content as a plugin. You need to providea valid plugin (file) name in order for the plugin processing to succeed. Optionally you canrequest that a plugin scan will be started and the plugin be registered in the system.The content identified by the handle is not removed.")
    public Response provideAsPlugin(@ApiParam(value="Name of the handle retrieved from upload") @PathParam(value="handle") String handle, @ApiParam(value="Name of the plugin file") @QueryParam(value="name") String name, @ApiParam(value="Should a discovery scan be started?") @QueryParam(value="scan") @DefaultValue(value="false") boolean startScan, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        if (name == null || name.isEmpty()) {
            throw new BadArgumentException("A valid 'name' must be given");
        }
        File content = this.getFileForHandle(handle);
        if (!content.exists() || !content.canRead()) {
            throw new StuffNotFoundException("Content with handle " + handle);
        }
        try {
            boolean isAllowed = LookupUtil.getAuthorizationManager().hasGlobalPermission(this.caller, Permission.MANAGE_SETTINGS);
            if (!isAllowed) {
                this.log.error((Object)("An unauthorized user [" + this.caller + "] attempted to upload a plugin"));
                throw new PermissionException("You are not authorized to do this");
            }
            File dir = LookupUtil.getPluginManager().getPluginDropboxDirectory();
            File targetFile = new File(dir, name);
            FileOutputStream fos = new FileOutputStream(targetFile);
            try {
                FileInputStream fis = new FileInputStream(content);
                try {
                    StreamUtil.copy((InputStream)fis, (OutputStream)fos);
                }
                finally {
                    fis.close();
                }
            }
            finally {
                fos.close();
            }
            if (startScan) {
                PluginDeploymentScannerMBean scanner = LookupUtil.getPluginDeploymentScanner();
                scanner.scanAndRegister();
            }
            builder = Response.ok();
        }
        catch (Exception e) {
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            builder.entity((Object)e.getMessage());
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder.type(mediaType);
        return builder.build();
    }

    @DELETE
    @Path(value="/{handle}")
    @ApiOperation(value="Remove the content with the passed handle", notes="This operation is by default idempotent, returning 204.If you want to check if the content existed at all, you need to pass the 'validate' query parameter.")
    @ApiErrors(value={@ApiError(code=204, reason="Content was deleted or did not exist with validation not set"), @ApiError(code=404, reason="Content did not exist and validate was set")})
    public Response removeUploadedContent(@PathParam(value="handle") String handle, @ApiParam(value="Validate if the content exists") @QueryParam(value="validate") @DefaultValue(value="false") boolean validate) {
        Response.ResponseBuilder builder;
        File content = this.getFileForHandle(handle);
        if (!content.exists()) {
            if (validate) {
                throw new StuffNotFoundException("Content with handle " + handle);
            }
            builder = Response.noContent();
        } else {
            boolean deleted = content.delete();
            if (deleted) {
                builder = Response.noContent();
            } else {
                builder = Response.serverError();
                System.err.println("Deletion of " + content.getAbsolutePath() + " failed");
            }
        }
        return builder.build();
    }

    private File getFileForHandle(String handle) {
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        return new File(tmpDir, handle);
    }
}

