/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.rhq.core.domain.criteria.EventCriteria;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.EventDefinitionRest;
import org.rhq.enterprise.server.rest.domain.EventRest;
import org.rhq.enterprise.server.rest.domain.EventSourceRest;

@Path(value="/event")
@Api(value="Api that deals with Events (e.g snmp traps, logfile lines)")
@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class EventHandlerBean
extends AbstractRestBean {
    @EJB
    EventManagerLocal eventManager;
    @PersistenceContext(unitName="rhqpu")
    EntityManager em;

    @GET
    @Path(value="/{id}/sources")
    @ApiOperation(value="List the defined event sources for the resource", responseClass="EventSourceRest", multiValueResponse=true)
    public Response listEventSourcesForResource(@ApiParam(value="id of the resource") @PathParam(value="id") int resourceId, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        Resource res = this.fetchResource(resourceId);
        Set eventSources = res.getEventSources();
        ArrayList<EventSourceRest> restSources = new ArrayList<EventSourceRest>(eventSources.size());
        for (EventSource source : eventSources) {
            EventSourceRest esr = this.convertEventSource(source);
            restSources.add(esr);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            GenericEntity<List<EventSourceRest>> list = new GenericEntity<List<EventSourceRest>>(restSources){};
            builder = Response.ok((Object)list, (MediaType)mediaType);
        } else {
            builder = Response.ok(restSources, (MediaType)mediaType);
        }
        return builder.build();
    }

    @GET
    @Path(value="/{id}/definitions")
    @ApiOperation(value="List the defined event source definitions for the resource", responseClass="EventDefintionRest", multiValueResponse=true)
    public Response listEventDefinitionsForResource(@ApiParam(value="id of the resource") @PathParam(value="id") int resourceId, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        Resource res = this.fetchResource(resourceId);
        ResourceType resourceType = res.getResourceType();
        this.em.refresh((Object)resourceType);
        Set eventDefinitions = resourceType.getEventDefinitions();
        ArrayList<EventDefinitionRest> definitionsRest = new ArrayList<EventDefinitionRest>(eventDefinitions.size());
        for (EventDefinition source : eventDefinitions) {
            EventDefinitionRest esr = new EventDefinitionRest();
            esr.setDescription(source.getDescription());
            esr.setId(source.getId());
            esr.setDisplayName(source.getDisplayName());
            esr.setName(source.getName());
            definitionsRest.add(esr);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            GenericEntity<List<EventDefinitionRest>> list = new GenericEntity<List<EventDefinitionRest>>(definitionsRest){};
            builder = Response.ok((Object)list, (MediaType)mediaType);
        } else {
            builder = Response.ok(definitionsRest, (MediaType)mediaType);
        }
        return builder.build();
    }

    @GET
    @Path(value="/source/{id}")
    @ApiOperation(value="Retrieve the event source with the passed id", responseClass="EventSourceRest")
    @ApiError(code=404, reason="There is no event source with the passed id")
    public EventSourceRest getEventSource(@ApiParam(value="Id of the source to retrieve") @PathParam(value="id") int sourceId) {
        EventSource source = this.findEventSourceById(sourceId);
        EventSourceRest esr = this.convertEventSource(source);
        return esr;
    }

    @POST
    @Path(value="/{id}/sources")
    @ApiOperation(value="Add a new event source for a resource. This can e.g. be a different logfile. The source.name must match an existing definition fo this resource. If an event source for the definition name and resource with the same location already exists, no new source is created. NOTE: An Event source added this way will not show up in the connection properties.")
    @ApiErrors(value={@ApiError(code=404, reason="Resource with the passed id does not exist"), @ApiError(code=404, reason="Event definition with the passed name not found"), @ApiError(code=406, reason="Tried to create an event source on the same definition with the same location")})
    public EventSourceRest addEventSource(@ApiParam(value="id of the resource") @PathParam(value="id") int resourceId, EventSourceRest esr) {
        EventSource source;
        Resource resource = this.fetchResource(resourceId);
        ResourceType rt = resource.getResourceType();
        Set eventDefinitions = rt.getEventDefinitions();
        EventDefinition eventDefinition = null;
        for (EventDefinition ed : eventDefinitions) {
            if (!ed.getName().equals(esr.getName())) continue;
            eventDefinition = ed;
            break;
        }
        if (eventDefinition == null) {
            throw new StuffNotFoundException("eventDefinition with name " + esr.getName());
        }
        Query q = this.em.createQuery("SELECT es FROM EventSource es WHERE es.location = :location AND es.eventDefinition = :definition AND es.resourceId = :resourceId");
        q.setParameter("location", (Object)esr.getLocation());
        q.setParameter("definition", (Object)eventDefinition);
        q.setParameter("resourceId", (Object)resourceId);
        List sources = q.getResultList();
        if (sources.isEmpty()) {
            source = new EventSource(esr.getLocation(), eventDefinition, resource);
            this.em.persist((Object)source);
        } else if (sources.size() == 1) {
            source = (EventSource)sources.get(0);
        } else {
            throw new IllegalStateException("We have more than one EventSource on the same Definition with the same location - must not happen");
        }
        EventSourceRest result = this.convertEventSource(source);
        return result;
    }

    @DELETE
    @Path(value="/source/{id}")
    @ApiOperation(value="Delete the event source with the passed id", notes="This operation is by default idempotent, returning 204.If you want to check if the source existed at all, you need to pass the 'validate' query parameter.")
    @ApiErrors(value={@ApiError(code=204, reason="Source was deleted or did not exist with validation not set"), @ApiError(code=404, reason="Source did not exist and validate was set")})
    public Response deleteEventSource(@ApiParam(value="Id of the source to delete") @PathParam(value="id") int sourceId, @ApiParam(value="Validate if the content exists") @QueryParam(value="validate") @DefaultValue(value="false") boolean validate) {
        EventSource source = (EventSource)this.em.find(EventSource.class, (Object)sourceId);
        if (source != null) {
            this.em.remove((Object)source);
        } else if (validate) {
            throw new StuffNotFoundException("Event source with id " + sourceId);
        }
        return Response.noContent().build();
    }

    @GET
    @GZIP
    @Path(value="/source/{id}/events")
    @ApiOperation(value="List the events for the event source with the passed id. If no time range is given, the last 200 entries will be displayed", responseClass="EventRest", multiValueResponse=true)
    public Response getEventsForSource(@PathParam(value="id") int sourceId, @QueryParam(value="startTime") long startTime, @QueryParam(value="endTime") long endTime, @ApiParam(value="Select the severity to display. Default is to show all", allowableValues="DEBUG, INFO, WARN, ERROR, FATAL") @QueryParam(value="severity") String severity, @ApiParam(value="Page size for paging") @QueryParam(value="ps") @DefaultValue(value="20") int pageSize, @ApiParam(value="Page for paging, 0-based") @QueryParam(value="page") Integer page, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (severity != null) {
            try {
                EventSeverity.valueOf((String)severity.toUpperCase());
            }
            catch (Exception e) {
                throw new BadArgumentException("severity", severity + " is bad. Allowed values are DEBUG, INFO, WARN, ERROR, FATAL");
            }
        }
        EventSource source = this.findEventSourceById(sourceId);
        EventCriteria criteria = new EventCriteria();
        criteria.addSortId(PageOrdering.ASC);
        criteria.addFilterSourceId(Integer.valueOf(source.getId()));
        if (startTime > 0L) {
            criteria.addFilterStartTime(Long.valueOf(startTime));
        }
        if (endTime > 0L) {
            criteria.addFilterEndTime(Long.valueOf(endTime));
        }
        if (page != null) {
            criteria.setPaging(page.intValue(), pageSize);
        } else if (startTime == 0L && endTime == 0L) {
            PageControl pageControl = new PageControl();
            pageControl.setPageSize(200);
            criteria.setPageControl(pageControl);
        }
        if (severity != null) {
            criteria.addFilterSeverities(new EventSeverity[]{EventSeverity.valueOf((String)severity.toUpperCase())});
        }
        Response.ResponseBuilder builder = this.getEventsAsBuilderForCriteria(headers, criteria, uriInfo);
        return builder.build();
    }

    @GET
    @GZIP
    @Path(value="/{id}/events")
    @ApiOperation(value="List the events for the resource with the passed id. If no time range is given, the last 200 entries will be displayed", responseClass="EventRest", multiValueResponse=true)
    public Response getEventsForResource(@PathParam(value="id") int resourceId, @QueryParam(value="startTime") long startTime, @QueryParam(value="endTime") long endTime, @ApiParam(value="Page size for paging") @QueryParam(value="ps") @DefaultValue(value="20") int pageSize, @ApiParam(value="Page for paging, 0-based") @QueryParam(value="page") Integer page, @ApiParam(value="Select the severity to display. Default is to show all", allowableValues="DEBUG, INFO, WARN, ERROR, FATAL") @QueryParam(value="severity") String severity, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (severity != null) {
            try {
                EventSeverity.valueOf((String)severity.toUpperCase());
            }
            catch (Exception e) {
                throw new BadArgumentException("severity", severity + " is bad. Allowed values are DEBUG, INFO, WARN, ERROR, FATAL");
            }
        }
        EventCriteria criteria = new EventCriteria();
        criteria.addSortId(PageOrdering.ASC);
        criteria.addFilterResourceId(Integer.valueOf(resourceId));
        if (startTime > 0L) {
            criteria.addFilterStartTime(Long.valueOf(startTime));
        }
        if (endTime > 0L) {
            criteria.addFilterEndTime(Long.valueOf(endTime));
        }
        if (page != null) {
            criteria.setPaging(page.intValue(), pageSize);
        } else if (startTime == 0L && endTime == 0L) {
            PageControl pageControl = new PageControl();
            pageControl.setPageSize(200);
            criteria.setPageControl(pageControl);
        }
        if (severity != null) {
            criteria.addFilterSeverities(new EventSeverity[]{EventSeverity.valueOf((String)severity.toUpperCase())});
        }
        Response.ResponseBuilder builder = this.getEventsAsBuilderForCriteria(headers, criteria, uriInfo);
        return builder.build();
    }

    @POST
    @Path(value="/source/{id}/events")
    @ApiOperation(value="Submit multiple events for one given event source; the event source in the passed Events is ignored. Make sure your events are ordered by timestamp to get alerts fired correctly.")
    public Response addEventsToSource(@ApiParam(value="Id of the source to add data to") @PathParam(value="id") int sourceId, List<EventRest> eventRest) {
        EventSource source = this.findEventSourceById(sourceId);
        HashMap<EventSource, Set<Event>> eventMap = new HashMap<EventSource, Set<Event>>();
        LinkedHashSet<Event> events = new LinkedHashSet<Event>(eventRest.size());
        for (EventRest eRest : eventRest) {
            EventSeverity eventSeverity = EventSeverity.valueOf((String)eRest.getSeverity());
            Event event = new Event(eRest.getTimestamp(), eventSeverity, source, eRest.getDetail());
            events.add(event);
        }
        eventMap.put(source, events);
        this.eventManager.addEventData(eventMap);
        return Response.noContent().build();
    }

    private Response.ResponseBuilder getEventsAsBuilderForCriteria(HttpHeaders headers, EventCriteria criteria, UriInfo uriInfo) {
        PageList<Event> eventList = this.eventManager.findEventsByCriteria(this.caller, criteria);
        ArrayList<EventRest> restEvents = new ArrayList<EventRest>(eventList.size());
        for (Event event : eventList) {
            restEvents.add(this.convertEvent(event));
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = Response.ok();
        builder.type(mediaType);
        if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            GenericEntity<List<EventRest>> list = new GenericEntity<List<EventRest>>(restEvents){};
            builder.entity((Object)list);
            this.createPagingHeader(builder, uriInfo, eventList);
        } else if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            builder.entity(restEvents);
            this.createPagingHeader(builder, uriInfo, eventList);
        } else {
            this.wrapForPaging(builder, uriInfo, eventList, restEvents);
        }
        return builder;
    }

    private EventSourceRest convertEventSource(EventSource source) {
        EventSourceRest esr = new EventSourceRest();
        esr.setId(source.getId());
        esr.setDescription(source.getEventDefinition().getDescription());
        esr.setDisplayName(source.getEventDefinition().getDisplayName());
        esr.setName(source.getEventDefinition().getName());
        esr.setLocation(source.getLocation());
        esr.setResourceId(source.getResourceId());
        return esr;
    }

    private EventRest convertEvent(Event event) {
        EventRest er = new EventRest();
        er.setDetail(event.getDetail());
        er.setId(event.getId());
        er.setSeverity(event.getSeverity().toString());
        er.setTimestamp(event.getTimestamp());
        er.setSourceId(event.getSource().getId());
        return er;
    }

    private EventSource findEventSourceById(int sourceId) {
        EventSource source = (EventSource)this.em.find(EventSource.class, (Object)sourceId);
        if (source == null) {
            throw new StuffNotFoundException("Event source with id " + sourceId);
        }
        return source;
    }
}

