/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.cache.Cache;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.criteria.ResourceGroupDefinitionCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupDefinition;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupAlreadyExistsException;
import org.rhq.enterprise.server.resource.group.ResourceGroupDeleteException;
import org.rhq.enterprise.server.resource.group.ResourceGroupNotFoundException;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionAlreadyExistsException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionCreateException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionDeleteException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionNotFoundException;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.GroupDefinitionRest;
import org.rhq.enterprise.server.rest.domain.GroupRest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;

@Stateless
@Interceptors(value={SetCallerInterceptor.class})
@Path(value="/group")
@Api(value="Deal with groups and DynaGroups", description="Api that deals with resource groups and group definitions")
public class GroupHandlerBean
extends AbstractRestBean {
    private final Log log = LogFactory.getLog(GroupHandlerBean.class);
    @EJB
    ResourceManagerLocal resourceManager;
    @EJB
    ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    GroupDefinitionManagerLocal definitionManager;

    @GZIP
    @GET
    @Path(value="/")
    @ApiOperation(value="List all groups", multiValueResponse=true, responseClass="GroupRest")
    public Response getGroups(@ApiParam(value="String to search in the group name") @QueryParam(value="q") String q, @ApiParam(value="Page size for paging") @QueryParam(value="ps") @DefaultValue(value="20") int pageSize, @ApiParam(value="Page number for paging, 0-based") @QueryParam(value="page") Integer page, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ResourceGroupCriteria criteria = new ResourceGroupCriteria();
        criteria.addSortId(PageOrdering.ASC);
        if (q != null) {
            criteria.addFilterName(q);
        }
        if (page != null) {
            criteria.setPaging(page.intValue(), pageSize);
        }
        PageList<ResourceGroup> groups = this.resourceGroupManager.findResourceGroupsByCriteria(this.caller, criteria);
        ArrayList<GroupRest> list = new ArrayList<GroupRest>();
        for (ResourceGroup group : groups) {
            list.add(this.fillGroup(group, uriInfo));
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = Response.ok();
        builder.type(mediaType);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder.entity((Object)this.renderTemplate("listGroup", list));
        } else if (mediaType.equals((Object)this.wrappedCollectionJsonType)) {
            this.wrapForPaging(builder, uriInfo, groups, list);
        } else {
            GenericEntity<List<GroupRest>> ret = new GenericEntity<List<GroupRest>>(list){};
            builder.entity((Object)ret);
            this.createPagingHeader(builder, uriInfo, groups);
        }
        return builder.build();
    }

    @Cache(isPrivate=true, maxAge=60)
    @GET
    @Path(value="{id}")
    @ApiOperation(value="Get the group with the passed id")
    @ApiError(code=404, reason="Group with passed id not found")
    public Response getGroup(@ApiParam(value="Id of the group") @PathParam(value="id") int id, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ResourceGroup group = this.fetchGroup(id, false);
        GroupRest groupRest = this.fillGroup(group, uriInfo);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = Response.ok();
        builder.type(mediaType);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder.entity((Object)this.renderTemplate("group", groupRest));
        } else {
            builder.entity((Object)groupRest);
        }
        return builder.build();
    }

    @POST
    @Path(value="/")
    @ApiOperation(value="Create a new group")
    @ApiErrors(value={@ApiError(code=404, reason="Resource type for provided type id does not exist"), @ApiError(code=406, reason="No group provided"), @ApiError(code=406, reason="Provided group has no name")})
    public Response createGroup(@ApiParam(value="A GroupRest object containing at least a name for the group") GroupRest group, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        if (group == null) {
            throw new BadArgumentException("A group must be provided");
        }
        if (group.getName() == null) {
            throw new BadArgumentException("A group name is required");
        }
        ResourceGroup newGroup = new ResourceGroup(group.getName());
        if (group.getResourceTypeId() != null) {
            ResourceType resourceType = null;
            try {
                resourceType = this.resourceTypeManager.getResourceTypeById(this.caller, group.getResourceTypeId());
                newGroup.setResourceType(resourceType);
            }
            catch (ResourceTypeNotFoundException e) {
                throw new StuffNotFoundException("ResourceType with id " + group.getResourceTypeId());
            }
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/{id}");
        try {
            newGroup = this.resourceGroupManager.createResourceGroup(this.caller, newGroup);
            URI uri = uriBuilder.build(new Object[]{newGroup.getId()});
            builder = Response.created((URI)uri);
        }
        catch (ResourceGroupAlreadyExistsException e) {
            ResourceGroupCriteria criteria = new ResourceGroupCriteria();
            criteria.setStrict(true);
            criteria.addFilterName(newGroup.getName());
            PageList<ResourceGroup> groups = this.resourceGroupManager.findResourceGroupsByCriteria(this.caller, criteria);
            newGroup = (ResourceGroup)groups.get(0);
            URI uri = uriBuilder.build(new Object[]{newGroup.getId()});
            builder = Response.ok((Object)uri);
        }
        catch (Exception e) {
            builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
            builder.type(mediaType);
            builder.entity((Object)e.getCause());
        }
        builder.type(mediaType);
        builder.entity((Object)this.fillGroup(newGroup, uriInfo));
        this.putToCache(newGroup.getId(), ResourceGroup.class, newGroup);
        return builder.build();
    }

    @PUT
    @Path(value="{id}")
    @ApiOperation(value="Update the passed group. Currently only name change is supported")
    @ApiErrors(value={@ApiError(code=404, reason="Group with the passed id does not exist"), @ApiError(code=406, reason="Updating the name failed")})
    public Response updateGroup(@ApiParam(value="Id of the group to update") @PathParam(value="id") int id, @ApiParam(value="New version of the group") GroupRest in, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroup resourceGroup = this.fetchGroup(id, false);
        resourceGroup.setName(in.getName());
        try {
            resourceGroup = this.resourceGroupManager.updateResourceGroup(this.caller, resourceGroup);
            builder = Response.ok((Object)this.fillGroup(resourceGroup, uriInfo));
            this.putToCache(resourceGroup.getId(), ResourceGroup.class, resourceGroup);
        }
        catch (Exception e) {
            builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder.type(mediaType);
        return builder.build();
    }

    @DELETE
    @Path(value="{id}")
    @ApiOperation(value="Delete the group with the passed id", notes="This operation is by default idempotent, returning 204.If you want to check if the group existed at all, you need to pass the 'validate' query parameter.")
    @ApiErrors(value={@ApiError(code=204, reason="Group was deleted or did not exist with validation not set"), @ApiError(code=404, reason="Group did not exist and validate was set")})
    public Response deleteGroup(@ApiParam(value="Id of the group to delete") @PathParam(value="id") int id, @ApiParam(value="Validate if the group exists") @QueryParam(value="validate") @DefaultValue(value="false") boolean validate) {
        Response.ResponseBuilder builder;
        try {
            this.resourceGroupManager.deleteResourceGroup(this.caller, id);
            this.removeFromCache(id, ResourceGroup.class);
            builder = Response.noContent();
        }
        catch (ResourceGroupNotFoundException e) {
            builder = validate ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.noContent();
        }
        catch (ResourceGroupDeleteException e) {
            builder = Response.serverError();
            builder.entity((Object)e.getMessage());
        }
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="{id}/resources")
    @Cache(isPrivate=true, maxAge=60)
    @ApiOperation(value="Get the resources of the group", multiValueResponse=true, responseClass="ResourceWithType")
    @ApiError(code=404, reason="Group with passed id does not exist")
    public Response getResources(@ApiParam(value="Id of the group to retrieve the resources for") @PathParam(value="id") int id, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroup resourceGroup = this.fetchGroup(id, false);
        Set resources = resourceGroup.getExplicitResources();
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(resources.size());
        for (Resource res : resources) {
            rwtList.add(this.fillRWT(res, uriInfo));
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listResourceWithType", rwtList), (MediaType)mediaType);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(rwtList){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    @PUT
    @Path(value="{id}/resource/{resourceId}")
    @ApiOperation(value="Add a resource to an existing group", notes="If you have created the group as a compatible group and a resource type was provided on creation, only resources with this typemay be added.")
    @ApiErrors(value={@ApiError(code=404, reason="If there is no resource or group with the passed id "), @ApiError(code=409, reason=" Resource type does not match the group one")})
    public Response addResource(@ApiParam(value="Id of the existing group") @PathParam(value="id") int id, @ApiParam(value="Id of the resource to add") @PathParam(value="resourceId") int resourceId, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        ResourceGroup resourceGroup = this.fetchGroup(id, false);
        Resource res = this.resourceManager.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("Resource with id " + resourceId);
        }
        if (resourceGroup.getResourceType() != null && !res.getResourceType().equals((Object)resourceGroup.getResourceType())) {
            Response.ResponseBuilder status = Response.status((Response.Status)Response.Status.CONFLICT);
            status.type(mediaType);
            return status.build();
        }
        this.resourceGroupManager.addResourcesToGroup(this.caller, id, new int[]{resourceId});
        resourceGroup = this.fetchGroup(id, false);
        GroupRest gr = this.fillGroup(resourceGroup, uriInfo);
        Response.ResponseBuilder builder = Response.ok();
        builder.entity((Object)gr);
        builder.type(mediaType);
        return builder.build();
    }

    @DELETE
    @Path(value="{id}/resource/{resourceId}")
    @ApiOperation(value="Remove the resource with the passed id from the group", notes="This operation is by default idempotent, returning 204even if the resource was not member of the group.If you want to check if the resource existed at all, you need to pass the 'validate' query parameter.")
    @ApiErrors(value={@ApiError(code=404, reason="Group with the passed id does not exist"), @ApiError(code=404, reason="Resource with the passed id does not exist"), @ApiError(code=204, reason="Resource was removed from the group or was no member and validation was not set"), @ApiError(code=404, reason="Resource was no member of the group and validate was set")})
    public Response removeResource(@ApiParam(value="Id of the existing group") @PathParam(value="id") int id, @ApiParam(value="Id of the resource to remove") @PathParam(value="resourceId") int resourceId, @ApiParam(value="Validate if the resource exists in the group") @QueryParam(value="validate") @DefaultValue(value="false") boolean validate) {
        ResourceGroup resourceGroup = this.fetchGroup(id, false);
        Resource res = this.resourceManager.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("Resource with id " + resourceId);
        }
        boolean removed = resourceGroup.removeExplicitResource(res);
        if (!removed && validate) {
            throw new StuffNotFoundException("Resource " + resourceId + " in group " + id);
        }
        return Response.noContent().build();
    }

    @GET
    @GZIP
    @Path(value="{id}/metricDefinitions")
    @ApiOperation(value="Get the metric definitions for the compatible group with the passed id")
    @ApiError(code=404, reason="Group with the passed id does not exist")
    public Response getMetricDefinitionsForGroup(@ApiParam(value="Id of the group") @PathParam(value="id") int id, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroup group = this.fetchGroup(id, true);
        Set definitions = group.getResourceType().getMetricDefinitions();
        ArrayList<MetricSchedule> schedules = new ArrayList<MetricSchedule>(definitions.size());
        for (MeasurementDefinition def : definitions) {
            MetricSchedule schedule = new MetricSchedule(def.getId(), def.getName(), def.getDisplayName(), false, def.getDefaultInterval(), def.getUnits().getName(), def.getDataType().toString());
            schedule.setDefinitionId(def.getId());
            if (def.getDataType() == DataType.MEASUREMENT) {
                UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("/metric/data/group/{groupId}/{definitionId}");
                URI uri = uriBuilder.build(new Object[]{id, def.getId()});
                Link link = new Link("metric", uri.toString());
                schedule.addLink(link);
            }
            schedules.add(schedule);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listMetricDefinitions", schedules));
        } else {
            GenericEntity<List<MetricSchedule>> ret = new GenericEntity<List<MetricSchedule>>(schedules){};
            builder = Response.ok((Object)ret);
        }
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="/definitions")
    @ApiOperation(value="List all existing GroupDefinitions", multiValueResponse=true, responseClass="GroupDefinitionRest")
    public Response getGroupDefinitions(@ApiParam(value="String to search in the group definition name") @QueryParam(value="q") String q, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceGroupDefinitionCriteria criteria = new ResourceGroupDefinitionCriteria();
        if (q != null) {
            criteria.addFilterName(q);
        }
        PageList<GroupDefinition> gdlist = this.definitionManager.findGroupDefinitionsByCriteria(this.caller, criteria);
        ArrayList<GroupDefinitionRest> list = new ArrayList<GroupDefinitionRest>();
        for (GroupDefinition def : gdlist) {
            GroupDefinitionRest definitionRest = this.buildGDRestFromDefinition(def);
            this.createLinksForGDRest(uriInfo, definitionRest);
            list.add(definitionRest);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listGroupDefinition", list), (MediaType)mediaType);
        } else {
            GenericEntity<List<GroupDefinitionRest>> ret = new GenericEntity<List<GroupDefinitionRest>>(list){};
            builder = Response.ok((Object)ret);
        }
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="/definition/{id}")
    @Cache(isPrivate=true, maxAge=60)
    @ApiOperation(value="Retrieve a single GroupDefinition by id", responseClass="GroupDefinitionRest")
    @ApiError(code=404, reason="Group definition with the passed id does not exist.")
    public Response getGroupDefinition(@ApiParam(value="The id of the definition to retrieve") @PathParam(value="id") int definitionId, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        try {
            GroupDefinition def = this.definitionManager.getById(definitionId);
            GroupDefinitionRest gdr = this.buildGDRestFromDefinition(def);
            this.createLinksForGDRest(uriInfo, gdr);
            MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
            Response.ResponseBuilder builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("groupDefinition", gdr), (MediaType)mediaType) : Response.ok((Object)gdr);
            return builder.build();
        }
        catch (GroupDefinitionNotFoundException e) {
            throw new StuffNotFoundException("Group definition with id " + definitionId);
        }
    }

    private GroupDefinitionRest buildGDRestFromDefinition(GroupDefinition def) {
        List<Integer> generatedGroups;
        GroupDefinitionRest gdr = new GroupDefinitionRest(def.getId(), def.getName(), def.getDescription(), def.getRecalculationInterval());
        gdr.setRecursive(def.isRecursive());
        if (def.getManagedResourceGroups() != null) {
            generatedGroups = new ArrayList<Integer>(def.getManagedResourceGroups().size());
            for (ResourceGroup group : def.getManagedResourceGroups()) {
                generatedGroups.add(group.getId());
            }
        } else {
            generatedGroups = Collections.emptyList();
        }
        gdr.setGeneratedGroupIds(generatedGroups);
        gdr.setExpression(def.getExpressionAsList());
        return gdr;
    }

    @DELETE
    @Path(value="/definition/{id}")
    @ApiOperation(value="Delete the GroupDefinition with the passed id", notes="This operation is by default idempotent, returning 204.If you want to check if the definition existed at all, you need to pass the 'validate' query parameter.")
    @ApiErrors(value={@ApiError(code=204, reason="Definition was deleted or did not exist with validation not set"), @ApiError(code=404, reason="Definition did not exist and validate was set")})
    public Response deleteGroupDefinition(@ApiParam(value="The id of the definition to delete") @PathParam(value="id") int definitionId, @ApiParam(value="Validate if the definition exists") @QueryParam(value="validate") @DefaultValue(value="false") boolean validate, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        try {
            GroupDefinition def = this.definitionManager.getById(definitionId);
            this.definitionManager.removeGroupDefinition(this.caller, definitionId);
            builder = Response.noContent();
        }
        catch (GroupDefinitionNotFoundException e) {
            if (validate) {
                builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                builder.entity((Object)("Definition with id " + definitionId));
            } else {
                builder = Response.noContent();
            }
        }
        catch (GroupDefinitionDeleteException e) {
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            builder.entity((Object)e.getMessage());
        }
        MediaType type = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder.type(type);
        return builder.build();
    }

    @POST
    @Path(value="/definitions")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Create a new GroupDefinition.", notes="The name of the group is required in the passed definition, as well as a non-empty expression. A recalcInterval of 0 means to never recalculate.")
    @ApiErrors(value={@ApiError(code=406, reason="Passed group definition has no name"), @ApiError(code=406, reason="Passed expression was empty"), @ApiError(code=406, reason="Recalculation interval is < 0 "), @ApiError(code=409, reason="There already exists a definition by this name"), @ApiError(code=406, reason="Group creation failed")})
    public Response createGroupDefinition(GroupDefinitionRest definition, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder = null;
        if (definition.getName() == null || definition.getName().trim().isEmpty()) {
            builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
            builder.entity((Object)"No name for the definition given");
        }
        if (builder != null) {
            return builder.build();
        }
        GroupDefinition gd = new GroupDefinition(definition.getName());
        gd.setDescription(definition.getDescription());
        this.addGroupDefinitionExpression(definition, gd);
        if (definition.getRecalcInterval() < 0L) {
            throw new BadArgumentException("Recalculation interval must be >= 0");
        }
        gd.setRecalculationInterval(Long.valueOf(definition.getRecalcInterval()));
        gd.setRecursive(definition.isRecursive());
        try {
            GroupDefinition res = this.definitionManager.createGroupDefinition(this.caller, gd);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/group/definition/{id}");
            URI location = uriBuilder.build(new Object[]{res.getId()});
            Link link = new Link("edit", location.toString());
            builder = Response.created((URI)location);
            GroupDefinitionRest gdr = this.buildGDRestFromDefinition(res);
            this.createLinksForGDRest(uriInfo, gdr);
            builder.entity((Object)gdr);
        }
        catch (GroupDefinitionAlreadyExistsException e) {
            builder = Response.status((Response.Status)Response.Status.CONFLICT);
            builder.entity((Object)e.getMessage());
        }
        catch (GroupDefinitionCreateException e) {
            e.printStackTrace();
            builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
            builder.entity((Object)e.getMessage());
        }
        return builder.build();
    }

    private void addGroupDefinitionExpression(GroupDefinitionRest definition, GroupDefinition gd) {
        boolean isEmpty = false;
        List<String> expressionList = definition.getExpression();
        if (expressionList.isEmpty()) {
            isEmpty = true;
        }
        StringBuilder sb = new StringBuilder();
        int countEmpty = 0;
        for (String e : expressionList) {
            if (e == null) {
                ++countEmpty;
                continue;
            }
            sb.append(e);
            if (e.trim().isEmpty()) {
                ++countEmpty;
            }
            sb.append("\n");
        }
        if (countEmpty == expressionList.size()) {
            isEmpty = true;
        }
        if (isEmpty) {
            throw new BadArgumentException("The expression must not be empty");
        }
        gd.setExpression(sb.toString());
    }

    @PUT
    @Path(value="/definition/{id}")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Update or recalculate an existing GroupDefinition", notes="If the query param 'recalculate' is set to true, the group with the passed id is recalculated. Otherwise the existing group will be updated with the passed definition. The expression in the definition must be empty. If the name is emtpy, the old name is kept. A recalcIntervalof 0 means no recalculation.")
    @ApiErrors(value={@ApiError(code=404, reason="Group with the passed id does not exist"), @ApiError(code=406, reason="Passed expression was empty"), @ApiError(code=406, reason="Recalculation interval is < 0 "), @ApiError(code=406, reason="Group membership calculation failed")})
    public Response updateGroupDefinition(@ApiParam(value="Id fo the definition to update") @PathParam(value="id") int definitionId, @ApiParam(value="If true, trigger a re-calculation") @QueryParam(value="recalculate") @DefaultValue(value="false") boolean recalculate, GroupDefinitionRest definition, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        GroupDefinition gd;
        try {
            gd = this.definitionManager.getById(definitionId);
        }
        catch (GroupDefinitionNotFoundException e) {
            throw new StuffNotFoundException("Group Definition with id " + definitionId);
        }
        Response.ResponseBuilder builder = null;
        if (recalculate) {
            try {
                this.definitionManager.calculateGroupMembership(this.caller, gd.getId());
                builder = Response.noContent();
            }
            catch (Exception e) {
                builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
                builder.entity((Object)e.getLocalizedMessage());
            }
            return builder.build();
        }
        if (!definition.getName().isEmpty()) {
            gd.setName(definition.getName());
        }
        gd.setDescription(definition.getDescription());
        this.addGroupDefinitionExpression(definition, gd);
        if (definition.getRecalcInterval() < 0L) {
            throw new BadArgumentException("Recalculation interval must be >= 0");
        }
        gd.setRecalculationInterval(Long.valueOf(definition.getRecalcInterval()));
        gd.setRecursive(definition.isRecursive());
        try {
            this.definitionManager.updateGroupDefinition(this.caller, gd);
        }
        catch (Exception e) {
            builder = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE);
            builder.entity((Object)e.getLocalizedMessage());
            return builder.build();
        }
        try {
            gd = this.definitionManager.getById(gd.getId());
            GroupDefinitionRest gdr = this.buildGDRestFromDefinition(gd);
            this.createLinksForGDRest(uriInfo, gdr);
            builder = Response.ok((Object)gdr);
        }
        catch (GroupDefinitionNotFoundException e) {
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            builder.entity((Object)("Group Definition with id " + gd.getId()));
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder.type(mediaType);
        return builder.build();
    }

    private void createLinksForGDRest(UriInfo uriInfo, GroupDefinitionRest gdr) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/definition/{id}");
        URI location = uriBuilder.build(new Object[]{gdr.getId()});
        Link link = new Link("edit", location.toString());
        gdr.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/definition");
        location = uriBuilder.build(new Object[0]);
        link = new Link("create", location.toString());
        gdr.addLink(link);
    }
}

