/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.reporting;

import java.io.IOException;
import java.io.OutputStream;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.criteria.ResourceConfigurationUpdateCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ReportsInterceptor;
import org.rhq.enterprise.server.rest.reporting.ConfigurationHistoryLocal;
import org.rhq.enterprise.server.rest.reporting.ReportFormatHelper;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

@Interceptors(value={ReportsInterceptor.class})
@Stateless
public class ConfigurationHistoryHandler
extends AbstractRestBean
implements ConfigurationHistoryLocal {
    private final Log log = LogFactory.getLog(ConfigurationHistoryHandler.class);
    @EJB
    private ConfigurationManagerLocal configurationManager;

    @Override
    public StreamingOutput configurationHistory(HttpServletRequest request) {
        return this.configurationHistoryInternal(request, this.caller);
    }

    @Override
    public StreamingOutput configurationHistoryInternal(final HttpServletRequest request, Subject user) {
        this.caller = user;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received request to generate report for " + this.caller));
        }
        return new StreamingOutput(){

            public void write(OutputStream stream) throws IOException, WebApplicationException {
                ResourceConfigurationUpdateCriteria criteria = new ResourceConfigurationUpdateCriteria();
                criteria.fetchConfiguration(true);
                criteria.addSortCreatedTime(PageOrdering.ASC);
                CriteriaQueryExecutor<ResourceConfigurationUpdate, ResourceConfigurationUpdateCriteria> queryExecutor = new CriteriaQueryExecutor<ResourceConfigurationUpdate, ResourceConfigurationUpdateCriteria>(){

                    @Override
                    public PageList<ResourceConfigurationUpdate> execute(ResourceConfigurationUpdateCriteria criteria) {
                        return ConfigurationHistoryHandler.this.configurationManager.findResourceConfigurationUpdatesByCriteria(ConfigurationHistoryHandler.this.caller, criteria);
                    }
                };
                CriteriaQuery<ResourceConfigurationUpdate, ResourceConfigurationUpdateCriteria> query = new CriteriaQuery<ResourceConfigurationUpdate, ResourceConfigurationUpdateCriteria>(criteria, queryExecutor);
                stream.write((this.getHeader() + "\n").getBytes());
                for (ResourceConfigurationUpdate alert : query) {
                    String record = this.toCSV(alert) + "\n";
                    stream.write(record.getBytes());
                }
            }

            private String toCSV(ResourceConfigurationUpdate configurationUpdate) {
                return configurationUpdate.getId() + "," + ReportFormatHelper.formatDateTime(configurationUpdate.getCreatedTime()) + "," + ReportFormatHelper.formatDateTime(configurationUpdate.getModifiedTime()) + "," + configurationUpdate.getStatus() + "," + ReportFormatHelper.cleanForCSV(configurationUpdate.getResource().getName()) + "," + ReportFormatHelper.cleanForCSV(ReportFormatHelper.parseAncestry(configurationUpdate.getResource().getAncestry())) + "," + this.getDetailsURL(configurationUpdate);
            }

            private String getHeader() {
                return "Version,Date Submitted,Date Completed,Status,Name,Ancestry,Details URL";
            }

            private String getDetailsURL(ResourceConfigurationUpdate configUpdate) {
                String protocol = request.isSecure() ? "https" : "http";
                return protocol + "://" + request.getServerName() + ":" + request.getServerPort() + "/coregui/#Resource/" + configUpdate.getResource().getId() + "/Configuration/History/" + configUpdate.getId();
            }
        };
    }
}

