/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.criteria.BundleDeploymentCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.QuartzUtil;

public class BundleDeploymentStatusCheckJob
implements Job {
    private static final String BUNDLE_DEPLOYMENT_ID_KEY = "BUNDLE_DEPLOYMENT_ID";

    public static JobDetail getJobDetail(int bundleDeploymentId) {
        JobDetail jobDetail = new JobDetail(String.valueOf(bundleDeploymentId), BundleDeploymentStatusCheckJob.class.getName(), BundleDeploymentStatusCheckJob.class);
        jobDetail.setVolatility(false);
        jobDetail.setDurability(false);
        jobDetail.setRequestsRecovery(false);
        JobDataMap map = new JobDataMap();
        map.putAsString(BUNDLE_DEPLOYMENT_ID_KEY, bundleDeploymentId);
        jobDetail.setJobDataMap(map);
        return jobDetail;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        SubjectManagerLocal subjectManager;
        Subject overlord;
        BundleManagerLocal bundleManager = LookupUtil.getBundleManager();
        PageList<BundleDeployment> deployments = bundleManager.findBundleDeploymentsByCriteria(overlord = (subjectManager = LookupUtil.getSubjectManager()).getOverlord(), this.getCriteriaFromContext(context));
        if (deployments.size() > 0) {
            BundleDeployment bundleDeployment = (BundleDeployment)deployments.get(0);
            SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
            JobDetail jobDetail = context.getJobDetail();
            if (bundleManager.determineBundleDeploymentStatus(bundleDeployment.getId()).isTerminal()) {
                try {
                    scheduler.deleteJob(jobDetail.getName(), jobDetail.getGroup());
                }
                catch (SchedulerException e) {
                    throw new JobExecutionException("Could not delete the bundle deployment completion check job for " + bundleDeployment + ".", (Throwable)e);
                }
            }
            try {
                Trigger trigger = QuartzUtil.getFireOnceOffsetTrigger(jobDetail, 10000L);
                trigger.setName(String.valueOf(System.currentTimeMillis()));
                scheduler.scheduleJob(trigger);
            }
            catch (SchedulerException e) {
                throw new JobExecutionException("Could not schedule the bundle deployment completion check job for " + bundleDeployment + ".", (Throwable)e);
            }
        }
    }

    private BundleDeploymentCriteria getCriteriaFromContext(JobExecutionContext context) {
        int bundleDeploymentId = context.getJobDetail().getJobDataMap().getInt(BUNDLE_DEPLOYMENT_ID_KEY);
        BundleDeploymentCriteria crit = new BundleDeploymentCriteria();
        crit.addFilterId(Integer.valueOf(bundleDeploymentId));
        return crit;
    }
}

