/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.RHQConstants;
import org.rhq.enterprise.server.alert.AlertConditionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementOOBManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.TimingVoodoo;
import org.rhq.server.metrics.MetricsServer;
import org.rhq.server.metrics.domain.AggregateNumericMetric;

public class DataPurgeJob
extends AbstractStatefulJob {
    private static final Log LOG = LogFactory.getLog(DataPurgeJob.class);
    private static long HOUR = 3600000L;

    public static void purgeNow() throws Exception {
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        SimpleTrigger trigger = new SimpleTrigger("DataPurgeJobNow", DataPurgeJob.class.getName());
        trigger.setJobName(DataPurgeJob.class.getName());
        trigger.setJobGroup(DataPurgeJob.class.getName());
        scheduler.scheduleJob((Trigger)trigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeJobCode(JobExecutionContext context) throws JobExecutionException {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)"Data Purge Job STARTING");
        try {
            Properties systemConfig = LookupUtil.getSystemManager().getSystemConfiguration(LookupUtil.getSubjectManager().getOverlord());
            Iterable<AggregateNumericMetric> oneHourAggregates = this.compressMeasurementData();
            this.purgeEverything(systemConfig);
            this.performDatabaseMaintenance(LookupUtil.getSystemManager(), systemConfig);
            this.calculateAutoBaselines(LookupUtil.getMeasurementBaselineManager());
            this.calculateOOBs(oneHourAggregates);
        }
        catch (Exception e) {
            LOG.error((Object)("Data Purge Job FAILED TO COMPLETE. Cause: " + e));
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Data Purge Job FINISHED [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<AggregateNumericMetric> compressMeasurementData() {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Measurement data compression starting at " + new Date(timeStart)));
        try {
            StorageClientManager storageClientManager = LookupUtil.getStorageClientManager();
            MetricsServer metricsServer = storageClientManager.getMetricsServer();
            Iterable iterable = metricsServer.calculateAggregates();
            return iterable;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to compress measurement data. Cause: " + e), (Throwable)e);
            List<AggregateNumericMetric> list = Collections.emptyList();
            return list;
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Measurement data compression completed in [" + duration + "]ms"));
        }
    }

    private void purgeEverything(Properties systemConfig) {
        this.purgeCallTimeData(LookupUtil.getCallTimeDataManager(), systemConfig);
        this.purgeEventData(LookupUtil.getEventManager(), systemConfig);
        this.purgeAlertData(LookupUtil.getAlertManager(), systemConfig);
        this.purgeUnusedAlertDefinitions(LookupUtil.getAlertDefinitionManager());
        this.purgeOrphanedAlertConditions(LookupUtil.getAlertConditionManager());
        this.purgeOrphanedAlertNotifications(LookupUtil.getAlertNotificationManager());
        this.purgeMeasurementTraitData(LookupUtil.getMeasurementDataManager(), systemConfig);
        this.purgeAvailabilityData(LookupUtil.getAvailabilityManager(), systemConfig);
        this.purgeOrphanedDriftFiles(LookupUtil.getDriftManager(), systemConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeMeasurementTraitData(MeasurementDataManagerLocal measurementDataManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Trait data purge starting at " + new Date(timeStart)));
        int traitsPurged = 0;
        try {
            long threshold;
            String traitPurgeThresholdStr = systemConfig.getProperty(RHQConstants.TraitPurge);
            if (traitPurgeThresholdStr == null) {
                threshold = timeStart - 31536000000L;
                LOG.debug((Object)"No purge traits threshold found - will purge traits older than one year");
            } else {
                threshold = timeStart - Long.parseLong(traitPurgeThresholdStr);
            }
            LOG.info((Object)("Purging traits that are older than " + new Date(threshold)));
            traitsPurged = measurementDataManager.purgeTraits(threshold);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge trait data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Traits data purged [" + traitsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeAvailabilityData(AvailabilityManagerLocal availabilityManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Availability data purge starting at " + new Date(timeStart)));
        int availsPurged = 0;
        try {
            long threshold;
            String availPurgeThresholdStr = systemConfig.getProperty(RHQConstants.AvailabilityPurge);
            if (availPurgeThresholdStr == null) {
                threshold = timeStart - 31536000000L;
                LOG.debug((Object)"No purge avails threshold found - will purge availabilities older than one year");
            } else {
                threshold = timeStart - Long.parseLong(availPurgeThresholdStr);
            }
            LOG.info((Object)("Purging availablities that are older than " + new Date(threshold)));
            availsPurged = availabilityManager.purgeAvailabilities(threshold);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge availability data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Availability data purged [" + availsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeCallTimeData(CallTimeDataManagerLocal callTimeDataManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Measurement calltime data purge starting at " + new Date(timeStart)));
        int calltimePurged = 0;
        try {
            long threshold = timeStart - Long.parseLong(systemConfig.getProperty(RHQConstants.RtDataPurge));
            LOG.info((Object)("Purging calltime data that is older than " + new Date(threshold)));
            calltimePurged = callTimeDataManager.purgeCallTimeData(new Date(threshold));
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge calltime data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Calltime purged [" + calltimePurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeEventData(EventManagerLocal eventManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Event data purge starting at " + new Date(timeStart)));
        int eventsPurged = 0;
        try {
            long threshold = timeStart - Long.parseLong(systemConfig.getProperty(RHQConstants.EventPurge));
            LOG.info((Object)("Purging event data older than " + new Date(threshold)));
            eventsPurged = eventManager.purgeEventData(new Date(threshold));
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge event data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Event data purged [" + eventsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeAlertData(AlertManagerLocal alertManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Alert data purge starting at " + new Date(timeStart)));
        int alertsPurged = 0;
        try {
            long threshold = timeStart - Long.parseLong(systemConfig.getProperty(RHQConstants.AlertPurge));
            LOG.info((Object)("Purging alert data older than " + new Date(threshold)));
            alertsPurged = alertManager.deleteAlerts(0L, threshold);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge alert data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Alert data purged [" + alertsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeUnusedAlertDefinitions(AlertDefinitionManagerLocal alertDefinitionManager) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Alert definition unused purge starting at " + new Date(timeStart)));
        int alertDefinitionsPurged = 0;
        try {
            alertDefinitionsPurged = alertDefinitionManager.purgeUnusedAlertDefinitions();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge alert definition data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Alert definitions purged [" + alertDefinitionsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOrphanedAlertConditions(AlertConditionManagerLocal alertConditionManager) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Alert condition orphan purge starting at " + new Date(timeStart)));
        int orphansPurged = 0;
        try {
            orphansPurged = alertConditionManager.purgeOrphanedAlertConditions();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge alert condition data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Purged [" + orphansPurged + "] orphan alert conditions - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOrphanedAlertNotifications(AlertNotificationManagerLocal alertNotificationManager) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Alert notification orphan purge starting at " + new Date(timeStart)));
        int orphansPurged = 0;
        try {
            orphansPurged = alertNotificationManager.purgeOrphanedAlertNotifications();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge alert notification data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Purged [" + orphansPurged + "] orphan alert notifications - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOrphanedDriftFiles(DriftManagerLocal driftManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Drift file orphan purge starting at " + new Date(timeStart)));
        int orphansPurged = 0;
        try {
            long threshold = timeStart - Long.parseLong(systemConfig.getProperty(RHQConstants.DriftFilePurge));
            LOG.info((Object)("Purging orphaned drift files older than " + new Date(threshold)));
            orphansPurged = driftManager.purgeOrphanedDriftFiles(LookupUtil.getSubjectManager().getOverlord(), threshold);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge orphaned drift files. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Purged [" + orphansPurged + "] orphaned drift files - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDatabaseMaintenance(SystemManagerLocal systemManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Database maintenance starting at " + new Date(timeStart)));
        try {
            String dataMaintenance = systemConfig.getProperty(RHQConstants.DataMaintenance);
            if (dataMaintenance == null) {
                LOG.error((Object)"No data maintenance interval found - will not perform db maintenance");
                return;
            }
            long maintInterval = Long.parseLong(dataMaintenance);
            Calendar cal = Calendar.getInstance();
            if (cal.get(11) == 0) {
                LOG.info((Object)"Performing daily database maintenance");
                systemManager.vacuum(LookupUtil.getSubjectManager().getOverlord());
                String reindexStr = systemConfig.getProperty(RHQConstants.DataReindex);
                boolean reindexNightly = Boolean.valueOf(reindexStr);
                if (reindexNightly) {
                    LOG.info((Object)"Re-indexing data tables");
                    systemManager.reindex(LookupUtil.getSubjectManager().getOverlord());
                } else {
                    LOG.info((Object)"Skipping re-indexing of data tables");
                }
            } else if (TimingVoodoo.roundDownTime(timeStart, HOUR) == TimingVoodoo.roundDownTime(timeStart, maintInterval)) {
                LOG.info((Object)"Performing hourly database maintenance");
                systemManager.analyze(LookupUtil.getSubjectManager().getOverlord());
            } else {
                LOG.debug((Object)"Not performing any database maintenance now");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to perform database maintenance. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Database maintenance completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateAutoBaselines(MeasurementBaselineManagerLocal measurementBaselineManager) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Auto-calculation of baselines starting at " + new Date(timeStart)));
        try {
            measurementBaselineManager.calculateAutoBaselines();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to auto-calculate baselines. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Auto-calculation of baselines completed in [" + duration + "]ms"));
        }
    }

    public void calculateOOBs(Iterable<AggregateNumericMetric> oneHourAggregates) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)"Auto-calculation of OOBs starting");
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        MeasurementOOBManagerLocal manager = LookupUtil.getOOBManager();
        long cutOff = System.currentTimeMillis() - 1800000L;
        manager.removeOutdatedOOBs(overlord, cutOff);
        LookupUtil.getSystemManager().vacuum(overlord, new String[]{"RHQ_MEASUREMENT_OOB"});
        manager.computeOOBsForLastHour(overlord, oneHourAggregates);
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Auto-calculation of OOBs completed in [" + duration + "]ms"));
    }
}

