/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.storage;

import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.server.metrics.StorageSession;
import org.rhq.server.metrics.StorageStateListener;

public class StorageClusterMonitor
implements StorageStateListener {
    private Log log = LogFactory.getLog(StorageClusterMonitor.class);
    private boolean isClusterAvailable = true;
    private StorageSession session;

    public StorageClusterMonitor(StorageSession session) {
        this.session = session;
    }

    public boolean isClusterAvailable() {
        return this.isClusterAvailable;
    }

    public void onStorageNodeUp(InetAddress address) {
        this.log.info((Object)("Storage node at " + address.getHostAddress() + " is up"));
        this.isClusterAvailable = true;
        this.updateRequestLimit();
    }

    public void onStorageNodeDown(InetAddress address) {
        this.log.info((Object)("Storage node at " + address.getHostAddress() + " is down"));
        this.updateRequestLimit();
    }

    public void onStorageNodeRemoved(InetAddress address) {
        this.log.info((Object)("Storage node at " + address.getHostAddress() + " has been removed from the cluster"));
        this.updateRequestLimit();
    }

    public void onStorageClusterUp() {
        this.log.info((Object)"Storage cluster is up");
        this.isClusterAvailable = true;
    }

    public void onStorageClusterDown(NoHostAvailableException e) {
        this.log.info((Object)"Storage cluster is down");
        this.isClusterAvailable = false;
    }

    public void onClientTimeout(NoHostAvailableException e) {
        this.updateRequestLimit();
    }

    public void updateRequestLimit() {
        StorageClientManager storageClientManager = LookupUtil.getStorageClientManager();
        storageClientManager.persistStorageProperty("rhq.storage.request.limit", Double.toString(this.session.getRequestLimit()));
    }
}

